/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.message.format.xml;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.internal.soa.esb.message.format.xml.AttachmentImpl;
import org.jboss.internal.soa.esb.message.format.xml.BodyImpl;
import org.jboss.internal.soa.esb.message.format.xml.ContextImpl;
import org.jboss.internal.soa.esb.message.format.xml.FaultImpl;
import org.jboss.internal.soa.esb.message.format.xml.HeaderImpl;
import org.jboss.internal.soa.esb.message.format.xml.PropertiesImpl;
import org.jboss.internal.soa.esb.message.format.xml.XMLUtil;
import org.jboss.internal.soa.esb.util.stax.ElementContent;
import org.jboss.internal.soa.esb.util.stax.StreamHelper;
import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.message.Attachment;
import org.jboss.soa.esb.message.Body;
import org.jboss.soa.esb.message.ByReferenceMessage;
import org.jboss.soa.esb.message.Context;
import org.jboss.soa.esb.message.Fault;
import org.jboss.soa.esb.message.Header;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.Properties;
import org.jboss.soa.esb.message.body.content.Payload;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.message.format.MessageType;
import org.jboss.soa.esb.util.Util;

public class MessageImpl
extends ElementContent
implements ByReferenceMessage {
    private HeaderImpl _theHeader = new HeaderImpl();
    private ContextImpl _theContext;
    private BodyImpl _theBody;
    private FaultImpl _theFault;
    private AttachmentImpl _theAttachment;
    private PropertiesImpl _theProperties;

    public MessageImpl() {
        this._theContext = new ContextImpl();
        this._theBody = new BodyImpl();
        this._theFault = new FaultImpl(this._theBody);
        this._theAttachment = new AttachmentImpl();
        this._theProperties = new PropertiesImpl();
    }

    private MessageImpl(MessageImpl message) {
        Call origCall = message._theHeader.getCall();
        Call call = new Call(origCall.getTo());
        call.setAction(origCall.getAction());
        call.setFaultTo(origCall.getFaultTo());
        call.setFrom(origCall.getFrom());
        call.setMessageID(origCall.getMessageID());
        call.setRelatesTo(origCall.getRelatesTo());
        call.setReplyTo(origCall.getReplyTo());
        this._theHeader.setCall(call);
        this._theContext = new ContextImpl(message._theContext);
        this._theBody = message._theBody;
        this._theFault = message._theFault;
        this._theAttachment = message._theAttachment;
        this._theProperties = message._theProperties;
    }

    public MessageImpl(XMLStreamReader in) throws XMLStreamException {
        this();
        this.parse(in);
        String payloadType = Payload.bodyType(this);
        if (payloadType != null && !payloadType.equals("raw")) {
            this._theBody = (BodyImpl)MessageFactory.getInstance().createBodyType(this, payloadType);
        }
        this._theFault = new FaultImpl(this._theBody);
    }

    @Override
    public Header getHeader() {
        return this._theHeader;
    }

    @Override
    public Context getContext() {
        return this._theContext;
    }

    @Override
    public Body getBody() {
        return this._theBody;
    }

    @Override
    public Fault getFault() {
        return this._theFault;
    }

    @Override
    public Attachment getAttachment() {
        return this._theAttachment;
    }

    @Override
    public URI getType() {
        return MessageType.JBOSS_XML;
    }

    @Override
    public Properties getProperties() {
        return this._theProperties;
    }

    @Override
    public Message copy() throws IOException {
        try {
            Serializable state = Util.serialize(this);
            return (MessageImpl)Util.deserialize(state);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            IOException ioe = new IOException("Unexpected exception during copying");
            ioe.initCause(ex);
            throw ioe;
        }
    }

    public String toString() {
        return "message: [ JBOSS_XML ]\n" + this._theHeader.toString() + "\n" + this._theContext.toString() + "\n" + this._theBody.toString() + "\n" + this._theFault.toString() + "\n" + this._theAttachment.toString() + "\n" + this._theProperties.toString();
    }

    @Override
    public void writeChildContent(XMLStreamWriter out) throws XMLStreamException {
        StreamHelper.writeElement(out, XMLUtil.ESB_QNAME_HEADER, this._theHeader);
        StreamHelper.writeElement(out, XMLUtil.ESB_QNAME_CONTEXT, this._theContext);
        StreamHelper.writeElement(out, XMLUtil.ESB_QNAME_BODY, this._theBody);
        StreamHelper.writeElement(out, XMLUtil.ESB_QNAME_ATTACHMENT, this._theAttachment);
        StreamHelper.writeElement(out, XMLUtil.ESB_QNAME_PROPERTIES, this._theProperties);
    }

    @Override
    protected void putElement(XMLStreamReader in, QName elementName) throws XMLStreamException {
        if (XMLUtil.ESB_QNAME_HEADER.equals(elementName)) {
            this._theHeader = new HeaderImpl(in);
        } else if (XMLUtil.ESB_QNAME_CONTEXT.equals(elementName)) {
            this._theContext = new ContextImpl(in);
        } else if (XMLUtil.ESB_QNAME_BODY.equals(elementName)) {
            this._theBody = new BodyImpl(in);
        } else if (XMLUtil.ESB_QNAME_ATTACHMENT.equals(elementName)) {
            this._theAttachment = new AttachmentImpl(in);
        } else if (XMLUtil.ESB_QNAME_PROPERTIES.equals(elementName)) {
            this._theProperties = new PropertiesImpl(in);
        } else {
            throw new XMLStreamException("Unexpected element name: " + elementName);
        }
    }

    @Override
    public Message reference() {
        return new MessageImpl(this);
    }

    void replaceBody(BodyImpl body) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        this._theBody = body;
    }
}

