/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.message.format.xml;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.message.format.xml.SerializedValueImpl;
import org.jboss.internal.soa.esb.message.format.xml.XMLUtil;
import org.jboss.internal.soa.esb.util.Encoding;
import org.jboss.internal.soa.esb.util.stax.ElementContent;
import org.jboss.internal.soa.esb.util.stax.StreamHelper;
import org.jboss.internal.soa.esb.util.stax.TextElement;
import org.jboss.soa.esb.message.Context;

public class ContextImpl
extends ElementContent
implements Context {
    private Map<String, SerializedValueImpl> context = new HashMap<String, SerializedValueImpl>();

    public ContextImpl() {
    }

    ContextImpl(ContextImpl copy) {
        this.context.putAll(copy.context);
    }

    public ContextImpl(XMLStreamReader in) throws XMLStreamException {
        this.parse(in);
    }

    public String toString() {
        return "context: " + this.context;
    }

    @Override
    public Object setContext(String key, Object value) {
        AssertArgument.isNotNull(key, "key");
        AssertArgument.isNotNull(value, "value");
        if (value instanceof Serializable) {
            return this.unwrap(this.context.put(key, new SerializedValueImpl((Serializable)value)));
        }
        throw new IllegalArgumentException("value must be serializable");
    }

    @Override
    public Object getContext(String key) {
        return this.unwrap(this.context.get(key));
    }

    @Override
    public Object removeContext(String key) {
        return this.unwrap(this.context.remove(key));
    }

    @Override
    public Set<String> getContextKeys() {
        return Collections.unmodifiableSet(this.context.keySet());
    }

    @Override
    public void clearContext() {
        this.context = new HashMap<String, SerializedValueImpl>();
    }

    @Override
    protected void writeChildContent(XMLStreamWriter out) throws XMLStreamException {
        for (Map.Entry<String, SerializedValueImpl> entry : this.context.entrySet()) {
            String origPropertyURI = StreamHelper.writeStartElement(out, XMLUtil.ESB_QNAME_CONTEXT_ENTRY);
            TextElement keyElement = new TextElement(Encoding.encodeBytes(entry.getKey().getBytes()));
            StreamHelper.writeElement(out, XMLUtil.ESB_QNAME_CONTEXT_ENTRY_KEY, keyElement);
            String value = entry.getValue().getSerialisedForm();
            TextElement valueElement = new TextElement(value);
            StreamHelper.writeElement(out, XMLUtil.ESB_QNAME_CONTEXT_ENTRY_VALUE, valueElement);
            StreamHelper.writeEndElement(out, XMLUtil.ESB_QNAME_CONTEXT_ENTRY.getPrefix(), origPropertyURI);
        }
    }

    @Override
    protected void putElement(XMLStreamReader in, QName elementName) throws XMLStreamException {
        if (!XMLUtil.ESB_QNAME_CONTEXT_ENTRY.equals(elementName)) {
            throw new XMLStreamException("Unexpected element name: " + elementName);
        }
        StreamHelper.checkNextStartTag(in, XMLUtil.ESB_QNAME_CONTEXT_ENTRY_KEY);
        TextElement keyElement = new TextElement(in);
        String key = new String(Encoding.decodeToBytes(keyElement.getText()));
        StreamHelper.checkNextStartTag(in, XMLUtil.ESB_QNAME_CONTEXT_ENTRY_VALUE);
        TextElement valueElement = new TextElement(in);
        SerializedValueImpl value = new SerializedValueImpl(valueElement.getText());
        StreamHelper.checkParentFinished(in);
        this.context.put(key, value);
    }

    private Object unwrap(SerializedValueImpl value) {
        return value == null ? null : value.getValue();
    }
}

