/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.message.format.xml;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.internal.soa.esb.addressing.helpers.EPRHelper;
import org.jboss.internal.soa.esb.message.format.xml.XMLUtil;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.internal.soa.esb.util.stax.ElementContent;
import org.jboss.internal.soa.esb.util.stax.NamedElement;
import org.jboss.internal.soa.esb.util.stax.StreamHelper;
import org.jboss.internal.soa.esb.util.stax.TextElement;
import org.jboss.internal.soa.esb.util.stax.URIElement;
import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.PortReference;

public class CallImpl
extends ElementContent {
    private final Call call;
    private List<NamedElement> extensions = new ArrayList<NamedElement>();

    public CallImpl(Call call) {
        this.call = call;
    }

    public CallImpl(XMLStreamReader in) throws XMLStreamException {
        this.call = new Call();
        this.parse(in);
        if (this.extensions.size() > 0) {
            EPR origEPR = this.call.getTo();
            PortReference to = origEPR.getAddr();
            for (NamedElement element : this.extensions) {
                QName name = element.getName();
                TextElement content = (TextElement)element.getElementContent();
                to.addExtension(name.getLocalPart(), name.getPrefix(), name.getNamespaceURI(), content.getText());
            }
            this.call.setTo(EPRHelper.getSpecificEPR(origEPR));
        }
    }

    public Call getCall() {
        return this.call;
    }

    @Override
    protected void writeChildContent(XMLStreamWriter out) throws XMLStreamException {
        URIElement actionElement;
        StreamHelper.writeNamespace(out, "wsa", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
        if (this.call.getTo() != null) {
            EPRHelper.toXML(out, org.jboss.soa.esb.addressing.XMLUtil.QNAME_TO_TAG, this.call.getTo());
        }
        if (this.call.getFrom() != null) {
            EPRHelper.toXML(out, org.jboss.soa.esb.addressing.XMLUtil.QNAME_FROM_TAG, this.call.getFrom());
        }
        if (this.call.getReplyTo() != null) {
            EPRHelper.toXML(out, org.jboss.soa.esb.addressing.XMLUtil.QNAME_REPLY_TO_TAG, this.call.getReplyTo());
        }
        if (this.call.getRelatesTo() != null) {
            actionElement = new URIElement(this.call.getRelatesTo());
            StreamHelper.writeElement(out, org.jboss.soa.esb.addressing.XMLUtil.QNAME_RELATES_TO_TAG, actionElement);
        }
        if (this.call.getFaultTo() != null) {
            EPRHelper.toXML(out, org.jboss.soa.esb.addressing.XMLUtil.QNAME_FAULT_TO_TAG, this.call.getFaultTo());
        }
        if (this.call.getAction() != null) {
            actionElement = new URIElement(this.call.getAction());
            StreamHelper.writeElement(out, org.jboss.soa.esb.addressing.XMLUtil.QNAME_ACTION_TAG, actionElement);
        }
        if (this.call.getMessageID() != null) {
            URIElement messageIdElement = new URIElement(this.call.getMessageID());
            StreamHelper.writeElement(out, org.jboss.soa.esb.addressing.XMLUtil.QNAME_MESSAGE_IDENTIFIER_TAG, messageIdElement);
        }
    }

    @Override
    protected void putElement(XMLStreamReader in, QName elementName) throws XMLStreamException {
        if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(elementName.getNamespaceURI())) {
            String name = elementName.getLocalPart();
            if ("To".equals(name)) {
                this.call.setTo(EPRHelper.fromXML(in));
            } else if ("From".equals(name)) {
                this.call.setFrom(EPRHelper.fromXML(in));
            } else if ("ReplyTo".equals(name)) {
                this.call.setReplyTo(EPRHelper.fromXML(in));
            } else if ("RelatesTo".equals(name)) {
                URIElement relatesTo = new URIElement(in);
                this.call.setRelatesTo(relatesTo.getValue());
            } else if ("FaultTo".equals(name)) {
                this.call.setFaultTo(EPRHelper.fromXML(in));
            } else if ("Action".equals(name)) {
                URIElement action = new URIElement(in);
                this.call.setAction(action.getValue());
            } else if ("MessageID".equals(name)) {
                URIElement messageIdentifier = new URIElement(in);
                this.call.setMessageID(messageIdentifier.getValue());
            } else {
                TextElement content = new TextElement(in);
                this.extensions.add(new NamedElement(elementName, content));
            }
        } else {
            TextElement content = new TextElement(in);
            this.extensions.add(new NamedElement(elementName, content));
        }
    }

    public static String toXML(Call call) throws XMLStreamException {
        CallImpl callImpl = new CallImpl(call);
        StringWriter writer = new StringWriter();
        XMLStreamWriter out = XMLHelper.getXMLStreamWriter(writer);
        QName name = XMLUtil.ESB_QNAME_HEADER;
        String origURI = StreamHelper.writeStartElement(out, name);
        callImpl.writeContent(out);
        StreamHelper.writeEndElement(out, name.getPrefix(), origURI);
        out.flush();
        return writer.toString();
    }

    public static Call fromXML(String content) throws XMLStreamException {
        StringReader reader = new StringReader(content);
        XMLStreamReader in = XMLHelper.getXMLStreamReader(reader);
        StreamHelper.checkNextStartTag(in, XMLUtil.ESB_QNAME_HEADER);
        CallImpl callImpl = new CallImpl(in);
        return callImpl.getCall();
    }
}

