/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.message.format.serialized;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jboss.internal.soa.esb.message.format.DeferredDeserialisationException;
import org.jboss.soa.esb.util.ContextObjectInputStream;

public class SerializedValueImpl
implements Serializable {
    private static final long serialVersionUID = -5354588126152655437L;
    private transient Serializable value;
    private byte[] serialisedForm;

    private SerializedValueImpl(Serializable value) {
        this.value = value;
    }

    public Serializable getValue() {
        if (this.value == null && this.serialisedForm != null) {
            ContextObjectInputStream ois;
            ByteArrayInputStream bais = new ByteArrayInputStream(this.serialisedForm);
            try {
                ois = new ContextObjectInputStream(bais);
            }
            catch (IOException ioe) {
                throw new DeferredDeserialisationException("Error creating object input stream", ioe);
            }
            try {
                this.value = (Serializable)ois.readObject();
            }
            catch (IOException ioe) {
                throw new DeferredDeserialisationException("Error reading object input stream", ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new DeferredDeserialisationException("Error constructing object value", cnfe);
            }
            this.serialisedForm = null;
        }
        return this.value;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this.value != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.value);
            this.serialisedForm = baos.toByteArray();
        }
        stream.defaultWriteObject();
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return "Deferred serialized value: " + Integer.toHexString(System.identityHashCode(this));
    }

    public static Serializable wrap(Serializable value) {
        Class<?> componentType;
        if (value != null && (componentType = SerializedValueImpl.getComponentType(value.getClass())) != Boolean.class && componentType != Boolean.TYPE && componentType != Byte.class && componentType != Byte.TYPE && componentType != Short.class && componentType != Short.TYPE && componentType != Character.class && componentType != Character.TYPE && componentType != Integer.class && componentType != Integer.TYPE && componentType != Long.class && componentType != Long.TYPE && componentType != Float.class && componentType != Float.TYPE && componentType != Double.class && componentType != Double.TYPE && componentType != String.class && componentType != SerializedValueImpl.class) {
            return new SerializedValueImpl(value);
        }
        return value;
    }

    public static Serializable unwrap(Serializable value) {
        if (value instanceof SerializedValueImpl) {
            return ((SerializedValueImpl)value).getValue();
        }
        return value;
    }

    public static void wrapList(List<Serializable> list) {
        int listSize = list.size();
        for (int count = 0; count < listSize; ++count) {
            Serializable wrapped;
            Serializable current = list.get(count);
            if (current == (wrapped = SerializedValueImpl.wrap(current))) continue;
            list.set(count, wrapped);
        }
    }

    public static <K> void wrapMap(Map<K, Serializable> map) {
        if (map.size() > 0) {
            Hashtable<K, Serializable> wrappedMap = null;
            for (Map.Entry<K, Serializable> entry : map.entrySet()) {
                Serializable wrapped;
                Serializable current = entry.getValue();
                if (current == (wrapped = SerializedValueImpl.wrap(current))) continue;
                if (wrappedMap == null) {
                    wrappedMap = new Hashtable<K, Serializable>();
                }
                wrappedMap.put(entry.getKey(), wrapped);
            }
            if (wrappedMap != null) {
                map.putAll(wrappedMap);
            }
        }
    }

    private static Class<?> getComponentType(Class<?> clazz) {
        if (clazz.isArray()) {
            return SerializedValueImpl.getComponentType(clazz.getComponentType());
        }
        return clazz;
    }
}

