/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.message.format.serialized;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.message.format.serialized.SerializedValueImpl;
import org.jboss.soa.esb.message.Body;
import org.jboss.soa.esb.util.Util;

public class BodyImpl
implements Body,
Serializable {
    private static final long serialVersionUID = 0L;
    private Hashtable<String, Serializable> _objects;

    public BodyImpl() {
        this._objects = new Hashtable();
    }

    @Override
    public void setByteArray(byte[] content) {
        this.add("org.jboss.soa.esb.message.content.bytes", content);
    }

    @Override
    public byte[] getByteArray() {
        return (byte[])this.get("org.jboss.soa.esb.message.content.bytes");
    }

    @Override
    public void setContents(byte[] content) {
        this.setByteArray(content);
    }

    @Override
    public byte[] getContents() {
        return this.getByteArray();
    }

    @Override
    public void add(Object value) {
        this.add("org.jboss.soa.esb.message.defaultEntry", value);
    }

    @Override
    public synchronized void add(String name, Object value) {
        AssertArgument.isNotNull(value, "value");
        AssertArgument.isNotNull(name, "name");
        if (!(value instanceof Serializable)) {
            throw new IllegalArgumentException("Object must be Serializable.");
        }
        this._objects.put(name, SerializedValueImpl.wrap((Serializable)value));
    }

    @Override
    public Object get() {
        return this.get("org.jboss.soa.esb.message.defaultEntry");
    }

    @Override
    public synchronized Object get(String name) {
        AssertArgument.isNotNull(name, "name");
        return SerializedValueImpl.unwrap(this._objects.get(name));
    }

    @Override
    public synchronized String[] getNames() {
        Set<String> keys = this._objects.keySet();
        return keys.toArray(new String[0]);
    }

    public Enumeration<String> getEnumeratedNames() {
        return Collections.enumeration(Arrays.asList(this.getNames()));
    }

    @Override
    public synchronized Object remove(String name) {
        return SerializedValueImpl.unwrap(this._objects.remove(name));
    }

    @Override
    public void replace(Body b) {
        if (b == null) {
            throw new IllegalArgumentException();
        }
        this.setByteArray(b.getByteArray());
        this._objects = ((BodyImpl)b)._objects;
    }

    @Override
    public void merge(Body b) {
        if (b == null) {
            throw new IllegalArgumentException();
        }
        BodyImpl toMerge = null;
        if (!(b instanceof BodyImpl)) {
            throw new IllegalArgumentException();
        }
        toMerge = (BodyImpl)b;
        this._objects.putAll(toMerge._objects);
        byte[] toAdd = b.getByteArray();
        if (toAdd != null && toAdd.length > 0) {
            this.setByteArray(toAdd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder toReturn = new StringBuilder("body: [ ");
        byte[] content = this.getByteArray();
        if (content != null) {
            toReturn.append("byte[]: ").append(Util.format(new String(content))).append(", ");
        }
        BodyImpl bodyImpl = this;
        synchronized (bodyImpl) {
            toReturn.append("objects: ").append(this._objects.toString());
        }
        return toReturn.append(" ]").toString();
    }

    protected BodyImpl(BodyImpl orig) {
        this._objects = new Hashtable<String, Serializable>(orig._objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialiseMap(Map<String, Serializable> payload) {
        BodyImpl bodyImpl = this;
        synchronized (bodyImpl) {
            this._objects.clear();
            this._objects.putAll(payload);
            SerializedValueImpl.wrapMap(this._objects);
        }
    }
}

