/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.message.format;

import java.net.URI;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.jboss.internal.soa.esb.message.format.serialized.SerializedMessagePlugin;
import org.jboss.internal.soa.esb.message.format.xml.XMLMessagePlugin;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.message.format.MessagePlugin;
import org.jboss.soa.esb.message.format.MessageType;
import org.jboss.soa.esb.util.ClassUtil;

public class MessageFactoryImpl
extends MessageFactory {
    private final Hashtable<URI, MessagePlugin> messageFormats = new Hashtable();

    public MessageFactoryImpl() {
        this.reset();
    }

    @Override
    public void reset() {
        this.messageFormats.clear();
        Properties properties = ModulePropertyManager.getPropertyManager("core").getProperties();
        if (properties != null) {
            Enumeration<?> names = properties.propertyNames();
            while (names.hasMoreElements()) {
                String attrName = (String)names.nextElement();
                if (!attrName.startsWith("org.jboss.soa.esb.message.format.plugin")) continue;
                try {
                    String pluginName = properties.getProperty(attrName);
                    Class c = ClassUtil.forName(pluginName, this.getClass());
                    MessagePlugin thePlugin = (MessagePlugin)c.newInstance();
                    this.messageFormats.put(thePlugin.getType(), thePlugin);
                }
                catch (ClassNotFoundException ex) {
                    ex.printStackTrace();
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                }
                catch (InstantiationException ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.messageFormats.put(MessageType.JBOSS_XML, new XMLMessagePlugin());
        this.messageFormats.put(MessageType.JAVA_SERIALIZED, new SerializedMessagePlugin());
    }

    @Override
    public Message getMessage() {
        return this.messageFormats.get(MessageType.DEFAULT_TYPE).getMessage();
    }

    @Override
    public Message getMessage(URI type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        MessagePlugin plugin = this.messageFormats.get(type);
        if (plugin != null) {
            return plugin.getMessage();
        }
        return null;
    }

    @Override
    public Message getMessage(Message msg, URI type) {
        if (msg == null || type == null) {
            throw new IllegalArgumentException();
        }
        return null;
    }

    @Override
    public Object createBodyType(Message m, String bodyType) {
        if (m == null) {
            throw new IllegalArgumentException();
        }
        MessagePlugin plugin = this.messageFormats.get(m.getType());
        if (plugin != null) {
            return plugin.createBodyType(m, bodyType);
        }
        throw new IllegalArgumentException();
    }
}

