/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.message.filter;

import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.filter.InputOutputFilter;
import org.jboss.soa.esb.message.Message;

public class TraceFilter
extends InputOutputFilter {
    public static final String UNLOGGABLE_MESSAGE = "org.jboss.soa.esb.message.unloggable";
    private boolean _enabled = ModulePropertyManager.getPropertyManager("filters").getProperty("org.jboss.soa.esb.messagetrace", "off").equalsIgnoreCase("on");
    private boolean _permsg = ModulePropertyManager.getPropertyManager("filters").getProperty("org.jboss.soa.esb.permessagetrace", "off").equalsIgnoreCase("on");
    private static final Logger _logger = Logger.getLogger(TraceFilter.class);

    @Override
    public Message onOutput(Message msg, Map<String, Object> params) throws CourierException {
        if (this._enabled) {
            Object unloggable;
            boolean ignore = false;
            if (this._permsg && (unloggable = msg.getProperties().getProperty(UNLOGGABLE_MESSAGE, "no")) instanceof String && ((String)unloggable).equalsIgnoreCase("yes")) {
                ignore = true;
            }
            if (!ignore) {
                _logger.info((Object)("TraceFilter.onOutput ( " + msg.getHeader() + " )"));
            }
        }
        return msg;
    }

    @Override
    public Message onInput(Message msg, Map<String, Object> params) throws CourierException {
        if (this._enabled) {
            Object unloggable;
            boolean ignore = false;
            if (this._permsg && (unloggable = msg.getProperties().getProperty(UNLOGGABLE_MESSAGE, "no")) instanceof String && ((String)unloggable).equalsIgnoreCase("yes")) {
                ignore = true;
            }
            if (!ignore) {
                _logger.info((Object)("TraceFilter.onInput ( " + msg.getHeader() + " )"));
            }
        }
        return msg;
    }
}

