/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.listeners.war;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.listeners.war.Filter;
import org.jboss.internal.soa.esb.listeners.war.Servlet;
import org.jboss.soa.esb.ConfigurationException;

public class WebModel {
    private String esbName;
    private List<Filter> filters = new ArrayList<Filter>();
    private List<Servlet> servlets = new ArrayList<Servlet>();
    private Set<String> securityRoles = new LinkedHashSet<String>();
    private String authMethod;
    private String authDomain;

    public WebModel(String esbName) {
        AssertArgument.isNotNullAndNotEmpty(esbName, "esbName");
        this.esbName = esbName;
    }

    public String getEsbName() {
        return this.esbName;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public List<Servlet> getServlets() {
        return this.servlets;
    }

    public Set<String> getSecurityRoles() {
        return this.securityRoles;
    }

    public String getAuthMethod() {
        if (!(this.authMethod != null || this.authDomain == null && this.securityRoles.isEmpty())) {
            return "BASIC";
        }
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) throws ConfigurationException {
        if (authMethod == null) {
            return;
        }
        if (this.authMethod != null && !this.authMethod.equals(authMethod)) {
            throw new ConfigurationException("The authentication method for the web deployment associated with this deployment has already been set to '" + this.authMethod + "'.  Cannot reset to '" + authMethod + "'.");
        }
        this.authMethod = authMethod;
    }

    public String getAuthDomain() {
        return this.authDomain;
    }

    public void setAuthDomain(String authDomain) throws ConfigurationException {
        if (authDomain == null) {
            return;
        }
        if (!authDomain.startsWith("java:/jaas/")) {
            authDomain = "java:/jaas/" + authDomain;
        }
        if (this.authDomain != null && !this.authDomain.equals(authDomain)) {
            throw new ConfigurationException("The authentication domain for the web deployment associated with this deployment has already been set to '" + this.authDomain + "'.  Cannot reset to '" + authDomain + "'.");
        }
        this.authDomain = authDomain;
    }
}

