/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.listeners.war;

import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.jboss.internal.soa.esb.listeners.war.WebModel;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.util.DeploymentArchive;
import org.jboss.soa.esb.util.FreeMarkerTemplate;

public class WebDeploymentArchive
extends DeploymentArchive {
    private WebModel webModel;
    private boolean archiveFinalized = false;

    public WebDeploymentArchive(String archiveName) {
        super(archiveName);
        this.webModel = new WebModel(archiveName);
    }

    public WebModel getWebModel() {
        this.assertNotFinalized();
        return this.webModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeArchive() throws ConfigurationException {
        try {
            this.addWebXML();
            this.addJBossWebXML();
        }
        finally {
            this.archiveFinalized = true;
        }
    }

    private void addWebXML() throws ConfigurationException {
        try {
            String webXml = this.getWebXML();
            this.addEntry("WEB-INF/web.xml", new ByteArrayInputStream(webXml.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new ConfigurationException("Error adding web.xml to web deployment.", e);
        }
    }

    String getWebXML() throws TemplateException {
        FreeMarkerTemplate template = new FreeMarkerTemplate("templates/web.xml.ftl", WebDeploymentArchive.class);
        HashMap<String, WebModel> contextObj = new HashMap<String, WebModel>();
        contextObj.put("webModel", this.webModel);
        return template.apply(contextObj);
    }

    private void addJBossWebXML() throws ConfigurationException {
        try {
            String jbossWebXml = this.getJBossWebXML();
            this.addEntry("WEB-INF/jboss-web.xml", new ByteArrayInputStream(jbossWebXml.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new ConfigurationException("Error adding web.xml to web deployment.", e);
        }
    }

    String getJBossWebXML() throws TemplateException {
        FreeMarkerTemplate template = new FreeMarkerTemplate("templates/jboss-web.xml.ftl", WebDeploymentArchive.class);
        HashMap<String, WebModel> contextObj = new HashMap<String, WebModel>();
        contextObj.put("webModel", this.webModel);
        return template.apply(contextObj);
    }

    @Override
    public final void addEntry(String path, InputStream data) {
        this.assertNotFinalized();
        super.addEntry(path, data);
    }

    @Override
    public final void addEntry(String path, byte[] data) {
        this.assertNotFinalized();
        super.addEntry(path, data);
    }

    @Override
    public final void addEntry(String path) {
        super.addEntry(path);
    }

    @Override
    public final void addEntry(String path, String resource) throws IOException {
        super.addEntry(path, resource);
    }

    @Override
    public void addEntry(Class clazz) throws IOException {
        super.addEntry(clazz);
    }

    private void assertNotFinalized() {
        if (this.archiveFinalized) {
            throw new IllegalStateException("Cannot update archive after it has been finalized!");
        }
    }
}

