/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.listeners.war;

import org.jboss.internal.soa.esb.listeners.war.SecurityConstraints;
import org.jboss.internal.soa.esb.listeners.war.Servlet;
import org.jboss.internal.soa.esb.listeners.war.WebGatewayDeploymentFactory;
import org.jboss.internal.soa.esb.listeners.war.WebModel;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.soa.esb.http.HttpConfiguration;
import org.jboss.soa.esb.listeners.gateway.http.HttpGatewayServlet;

public class HttpGatewayDeploymentFactory
implements WebGatewayDeploymentFactory {
    public static final String URL_PATTERN = "urlPattern";
    public static final String PROTECTED_METHODS = "protectedMethods";
    public static final String TRANSPORT_GUARANTEE = "transportGuarantee";
    public static final String ALLOWED_ROLES = "allowedRoles";
    public static final String AUTH_METHOD = "authMethod";
    public static final String AUTH_DOMAIN = "authDomain";

    @Override
    public void updateWebModel(ConfigTree webEndpointConfig, WebModel webModel) throws ConfigurationException {
        String urlMapping;
        String servletName = webEndpointConfig.getRequiredAttribute("name");
        Servlet servlet = new Servlet(servletName, HttpGatewayServlet.class.getName(), webModel);
        servlet.setService(Service.getGatewayTargetService(webEndpointConfig));
        String urlPattern = webEndpointConfig.getAttribute(URL_PATTERN);
        if (urlPattern != null) {
            urlMapping = urlPattern.startsWith("/") ? "/http" + urlPattern : "/http/" + urlPattern;
        } else {
            String serviceCat = webEndpointConfig.getAttribute("target-service-category");
            String serviceName = webEndpointConfig.getAttribute("target-service-name");
            urlMapping = "/http/" + serviceCat + "/" + serviceName;
        }
        servlet.getUrlMappings().add(urlMapping);
        String allowedPorts = webEndpointConfig.getAttribute("allowedPorts");
        if (allowedPorts != null) {
            servlet.getParams().add(new KeyValuePair("allowedPorts", allowedPorts));
        }
        this.addEndpointAddress(webEndpointConfig, servlet, urlMapping);
        this.addSecurityConstraints(webEndpointConfig, servlet);
        servlet.getParams().addAll(webEndpointConfig.attributesAsList());
    }

    private void addEndpointAddress(ConfigTree webEndpointConfig, Servlet servlet, String urlMapping) {
        String transportGuarantee = webEndpointConfig.getAttribute(TRANSPORT_GUARANTEE);
        boolean secure = "CONFIDENTIAL".equals(transportGuarantee) || "INTEGRAL".equals(transportGuarantee);
        String path = servlet.getWebModel().getEsbName();
        path = path.substring(0, path.length() - 4) + urlMapping;
        while (path.endsWith("*") || path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        String address = secure ? HttpConfiguration.getSecureAddress(path) : HttpConfiguration.getAddress(path);
        servlet.getParams().add(new KeyValuePair("endpointAddress", address));
        servlet.setEndpointAddress(address);
    }

    private void addSecurityConstraints(ConfigTree webEndpointConfig, Servlet servlet) {
        String transportGuarantee;
        String rolesConfig;
        String methodsConfig = webEndpointConfig.getAttribute(PROTECTED_METHODS);
        if (methodsConfig != null) {
            String[] methods;
            SecurityConstraints securityConstraints = this.getSecurityConstraints(servlet);
            for (String method : methods = methodsConfig.split(",")) {
                securityConstraints.getProtectedMethods().add(method.trim());
            }
        }
        if ((rolesConfig = webEndpointConfig.getAttribute(ALLOWED_ROLES)) != null) {
            String[] roles;
            SecurityConstraints securityConstraints = this.getSecurityConstraints(servlet);
            for (String role : roles = rolesConfig.split(",")) {
                securityConstraints.getAllowedRoles().add(role.trim());
            }
        }
        if ((transportGuarantee = webEndpointConfig.getAttribute(TRANSPORT_GUARANTEE)) != null) {
            this.getSecurityConstraints(servlet).setTransportGuarantee(transportGuarantee);
        }
    }

    private SecurityConstraints getSecurityConstraints(Servlet servlet) {
        SecurityConstraints securityConstraints = servlet.getSecurityConstraints();
        if (securityConstraints == null) {
            securityConstraints = new SecurityConstraints(servlet);
        }
        return securityConstraints;
    }
}

