/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.dependencies;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.dependencies.JuddiClientServiceMBean;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.system.ServiceMBeanSupport;

public class JuddiClientService
extends ServiceMBeanSupport
implements JuddiClientServiceMBean {
    private static final Logger logger = Logger.getLogger(JuddiClientService.class);
    private static final String DEFAULT_UDDI_CLIENT_FILE = "esb.juddi.client.xml";
    private static final String UDDI_CLIENT_RESOURCE_FILE = "uddi.xml";
    private String propertiesResourceFile;
    private String propertiesFileDir;

    @Override
    public String getPropertiesResourceFile() {
        return this.propertiesResourceFile;
    }

    @Override
    public void setPropertiesResourceFile(String propertiesResourceFile) {
        this.propertiesResourceFile = propertiesResourceFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        InputStream xmlPropertyIS;
        logger.info((Object)"starting juddi client service");
        String propertiesResourceFileVal = this.propertiesResourceFile == null ? DEFAULT_UDDI_CLIENT_FILE : this.propertiesResourceFile;
        File baseFile = new File(propertiesResourceFileVal);
        if (this.propertiesFileDir == null) {
            String errorMsg = String.format("No property named '%s' was configured in jbossesb.sar/META-INF/jboss-service.xml for %s", "propertiesFileDir", this.getClass().getName());
            throw new IllegalArgumentException(errorMsg);
        }
        File dataDir = new File(this.propertiesFileDir);
        if (!dataDir.exists()) {
            String errorMsg = String.format("The directory configured for %s='%s' does not exist.", "warFilesDir", dataDir);
            throw new FileNotFoundException(errorMsg);
        }
        File uddiClientResourceFile = new File(dataDir, UDDI_CLIENT_RESOURCE_FILE);
        if (baseFile.isAbsolute()) {
            xmlPropertyIS = new FileInputStream(baseFile);
        } else {
            URL url = Thread.currentThread().getContextClassLoader().getResource(propertiesResourceFileVal);
            xmlPropertyIS = url.openStream();
        }
        try {
            FileOutputStream os = new FileOutputStream(uddiClientResourceFile);
            try {
                XMLHelper.replaceSystemProperties(XMLHelper.getXMLStreamReader(xmlPropertyIS), XMLHelper.getXMLStreamWriter(os));
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        finally {
            xmlPropertyIS.close();
        }
        System.setProperty("uddi.client.xml", uddiClientResourceFile.getAbsolutePath());
        System.setProperty("javax.xml.registry.ConnectionFactoryClass", "org.apache.ws.scout.registry.ConnectionFactoryImpl");
    }

    protected void stopService() throws Exception {
    }

    @Override
    public void setPropertiesFileDir(String directory) {
        this.propertiesFileDir = directory;
    }
}

