/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.dependencies;

import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.jboss.internal.soa.esb.dependencies.DatabaseInitializerMBean;
import org.jboss.soa.esb.listeners.config.Configuration;
import org.jboss.system.ServiceMBeanSupport;

public class DatabaseInitializer
extends ServiceMBeanSupport
implements DatabaseInitializerMBean {
    private String datasource;
    private String sqlFiles;
    private String existsSql;
    private boolean useEOL;

    @Override
    public String getExistsSql() {
        return this.existsSql;
    }

    @Override
    public void setExistsSql(String existsSql) {
        this.existsSql = existsSql;
    }

    @Override
    public boolean getUseEOL() {
        return this.useEOL;
    }

    @Override
    public void setUseEOL(boolean useEOL) {
        this.useEOL = useEOL;
    }

    @Override
    public String getSqlFiles() {
        return this.sqlFiles;
    }

    @Override
    public void setSqlFiles(String sqlFiles) {
        this.sqlFiles = sqlFiles;
    }

    @Override
    public String getDatasource() {
        return this.datasource;
    }

    @Override
    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    protected void initDatabase() throws Exception {
        String[] list;
        DataSource ds = (DataSource)new InitialContext().lookup(this.datasource);
        Connection conn = ds.getConnection();
        boolean load = false;
        Statement st = conn.createStatement();
        ResultSet rs = null;
        try {
            rs = st.executeQuery(this.existsSql.trim());
            rs.close();
        }
        catch (SQLException e) {
            load = true;
        }
        st.close();
        if (!load) {
            this.log.info((Object)(this.datasource + " datasource is already initialized"));
            return;
        }
        this.log.info((Object)("Initializing " + this.datasource + " from listed sql files"));
        for (String sql : list = this.sqlFiles.split(",")) {
            this.executeSql(sql.trim(), conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSql(String resource, Connection conn) throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
        String sql = Configuration.getStringFromStream(url.openStream());
        sql = sql.replaceAll("(?m)^--([^\n]+)?$", "");
        String[] statements = this.useEOL ? sql.split("[\n;]") : sql.split(";");
        for (String statement : statements) {
            if (statement == null || "".equals(statement.trim())) continue;
            Statement sqlStatement = conn.createStatement();
            try {
                sqlStatement.executeUpdate(statement);
            }
            finally {
                sqlStatement.close();
            }
        }
    }

    protected void startService() throws Exception {
        this.initDatabase();
        super.startService();
    }
}

