/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.couriers.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.couriers.transport.InVMException;
import org.jboss.internal.soa.esb.couriers.tx.InVMXAResource;
import org.jboss.internal.soa.esb.message.format.MessageSerializer;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.eprs.InVMEpr;
import org.jboss.soa.esb.common.TransactionStrategy;
import org.jboss.soa.esb.common.TransactionStrategyException;
import org.jboss.soa.esb.message.ByReferenceMessage;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.registry.ServiceNotFoundException;

public class InVMTransport {
    private static final Logger LOGGER = Logger.getLogger(InVMTransport.class);
    private final Map<String, InVMEntry> serviceIdToEntry = new HashMap<String, InVMEntry>();
    private final Map<String, Map<String, InVMEntry>> categoryToNameToEntry = new HashMap<String, Map<String, InVMEntry>>();
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private static InVMTransport instance = new InVMTransport();

    public static InVMTransport getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEPR(String category, String name, InVMEpr epr) throws InVMException {
        if (epr.isTemporaryEPR()) {
            throw new InVMException("Attempt to register temporary EPR in permanent registry");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Registering EPR " + epr + " for category " + category + ", name " + name));
        }
        String serviceId = epr.getServiceId();
        this.acquireWriteLock();
        try {
            InVMEntry entry;
            InVMEntry existingEntry = this.serviceIdToEntry.get(serviceId);
            Map<String, InVMEntry> nameToEntry = this.categoryToNameToEntry.get(category);
            if (nameToEntry == null) {
                if (existingEntry != null) {
                    throw new InVMException("Service " + serviceId + " registered under a multiple categories");
                }
                nameToEntry = new HashMap<String, InVMEntry>();
                this.categoryToNameToEntry.put(category, nameToEntry);
            }
            if ((entry = nameToEntry.get(name)) == null) {
                if (existingEntry != null) {
                    throw new InVMException("Service " + serviceId + " registered under a multiple names");
                }
                entry = new InVMEntry(serviceId);
                nameToEntry.put(name, entry);
            } else if (existingEntry != null && existingEntry != entry) {
                throw new InVMException("Service " + serviceId + " registered under a multiple names");
            }
            if (entry.addEPR(epr)) {
                this.serviceIdToEntry.put(serviceId, entry);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unRegisterService(String category, String name) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Unregistering service category " + category + ", name " + name));
        }
        this.acquireWriteLock();
        try {
            Map<String, InVMEntry> nameToEntry = this.categoryToNameToEntry.get(category);
            if (nameToEntry == null) {
                boolean bl = false;
                return bl;
            }
            InVMEntry entry = nameToEntry.remove(name);
            if (entry == null) {
                boolean bl = false;
                return bl;
            }
            entry.shutdown();
            if (nameToEntry.isEmpty()) {
                this.categoryToNameToEntry.remove(category);
            }
            this.serviceIdToEntry.remove(entry.getServiceId());
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterEPR(String category, String name, InVMEpr epr) throws ServiceNotFoundException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Unregistering EPR " + epr + " for category " + category + ", name " + name));
        }
        this.acquireWriteLock();
        try {
            Map<String, InVMEntry> nameToEntry = this.categoryToNameToEntry.get(category);
            if (nameToEntry == null) {
                throw new ServiceNotFoundException("Could not locate any services for category " + category);
            }
            InVMEntry entry = nameToEntry.get(name);
            if (entry == null) {
                throw new ServiceNotFoundException("Could not locate service " + category + ", " + name);
            }
            if (entry.removeEPR(epr)) {
                nameToEntry.remove(name);
                entry.shutdown();
                if (nameToEntry.isEmpty()) {
                    this.categoryToNameToEntry.remove(category);
                }
                this.serviceIdToEntry.remove(entry.getServiceId());
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> findAllServices() {
        ArrayList<String> result = new ArrayList<String>();
        this.acquireReadLock();
        try {
            for (Map<String, InVMEntry> nameToEntry : this.categoryToNameToEntry.values()) {
                result.addAll(nameToEntry.keySet());
            }
        }
        finally {
            this.releaseReadLock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> findServices(String category) {
        ArrayList<String> result = new ArrayList<String>();
        this.acquireReadLock();
        try {
            Map<String, InVMEntry> nameToEntry = this.categoryToNameToEntry.get(category);
            if (nameToEntry != null) {
                result.addAll(nameToEntry.keySet());
            }
        }
        finally {
            this.releaseReadLock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EPR> findEPRs(String category, String name) {
        ArrayList<EPR> result = new ArrayList<EPR>();
        this.acquireReadLock();
        try {
            InVMEntry entry;
            Map<String, InVMEntry> nameToEntry = this.categoryToNameToEntry.get(category);
            if (nameToEntry != null && (entry = nameToEntry.get(name)) != null) {
                result.addAll(entry.getEPRs());
            }
        }
        finally {
            this.releaseReadLock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EPR findEPR(String category, String name) {
        this.acquireReadLock();
        try {
            InVMEntry entry;
            Map<String, InVMEntry> nameToEntry = this.categoryToNameToEntry.get(category);
            if (nameToEntry != null && (entry = nameToEntry.get(name)) != null) {
                EPR ePR = entry.getEPRs().get(0);
                return ePR;
            }
        }
        finally {
            this.releaseReadLock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliver(InVMEpr inVMEpr, Message message) throws InVMException {
        long lockstep;
        boolean passByValue;
        InVMEntry entry;
        String serviceId = inVMEpr.getServiceId();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Delivering message to " + serviceId));
        }
        this.acquireReadLock();
        try {
            entry = this.serviceIdToEntry.get(serviceId);
            if (entry == null) {
                throw new InVMException("Could not locate service entry for epr " + inVMEpr);
            }
            passByValue = entry.isPassByValue();
            lockstep = entry.getLockstep();
        }
        finally {
            this.releaseReadLock();
        }
        Object addedObject = InVMTransport.toDeliveryObject(message, passByValue);
        if (InVMTransport.isTransactional()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Delivering transactional message to " + serviceId));
            }
            TransactionStrategy txStrategy = TransactionStrategy.getTransactionStrategy(true);
            try {
                txStrategy.enlistResource(new InVMXAResource(inVMEpr, addedObject, InVMXAResource.Operation.INSERT));
            }
            catch (TransactionStrategyException tse) {
                throw new InVMException("Unexpected error enlisting transaction resource", tse);
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Delivering message direct to " + serviceId + " queue"));
            }
            entry.deliver(addedObject, lockstep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message pickup(InVMEpr inVMEpr, long millis) throws InVMException {
        InVMEntry entry;
        String serviceId = inVMEpr.getServiceId();
        this.acquireReadLock();
        try {
            entry = this.serviceIdToEntry.get(serviceId);
        }
        finally {
            this.releaseReadLock();
        }
        if (entry == null) {
            throw new InVMException("Could not locate service entry for epr " + inVMEpr);
        }
        Object msgObject = entry.pickup(millis);
        if (msgObject != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Pickup of message from " + serviceId));
            }
            Message message = InVMTransport.fromDeliveryObject(msgObject, inVMEpr.getPassByValue());
            if (InVMTransport.isTransactional()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Pickup enlisting transactional resource for service " + serviceId));
                }
                TransactionStrategy txStrategy = TransactionStrategy.getTransactionStrategy(true);
                try {
                    txStrategy.enlistResource(new InVMXAResource(inVMEpr, msgObject, InVMXAResource.Operation.REMOVE));
                }
                catch (TransactionStrategyException tse) {
                    throw new InVMException("Unexpected error enlisting transaction resource", tse);
                }
            }
            return message;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverTx(InVMEpr inVMEpr, Object msgObject) throws InVMException {
        InVMEntry entry;
        String serviceId = inVMEpr.getServiceId();
        this.acquireReadLock();
        try {
            entry = this.serviceIdToEntry.get(serviceId);
        }
        finally {
            this.releaseReadLock();
        }
        if (entry == null) {
            throw new InVMException("Could not locate service entry for epr " + inVMEpr);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Transactional redelivery of message to " + serviceId));
        }
        entry.deliver(msgObject, 0L);
    }

    public static Object toDeliveryObject(Message message, boolean passByValue) throws InVMException {
        Object object;
        if (passByValue) {
            try {
                object = MessageSerializer.serialize(message);
            }
            catch (IOException ex) {
                throw new InVMException("Could not serialize message to pass by value.", ex);
            }
        } else {
            object = message instanceof ByReferenceMessage ? (Object)((ByReferenceMessage)message).reference() : (Object)message;
        }
        return object;
    }

    public static Message fromDeliveryObject(Object msgObject, boolean passByValue) throws InVMException {
        Message message;
        try {
            message = msgObject instanceof byte[] ? MessageSerializer.deserialize((byte[])msgObject) : (passByValue ? ((Message)msgObject).copy() : (Message)msgObject);
        }
        catch (IOException ioe) {
            throw new InVMException("Failed to deserialise incoming message", ioe);
        }
        return message;
    }

    private void acquireReadLock() {
        this.lock.readLock().lock();
    }

    private void releaseReadLock() {
        this.lock.readLock().unlock();
    }

    private void acquireWriteLock() {
        this.lock.writeLock().lock();
    }

    private void releaseWriteLock() {
        this.lock.writeLock().unlock();
    }

    static boolean isTransactional() throws InVMException {
        boolean transactional;
        try {
            TransactionStrategy txStrategy = TransactionStrategy.getTransactionStrategy(true);
            Object txHandle = txStrategy == null ? null : txStrategy.getTransaction();
            boolean isActive = txStrategy == null ? false : txStrategy.isActive();
            boolean bl = transactional = txHandle != null;
            if (transactional && !isActive) {
                throw new InVMException("Associated transaction is no longer active!");
            }
        }
        catch (TransactionStrategyException ex) {
            throw new InVMException(ex);
        }
        return transactional;
    }

    private static class InVMEntry {
        private final Lock lock = new ReentrantLock();
        private final Condition waitingCondition = this.lock.newCondition();
        private int numWaiters;
        private boolean shutdown;
        private final Queue<InVMQueueEntry> entries = new LinkedList<InVMQueueEntry>();
        private final List<InVMEpr> eprs = new LinkedList<InVMEpr>();
        private final String serviceId;
        private int numPassByValue;
        private long lockstep;

        InVMEntry(String serviceId) {
            this.serviceId = serviceId;
        }

        String getServiceId() {
            return this.serviceId;
        }

        List<InVMEpr> getEPRs() {
            return this.eprs;
        }

        boolean addEPR(InVMEpr epr) {
            long eprLockstep;
            boolean result = this.eprs.isEmpty();
            this.eprs.add(epr);
            if (epr.getPassByValue()) {
                ++this.numPassByValue;
            }
            if (epr.getLockstep() && (eprLockstep = epr.getLockstepWaitTime()) > this.lockstep) {
                this.lockstep = eprLockstep;
            }
            return result;
        }

        boolean removeEPR(InVMEpr epr) throws ServiceNotFoundException {
            if (!this.eprs.remove(epr)) {
                throw new ServiceNotFoundException("Could not locate the EPR in the current service");
            }
            if (epr.getPassByValue()) {
                --this.numPassByValue;
            }
            if (epr.getLockstep() && epr.getLockstepWaitTime() == this.lockstep) {
                this.lockstep = 0L;
                for (InVMEpr inVMEpr : this.eprs) {
                    long eprLockstep;
                    if (!inVMEpr.getLockstep() || (eprLockstep = inVMEpr.getLockstepWaitTime()) <= this.lockstep) continue;
                    this.lockstep = eprLockstep;
                }
            }
            return this.eprs.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.lock.lock();
            try {
                this.shutdown = true;
                if (this.numWaiters > 0) {
                    this.waitingCondition.signalAll();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean isPassByValue() {
            return this.numPassByValue > 0;
        }

        public long getLockstep() {
            return this.lockstep;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deliver(Object value, long lockstep) throws InVMException {
            this.lock.lock();
            try {
                if (this.shutdown) {
                    throw new InVMException("InVM Transport already shutdown");
                }
                Condition condition = lockstep > 0L ? this.lock.newCondition() : null;
                InVMQueueEntry queueEntry = new InVMQueueEntry(value, condition);
                if (!this.entries.offer(queueEntry)) {
                    throw new InVMException("Failed to append message to InVM queue");
                }
                if (this.numWaiters > 0) {
                    this.waitingCondition.signal();
                }
                if (condition != null) {
                    try {
                        condition.await(lockstep, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException ie) {
                        LOGGER.warn((Object)("Waiting delivery thread interupted while waiting on message pickup on InVM queue '" + this.serviceId + "'.  Exiting pickup wait state."));
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object pickup(long millis) throws InVMException {
            long end = System.currentTimeMillis() + millis;
            this.lock.lock();
            try {
                InVMQueueEntry entry;
                long delay;
                if (this.shutdown) {
                    throw new InVMException("InVM Transport already shutdown");
                }
                if (this.entries.isEmpty() && (delay = end - System.currentTimeMillis()) > 0L) {
                    ++this.numWaiters;
                    try {
                        this.waitingCondition.await(delay, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException ioe) {
                        throw new InVMException("Interrupted during wait");
                    }
                }
                if ((entry = this.entries.poll()) != null) {
                    Object result = entry.getValue();
                    Condition condition = entry.getCondition();
                    if (condition != null) {
                        condition.signal();
                    }
                    Object object = result;
                    return object;
                }
                Object var6_8 = null;
                return var6_8;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static class InVMQueueEntry {
        private final Object value;
        private final Condition condition;

        InVMQueueEntry(Object value, Condition condition) {
            this.value = value;
            this.condition = condition;
        }

        Object getValue() {
            return this.value;
        }

        Condition getCondition() {
            return this.condition;
        }
    }
}

