/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.couriers.helpers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.couriers.helpers.FileHandler;
import org.jboss.soa.esb.addressing.eprs.FileEpr;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.util.FileUtil;
import org.jboss.soa.esb.util.Util;

public class LocalFileHandler
implements FileHandler {
    protected FileEpr _epr;
    static Logger _logger = Logger.getLogger(LocalFileHandler.class);

    LocalFileHandler(FileEpr epr) {
        this._epr = epr;
    }

    @Override
    public boolean deleteFile(File file) throws CourierException {
        return file.delete();
    }

    @Override
    public byte[] getFileContents(File file) throws CourierException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] ba = new byte[1000];
        try {
            int iQread;
            FileInputStream inp = new FileInputStream(file);
            while (-1 != (iQread = inp.read(ba))) {
                if (iQread <= 0) continue;
                out.write(ba, 0, iQread);
            }
            inp.close();
            out.close();
            return out.toByteArray();
        }
        catch (FileNotFoundException e) {
            throw new CourierException(e);
        }
        catch (IOException e) {
            throw new CourierException(e);
        }
        catch (Exception e) {
            throw new CourierException(e);
        }
    }

    @Override
    public File[] getFileList() throws CourierException {
        try {
            File dir = new File(this._epr.getURI());
            if (!dir.isDirectory()) {
                throw new CourierException("Can't get file list if URL is not a directory");
            }
            FileEndsWith filter = new FileEndsWith(this._epr.getInputSuffix());
            return dir.listFiles(filter);
        }
        catch (Exception e) {
            throw new CourierException(e);
        }
    }

    @Override
    public boolean renameFile(File from, File to) throws CourierException {
        try {
            if (to.exists() && !to.delete()) {
                throw new CourierException("Unable to delete target file " + to.getCanonicalPath());
            }
            if (!FileUtil.renameTo(from, to)) {
                throw new CourierException("Unable to rename from " + from + " to " + to);
            }
            return true;
        }
        catch (Exception e) {
            throw new CourierException(e);
        }
    }

    private static class FileEndsWith
    implements FileFilter {
        String m_sSuffix;

        FileEndsWith(String p_sEnd) throws CourierException {
            this.m_sSuffix = p_sEnd;
            if (Util.isNullString(this.m_sSuffix)) {
                throw new CourierException("A file suffix (or full Message id) must be specified for pickup");
            }
        }

        @Override
        public boolean accept(File p_f) {
            return p_f.isFile() ? p_f.toString().endsWith(this.m_sSuffix) : false;
        }
    }
}

