/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.couriers.helpers;

import java.io.IOException;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.couriers.FaultMessageException;
import org.jboss.soa.esb.listeners.gateway.ESBPropertiesSetter;
import org.jboss.soa.esb.listeners.message.errors.Factory;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.util.Type;
import org.jboss.soa.esb.util.Util;
import org.xml.sax.SAXException;

public class JmsComposer {
    private static final Logger LOGGER = Logger.getLogger(JmsComposer.class);

    public static Message compose(Object incomingMessage, ESBPropertiesSetter propertiesSetter) throws FaultMessageException {
        if (incomingMessage == null) {
            return null;
        }
        if (!(incomingMessage instanceof ObjectMessage)) {
            LOGGER.error((Object)("Unsupported JMS message type: " + incomingMessage.getClass().getName() + " for incoming ESB-aware message."));
            return null;
        }
        try {
            ObjectMessage jmsMessage = (ObjectMessage)incomingMessage;
            Serializable obj = jmsMessage.getObject();
            Message composedMessage = Util.deserialize(obj);
            propertiesSetter.setPropertiesFromJMSMessage((javax.jms.Message)jmsMessage, composedMessage);
            if (Type.isFaultMessage(composedMessage)) {
                Factory.createExceptionFromFault(composedMessage);
            }
            return composedMessage;
        }
        catch (JMSException jmse) {
            LOGGER.error((Object)"Failed to read Serialized Object from JMS message.", (Throwable)jmse);
            return null;
        }
        catch (ClassCastException cce) {
            LOGGER.error((Object)"Object in JMS message is not a org.jboss.soa.esb.message.Message", (Throwable)cce);
        }
        catch (IOException ioe) {
            LOGGER.error((Object)"Object in JMS message is not a Serializeable", (Throwable)ioe);
        }
        catch (ParserConfigurationException pce) {
            LOGGER.error((Object)"Object in JMS message has invalid XML", (Throwable)pce);
        }
        catch (SAXException saxe) {
            LOGGER.error((Object)"Object in JMS message has invalid XML", (Throwable)saxe);
        }
        return null;
    }
}

