/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.couriers.helpers;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.couriers.helpers.FileHandler;
import org.jboss.soa.esb.addressing.eprs.FTPEpr;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.couriers.CourierUtil;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.util.RemoteFileSystem;
import org.jboss.soa.esb.util.RemoteFileSystemException;
import org.jboss.soa.esb.util.RemoteFileSystemFactory;

public class FtpFileHandler
implements FileHandler {
    private static final Logger _logger = Logger.getLogger(FtpFileHandler.class);
    protected FTPEpr _epr;
    protected ConfigTree _tree;
    protected String _server;
    protected String _user;
    protected String _passwd;
    protected String _remoteDir;
    protected String _localDir;
    protected int _port;
    protected boolean _isAscii;
    protected boolean _isPassive;

    FtpFileHandler(FTPEpr epr) throws CourierException {
        URI uri;
        this._epr = epr;
        try {
            uri = this._epr.getURI();
        }
        catch (URISyntaxException e) {
            throw new CourierException(e);
        }
        this._server = uri.getHost();
        String[] sa = null;
        if (uri.getUserInfo() != null) {
            sa = uri.getUserInfo().split(":");
        }
        if (sa == null) {
            sa = new String[]{"", ""};
        }
        this._user = sa.length < 1 ? "" : sa[0];
        this._passwd = sa.length < 2 ? "" : sa[1];
        this._remoteDir = uri.getPath();
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (this._remoteDir == null || this._remoteDir.equals("")) {
            this._remoteDir = ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.ftp.remotedir", tmpdir);
        }
        this._port = uri.getPort();
        this._localDir = ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.ftp.localdir", tmpdir);
        this._isAscii = false;
        this._isPassive = this._epr.getPassive();
    }

    @Override
    public boolean deleteFile(File file) throws CourierException {
        RemoteFileSystem handler = this.getHandler();
        try {
            handler.deleteRemoteFile(file.getName());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CourierException(e);
        }
        finally {
            handler.quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getFileContents(File file) throws CourierException {
        try {
            String name = file.getName();
            if (file.toString().length() > name.length()) {
                _logger.debug((Object)("FtpFileHandler.getFileContents on " + file + " will ignore because of directory."));
                return null;
            }
            RemoteFileSystem handler = this.getHandler();
            try {
                handler.downloadFile(name, name);
            }
            finally {
                handler.quit();
            }
            File local = new File(this._localDir, name);
            byte[] ba = CourierUtil.bytesFromLocalFile(local);
            if (!local.delete()) {
                _logger.warn((Object)("Could not delete file " + local.getCanonicalPath()));
            }
            return ba;
        }
        catch (Exception e) {
            throw new CourierException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFile(File file) throws CourierException {
        try {
            String name = file.getName();
            RemoteFileSystem handler = this.getHandler();
            try {
                handler.uploadFile(file, name);
            }
            finally {
                handler.quit();
            }
            if (!file.delete()) {
                _logger.warn((Object)("Could not delete file " + file.getCanonicalPath()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CourierException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File downloadFile(File file) throws CourierException {
        try {
            String name = file.getName();
            RemoteFileSystem handler = this.getHandler();
            try {
                handler.downloadFile(name, name);
            }
            finally {
                handler.quit();
            }
            return new File(this._localDir, name);
        }
        catch (Exception e) {
            throw new CourierException(e);
        }
    }

    @Override
    public File[] getFileList() throws CourierException {
        String[] names = null;
        RemoteFileSystem handler = this.getHandler();
        try {
            names = handler.getFileListFromRemoteDir(this._epr.getInputSuffix());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CourierException(e);
        }
        finally {
            handler.quit();
        }
        if (null == names) {
            return null;
        }
        File[] files = new File[names.length];
        int i = 0;
        for (String file : names) {
            if (null == file) continue;
            files[i++] = new File(file);
        }
        return files;
    }

    @Override
    public boolean renameFile(File from, File to) throws CourierException {
        RemoteFileSystem handler = this.getHandler();
        try {
            handler.remoteRename(from, to);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new CourierException(e);
        }
        finally {
            handler.quit();
        }
    }

    protected RemoteFileSystem getHandler() throws CourierException {
        try {
            RemoteFileSystem rfs = RemoteFileSystemFactory.getRemoteFileSystem(this._epr, true);
            try {
                rfs.setRemoteDir(this._remoteDir);
            }
            catch (Exception e) {
                throw new CourierException(e);
            }
            return rfs;
        }
        catch (RemoteFileSystemException e) {
            throw new CourierException(e);
        }
    }
}

