/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.command;

import java.util.HashMap;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.command.CommandQueue;
import org.jboss.internal.soa.esb.command.CommandQueueException;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.NamingContextException;
import org.jboss.soa.esb.helpers.NamingContextPool;
import org.jboss.soa.esb.util.Util;

public class JmsCommandQueue
implements CommandQueue {
    private static Logger logger = Logger.getLogger(JmsCommandQueue.class);
    public static final String COMMAND_CONN_FACTORY = "commandConnFactoryClass";
    public static final String COMMAND_JNDI_URL = "commandJndiURL";
    public static final String COMMAND_JNDI_CONTEXT_FACTORY = "commandJndiContextFactory";
    public static final String COMMAND_JNDI_PKG_PREFIX = "commandJndiUrlPkgPrefix";
    public static final String COMMAND_IS_TOPIC = "commandIsTopic";
    public static final String COMMAND_JNDI_NAME = "commandJndiName";
    public static final String COMMAND_MSG_SELECTOR = "messageSelector";
    private MessageConsumer m_oCmdSrc;
    private Session m_oJmsSess;
    private Connection m_oJmsConn;

    @Override
    public void open(ConfigTree config) throws CommandQueueException {
        try {
            this.initialiseJMS(config);
        }
        catch (Exception e) {
            throw new CommandQueueException("Failed to initialise JMS Command Queue.", e);
        }
    }

    @Override
    public void close() throws CommandQueueException {
        if (null != this.m_oJmsSess) {
            try {
                this.m_oJmsSess.close();
            }
            catch (JMSException eS) {
                // empty catch block
            }
        }
        if (null != this.m_oJmsConn) {
            try {
                this.m_oJmsConn.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    @Override
    public String receiveCommand(long timeout) throws CommandQueueException {
        try {
            Message jmsMessage = this.m_oCmdSrc.receive(timeout);
            if (null == jmsMessage) {
                return null;
            }
            if (jmsMessage instanceof TextMessage) {
                return ((TextMessage)jmsMessage).getText();
            }
            logger.warn((Object)"Message in command queue IGNORED - should be instanceof TextMessage");
        }
        catch (Exception e) {
            throw new CommandQueueException("Exception receiving message from JMS Command Queue.", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseJMS(ConfigTree p_oP) throws ConfigurationException, JMSException, NamingException, NamingContextException {
        block15: {
            String sJndiName = p_oP.getAttribute(COMMAND_JNDI_NAME);
            if (!Util.isNullString(sJndiName)) {
                Properties environment = new Properties();
                HashMap<String, String> oNewAtts = new HashMap<String, String>();
                oNewAtts.put(COMMAND_JNDI_NAME, sJndiName);
                String sJndiURL = this.obtainAtt(p_oP, COMMAND_JNDI_URL, "");
                environment.put("java.naming.provider.url", sJndiURL);
                oNewAtts.put(COMMAND_JNDI_URL, sJndiURL);
                String sJndiContextFactory = this.obtainAtt(p_oP, COMMAND_JNDI_CONTEXT_FACTORY, "");
                environment.put("java.naming.factory.object", sJndiContextFactory);
                oNewAtts.put(COMMAND_JNDI_CONTEXT_FACTORY, sJndiContextFactory);
                String sJndiPkgPrefix = this.obtainAtt(p_oP, COMMAND_JNDI_PKG_PREFIX, "");
                environment.put("java.naming.factory.url.pkgs", sJndiPkgPrefix);
                oNewAtts.put(COMMAND_JNDI_PKG_PREFIX, sJndiPkgPrefix);
                Context oJndiCtx = NamingContextPool.getNamingContext(environment);
                try {
                    boolean bIsTopic;
                    String sFactClass = this.obtainAtt(p_oP, COMMAND_CONN_FACTORY, "ConnectionFactory");
                    oNewAtts.put(COMMAND_CONN_FACTORY, sFactClass);
                    if (Util.isNullString(sFactClass)) {
                        sFactClass = "ConnectionFactory";
                    }
                    Object oFactCls = null;
                    try {
                        oFactCls = oJndiCtx.lookup(sFactClass);
                    }
                    catch (NamingException ne) {
                        oJndiCtx = NamingContextPool.replaceNamingContext(oJndiCtx, environment);
                        try {
                            oFactCls = oJndiCtx.lookup(sFactClass);
                        }
                        catch (NamingException ex) {
                            throw new ConfigurationException(ex);
                        }
                    }
                    String sMsgSelector = p_oP.getAttribute(COMMAND_MSG_SELECTOR);
                    if (null != sMsgSelector) {
                        oNewAtts.put(COMMAND_MSG_SELECTOR, sMsgSelector);
                    }
                    if (bIsTopic = Boolean.parseBoolean(this.obtainAtt(p_oP, COMMAND_IS_TOPIC, "false"))) {
                        TopicConnectionFactory tcf = (TopicConnectionFactory)oFactCls;
                        TopicConnection oTC = tcf.createTopicConnection();
                        TopicSession oSess = oTC.createTopicSession(false, 1);
                        Topic oTopic = null;
                        try {
                            oTopic = (Topic)oJndiCtx.lookup(sJndiName);
                        }
                        catch (NamingException ne) {
                            oTopic = oSess.createTopic(sJndiName);
                        }
                        this.m_oJmsConn = oTC;
                        this.m_oJmsSess = oSess;
                        oTC.start();
                        this.m_oCmdSrc = oSess.createSubscriber(oTopic, sMsgSelector, true);
                        break block15;
                    }
                    QueueConnectionFactory qcf = (QueueConnectionFactory)oFactCls;
                    QueueConnection oQC = qcf.createQueueConnection();
                    QueueSession oSess = oQC.createQueueSession(false, 1);
                    Queue oQ = null;
                    try {
                        oQ = (Queue)oJndiCtx.lookup(sJndiName);
                    }
                    catch (NamingException ne) {
                        oQ = oSess.createQueue(sJndiName);
                    }
                    oQC.start();
                    this.m_oJmsConn = oQC;
                    this.m_oJmsSess = oSess;
                    this.m_oCmdSrc = oSess.createReceiver(oQ, sMsgSelector);
                }
                finally {
                    NamingContextPool.releaseNamingContext(oJndiCtx);
                }
            }
        }
    }

    private String obtainAtt(ConfigTree p_oP, String p_sAtt, String p_sDefault) throws ConfigurationException {
        String sVal = p_oP.getAttribute(p_sAtt);
        if (null == sVal && null == p_sDefault) {
            throw new ConfigurationException("Missing or invalid <" + p_sAtt + "> attribute");
        }
        return null != sVal ? sVal : p_sDefault;
    }
}

