/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.command;

import java.util.Hashtable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jboss.internal.soa.esb.command.CommandQueue;
import org.jboss.internal.soa.esb.command.CommandQueueException;
import org.jboss.soa.esb.helpers.ConfigTree;

public class InMemoryCommandQueue
implements CommandQueue {
    public static final String COMMAND_QUEUE_NAME = "command-queue-name";
    private static Hashtable<String, InMemoryCommandQueue> commandQueues = new Hashtable();
    private String name;
    private BlockingQueue<String> queue = new LinkedBlockingQueue<String>();

    @Override
    public void open(ConfigTree config) throws CommandQueueException {
        if (config == null) {
            throw new IllegalArgumentException("null 'config' arg in method call.");
        }
        this.name = config.getAttribute(COMMAND_QUEUE_NAME);
        if (this.name == null) {
            throw new CommandQueueException("Attribute 'command-queue-name' must be specified on the command queue configuration.");
        }
        commandQueues.put(this.name, this);
    }

    public void addCommand(String command) {
        this.queue.add(command);
        while (!this.queue.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String receiveCommand(long timeout) throws CommandQueueException {
        if (this.name == null || !commandQueues.containsKey(this.name)) {
            throw new CommandQueueException("Sorry.  Invalid call to 'receiveCommand' method.  Queue is not open!");
        }
        try {
            return this.queue.take();
        }
        catch (InterruptedException e) {
            throw new CommandQueueException("Error taking command message from command queue.", e);
        }
    }

    @Override
    public void close() throws CommandQueueException {
        commandQueues.remove(this.name);
    }

    public static InMemoryCommandQueue getQueue(String name) {
        return commandQueues.get(name);
    }
}

