/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.addressing.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.internal.soa.esb.util.stax.ElementContent;
import org.jboss.internal.soa.esb.util.stax.QNameHelper;
import org.jboss.internal.soa.esb.util.stax.StreamHelper;
import org.jboss.internal.soa.esb.util.stax.TextElement;
import org.jboss.soa.esb.addressing.PortReference;
import org.jboss.soa.esb.addressing.XMLUtil;

public class PortReferenceHelper {
    public static void toXML(XMLStreamWriter out, QName name, PortReference portReference) throws XMLStreamException {
        if (XMLUtil.QNAME_TO_TAG.equals(name)) {
            PortReferenceHelper.writeToXML(out, name, portReference);
        } else {
            PortReferenceHelper.writeXML(out, name, portReference);
        }
    }

    private static void writeToXML(XMLStreamWriter out, QName name, PortReference portReference) throws XMLStreamException {
        TextElement toElement = new TextElement(portReference.getAddress());
        StreamHelper.writeElement(out, name, toElement);
        PortReferenceHelper.writeExtensions(out, portReference);
    }

    private static void writeXML(XMLStreamWriter out, QName name, PortReference portReference) throws XMLStreamException {
        String origURI = StreamHelper.writeStartElement(out, name);
        TextElement addressElement = new TextElement(portReference.getAddress());
        StreamHelper.writeElement(out, XMLUtil.QNAME_ADDRESS_TAG, addressElement);
        if (portReference.getAllExtensions().size() > 0) {
            String origReferenceURI = StreamHelper.writeStartElement(out, XMLUtil.QNAME_REFERENCE_PROPERTIES_TAG);
            PortReferenceHelper.writeExtensions(out, portReference);
            StreamHelper.writeEndElement(out, XMLUtil.QNAME_REFERENCE_PROPERTIES_TAG.getPrefix(), origReferenceURI);
        }
        StreamHelper.writeEndElement(out, name.getPrefix(), origURI);
    }

    private static void writeExtensions(XMLStreamWriter out, PortReference portReference) throws XMLStreamException {
        for (PortReference.Extension extension : portReference.getAllExtensions()) {
            PortReferenceHelper.writeExtension(out, extension);
        }
    }

    private static void writeExtension(XMLStreamWriter out, PortReference.Extension extension) throws XMLStreamException {
        String uri = QNameHelper.getNormalisedValue(extension.getURI());
        String prefix = QNameHelper.getNormalisedValue(extension.getPrefix());
        QName name = new QName(uri, extension.getTag(), prefix);
        String origURI = StreamHelper.writeStartElement(out, name);
        HashMap attributes = extension.getAttributes();
        if (attributes != null) {
            for (Map.Entry entry : attributes.entrySet()) {
                ArjunaName arjunaName = (ArjunaName)entry.getKey();
                String value = (String)entry.getValue();
                String attributeURI = QNameHelper.getNormalisedValue(arjunaName.getURI());
                String attributePrefix = QNameHelper.getNormalisedValue(arjunaName.getPrefix());
                QName attributeName = new QName(attributeURI, arjunaName.getLocalName(), attributePrefix);
                StreamHelper.writeAttribute(out, attributeName, value);
            }
        }
        TextElement value = new TextElement(extension.getValue());
        value.writeContent(out);
        StreamHelper.writeEndElement(out, name.getPrefix(), origURI);
        LinkedList children = extension.getChildren();
        if (children != null) {
            Iterator childIter = extension.getChildren().iterator();
            while (childIter.hasNext()) {
                PortReferenceHelper.writeExtension(out, (PortReference.Extension)childIter.next());
            }
        }
    }

    public static PortReference fromXML(XMLStreamReader in) throws XMLStreamException {
        boolean toField = XMLUtil.QNAME_TO_TAG.equals(in.getName());
        if (toField) {
            return PortReferenceHelper.readToXML(in);
        }
        return PortReferenceHelper.readXML(in);
    }

    private static PortReference readToXML(XMLStreamReader in) throws XMLStreamException {
        PortReference portReference = new PortReference();
        TextElement toElement = new TextElement(in);
        portReference.setAddress(toElement.getText());
        return portReference;
    }

    private static PortReference readXML(XMLStreamReader in) throws XMLStreamException {
        PortReferenceImpl portReferenceImpl = new PortReferenceImpl(in);
        return portReferenceImpl.getPortReference();
    }

    private static class ArjunaName {
        private final String uri;
        private final String prefix;
        private final String localName;

        public ArjunaName(String uri, String prefix, String localName) {
            this.uri = uri;
            this.prefix = prefix;
            this.localName = localName;
        }

        public String getURI() {
            return this.uri;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String getQualifiedName() {
            return this.prefix == null ? this.localName : this.prefix + ":" + this.localName;
        }
    }

    private static class ExtensionImpl
    extends ElementContent {
        private final List<PortReference.Extension> extensions = new ArrayList<PortReference.Extension>();
        private final HashMap<ArjunaName, String> attributes = new HashMap();
        private final PortReference.Extension extension;
        private String value;

        ExtensionImpl(XMLStreamReader in) throws XMLStreamException {
            QName name = in.getName();
            this.parse(in);
            this.extension = new PortReference.Extension(name.getLocalPart(), name.getPrefix(), name.getNamespaceURI(), this.value);
        }

        PortReference.Extension getExtension() {
            return this.extension;
        }

        @Override
        protected void putAttribute(XMLStreamReader in, QName attributeName, String attributeValue) throws XMLStreamException {
            ArjunaName name = new ArjunaName(attributeName.getNamespaceURI(), attributeName.getPrefix(), attributeName.getLocalPart());
            this.attributes.put(name, attributeValue);
        }

        @Override
        protected void putValue(XMLStreamReader in, String value) throws XMLStreamException {
            this.value = value;
        }

        @Override
        protected void putElement(XMLStreamReader in, QName elementName) throws XMLStreamException {
            ExtensionImpl extension = new ExtensionImpl(in);
            this.extensions.add(extension.getExtension());
        }
    }

    private static class ReferencePropertiesImpl
    extends ElementContent {
        private List<PortReference.Extension> extensions = new ArrayList<PortReference.Extension>();

        ReferencePropertiesImpl(XMLStreamReader in) throws XMLStreamException {
            this.parse(in);
        }

        List<PortReference.Extension> getExtensions() {
            return this.extensions;
        }

        @Override
        protected void putElement(XMLStreamReader in, QName elementName) throws XMLStreamException {
            ExtensionImpl extension = new ExtensionImpl(in);
            this.extensions.add(extension.getExtension());
        }
    }

    private static class PortReferenceImpl
    extends ElementContent {
        private final PortReference portReference = new PortReference();

        PortReferenceImpl(XMLStreamReader in) throws XMLStreamException {
            this.parse(in);
        }

        PortReference getPortReference() {
            return this.portReference;
        }

        @Override
        protected void putElement(XMLStreamReader in, QName elementName) throws XMLStreamException {
            if (XMLUtil.QNAME_ADDRESS_TAG.equals(elementName)) {
                TextElement address = new TextElement(in);
                this.portReference.setAddress(address.getText());
            } else if (XMLUtil.QNAME_REFERENCE_PROPERTIES_TAG.equals(elementName)) {
                ReferencePropertiesImpl referenceProperties = new ReferencePropertiesImpl(in);
                this.portReference.addExtensions(referenceProperties.getExtensions());
            } else {
                throw new XMLStreamException("Unrecognised element name: " + elementName);
            }
        }
    }
}

