// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/protobuf/duration.proto

package io.prometheus.metrics.shaded.com_google_protobuf_3_21_7;

/**
 * <pre>
 * A Duration represents a signed, fixed-length span of time represented
 * as a count of seconds and fractions of seconds at nanosecond
 * resolution. It is independent of any calendar and concepts like "day"
 * or "month". It is related to Timestamp in that the difference between
 * two Timestamp values is a Duration and it can be added or subtracted
 * from a Timestamp. Range is approximately +-10,000 years.
 * # Examples
 * Example 1: Compute Duration from two Timestamps in pseudo code.
 *     Timestamp start = ...;
 *     Timestamp end = ...;
 *     Duration duration = ...;
 *     duration.seconds = end.seconds - start.seconds;
 *     duration.nanos = end.nanos - start.nanos;
 *     if (duration.seconds &lt; 0 &amp;&amp; duration.nanos &gt; 0) {
 *       duration.seconds += 1;
 *       duration.nanos -= 1000000000;
 *     } else if (duration.seconds &gt; 0 &amp;&amp; duration.nanos &lt; 0) {
 *       duration.seconds -= 1;
 *       duration.nanos += 1000000000;
 *     }
 * Example 2: Compute Timestamp from Timestamp + Duration in pseudo code.
 *     Timestamp start = ...;
 *     Duration duration = ...;
 *     Timestamp end = ...;
 *     end.seconds = start.seconds + duration.seconds;
 *     end.nanos = start.nanos + duration.nanos;
 *     if (end.nanos &lt; 0) {
 *       end.seconds -= 1;
 *       end.nanos += 1000000000;
 *     } else if (end.nanos &gt;= 1000000000) {
 *       end.seconds += 1;
 *       end.nanos -= 1000000000;
 *     }
 * Example 3: Compute Duration from datetime.timedelta in Python.
 *     td = datetime.timedelta(days=3, minutes=10)
 *     duration = Duration()
 *     duration.FromTimedelta(td)
 * # JSON Mapping
 * In JSON format, the Duration type is encoded as a string rather than an
 * object, where the string ends in the suffix "s" (indicating seconds) and
 * is preceded by the number of seconds, with nanoseconds expressed as
 * fractional seconds. For example, 3 seconds with 0 nanoseconds should be
 * encoded in JSON format as "3s", while 3 seconds and 1 nanosecond should
 * be expressed in JSON format as "3.000000001s", and 3 seconds and 1
 * microsecond should be expressed in JSON format as "3.000001s".
 * </pre>
 *
 * Protobuf type {@code google.protobuf.Duration}
 */
public final class Duration extends
    io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.protobuf.Duration)
    DurationOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Duration.newBuilder() to construct.
  private Duration(io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Duration() {
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new Duration();
  }

  @java.lang.Override
  public final io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  public static final io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Descriptors.Descriptor
      getDescriptor() {
    return io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.DurationProto.internal_static_google_protobuf_Duration_descriptor;
  }

  @java.lang.Override
  protected io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.DurationProto.internal_static_google_protobuf_Duration_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration.class, io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration.Builder.class);
  }

  public static final int SECONDS_FIELD_NUMBER = 1;
  private long seconds_;
  /**
   * <pre>
   * Signed seconds of the span of time. Must be from -315,576,000,000
   * to +315,576,000,000 inclusive. Note: these bounds are computed from:
   * 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
   * </pre>
   *
   * <code>int64 seconds = 1;</code>
   * @return The seconds.
   */
  @java.lang.Override
  public long getSeconds() {
    return seconds_;
  }

  public static final int NANOS_FIELD_NUMBER = 2;
  private int nanos_;
  /**
   * <pre>
   * Signed fractions of a second at nanosecond resolution of the span
   * of time. Durations less than one second are represented with a 0
   * `seconds` field and a positive or negative `nanos` field. For durations
   * of one second or more, a non-zero value for the `nanos` field must be
   * of the same sign as the `seconds` field. Must be from -999,999,999
   * to +999,999,999 inclusive.
   * </pre>
   *
   * <code>int32 nanos = 2;</code>
   * @return The nanos.
   */
  @java.lang.Override
  public int getNanos() {
    return nanos_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.CodedOutputStream output)
                      throws java.io.IOException {
    if (seconds_ != 0L) {
      output.writeInt64(1, seconds_);
    }
    if (nanos_ != 0) {
      output.writeInt32(2, nanos_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (seconds_ != 0L) {
      size += io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.CodedOutputStream
        .computeInt64Size(1, seconds_);
    }
    if (nanos_ != 0) {
      size += io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.CodedOutputStream
        .computeInt32Size(2, nanos_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration)) {
      return super.equals(obj);
    }
    io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration other = (io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration) obj;

    if (getSeconds()
        != other.getSeconds()) return false;
    if (getNanos()
        != other.getNanos()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SECONDS_FIELD_NUMBER;
    hash = (53 * hash) + io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Internal.hashLong(
        getSeconds());
    hash = (37 * hash) + NANOS_FIELD_NUMBER;
    hash = (53 * hash) + getNanos();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration parseFrom(
      java.nio.ByteBuffer data)
      throws io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration parseFrom(
      java.nio.ByteBuffer data,
      io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.ExtensionRegistryLite extensionRegistry)
      throws io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration parseFrom(
      io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.ByteString data)
      throws io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration parseFrom(
      io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.ByteString data,
      io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.ExtensionRegistryLite extensionRegistry)
      throws io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration parseFrom(byte[] data)
      throws io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration parseFrom(
      byte[] data,
      io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.ExtensionRegistryLite extensionRegistry)
      throws io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration parseFrom(
      java.io.InputStream input,
      io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration parseDelimitedFrom(
      java.io.InputStream input,
      io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration parseFrom(
      io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.CodedInputStream input)
      throws java.io.IOException {
    return io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration parseFrom(
      io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.CodedInputStream input,
      io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A Duration represents a signed, fixed-length span of time represented
   * as a count of seconds and fractions of seconds at nanosecond
   * resolution. It is independent of any calendar and concepts like "day"
   * or "month". It is related to Timestamp in that the difference between
   * two Timestamp values is a Duration and it can be added or subtracted
   * from a Timestamp. Range is approximately +-10,000 years.
   * # Examples
   * Example 1: Compute Duration from two Timestamps in pseudo code.
   *     Timestamp start = ...;
   *     Timestamp end = ...;
   *     Duration duration = ...;
   *     duration.seconds = end.seconds - start.seconds;
   *     duration.nanos = end.nanos - start.nanos;
   *     if (duration.seconds &lt; 0 &amp;&amp; duration.nanos &gt; 0) {
   *       duration.seconds += 1;
   *       duration.nanos -= 1000000000;
   *     } else if (duration.seconds &gt; 0 &amp;&amp; duration.nanos &lt; 0) {
   *       duration.seconds -= 1;
   *       duration.nanos += 1000000000;
   *     }
   * Example 2: Compute Timestamp from Timestamp + Duration in pseudo code.
   *     Timestamp start = ...;
   *     Duration duration = ...;
   *     Timestamp end = ...;
   *     end.seconds = start.seconds + duration.seconds;
   *     end.nanos = start.nanos + duration.nanos;
   *     if (end.nanos &lt; 0) {
   *       end.seconds -= 1;
   *       end.nanos += 1000000000;
   *     } else if (end.nanos &gt;= 1000000000) {
   *       end.seconds += 1;
   *       end.nanos -= 1000000000;
   *     }
   * Example 3: Compute Duration from datetime.timedelta in Python.
   *     td = datetime.timedelta(days=3, minutes=10)
   *     duration = Duration()
   *     duration.FromTimedelta(td)
   * # JSON Mapping
   * In JSON format, the Duration type is encoded as a string rather than an
   * object, where the string ends in the suffix "s" (indicating seconds) and
   * is preceded by the number of seconds, with nanoseconds expressed as
   * fractional seconds. For example, 3 seconds with 0 nanoseconds should be
   * encoded in JSON format as "3s", while 3 seconds and 1 nanosecond should
   * be expressed in JSON format as "3.000000001s", and 3 seconds and 1
   * microsecond should be expressed in JSON format as "3.000001s".
   * </pre>
   *
   * Protobuf type {@code google.protobuf.Duration}
   */
  public static final class Builder extends
      io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.protobuf.Duration)
      io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.DurationOrBuilder {
    public static final io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Descriptors.Descriptor
        getDescriptor() {
      return io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.DurationProto.internal_static_google_protobuf_Duration_descriptor;
    }

    @java.lang.Override
    protected io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.DurationProto.internal_static_google_protobuf_Duration_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration.class, io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration.Builder.class);
    }

    // Construct using io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration.newBuilder()
    private Builder() {

    }

    private Builder(
        io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      seconds_ = 0L;

      nanos_ = 0;

      return this;
    }

    @java.lang.Override
    public io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Descriptors.Descriptor
        getDescriptorForType() {
      return io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.DurationProto.internal_static_google_protobuf_Duration_descriptor;
    }

    @java.lang.Override
    public io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration getDefaultInstanceForType() {
      return io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration.getDefaultInstance();
    }

    @java.lang.Override
    public io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration build() {
      io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration buildPartial() {
      io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration result = new io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration(this);
      result.seconds_ = seconds_;
      result.nanos_ = nanos_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Message other) {
      if (other instanceof io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration) {
        return mergeFrom((io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration other) {
      if (other == io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration.getDefaultInstance()) return this;
      if (other.getSeconds() != 0L) {
        setSeconds(other.getSeconds());
      }
      if (other.getNanos() != 0) {
        setNanos(other.getNanos());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.CodedInputStream input,
        io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {
              seconds_ = input.readInt64();

              break;
            } // case 8
            case 16: {
              nanos_ = input.readInt32();

              break;
            } // case 16
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private long seconds_ ;
    /**
     * <pre>
     * Signed seconds of the span of time. Must be from -315,576,000,000
     * to +315,576,000,000 inclusive. Note: these bounds are computed from:
     * 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
     * </pre>
     *
     * <code>int64 seconds = 1;</code>
     * @return The seconds.
     */
    @java.lang.Override
    public long getSeconds() {
      return seconds_;
    }
    /**
     * <pre>
     * Signed seconds of the span of time. Must be from -315,576,000,000
     * to +315,576,000,000 inclusive. Note: these bounds are computed from:
     * 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
     * </pre>
     *
     * <code>int64 seconds = 1;</code>
     * @param value The seconds to set.
     * @return This builder for chaining.
     */
    public Builder setSeconds(long value) {
      
      seconds_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Signed seconds of the span of time. Must be from -315,576,000,000
     * to +315,576,000,000 inclusive. Note: these bounds are computed from:
     * 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
     * </pre>
     *
     * <code>int64 seconds = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearSeconds() {
      
      seconds_ = 0L;
      onChanged();
      return this;
    }

    private int nanos_ ;
    /**
     * <pre>
     * Signed fractions of a second at nanosecond resolution of the span
     * of time. Durations less than one second are represented with a 0
     * `seconds` field and a positive or negative `nanos` field. For durations
     * of one second or more, a non-zero value for the `nanos` field must be
     * of the same sign as the `seconds` field. Must be from -999,999,999
     * to +999,999,999 inclusive.
     * </pre>
     *
     * <code>int32 nanos = 2;</code>
     * @return The nanos.
     */
    @java.lang.Override
    public int getNanos() {
      return nanos_;
    }
    /**
     * <pre>
     * Signed fractions of a second at nanosecond resolution of the span
     * of time. Durations less than one second are represented with a 0
     * `seconds` field and a positive or negative `nanos` field. For durations
     * of one second or more, a non-zero value for the `nanos` field must be
     * of the same sign as the `seconds` field. Must be from -999,999,999
     * to +999,999,999 inclusive.
     * </pre>
     *
     * <code>int32 nanos = 2;</code>
     * @param value The nanos to set.
     * @return This builder for chaining.
     */
    public Builder setNanos(int value) {
      
      nanos_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Signed fractions of a second at nanosecond resolution of the span
     * of time. Durations less than one second are represented with a 0
     * `seconds` field and a positive or negative `nanos` field. For durations
     * of one second or more, a non-zero value for the `nanos` field must be
     * of the same sign as the `seconds` field. Must be from -999,999,999
     * to +999,999,999 inclusive.
     * </pre>
     *
     * <code>int32 nanos = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearNanos() {
      
      nanos_ = 0;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.protobuf.Duration)
  }

  // @@protoc_insertion_point(class_scope:google.protobuf.Duration)
  private static final io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration();
  }

  public static io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Parser<Duration>
      PARSER = new io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.AbstractParser<Duration>() {
    @java.lang.Override
    public Duration parsePartialFrom(
        io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.CodedInputStream input,
        io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.ExtensionRegistryLite extensionRegistry)
        throws io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Parser<Duration> parser() {
    return PARSER;
  }

  @java.lang.Override
  public io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Parser<Duration> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public io.prometheus.metrics.shaded.com_google_protobuf_3_21_7.Duration getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

