// Protocol Buffers - Google's data interchange format
// Copyright 2008 Google Inc.  All rights reserved.
//
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file or at
// https://developers.google.com/open-source/licenses/bsd

package io.prometheus.metrics.shaded.com_google_protobuf_4_31_1;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.SOURCE;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/** Marks protobuf implementations generated by the {@code protoc} compiler. */
@Documented
// This is only used for static analysis at the compilation level, so SOURCE retention is used. It
// also must be SOURCE so that it does not force annotated classes to be forced into a main dex file
// in Android apks.
@Retention(SOURCE)
@Target(TYPE)
public @interface Generated {}
