/*
 * Decompiled with CFR 0.152.
 */
package io.lemonlabs.uri.parsing;

import cats.parse.Numbers$;
import cats.parse.Parser;
import cats.parse.Parser$;
import cats.parse.Parser0;
import cats.parse.Rfc5234$;
import io.lemonlabs.uri.AbsoluteOrEmptyPath;
import io.lemonlabs.uri.AbsolutePath$;
import io.lemonlabs.uri.AbsoluteUrl;
import io.lemonlabs.uri.AbsoluteUrl$;
import io.lemonlabs.uri.Authority;
import io.lemonlabs.uri.Authority$;
import io.lemonlabs.uri.DataUrl;
import io.lemonlabs.uri.DataUrl$;
import io.lemonlabs.uri.DomainName;
import io.lemonlabs.uri.DomainName$;
import io.lemonlabs.uri.EmptyPath$;
import io.lemonlabs.uri.Host;
import io.lemonlabs.uri.IpV4;
import io.lemonlabs.uri.IpV4$;
import io.lemonlabs.uri.IpV6;
import io.lemonlabs.uri.IpV6$;
import io.lemonlabs.uri.MediaType;
import io.lemonlabs.uri.MediaType$;
import io.lemonlabs.uri.ProtocolRelativeUrl;
import io.lemonlabs.uri.ProtocolRelativeUrl$;
import io.lemonlabs.uri.QueryString;
import io.lemonlabs.uri.QueryString$;
import io.lemonlabs.uri.RelativeUrl;
import io.lemonlabs.uri.RelativeUrl$;
import io.lemonlabs.uri.RootlessPath$;
import io.lemonlabs.uri.ScpLikeUrl;
import io.lemonlabs.uri.ScpLikeUrl$;
import io.lemonlabs.uri.SimpleUrlWithoutAuthority;
import io.lemonlabs.uri.SimpleUrlWithoutAuthority$;
import io.lemonlabs.uri.Url;
import io.lemonlabs.uri.UrlPath;
import io.lemonlabs.uri.UrlPath$;
import io.lemonlabs.uri.UrlWithAuthority;
import io.lemonlabs.uri.UrlWithoutAuthority;
import io.lemonlabs.uri.UserInfo;
import io.lemonlabs.uri.UserInfo$;
import io.lemonlabs.uri.config.UriConfig;
import io.lemonlabs.uri.decoding.UriDecoder;
import io.lemonlabs.uri.parsing.UriParser;
import io.lemonlabs.uri.parsing.UriParsingException;
import io.lemonlabs.uri.parsing.UrlParser$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Failure$;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success$;
import scala.util.Try;
import scala.util.Try$;

public class UrlParser
implements UriParser {
    private Parser _alpha_num;
    private Parser _hex_digit;
    private Parser _unreserved;
    private Parser _pct_encoded;
    private Parser _sub_delims;
    private Parser _p_char;
    private final String input;
    private final UriConfig conf;
    private final String _host_end;
    private final Function5 extractAbsoluteUrl;
    private final Function4 extractProtocolRelativeUrl;
    private final Function3 extractRelativeUrl;
    private final Function4 extractUrlWithoutAuthority;
    private final Function1 extractInt;
    private final Function1 extractHexToInt;
    private final Function4 extractIpv4;
    private final Function1 extractFullIpv6;
    private final Function2<Seq<String>, IpV4, IpV6> extractFullIpv6Ls32Ipv4;
    private final Function3<Seq<String>, Seq<String>, IpV4, IpV6> extractIpv6Ls32Ipv4WithElided;
    private final Function2 extractIpv6WithEluded;
    private final Function1 extractDomainName;
    private final Function2 extractUserInfo;
    private final Function3 extractAuthority;
    private final Function1 extractFragment;
    private final Function1 extractQueryString;
    private final Function1 extractPathPart;
    private final Function1 extractAbsOrEmptyPath;
    private final Function2 extractRelPath;
    private final Function2 extractMediaTypeParam;
    private final Function2 extractMediaType;
    private final Function2 extractBase64DataUrl;
    private final Function2 extractPercentEncodedDataUrl;
    private final Function2 extractTuple;
    private final Function1 extractTok;
    private final Function3 extractScpLikeUrl;

    public static UrlParser apply(CharSequence charSequence, UriConfig uriConfig) {
        return UrlParser$.MODULE$.apply(charSequence, uriConfig);
    }

    public static UriConfig $lessinit$greater$default$2(String string) {
        return UrlParser$.MODULE$.$lessinit$greater$default$2(string);
    }

    public static UriConfig apply$default$2(CharSequence charSequence) {
        return UrlParser$.MODULE$.apply$default$2(charSequence);
    }

    public static UriConfig parseAbsoluteUrl$default$2(String string) {
        return UrlParser$.MODULE$.parseAbsoluteUrl$default$2(string);
    }

    public static UriConfig parseAuthority$default$2(String string) {
        return UrlParser$.MODULE$.parseAuthority$default$2(string);
    }

    public static UriConfig parseDataUrl$default$2(String string) {
        return UrlParser$.MODULE$.parseDataUrl$default$2(string);
    }

    public static UriConfig parseDomainName$default$2(String string) {
        return UrlParser$.MODULE$.parseDomainName$default$2(string);
    }

    public static UriConfig parseHost$default$2(String string) {
        return UrlParser$.MODULE$.parseHost$default$2(string);
    }

    public static UriConfig parseIpV4$default$2(String string) {
        return UrlParser$.MODULE$.parseIpV4$default$2(string);
    }

    public static UriConfig parseIpV6$default$2(String string) {
        return UrlParser$.MODULE$.parseIpV6$default$2(string);
    }

    public static UriConfig parsePath$default$2(String string) {
        return UrlParser$.MODULE$.parsePath$default$2(string);
    }

    public static UriConfig parseProtocolRelativeUrl$default$2(String string) {
        return UrlParser$.MODULE$.parseProtocolRelativeUrl$default$2(string);
    }

    public static UriConfig parseQuery$default$2(String string) {
        return UrlParser$.MODULE$.parseQuery$default$2(string);
    }

    public static UriConfig parseQueryParam$default$2(String string) {
        return UrlParser$.MODULE$.parseQueryParam$default$2(string);
    }

    public static UriConfig parseRelativeUrl$default$2(String string) {
        return UrlParser$.MODULE$.parseRelativeUrl$default$2(string);
    }

    public static UriConfig parseScpLikeUrl$default$2(String string) {
        return UrlParser$.MODULE$.parseScpLikeUrl$default$2(string);
    }

    public static UriConfig parseSimpleUrlWithoutAuthority$default$2(String string) {
        return UrlParser$.MODULE$.parseSimpleUrlWithoutAuthority$default$2(string);
    }

    public static UriConfig parseUrl$default$2(String string) {
        return UrlParser$.MODULE$.parseUrl$default$2(string);
    }

    public static UriConfig parseUrlWithAuthority$default$2(String string) {
        return UrlParser$.MODULE$.parseUrlWithAuthority$default$2(string);
    }

    public static UriConfig parseUrlWithoutAuthority$default$2(String string) {
        return UrlParser$.MODULE$.parseUrlWithoutAuthority$default$2(string);
    }

    public static UriConfig parseUserInfo$default$2(String string) {
        return UrlParser$.MODULE$.parseUserInfo$default$2(string);
    }

    public UrlParser(String input, UriConfig conf) {
        this.input = input;
        this.conf = conf;
        UriParser.$init$(this);
        this._host_end = ":/\\?# \t\r\n";
        this.extractAbsoluteUrl = (Function5 & Serializable)(scheme, authority, path, qs, f) -> AbsoluteUrl$.MODULE$.apply((String)scheme, (Authority)authority, (AbsoluteOrEmptyPath)path, (QueryString)qs, (Option<String>)f, conf);
        this.extractProtocolRelativeUrl = (Function4 & Serializable)(authority, path, qs, f) -> ProtocolRelativeUrl$.MODULE$.apply((Authority)authority, (AbsoluteOrEmptyPath)path, (QueryString)qs, (Option<String>)f, conf);
        this.extractRelativeUrl = (Function3 & Serializable)(path, qs, f) -> RelativeUrl$.MODULE$.apply((UrlPath)path, (QueryString)qs, (Option<String>)f, conf);
        this.extractUrlWithoutAuthority = (Function4 & Serializable)(scheme, path, qs, f) -> SimpleUrlWithoutAuthority$.MODULE$.apply((String)scheme, (UrlPath)path, (QueryString)qs, (Option<String>)f, conf);
        this.extractInt = (Function1 & Serializable)num -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(num));
        this.extractHexToInt = (Function1 & Serializable)num -> Integer.parseInt(num, 16);
        this.extractIpv4 = (Function4 & Serializable)(a, b, c, d) -> IpV4$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)a), BoxesRunTime.unboxToInt((Object)b), BoxesRunTime.unboxToInt((Object)c), BoxesRunTime.unboxToInt((Object)d));
        this.extractFullIpv6 = (Function1 & Serializable)pieces -> IpV6$.MODULE$.fromHexPieces((Seq<String>)pieces);
        this.extractFullIpv6Ls32Ipv4 = (Function2 & Serializable)(pieces, ipV4) -> IpV6$.MODULE$.fromHexPiecesAndIpV4((Seq<String>)pieces, (IpV4)ipV4);
        this.extractIpv6Ls32Ipv4WithElided = (Function3 & Serializable)(beforeElided, afterElided, ipV4) -> {
            int elidedPieces = 6 - beforeElided.size() - afterElided.size();
            if (elidedPieces < 1) {
                throw new UriParsingException("IPv6 has too many pieces. When the least-significant 32bits are an IPv4, there must be either exactly six leading hex pieces or fewer than six hex pieces with a '::'");
            }
            return IpV6$.MODULE$.fromHexPiecesAndIpV4((Seq<String>)((Seq)((IterableOps)beforeElided.$plus$plus((IterableOnce)package$.MODULE$.Vector().fill(elidedPieces, UrlParser::$init$$$anonfun$10$$anonfun$1))).$plus$plus((IterableOnce)afterElided)), (IpV4)ipV4);
        };
        this.extractIpv6WithEluded = (Function2 & Serializable)(beforeEluded, afterEluded) -> {
            int elidedPieces = 8 - beforeEluded.size() - afterEluded.size();
            if (elidedPieces < 1) {
                throw new UriParsingException("IPv6 has too many pieces. Must be either exactly eight hex pieces or fewer than eight hex pieces with a '::'");
            }
            return IpV6$.MODULE$.fromHexPieces((Seq<String>)((Seq)((IterableOps)beforeEluded.$plus$plus((IterableOnce)package$.MODULE$.Vector().fill(elidedPieces, UrlParser::$init$$$anonfun$11$$anonfun$1))).$plus$plus((IterableOnce)afterEluded)));
        };
        this.extractDomainName = (Function1 & Serializable)domainName -> DomainName$.MODULE$.apply((String)domainName, conf);
        this.extractUserInfo = (Function2 & Serializable)(user, pass) -> {
            UriDecoder uriDecoder = this.pathDecoder();
            return UserInfo$.MODULE$.apply(this.pathDecoder().decode((String)user), (Option<String>)pass.map((Function1 & Serializable)u -> uriDecoder.decode((String)u)), conf);
        };
        this.extractAuthority = (Function3 & Serializable)(userInfo, host, port) -> Authority$.MODULE$.apply((Option<UserInfo>)userInfo, (Host)host, (Option<Object>)port, conf);
        this.extractFragment = (Function1 & Serializable)x -> this.fragmentDecoder().decode((String)x);
        this.extractQueryString = (Function1 & Serializable)tuples -> {
            UriDecoder uriDecoder = this.queryDecoder();
            return QueryString$.MODULE$.apply((Vector<Tuple2<String, Option<String>>>)((Vector)tuples.toVector().map((Function1 & Serializable)kv -> uriDecoder.decodeTuple((Tuple2<String, Option<String>>)kv))), conf);
        };
        this.extractPathPart = (Function1 & Serializable)pathPart -> this.pathDecoder().decode((String)pathPart);
        this.extractAbsOrEmptyPath = (Function1 & Serializable)pp -> {
            if (pp.isEmpty()) {
                return EmptyPath$.MODULE$;
            }
            return AbsolutePath$.MODULE$.apply((Vector<String>)pp.toVector(), conf);
        };
        this.extractRelPath = (Function2 & Serializable)(maybeSlash, pp) -> {
            if (maybeSlash.nonEmpty()) {
                return AbsolutePath$.MODULE$.apply((Vector<String>)pp.toVector(), conf);
            }
            Seq seq = pp;
            SeqOps seqOps = package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}));
            if (!(seq != null ? !seq.equals(seqOps) : seqOps != null)) {
                return UrlPath$.MODULE$.empty();
            }
            return RootlessPath$.MODULE$.apply((Vector<String>)pp.toVector(), conf);
        };
        this.extractMediaTypeParam = (Function2 & Serializable)(k, v) -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(k);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, v);
        };
        this.extractMediaType = (Function2 & Serializable)(value, params) -> MediaType$.MODULE$.apply((Option<String>)(value.isEmpty() ? None$.MODULE$ : Some$.MODULE$.apply(value)), (Vector<Tuple2<String, String>>)params.toVector());
        this.extractBase64DataUrl = (Function2 & Serializable)(mediaType, data) -> DataUrl$.MODULE$.fromBase64((MediaType)mediaType, (String)data, conf);
        this.extractPercentEncodedDataUrl = (Function2 & Serializable)(mediaType, data) -> DataUrl$.MODULE$.fromPercentEncoded((MediaType)mediaType, (String)data, conf);
        this.extractTuple = (Function2 & Serializable)(k, v) -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(k);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Some$.MODULE$.apply(v));
        };
        this.extractTok = (Function1 & Serializable)k -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(k);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)None$.MODULE$);
        };
        this.extractScpLikeUrl = (Function3 & Serializable)(user, host, path) -> ScpLikeUrl$.MODULE$.apply((Option<String>)user, (Host)host, (UrlPath)path, conf);
        Statics.releaseFence();
    }

    public Parser _alpha_num() {
        return this._alpha_num;
    }

    public Parser _hex_digit() {
        return this._hex_digit;
    }

    public Parser _unreserved() {
        return this._unreserved;
    }

    public Parser _pct_encoded() {
        return this._pct_encoded;
    }

    public Parser _sub_delims() {
        return this._sub_delims;
    }

    public Parser _p_char() {
        return this._p_char;
    }

    @Override
    public void io$lemonlabs$uri$parsing$UriParser$_setter_$_alpha_num_$eq(Parser x$0) {
        this._alpha_num = x$0;
    }

    @Override
    public void io$lemonlabs$uri$parsing$UriParser$_setter_$_hex_digit_$eq(Parser x$0) {
        this._hex_digit = x$0;
    }

    @Override
    public void io$lemonlabs$uri$parsing$UriParser$_setter_$_unreserved_$eq(Parser x$0) {
        this._unreserved = x$0;
    }

    @Override
    public void io$lemonlabs$uri$parsing$UriParser$_setter_$_pct_encoded_$eq(Parser x$0) {
        this._pct_encoded = x$0;
    }

    @Override
    public void io$lemonlabs$uri$parsing$UriParser$_setter_$_sub_delims_$eq(Parser x$0) {
        this._sub_delims = x$0;
    }

    @Override
    public void io$lemonlabs$uri$parsing$UriParser$_setter_$_p_char_$eq(Parser x$0) {
        this._p_char = x$0;
    }

    public String input() {
        return this.input;
    }

    public String _host_end() {
        return this._host_end;
    }

    public Parser<Object> _int(int maxLength) {
        return Numbers$.MODULE$.digit().rep(1, maxLength).string().map(this.extractInt());
    }

    public Parser<Object> _octet() {
        return this._int(3).filter((Function1)(JFunction1.mcZI.sp & Serializable)octet -> 0 <= octet && octet <= 255);
    }

    public Parser<String> _scheme() {
        return Rfc5234$.MODULE$.alpha().$tilde(Rfc5234$.MODULE$.alpha().$bar(Numbers$.MODULE$.digit()).$bar(Parser$.MODULE$.charIn('+', (Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'-', '.'}))).rep0()).string();
    }

    public Parser<IpV4> _ip_v4() {
        return this._octet().repSep(4, 4, (Parser0)Parser$.MODULE$.char('.')).map((Function1 & Serializable)list -> {
            SeqOps seqOps;
            List list2 = list.toList();
            if (list2 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list2), 4) != 0) {
                throw new MatchError((Object)list2);
            }
            int n = BoxesRunTime.unboxToInt((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0));
            int n2 = BoxesRunTime.unboxToInt((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1));
            int n3 = BoxesRunTime.unboxToInt((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 2));
            int n4 = BoxesRunTime.unboxToInt((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 3));
            int a = n;
            int b = n2;
            int c = n3;
            int d = n4;
            Tuple4 tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)a), (Object)BoxesRunTime.boxToInteger((int)b), (Object)BoxesRunTime.boxToInteger((int)c), (Object)BoxesRunTime.boxToInteger((int)d));
            int a2 = BoxesRunTime.unboxToInt((Object)tuple4._1());
            int b2 = BoxesRunTime.unboxToInt((Object)tuple4._2());
            int c2 = BoxesRunTime.unboxToInt((Object)tuple4._3());
            int d2 = BoxesRunTime.unboxToInt((Object)tuple4._4());
            return (IpV4)this.extractIpv4().apply((Object)BoxesRunTime.boxToInteger((int)a2), (Object)BoxesRunTime.boxToInteger((int)b2), (Object)BoxesRunTime.boxToInteger((int)c2), (Object)BoxesRunTime.boxToInteger((int)d2));
        });
    }

    public Parser<String> _ip_v6_hex_piece() {
        return this._hex_digit().rep(1, 4).string();
    }

    public Parser<IpV6> _full_ip_v6() {
        return Parser$.MODULE$.char('[').flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this._ip_v6_hex_piece().repSep(8, 8, (Parser0)Parser$.MODULE$.char(':')).flatMap((Function1 & Serializable)ip_v6_hex_pieces -> Parser$.MODULE$.char(']').map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (IpV6)this.extractFullIpv6().apply((Object)ip_v6_hex_pieces.toList());
            }));
        });
    }

    private Parser<IpV6> _full_ip_v6_ls32_ip_v4() {
        return Parser$.MODULE$.char('[').flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this._ip_v6_hex_piece().repSep(6, 6, (Parser0)Parser$.MODULE$.char(':')).flatMap((Function1 & Serializable)ip_v6_hex_pieces -> Parser$.MODULE$.char(':').flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this._ip_v4().flatMap((Function1 & Serializable)ip_v4 -> Parser$.MODULE$.char(']').map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return (IpV6)this.extractFullIpv6Ls32Ipv4.apply((Object)ip_v6_hex_pieces.toList(), ip_v4);
                }));
            }));
        });
    }

    public Parser0<Seq<String>> _ip_v6_hex_pieces() {
        return this._ip_v6_hex_piece().repSep0((Parser0)Parser$.MODULE$.char(':')).map((Function1 & Serializable)_$1 -> _$1.toList());
    }

    private Parser0<Seq<String>> _ip_v6_hex_pieces_ending_colon() {
        return this._ip_v6_hex_piece().soft().$less$times((Parser0)Parser$.MODULE$.char(':')).rep0().map((Function1 & Serializable)_$2 -> _$2.toList());
    }

    public Parser<IpV6> _ip_v6_with_eluded() {
        return Parser$.MODULE$.char('[').flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this._ip_v6_hex_pieces().flatMap((Function1 & Serializable)firstPart -> Parser$.MODULE$.string("::").flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this._ip_v6_hex_pieces().flatMap((Function1 & Serializable)secondPart -> Parser$.MODULE$.char(']').map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return (IpV6)this.extractIpv6WithEluded().apply(firstPart, secondPart);
                }));
            }));
        });
    }

    private Parser<IpV6> _ip_v6_ls32_ip_v4_with_elided() {
        return Parser$.MODULE$.char('[').flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this._ip_v6_hex_pieces().flatMap((Function1 & Serializable)firstPart -> Parser$.MODULE$.string("::").flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object[] objectArray = new Parser0[2];
                objectArray[0] = this._ip_v6_hex_pieces_ending_colon().$tilde(this._ip_v4()).backtrack();
                Parser0 parser0 = Parser$.MODULE$.pure((Object)package$.MODULE$.List().empty()).with1();
                objectArray[1] = Parser.With1$.MODULE$.$tilde$extension(parser0, this._ip_v4());
                return Parser$.MODULE$.oneOf0((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).flatMap((Function1 & Serializable)t -> Parser$.MODULE$.char(']').map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return (IpV6)this.extractIpv6Ls32Ipv4WithElided.apply((Object)firstPart.toList(), (Object)((IterableOnceOps)t._1()).toList(), t._2());
                }));
            }));
        });
    }

    public Parser<IpV6> _ip_v6() {
        return Parser$.MODULE$.oneOf((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Parser[]{this._full_ip_v6().backtrack(), this._ip_v6_with_eluded().backtrack(), this._full_ip_v6_ls32_ip_v4().backtrack(), this._ip_v6_ls32_ip_v4_with_elided()})));
    }

    public Parser0<DomainName> _domain_name() {
        return Parser$.MODULE$.until0((Parser0)Parser$.MODULE$.charIn((Iterable)Predef$.MODULE$.wrapString(this._host_end()))).map(this.extractDomainName());
    }

    public Parser0<Host> _host() {
        return this._host_in_authority("");
    }

    public Parser0<BoxedUnit> _ip_in_url_end() {
        return this._ip_in_url_end(this._host_end());
    }

    public Parser0<BoxedUnit> _ip_in_url_end(String hostEndChars) {
        return Parser$.MODULE$.charIn((Iterable)Predef$.MODULE$.wrapString(hostEndChars)).peek().$bar(Parser$.MODULE$.end());
    }

    public Parser0<Host> _host_in_authority() {
        return this._host_in_authority(this._host_end());
    }

    public Parser0<Host> _host_in_authority(String hostEndChars) {
        return this._ip_v4().$less$times(this._ip_in_url_end(hostEndChars)).backtrack().$bar(this._ip_v6()).$bar(this._domain_name());
    }

    public Parser0<UserInfo> _user_info() {
        return Parser$.MODULE$.until0((Parser0)Parser$.MODULE$.charIn((Iterable)Predef$.MODULE$.wrapString(":/?[]@ \t\r\n"))).flatMap((Function1 & Serializable)user -> Parser$.MODULE$.char(':').$times$greater(Parser$.MODULE$.until0((Parser0)Parser$.MODULE$.charIn((Iterable)Predef$.MODULE$.wrapString("/@")))).$qmark().flatMap((Function1 & Serializable)password -> Parser$.MODULE$.char('@').map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return (UserInfo)this.extractUserInfo().apply(user, password);
        })));
    }

    public Parser<Object> _port() {
        return Parser$.MODULE$.char(':').$times$greater(this._int(10));
    }

    public Parser0<Authority> _authority() {
        return this._user_info().map((Function1 & Serializable)value -> Some$.MODULE$.apply(value)).$tilde(this._host_in_authority()).backtrack().$bar(Parser$.MODULE$.pure((Object)None$.MODULE$).$tilde(this._host_in_authority())).flatMap((Function1 & Serializable)t -> this._port().$qmark().map((Function1 & Serializable)port -> (Authority)this.extractAuthority().apply(t._1(), t._2(), port)));
    }

    public Parser0<String> _path_segment() {
        return Parser$.MODULE$.until0((Parser0)Parser$.MODULE$.charIn((Iterable)Predef$.MODULE$.wrapString("/?#"))).string().map(this.extractPathPart());
    }

    public Parser0<AbsoluteOrEmptyPath> _path_for_authority() {
        return Parser$.MODULE$.char('/').$times$greater(this._path_segment()).rep0().map((Function1 & Serializable)parts -> (AbsoluteOrEmptyPath)this.extractAbsOrEmptyPath().apply(parts));
    }

    public Parser0<UrlPath> _path() {
        return Parser$.MODULE$.char('/').$qmark().$tilde(this.rep0sep0(this._path_segment(), (Parser<Object>)Parser$.MODULE$.char('/'))).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Option maybeSlash = (Option)tuple2._1();
                List parts = (List)tuple2._2();
                return (UrlPath)this.extractRelPath().apply((Object)maybeSlash, (Object)parts);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Parser<Tuple2<String, Some<String>>> _query_param() {
        return Parser$.MODULE$.until((Parser0)Parser$.MODULE$.charIn((Iterable)Predef$.MODULE$.wrapString("=&#"))).string().flatMap((Function1 & Serializable)key -> Parser$.MODULE$.char('=').flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Parser$.MODULE$.until0((Parser0)Parser$.MODULE$.charIn((Iterable)Predef$.MODULE$.wrapString("&#"))).map((Function1 & Serializable)value -> (Tuple2)this.extractTuple().apply(key, value));
        }));
    }

    public Parser<Tuple2<String, None$>> _query_tok() {
        return Parser$.MODULE$.until((Parser0)Parser$.MODULE$.charIn((Iterable)Predef$.MODULE$.wrapString("=&#"))).string().map((Function1 & Serializable)key -> (Tuple2)this.extractTok().apply(key));
    }

    public Parser0<Tuple2<String, Option<String>>> _query_param_or_tok() {
        return this._query_param().backtrack().$bar(this._query_tok()).$bar(Parser$.MODULE$.char('&').peek().$bar(Parser$.MODULE$.char('#').peek()).$bar(Parser$.MODULE$.end()).as((Object)Tuple2$.MODULE$.apply((Object)"", (Object)None$.MODULE$)));
    }

    public Parser<QueryString> _query_string() {
        return Parser$.MODULE$.char('?').flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.rep0sep0(this._query_param_or_tok(), (Parser<Object>)Parser$.MODULE$.char('&')).map((Function1 & Serializable)params -> (QueryString)this.extractQueryString().apply(params));
        });
    }

    public Parser0<QueryString> _maybe_query_string() {
        return this._query_string().$bar(Parser$.MODULE$.pure((Object)QueryString$.MODULE$.empty(this.conf)));
    }

    public Parser<String> _fragment() {
        return Parser$.MODULE$.char('#').$times$greater(Parser$.MODULE$.anyChar().rep0().string().map(this.extractFragment()));
    }

    public Parser<AbsoluteUrl> _abs_url() {
        return this._scheme().flatMap((Function1 & Serializable)scheme -> Parser$.MODULE$.string("://").flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this._authority().flatMap((Function1 & Serializable)authority -> this._path_for_authority().flatMap((Function1 & Serializable)path_for_authority -> this._maybe_query_string().flatMap((Function1 & Serializable)maybe_query_string -> this._fragment().$qmark().map((Function1 & Serializable)maybeFragment -> (AbsoluteUrl)this.extractAbsoluteUrl().apply(scheme, authority, path_for_authority, maybe_query_string, maybeFragment)))));
        }));
    }

    public Parser<UrlWithoutAuthority> _url_without_authority() {
        return this._data_url().backtrack().$bar(this._simple_url_without_authority());
    }

    public Parser<SimpleUrlWithoutAuthority> _simple_url_without_authority() {
        return this._scheme().flatMap((Function1 & Serializable)scheme -> Parser$.MODULE$.char(':').flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Parser$.MODULE$.not((Parser0)Parser$.MODULE$.string("//")).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this._path().flatMap((Function1 & Serializable)path -> this._maybe_query_string().flatMap((Function1 & Serializable)maybe_query_string -> this._fragment().$qmark().map((Function1 & Serializable)maybe_fragment -> (SimpleUrlWithoutAuthority)this.extractUrlWithoutAuthority().apply(scheme, path, maybe_query_string, maybe_fragment))));
            });
        }));
    }

    public Parser<Tuple2<String, String>> _media_type_param() {
        return Parser$.MODULE$.until((Parser0)Parser$.MODULE$.charIn((Iterable)Predef$.MODULE$.wrapString(";,="))).string().flatMap((Function1 & Serializable)k -> Parser$.MODULE$.char('=').flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Parser$.MODULE$.until((Parser0)Parser$.MODULE$.charIn((Iterable)Predef$.MODULE$.wrapString(";,"))).string().map((Function1 & Serializable)v -> (Tuple2)this.extractMediaTypeParam().apply(k, v));
        }));
    }

    public Parser0<MediaType> _media_type() {
        return Parser$.MODULE$.until0((Parser0)Parser$.MODULE$.charIn((Iterable)Predef$.MODULE$.wrapString(";,"))).flatMap((Function1 & Serializable)value -> Parser$.MODULE$.char(';').$times$greater(this._media_type_param()).backtrack().rep0().map((Function1 & Serializable)params -> (MediaType)this.extractMediaType().apply(value, params)));
    }

    public Parser<DataUrl> _data_url_base64() {
        return Parser$.MODULE$.string("data:").flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Parser$.MODULE$.not((Parser0)Parser$.MODULE$.string("//")).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this._media_type().flatMap((Function1 & Serializable)media_type -> Parser$.MODULE$.string(";base64,").flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return Parser$.MODULE$.until0(Parser$.MODULE$.end()).map((Function1 & Serializable)data -> (DataUrl)this.extractBase64DataUrl().apply(media_type, data));
                }));
            });
        });
    }

    public Parser<DataUrl> _data_url_percent_encoded() {
        return Parser$.MODULE$.string("data:").flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Parser$.MODULE$.not((Parser0)Parser$.MODULE$.string("//")).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this._media_type().flatMap((Function1 & Serializable)media_type -> Parser$.MODULE$.char(';').$qmark().flatMap((Function1 & Serializable)x$12 -> {
                    Option option = x$12;
                    return Parser$.MODULE$.char(',').flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return Parser$.MODULE$.until0(Parser$.MODULE$.end()).map((Function1 & Serializable)data -> (DataUrl)this.extractPercentEncodedDataUrl().apply(media_type, data));
                    });
                }));
            });
        });
    }

    public Parser<DataUrl> _data_url() {
        return this._data_url_base64().backtrack().$bar(this._data_url_percent_encoded());
    }

    public Parser<ProtocolRelativeUrl> _protocol_rel_url() {
        return Parser$.MODULE$.string("//").flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this._authority().flatMap((Function1 & Serializable)authority -> this._path_for_authority().flatMap((Function1 & Serializable)path_for_authority -> this._maybe_query_string().flatMap((Function1 & Serializable)maybe_query_string -> this._fragment().$qmark().map((Function1 & Serializable)maybe_fragment -> (ProtocolRelativeUrl)this.extractProtocolRelativeUrl().apply(authority, path_for_authority, maybe_query_string, maybe_fragment)))));
        });
    }

    public Parser0<RelativeUrl> _rel_url() {
        return Parser$.MODULE$.not((Parser0)Parser$.MODULE$.string("//")).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this._path().map((Function1 & Serializable)path -> {
                boolean colonInFirstSegment = path.nonEmptyRootless() && path.parts().headOption().exists((Function1 & Serializable)_$3 -> StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(_$3), ':'));
                return Tuple2$.MODULE$.apply(path, (Object)BoxesRunTime.boxToBoolean((boolean)colonInFirstSegment));
            }).flatMap((Function1 & Serializable)x$12 -> {
                Tuple2 tuple2 = x$12;
                if (tuple2 != null) {
                    UrlPath path = (UrlPath)tuple2._1();
                    boolean colonInFirstSegment = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                    return (colonInFirstSegment ? Parser$.MODULE$.fail() : Parser$.MODULE$.unit()).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return this._maybe_query_string().flatMap((Function1 & Serializable)maybe_query_string -> this._fragment().$qmark().map((Function1 & Serializable)maybe_fragment -> (RelativeUrl)this.extractRelativeUrl().apply((Object)path, maybe_query_string, maybe_fragment)));
                    });
                }
                throw new MatchError((Object)tuple2);
            });
        });
    }

    public Parser<UrlWithAuthority> _url_with_authority() {
        return this._abs_url().backtrack().$bar(this._protocol_rel_url());
    }

    public Parser0<Url> _url() {
        return this._abs_url().backtrack().$bar(this._protocol_rel_url().backtrack()).$bar(this._url_without_authority().backtrack()).$bar(this._rel_url());
    }

    public Parser0<Option<String>> _scp_like_user() {
        return Parser$.MODULE$.until0((Parser0)Parser$.MODULE$.char('@')).soft().$less$times((Parser0)Parser$.MODULE$.char('@')).$qmark();
    }

    public Parser<ScpLikeUrl> _scp_like_url() {
        Parser0 parser0 = this._scp_like_user().with1();
        return Parser.With1$.MODULE$.flatMap$extension(parser0, (Function1 & Serializable)scp_like_user -> {
            Parser0 parser0 = this._host_in_authority(":").with1();
            return Parser.With1$.MODULE$.flatMap$extension(parser0, (Function1 & Serializable)host_in_authority -> Parser$.MODULE$.char(':').flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this._path().map((Function1 & Serializable)path -> (ScpLikeUrl)this.extractScpLikeUrl().apply(scp_like_user, host_in_authority, path));
            }));
        });
    }

    public Function5<String, Authority, AbsoluteOrEmptyPath, QueryString, Option<String>, AbsoluteUrl> extractAbsoluteUrl() {
        return this.extractAbsoluteUrl;
    }

    public Function4<Authority, AbsoluteOrEmptyPath, QueryString, Option<String>, ProtocolRelativeUrl> extractProtocolRelativeUrl() {
        return this.extractProtocolRelativeUrl;
    }

    public Function3<UrlPath, QueryString, Option<String>, RelativeUrl> extractRelativeUrl() {
        return this.extractRelativeUrl;
    }

    public Function4<String, UrlPath, QueryString, Option<String>, SimpleUrlWithoutAuthority> extractUrlWithoutAuthority() {
        return this.extractUrlWithoutAuthority;
    }

    public Function1<String, Object> extractInt() {
        return this.extractInt;
    }

    public Function1<String, Object> extractHexToInt() {
        return this.extractHexToInt;
    }

    public Function4<Object, Object, Object, Object, IpV4> extractIpv4() {
        return this.extractIpv4;
    }

    public Function1<Seq<String>, IpV6> extractFullIpv6() {
        return this.extractFullIpv6;
    }

    public Function2<Seq<String>, Seq<String>, IpV6> extractIpv6WithEluded() {
        return this.extractIpv6WithEluded;
    }

    public Function1<String, DomainName> extractDomainName() {
        return this.extractDomainName;
    }

    public Function2<String, Option<String>, UserInfo> extractUserInfo() {
        return this.extractUserInfo;
    }

    public Function3<Option<UserInfo>, Host, Option<Object>, Authority> extractAuthority() {
        return this.extractAuthority;
    }

    public Function1<String, String> extractFragment() {
        return this.extractFragment;
    }

    public Function1<Seq<Tuple2<String, Option<String>>>, QueryString> extractQueryString() {
        return this.extractQueryString;
    }

    public Function1<String, String> extractPathPart() {
        return this.extractPathPart;
    }

    public Function1<Seq<String>, AbsoluteOrEmptyPath> extractAbsOrEmptyPath() {
        return this.extractAbsOrEmptyPath;
    }

    public Function2<Option<BoxedUnit>, Seq<String>, UrlPath> extractRelPath() {
        return this.extractRelPath;
    }

    public Function2<String, String, Tuple2<String, String>> extractMediaTypeParam() {
        return this.extractMediaTypeParam;
    }

    public Function2<String, Seq<Tuple2<String, String>>, MediaType> extractMediaType() {
        return this.extractMediaType;
    }

    public Function2<MediaType, String, DataUrl> extractBase64DataUrl() {
        return this.extractBase64DataUrl;
    }

    public Function2<MediaType, String, DataUrl> extractPercentEncodedDataUrl() {
        return this.extractPercentEncodedDataUrl;
    }

    public Function2<String, String, Tuple2<String, Some<String>>> extractTuple() {
        return this.extractTuple;
    }

    public Function1<String, Tuple2<String, None$>> extractTok() {
        return this.extractTok;
    }

    public Function3<Option<String>, Host, UrlPath, ScpLikeUrl> extractScpLikeUrl() {
        return this.extractScpLikeUrl;
    }

    public UriDecoder pathDecoder() {
        return this.conf.pathDecoder();
    }

    public UriDecoder queryDecoder() {
        return this.conf.queryDecoder();
    }

    public UriDecoder fragmentDecoder() {
        return this.conf.fragmentDecoder();
    }

    public <T> Try<T> mapParseError(Function0<Either<Parser.Error, T>> t, Function0<String> name) {
        return Try$.MODULE$.apply(t).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Parser.Error error = (Parser.Error)((Left)either).value();
                return Failure$.MODULE$.apply((Throwable)new UriParsingException(new StringBuilder(30).append("Invalid ").append(name.apply()).append(" could not be parsed. ").append(error).toString()));
            }
            if (either instanceof Right) {
                Object value = ((Right)either).value();
                return Success$.MODULE$.apply(value);
            }
            throw new MatchError((Object)either);
        });
    }

    public Try<IpV6> parseIpV6() {
        return this.mapParseError(this::parseIpV6$$anonfun$1, (Function0<String>)((Function0 & Serializable)UrlParser::parseIpV6$$anonfun$2));
    }

    public Try<IpV4> parseIpV4() {
        return this.mapParseError(this::parseIpV4$$anonfun$1, (Function0<String>)((Function0 & Serializable)UrlParser::parseIpV4$$anonfun$2));
    }

    public Try<DomainName> parseDomainName() {
        return this.mapParseError(this::parseDomainName$$anonfun$1, (Function0<String>)((Function0 & Serializable)UrlParser::parseDomainName$$anonfun$2));
    }

    public Try<Host> parseHost() {
        return this.mapParseError(this::parseHost$$anonfun$1, (Function0<String>)((Function0 & Serializable)UrlParser::parseHost$$anonfun$2));
    }

    public Try<UserInfo> parseUserInfo() {
        return this.mapParseError(this::parseUserInfo$$anonfun$1, (Function0<String>)((Function0 & Serializable)UrlParser::parseUserInfo$$anonfun$2));
    }

    public Try<UrlWithoutAuthority> parseUrlWithoutAuthority() {
        return this.mapParseError(this::parseUrlWithoutAuthority$$anonfun$1, (Function0<String>)((Function0 & Serializable)UrlParser::parseUrlWithoutAuthority$$anonfun$2));
    }

    public Try<SimpleUrlWithoutAuthority> parseSimpleUrlWithoutAuthority() {
        return this.mapParseError(this::parseSimpleUrlWithoutAuthority$$anonfun$1, (Function0<String>)((Function0 & Serializable)UrlParser::parseSimpleUrlWithoutAuthority$$anonfun$2));
    }

    public Try<DataUrl> parseDataUrl() {
        return this.mapParseError(this::parseDataUrl$$anonfun$1, (Function0<String>)((Function0 & Serializable)UrlParser::parseDataUrl$$anonfun$2));
    }

    public Try<ScpLikeUrl> parseScpLikeUrl() {
        return this.mapParseError(this::parseScpLikeUrl$$anonfun$1, (Function0<String>)((Function0 & Serializable)UrlParser::parseScpLikeUrl$$anonfun$2));
    }

    public Try<AbsoluteUrl> parseAbsoluteUrl() {
        return this.mapParseError(this::parseAbsoluteUrl$$anonfun$1, (Function0<String>)((Function0 & Serializable)UrlParser::parseAbsoluteUrl$$anonfun$2));
    }

    public Try<ProtocolRelativeUrl> parseProtocolRelativeUrl() {
        return this.mapParseError(this::parseProtocolRelativeUrl$$anonfun$1, (Function0<String>)((Function0 & Serializable)UrlParser::parseProtocolRelativeUrl$$anonfun$2));
    }

    public Try<UrlWithAuthority> parseUrlWithAuthority() {
        return this.mapParseError(this::parseUrlWithAuthority$$anonfun$1, (Function0<String>)((Function0 & Serializable)UrlParser::parseUrlWithAuthority$$anonfun$2));
    }

    public Try<RelativeUrl> parseRelativeUrl() {
        return this.mapParseError(this::parseRelativeUrl$$anonfun$1, (Function0<String>)((Function0 & Serializable)UrlParser::parseRelativeUrl$$anonfun$2));
    }

    public Try<UrlPath> parsePath() {
        return this.mapParseError(this::parsePath$$anonfun$1, (Function0<String>)((Function0 & Serializable)UrlParser::parsePath$$anonfun$2));
    }

    public Try<Authority> parseAuthority() {
        return this.mapParseError(this::parseAuthority$$anonfun$1, (Function0<String>)((Function0 & Serializable)UrlParser::parseAuthority$$anonfun$2));
    }

    public Try<Url> parseUrl() {
        return this.mapParseError(this::parseUrl$$anonfun$1, (Function0<String>)((Function0 & Serializable)UrlParser::parseUrl$$anonfun$2));
    }

    public Try<QueryString> parseQuery() {
        String string = this.input();
        String string2 = "?";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return Success$.MODULE$.apply((Object)QueryString$.MODULE$.empty(this.conf));
        }
        return this.mapParseError(this::parseQuery$$anonfun$1, (Function0<String>)((Function0 & Serializable)UrlParser::parseQuery$$anonfun$2));
    }

    public Try<Tuple2<String, Option<String>>> parseQueryParam() {
        return this.mapParseError(this::parseQueryParam$$anonfun$1, (Function0<String>)((Function0 & Serializable)UrlParser::parseQueryParam$$anonfun$2));
    }

    private <A> Parser0<List<A>> rep0sep0(Parser0<A> data, Parser<Object> separator) {
        return data.$qmark().$tilde(separator.$times$greater(data).rep0()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Option a = (Option)tuple2._1();
                List as = (List)tuple2._2();
                return (List)as.$plus$plus$colon((IterableOnce)a);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private static final String $init$$$anonfun$10$$anonfun$1() {
        return "0";
    }

    private static final String $init$$$anonfun$11$$anonfun$1() {
        return "0";
    }

    private final Either parseIpV6$$anonfun$1() {
        return this._ip_v6().$less$times(Parser$.MODULE$.end()).parseAll(this.input());
    }

    private static final String parseIpV6$$anonfun$2() {
        return "IPv6";
    }

    private final Either parseIpV4$$anonfun$1() {
        return this._ip_v4().$less$times(Parser$.MODULE$.end()).parseAll(this.input());
    }

    private static final String parseIpV4$$anonfun$2() {
        return "IPv4";
    }

    private final Either parseDomainName$$anonfun$1() {
        return this._domain_name().$less$times(Parser$.MODULE$.end()).parseAll(this.input());
    }

    private static final String parseDomainName$$anonfun$2() {
        return "Domain Name";
    }

    private final Either parseHost$$anonfun$1() {
        return this._host().$less$times(Parser$.MODULE$.end()).parseAll(this.input());
    }

    private static final String parseHost$$anonfun$2() {
        return "Host";
    }

    private final Either parseUserInfo$$anonfun$1() {
        return this._user_info().$less$times(Parser$.MODULE$.end()).parseAll(this.input());
    }

    private static final String parseUserInfo$$anonfun$2() {
        return "User Info";
    }

    private final Either parseUrlWithoutAuthority$$anonfun$1() {
        return this._url_without_authority().$less$times(Parser$.MODULE$.end()).parseAll(this.input());
    }

    private static final String parseUrlWithoutAuthority$$anonfun$2() {
        return "Url";
    }

    private final Either parseSimpleUrlWithoutAuthority$$anonfun$1() {
        return this._simple_url_without_authority().$less$times(Parser$.MODULE$.end()).parseAll(this.input());
    }

    private static final String parseSimpleUrlWithoutAuthority$$anonfun$2() {
        return "Url";
    }

    private final Either parseDataUrl$$anonfun$1() {
        return this._data_url().$less$times(Parser$.MODULE$.end()).parseAll(this.input());
    }

    private static final String parseDataUrl$$anonfun$2() {
        return "Data Url";
    }

    private final Either parseScpLikeUrl$$anonfun$1() {
        return this._scp_like_url().$less$times(Parser$.MODULE$.end()).parseAll(this.input());
    }

    private static final String parseScpLikeUrl$$anonfun$2() {
        return "scp-like Url";
    }

    private final Either parseAbsoluteUrl$$anonfun$1() {
        return this._abs_url().$less$times(Parser$.MODULE$.end()).parseAll(this.input());
    }

    private static final String parseAbsoluteUrl$$anonfun$2() {
        return "Url";
    }

    private final Either parseProtocolRelativeUrl$$anonfun$1() {
        return this._protocol_rel_url().$less$times(Parser$.MODULE$.end()).parseAll(this.input());
    }

    private static final String parseProtocolRelativeUrl$$anonfun$2() {
        return "Url";
    }

    private final Either parseUrlWithAuthority$$anonfun$1() {
        return this._url_with_authority().$less$times(Parser$.MODULE$.end()).parseAll(this.input());
    }

    private static final String parseUrlWithAuthority$$anonfun$2() {
        return "Url";
    }

    private final Either parseRelativeUrl$$anonfun$1() {
        return this._rel_url().$less$times(Parser$.MODULE$.end()).parseAll(this.input());
    }

    private static final String parseRelativeUrl$$anonfun$2() {
        return "Url";
    }

    private final Either parsePath$$anonfun$1() {
        return this._path().$less$times(Parser$.MODULE$.end()).parseAll(this.input());
    }

    private static final String parsePath$$anonfun$2() {
        return "Path";
    }

    private final Either parseAuthority$$anonfun$1() {
        return this._authority().$less$times(Parser$.MODULE$.end()).parseAll(this.input());
    }

    private static final String parseAuthority$$anonfun$2() {
        return "Authority";
    }

    private final Either parseUrl$$anonfun$1() {
        return this._url().$less$times(Parser$.MODULE$.end()).parseAll(this.input());
    }

    private static final String parseUrl$$anonfun$2() {
        return "URL";
    }

    private final Either parseQuery$$anonfun$1() {
        return this._query_string().$less$times(Parser$.MODULE$.end()).parseAll(this.input());
    }

    private static final String parseQuery$$anonfun$2() {
        return "Query String";
    }

    private final Either parseQueryParam$$anonfun$1() {
        return this._query_param_or_tok().$less$times(Parser$.MODULE$.end()).parseAll(this.input());
    }

    private static final String parseQueryParam$$anonfun$2() {
        return "Query Parameter";
    }
}

