/*
 * Decompiled with CFR 0.152.
 */
package io.lemonlabs.uri;

import cats.Show;
import cats.kernel.Eq;
import cats.kernel.Order;
import io.lemonlabs.uri.DomainName$;
import io.lemonlabs.uri.Host;
import io.lemonlabs.uri.config.UriConfig;
import io.lemonlabs.uri.inet.PublicSuffixes$;
import io.lemonlabs.uri.inet.PunycodeSupport;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;

public final class DomainName
implements Host,
PunycodeSupport,
Product,
Serializable {
    private final String value;
    private final UriConfig conf;

    public static DomainName apply(String string, UriConfig uriConfig) {
        return DomainName$.MODULE$.apply(string, uriConfig);
    }

    public static DomainName empty() {
        return DomainName$.MODULE$.empty();
    }

    public static Eq<DomainName> eqDomainName() {
        return DomainName$.MODULE$.eqDomainName();
    }

    public static Order<DomainName> orderDomainName() {
        return DomainName$.MODULE$.orderDomainName();
    }

    public static DomainName parse(CharSequence charSequence, UriConfig uriConfig) {
        return DomainName$.MODULE$.parse(charSequence, uriConfig);
    }

    public static Option<DomainName> parseOption(CharSequence charSequence, UriConfig uriConfig) {
        return DomainName$.MODULE$.parseOption(charSequence, uriConfig);
    }

    public static Try<DomainName> parseTry(CharSequence charSequence, UriConfig uriConfig) {
        return DomainName$.MODULE$.parseTry(charSequence, uriConfig);
    }

    public static Show<DomainName> showDomainName() {
        return DomainName$.MODULE$.showDomainName();
    }

    public static DomainName unapply(DomainName domainName) {
        return DomainName$.MODULE$.unapply(domainName);
    }

    public static UriConfig $lessinit$greater$default$2(String string) {
        return DomainName$.MODULE$.$lessinit$greater$default$2(string);
    }

    public static UriConfig parse$default$2(CharSequence charSequence) {
        return DomainName$.MODULE$.parse$default$2(charSequence);
    }

    public static UriConfig parseOption$default$2(CharSequence charSequence) {
        return DomainName$.MODULE$.parseOption$default$2(charSequence);
    }

    public static UriConfig parseTry$default$2(CharSequence charSequence) {
        return DomainName$.MODULE$.parseTry$default$2(charSequence);
    }

    public DomainName(String value, UriConfig conf) {
        this.value = value;
        this.conf = conf;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof DomainName)) return false;
        DomainName domainName = (DomainName)object;
        String string = this.value();
        String string2 = domainName.value();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public boolean canEqual(Object that) {
        return that instanceof DomainName;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "DomainName";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "value";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public UriConfig conf() {
        return this.conf;
    }

    private boolean isValidPublicSuffix(String suffix) {
        if (PublicSuffixes$.MODULE$.set().contains((Object)suffix)) {
            return true;
        }
        if (PublicSuffixes$.MODULE$.exceptions().contains((Object)suffix)) {
            return false;
        }
        int dotIndex = suffix.indexOf(46);
        if (dotIndex < 1) {
            return false;
        }
        return PublicSuffixes$.MODULE$.wildcardPrefixes().contains((Object)suffix.substring(dotIndex + 1));
    }

    @Override
    public DomainName withConfig(UriConfig config) {
        return DomainName$.MODULE$.apply(this.value(), config);
    }

    @Override
    public Option<String> publicSuffix() {
        return this.findLongest$1(this.value());
    }

    @Override
    public Vector<String> publicSuffixes() {
        return this.findAll$1(this.value(), package$.MODULE$.Vector().empty());
    }

    @Override
    public String toStringPunycode() {
        return this.toPunycode(this.value());
    }

    @Override
    public Option<String> apexDomain() {
        return this.publicSuffix().map((Function1 & Serializable)ps -> {
            int apexDomainStart = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(this.value()), ps.length() + 1).lastIndexOf(46);
            if (apexDomainStart == -1) {
                return this.value();
            }
            return this.value().substring(apexDomainStart + 1);
        });
    }

    @Override
    public Option<String> subdomain() {
        return this.longestSubdomain().flatMap((Function1 & Serializable)ls -> {
            int n = ls.lastIndexOf(46);
            if (-1 == n) {
                return None$.MODULE$;
            }
            int i = n;
            return Some$.MODULE$.apply((Object)ls.substring(0, i));
        });
    }

    @Override
    public Vector<String> subdomains() {
        return (Vector)this.longestSubdomain().map((Function1 & Serializable)longestSubdomainStr -> DomainName.concatHostParts$1(longestSubdomainStr)).getOrElse(DomainName::subdomains$$anonfun$2);
    }

    @Override
    public Option<String> shortestSubdomain() {
        return this.longestSubdomain().map((Function1 & Serializable)_$2 -> StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(_$2), (Function1 & Serializable)_$3 -> DomainName.shortestSubdomain$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$3))));
    }

    @Override
    public Option<String> longestSubdomain() {
        int publicSuffixLength = BoxesRunTime.unboxToInt((Object)this.publicSuffix().map((Function1 & Serializable)_$4 -> _$4.length() + 1).getOrElse(DomainName::$anonfun$2));
        String string = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(this.value()), publicSuffixLength);
        if ("".equals(string)) {
            return None$.MODULE$;
        }
        String other = string;
        return Some$.MODULE$.apply((Object)other);
    }

    @Override
    public DomainName normalize() {
        return this.copy(this.value().toLowerCase(), this.conf());
    }

    public DomainName copy(String value, UriConfig conf) {
        return new DomainName(value, conf);
    }

    public String copy$default$1() {
        return this.value();
    }

    public String _1() {
        return this.value();
    }

    private final Option findLongest$1(String remaining) {
        while (!this.isValidPublicSuffix(remaining)) {
            int i = remaining.indexOf(46);
            if (i == -1) {
                return None$.MODULE$;
            }
            remaining = remaining.substring(i + 1);
        }
        return Some$.MODULE$.apply((Object)remaining);
    }

    private final Vector findAll$1(String remaining, Vector matches) {
        while (true) {
            Vector newMatches = this.isValidPublicSuffix(remaining) ? (Vector)matches.$colon$plus((Object)remaining) : matches;
            int i = remaining.indexOf(46);
            if (i == -1) {
                return newMatches;
            }
            String string = remaining.substring(i + 1);
            Vector vector = newMatches;
            remaining = string;
            matches = vector;
        }
    }

    private static final Vector concatHostParts$1(String longestSubdomainStr) {
        Vector parts = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(longestSubdomainStr), '.')).toVector();
        if (parts.size() == 1) {
            return parts;
        }
        return (Vector)parts.tail().foldLeft(package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)parts.head()})), (Function2 & Serializable)(subdomainList, part) -> (Vector)subdomainList.$colon$plus((Object)new StringBuilder(11).append((String)subdomainList.last()).append('.').append((String)part).toString()));
    }

    private static final Vector subdomains$$anonfun$2() {
        return package$.MODULE$.Vector().empty();
    }

    private static final /* synthetic */ boolean shortestSubdomain$$anonfun$1$$anonfun$1(char _$3) {
        return _$3 != '.';
    }

    private static final int $anonfun$2() {
        return 0;
    }
}

