/*
 * Decompiled with CFR 0.152.
 */
package firrtl_interpreter;

import firrtl.ir.ClockType$;
import firrtl.ir.IntWidth;
import firrtl.ir.SIntType;
import firrtl.ir.Type;
import firrtl.ir.UIntType;
import firrtl.ir.Width;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.util.Random;

public final class package$ {
    public static package$ MODULE$;
    private final int InterpreterMaxSupportedWidth;
    private final BigInt Big0;
    private final BigInt Big1;
    private final int DangerShiftSize;
    private final BigInt BitsRequiredOverflowSizeBigInt;
    private final Random random;

    static {
        new package$();
    }

    public int InterpreterMaxSupportedWidth() {
        return this.InterpreterMaxSupportedWidth;
    }

    public BigInt Big0() {
        return this.Big0;
    }

    public BigInt Big1() {
        return this.Big1;
    }

    public int DangerShiftSize() {
        return this.DangerShiftSize;
    }

    public BigInt BitsRequiredOverflowSizeBigInt() {
        return this.BitsRequiredOverflowSizeBigInt;
    }

    public Random random() {
        return this.random;
    }

    public BigInt randomBigInt(int width) {
        return scala.package$.MODULE$.BigInt().apply(width, this.random());
    }

    public int boolToInt(boolean condition) {
        return condition ? 1 : 0;
    }

    public BigInt boolToBigInt(boolean condition) {
        return condition ? BigInt$.MODULE$.int2bigInt(1) : BigInt$.MODULE$.int2bigInt(0);
    }

    public int widthToInt(Width width) {
        return ((IntWidth)width).width().toInt();
    }

    public int typeToWidth(Type tpe) {
        int n;
        Type type = tpe;
        if (type instanceof UIntType) {
            UIntType uIntType = (UIntType)type;
            Width w = uIntType.width();
            n = this.widthToInt(w);
        } else if (type instanceof SIntType) {
            SIntType sIntType = (SIntType)type;
            Width w = sIntType.width();
            n = this.widthToInt(w);
        } else if (ClockType$.MODULE$.equals(type)) {
            n = 1;
        } else {
            throw new MatchError((Object)type);
        }
        return n;
    }

    public int ceilingLog2(int x) {
        return (int)scala.math.package$.MODULE$.ceil(scala.math.package$.MODULE$.log((double)x) / scala.math.package$.MODULE$.log(2.0));
    }

    public int computeBits(BigInt n) {
        return n.bitLength() + (n.$less((Object)BigInt$.MODULE$.int2bigInt(0)) ? 1 : 0);
    }

    public Tuple2<BigInt, BigInt> extremaOfSIntOfWidth(int width) {
        BigInt nearestPowerOf2 = scala.package$.MODULE$.BigInt().apply("1" + new StringOps(Predef$.MODULE$.augmentString("0")).$times(width - 1), 2);
        return new Tuple2((Object)nearestPowerOf2.unary_$minus(), (Object)nearestPowerOf2.$minus(BigInt$.MODULE$.int2bigInt(1)));
    }

    public Tuple2<BigInt, BigInt> extremaOfUIntOfWidth(int width) {
        Tuple2 tuple2;
        if (width == 1) {
            tuple2 = new Tuple2((Object)BigInt$.MODULE$.int2bigInt(0), (Object)BigInt$.MODULE$.int2bigInt(1));
        } else {
            BigInt nearestPowerOf2 = scala.package$.MODULE$.BigInt().apply("1" + new StringOps(Predef$.MODULE$.augmentString("0")).$times(width - 1), 2);
            tuple2 = new Tuple2((Object)BigInt$.MODULE$.int2bigInt(0), (Object)nearestPowerOf2.$times(BigInt$.MODULE$.int2bigInt(2)).$minus(BigInt$.MODULE$.int2bigInt(1)));
        }
        return tuple2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int requiredBitsForSInt(BigInt num) {
        BigInt bigInt = num;
        BigInt bigInt2 = this.Big0();
        if (bigInt == null) {
            if (bigInt2 == null) return 1;
        } else if (bigInt.equals(bigInt2)) return 1;
        BigInt bigInt3 = num;
        BigInt bigInt4 = this.Big1().unary_$minus();
        if (bigInt3 == null) {
            if (bigInt4 == null) return 1;
        } else if (bigInt3.equals(bigInt4)) {
            return 1;
        }
        int n = num.$less((Object)BigInt$.MODULE$.int2bigInt(0)) ? this.computeBits(num) : this.computeBits(num) + 1;
        return n;
    }

    public int requiredBitsForUInt(BigInt num) {
        BigInt bigInt = num;
        BigInt bigInt2 = this.Big0();
        return !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null) ? 1 : this.computeBits(num);
    }

    public BigInt doubleToBigIntBits(double d) {
        return scala.package$.MODULE$.BigInt().apply(Double.doubleToLongBits(d));
    }

    public double bigIntBitsToDouble(BigInt bigInt) {
        return Double.longBitsToDouble(bigInt.toLong());
    }

    private package$() {
        MODULE$ = this;
        this.InterpreterMaxSupportedWidth = 100;
        this.Big0 = scala.package$.MODULE$.BigInt().apply(0);
        this.Big1 = scala.package$.MODULE$.BigInt().apply(1);
        this.DangerShiftSize = 27;
        this.BitsRequiredOverflowSizeBigInt = this.Big1().$less$less(this.DangerShiftSize());
        this.random = new Random();
        this.random().setSeed(System.currentTimeMillis());
    }
}

