/*
 * Decompiled with CFR 0.152.
 */
package firrtl_interpreter;

import firrtl.PrimOps;
import firrtl.WRef;
import firrtl.WSubField;
import firrtl.WSubIndex;
import firrtl.ir.ClockType$;
import firrtl.ir.DefRegister;
import firrtl.ir.DoPrim;
import firrtl.ir.Expression;
import firrtl.ir.IntWidth;
import firrtl.ir.IntWidth$;
import firrtl.ir.Mux;
import firrtl.ir.PrimOp;
import firrtl.ir.Print;
import firrtl.ir.SIntLiteral;
import firrtl.ir.SIntType;
import firrtl.ir.Stop;
import firrtl.ir.Type;
import firrtl.ir.UIntLiteral;
import firrtl.ir.UIntType;
import firrtl.ir.ValidIf;
import firrtl.ir.Width;
import firrtl_interpreter.BlackBoxOutput;
import firrtl_interpreter.CircuitState;
import firrtl_interpreter.Concrete;
import firrtl_interpreter.Concrete$;
import firrtl_interpreter.ConcreteClock;
import firrtl_interpreter.ConcreteSInt;
import firrtl_interpreter.ConcreteUInt;
import firrtl_interpreter.ConcreteUInt$;
import firrtl_interpreter.DependencyGraph;
import firrtl_interpreter.ExpressionExecutionStack;
import firrtl_interpreter.InterpreterException;
import firrtl_interpreter.InterpreterException$;
import firrtl_interpreter.Memory;
import firrtl_interpreter.Timer;
import firrtl_interpreter.package;
import firrtl_interpreter.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.StringContext$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\tEh\u0001B\u0001\u0003\u0001\u0015\u00111\u0004T8GSJ\u0014H\u000f\\#yaJ,7o]5p]\u00163\u0018\r\\;bi>\u0014(\"A\u0002\u0002%\u0019L'O\u001d;m?&tG/\u001a:qe\u0016$XM]\u0002\u0001'\r\u0001a\u0001\u0004\t\u0003\u000f)i\u0011\u0001\u0003\u0006\u0002\u0013\u0005)1oY1mC&\u00111\u0002\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u00055\tbB\u0001\b\u0010\u001b\u0005\u0011\u0011B\u0001\t\u0003\u0003\u001d\u0001\u0018mY6bO\u0016L!AE\n\u0003\u0019MKW\u000e\u001d7f\u0019><w-\u001a:\u000b\u0005A\u0011\u0001\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\u0001\f\u0002\u001f\u0011,\u0007/\u001a8eK:\u001c\u0017p\u0012:ba\",\u0012a\u0006\t\u0003\u001daI!!\u0007\u0002\u0003\u001f\u0011+\u0007/\u001a8eK:\u001c\u0017p\u0012:ba\"D\u0001b\u0007\u0001\u0003\u0002\u0003\u0006IaF\u0001\u0011I\u0016\u0004XM\u001c3f]\u000eLxI]1qQ\u0002B\u0001\"\b\u0001\u0003\u0006\u0004%\tAH\u0001\rG&\u00148-^5u'R\fG/Z\u000b\u0002?A\u0011a\u0002I\u0005\u0003C\t\u0011AbQ5sGVLGo\u0015;bi\u0016D\u0001b\t\u0001\u0003\u0002\u0003\u0006IaH\u0001\u000eG&\u00148-^5u'R\fG/\u001a\u0011\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\r9\u0003&\u000b\t\u0003\u001d\u0001AQ!\u0006\u0013A\u0002]AQ!\b\u0013A\u0002}Aqa\u000b\u0001A\u0002\u0013\u0005A&A\u0005u_J+7o\u001c7wKV\tQ\u0006E\u0002/gUj\u0011a\f\u0006\u0003aE\nq!\\;uC\ndWM\u0003\u00023\u0011\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Qz#a\u0002%bg\"\u001cV\r\u001e\t\u0003mur!aN\u001e\u0011\u0005aBQ\"A\u001d\u000b\u0005i\"\u0011A\u0002\u001fs_>$h(\u0003\u0002=\u0011\u00051\u0001K]3eK\u001aL!AP \u0003\rM#(/\u001b8h\u0015\ta\u0004\u0002C\u0004B\u0001\u0001\u0007I\u0011\u0001\"\u0002\u001bQ|'+Z:pYZ,w\fJ3r)\t\u0019e\t\u0005\u0002\b\t&\u0011Q\t\u0003\u0002\u0005+:LG\u000fC\u0004H\u0001\u0006\u0005\t\u0019A\u0017\u0002\u0007a$\u0013\u0007\u0003\u0004J\u0001\u0001\u0006K!L\u0001\u000bi>\u0014Vm]8mm\u0016\u0004\u0003bB&\u0001\u0001\u0004%\t\u0001T\u0001\fKZ\fG.^1uK\u0006cG.F\u0001N!\t9a*\u0003\u0002P\u0011\t9!i\\8mK\u0006t\u0007bB)\u0001\u0001\u0004%\tAU\u0001\u0010KZ\fG.^1uK\u0006cGn\u0018\u0013fcR\u00111i\u0015\u0005\b\u000fB\u000b\t\u00111\u0001N\u0011\u0019)\u0006\u0001)Q\u0005\u001b\u0006aQM^1mk\u0006$X-\u00117mA!9q\u000b\u0001a\u0001\n\u0003a\u0015aD3yG\u0016\u0004H/[8o\u0007\u0006,x\r\u001b;\t\u000fe\u0003\u0001\u0019!C\u00015\u0006\u0019R\r_2faRLwN\\\"bk\u001eDGo\u0018\u0013fcR\u00111i\u0017\u0005\b\u000fb\u000b\t\u00111\u0001N\u0011\u0019i\u0006\u0001)Q\u0005\u001b\u0006\u0001R\r_2faRLwN\\\"bk\u001eDG\u000f\t\u0005\b?\u0002\u0001\r\u0011\"\u0001M\u0003a)8/\u001a+pa>dwnZ5dC2\u001cvN\u001d;fI.+\u0017p\u001d\u0005\bC\u0002\u0001\r\u0011\"\u0001c\u0003q)8/\u001a+pa>dwnZ5dC2\u001cvN\u001d;fI.+\u0017p]0%KF$\"aQ2\t\u000f\u001d\u0003\u0017\u0011!a\u0001\u001b\"1Q\r\u0001Q!\n5\u000b\u0011$^:f)>\u0004x\u000e\\8hS\u000e\fGnU8si\u0016$7*Z=tA!9q\r\u0001a\u0001\n\u0003a\u0015aF1mY><8i\\7cS:\fG/[8oC2dun\u001c9t\u0011\u001dI\u0007\u00011A\u0005\u0002)\f1$\u00197m_^\u001cu.\u001c2j]\u0006$\u0018n\u001c8bY2{w\u000e]:`I\u0015\fHCA\"l\u0011\u001d9\u0005.!AA\u00025Ca!\u001c\u0001!B\u0013i\u0015\u0001G1mY><8i\\7cS:\fG/[8oC2dun\u001c9tA!9q\u000e\u0001b\u0001\n\u0003\u0001\u0018aD3wC2,\u0018\r^5p]N#\u0018mY6\u0016\u0003E\u0004\"A\u0004:\n\u0005M\u0014!\u0001G#yaJ,7o]5p]\u0016CXmY;uS>t7\u000b^1dW\"1Q\u000f\u0001Q\u0001\nE\f\u0001#\u001a<bYV\fG/[8o'R\f7m\u001b\u0011\t\u000f]\u0004\u0001\u0019!C\u0001q\u0006!B-\u001a4bk2$8*Z=t)>\u0014Vm]8mm\u0016,\u0012!\u001f\t\u0004\u000fi,\u0014BA>\t\u0005\u0015\t%O]1z\u0011\u001di\b\u00011A\u0005\u0002y\f\u0001\u0004Z3gCVdGoS3zgR{'+Z:pYZ,w\fJ3r)\t\u0019u\u0010C\u0004Hy\u0006\u0005\t\u0019A=\t\u000f\u0005\r\u0001\u0001)Q\u0005s\u0006)B-\u001a4bk2$8*Z=t)>\u0014Vm]8mm\u0016\u0004\u0003\u0002CA\u0004\u0001\u0001\u0007I\u0011\u0001'\u0002'-,\u0017p\u0014:eKJLe.\u001b;jC2L'0\u001a3\t\u0013\u0005-\u0001\u00011A\u0005\u0002\u00055\u0011aF6fs>\u0013H-\u001a:J]&$\u0018.\u00197ju\u0016$w\fJ3r)\r\u0019\u0015q\u0002\u0005\t\u000f\u0006%\u0011\u0011!a\u0001\u001b\"9\u00111\u0003\u0001!B\u0013i\u0015\u0001F6fs>\u0013H-\u001a:J]&$\u0018.\u00197ju\u0016$\u0007\u0005C\u0005\u0002\u0018\u0001\u0011\r\u0011\"\u0001\u0002\u001a\u0005!rN\u001d3fe\u0016$7*Z=t)>\u0014Vm]8mm\u0016,\"!a\u0007\u0011\t9\ni\"N\u0005\u0004\u0003?y#aC!se\u0006L()\u001e4gKJD\u0001\"a\t\u0001A\u0003%\u00111D\u0001\u0016_J$WM]3e\u0017\u0016L8\u000fV8SKN|GN^3!\u0011%\t9\u0003\u0001b\u0001\n\u0003\tI#A\u0003uS6,'/\u0006\u0002\u0002,A\u0019a\"!\f\n\u0007\u0005=\"AA\u0003US6,'\u000f\u0003\u0005\u00024\u0001\u0001\u000b\u0011BA\u0016\u0003\u0019!\u0018.\\3sA!9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0012\u0001C4fiZ\u000bG.^3\u0015\t\u0005m\u0012\u0011\t\t\u0004\u001d\u0005u\u0012bAA \u0005\tA1i\u001c8de\u0016$X\rC\u0004\u0002D\u0005U\u0002\u0019A\u001b\u0002\u0007-,\u0017\u0010C\u0004\u0002H\u0001!\t!!\u0013\u0002\t5\f7o\u001b\u000b\u0007\u0003\u0017\nY&a\u0018\u0011\t\u00055\u0013Q\u000b\b\u0005\u0003\u001f\n\u0019FD\u00029\u0003#J\u0011!C\u0005\u0003!!IA!a\u0016\u0002Z\t1!)[4J]RT!\u0001\u0005\u0005\t\u0011\u0005u\u0013Q\ta\u0001\u0003\u0017\naA\\;nE\u0016\u0014\b\u0002CA1\u0003\u000b\u0002\r!a\u0013\u0002\tML'0\u001a\u0005\b\u0003K\u0002A\u0011AA4\u0003)\u0019\b.\u001b4u%&<\u0007\u000e\u001e\u000b\u0007\u0003\u0017\nI'a\u001b\t\u0011\u0005u\u00131\ra\u0001\u0003\u0017B\u0001\"!\u0019\u0002d\u0001\u0007\u00111\n\u0005\b\u0003_\u0002A\u0011AA9\u0003%\u0019\b.\u001b4u\u0019\u00164G\u000f\u0006\u0004\u0002L\u0005M\u0014Q\u000f\u0005\t\u0003;\ni\u00071\u0001\u0002L!A\u0011\u0011MA7\u0001\u0004\tY\u0005C\u0004\u0002z\u0001!\t!a\u001f\u0002\u001b5\f7.Z+J]R4\u0016\r\\;f)\u0019\ti(!$\u0002\u0012B!\u0011qPAE\u001b\t\t\tI\u0003\u0003\u0002\u0004\u0006\u0015\u0015AA5s\u0015\t\t9)\u0001\u0004gSJ\u0014H\u000f\\\u0005\u0005\u0003\u0017\u000b\tIA\u0006V\u0013:$H*\u001b;fe\u0006d\u0007\u0002CAH\u0003o\u0002\r!a\u0013\u0002\u000bY\fG.^3\t\u0011\u0005M\u0015q\u000fa\u0001\u0003+\u000b\u0001\"\u001b8u/&$G\u000f\u001b\t\u0005\u0003\u007f\n9*\u0003\u0003\u0002\u001a\u0006\u0005%\u0001C%oi^KG\r\u001e5\t\u000f\u0005u\u0005\u0001\"\u0001\u0002 \u0006iQ.Y6f'&sGOV1mk\u0016$b!!)\u0002(\u0006%\u0006\u0003BA@\u0003GKA!!*\u0002\u0002\nY1+\u00138u\u0019&$XM]1m\u0011!\ty)a'A\u0002\u0005-\u0003\u0002CAJ\u00037\u0003\r!!&\t\u000f\u00055\u0006\u0001\"\u0001\u00020\u0006Aq-\u001a;XS\u0012$\b\u000e\u0006\u0003\u0002\u0016\u0006E\u0006\u0002CAZ\u0003W\u0003\r!!.\u0002\u0007Q\u0004X\r\u0005\u0003\u0002\u0000\u0005]\u0016\u0002BA]\u0003\u0003\u0013A\u0001V=qK\"9\u0011Q\u0018\u0001\u0005\u0002\u0005}\u0016!D7bi\"\u0004&/[7ji&4X\r\u0006\u0005\u0002<\u0005\u0005\u00171ZAn\u0011!\t\u0019-a/A\u0002\u0005\u0015\u0017AB8q\u0007>$W\r\u0005\u0003\u0002\u0000\u0005\u001d\u0017\u0002BAe\u0003\u0003\u0013a\u0001\u0015:j[>\u0003\b\u0002CAg\u0003w\u0003\r!a4\u0002\t\u0005\u0014xm\u001d\t\u0007\u0003\u001b\n\t.!6\n\t\u0005M\u0017\u0011\f\u0002\u0004'\u0016\f\b\u0003BA@\u0003/LA!!7\u0002\u0002\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u0005M\u00161\u0018a\u0001\u0003kCq!a8\u0001\t\u0003\t\t/A\u0006cSR\u001cV\r\\3di>\u0003HCCA\u001e\u0003G\f)/a:\u0002n\"A\u00111YAo\u0001\u0004\t)\r\u0003\u0005\u0002N\u0006u\u0007\u0019AAh\u0011!\tI/!8A\u0002\u0005-\u0018A\u00039be\u0006lW\r^3sgB1\u0011QJAi\u0003\u0017B\u0001\"a-\u0002^\u0002\u0007\u0011Q\u0017\u0005\b\u0003c\u0004A\u0011AAz\u00031\u0019w.\u001c9be&\u001cxN\\(q)!\tY$!>\u0002x\u0006e\b\u0002CAb\u0003_\u0004\r!!2\t\u0011\u00055\u0017q\u001ea\u0001\u0003\u001fD\u0001\"a-\u0002p\u0002\u0007\u0011Q\u0017\u0005\b\u0003{\u0004A\u0011AA\u0000\u0003%\u0001\u0018\r\u001a3j]\u001e|\u0005\u000f\u0006\u0006\u0002<\t\u0005!1\u0001B\u0003\u0005\u000fA\u0001\"a1\u0002|\u0002\u0007\u0011Q\u0019\u0005\t\u0003\u001b\fY\u00101\u0001\u0002P\"A\u0011\u0011^A~\u0001\u0004\tY\u000f\u0003\u0005\u00024\u0006m\b\u0019AA[\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0005\u001b\t\u0011bY1ti&twm\u00149\u0015\u0011\u0005m\"q\u0002B\t\u0005'A\u0001\"a1\u0003\n\u0001\u0007\u0011Q\u0019\u0005\t\u0003\u001b\u0014I\u00011\u0001\u0002P\"A\u00111\u0017B\u0005\u0001\u0004\t)\fC\u0004\u0003\u0018\u0001!\tA!\u0007\u0002\r\tLGo\u00149t))\tYDa\u0007\u0003\u001e\t}!\u0011\u0005\u0005\t\u0003\u0007\u0014)\u00021\u0001\u0002F\"A\u0011Q\u001aB\u000b\u0001\u0004\ty\r\u0003\u0005\u0002j\nU\u0001\u0019AAv\u0011!\t\u0019L!\u0006A\u0002\u0005U\u0006b\u0002B\u0013\u0001\u0011\u0005!qE\u0001\u000eIft\u0017-\\5d\u0005&$x\n]:\u0015\u0015\u0005m\"\u0011\u0006B\u0016\u0005[\u0011y\u0003\u0003\u0005\u0002D\n\r\u0002\u0019AAc\u0011!\tiMa\tA\u0002\u0005=\u0007\u0002CAu\u0005G\u0001\r!a;\t\u0011\u0005M&1\u0005a\u0001\u0003kCqAa\r\u0001\t\u0003\u0011)$A\u0005p]\u0016\f%oZ(qgRQ\u00111\bB\u001c\u0005s\u0011YD!\u0010\t\u0011\u0005\r'\u0011\u0007a\u0001\u0003\u000bD\u0001\"!4\u00032\u0001\u0007\u0011q\u001a\u0005\t\u0003S\u0014\t\u00041\u0001\u0002l\"A\u00111\u0017B\u0019\u0001\u0004\t)\fC\u0004\u0003B\u0001!\tAa\u0011\u0002\u001b\tLg.\u0019:z\u0005&$x+[:f)!\tYD!\u0012\u0003H\t%\u0003\u0002CAb\u0005\u007f\u0001\r!!2\t\u0011\u00055'q\ba\u0001\u0003\u001fD\u0001\"a-\u0003@\u0001\u0007\u0011Q\u0017\u0005\b\u0005\u001b\u0002A\u0011\u0001B(\u0003!)g/\u00197vCR,GCBA\u001e\u0005#\u0012)\u0006\u0003\u0005\u0003T\t-\u0003\u0019AAk\u0003))\u0007\u0010\u001d:fgNLwN\u001c\u0005\u000b\u0005/\u0012Y\u0005%AA\u0002\te\u0013A\u00057fMRD\u0015M\u001c3TS\u0012,w\n\u001d;j_:\u0004Ba\u0002B.k%\u0019!Q\f\u0005\u0003\r=\u0003H/[8o\u0011\u001d\u0011\t\u0007\u0001C\u0001\u0005G\n\u0011b\u001d5poN#\u0018mY6\u0015\u0003\rCqAa\u001a\u0001\t\u0003\u0011I'A\bsKN|GN^3SK\u001eL7\u000f^3s)\u0011\tYDa\u001b\t\u000f\u0005\r#Q\ra\u0001k!9!q\u000e\u0001\u0005\n\tE\u0014!\u0005:fg>dg/\u001a#fa\u0016tG-\u001a8dsR!\u00111\bB:\u0011\u001d\t\u0019E!\u001cA\u0002UBqAa\u001e\u0001\t\u0003\u0011I(A\nsKN|GN^3EKB,g\u000eZ3oG&,7\u000fF\u0002D\u0005wB\u0001B! \u0003v\u0001\u0007!qP\u0001\u0015gB,7-\u001b4jG\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:\u0011\u000b\u00055#\u0011Q\u001b\n\t\t\r\u0015\u0011\f\u0002\t\u0013R,'/\u00192mK\"9!q\u0011\u0001\u0005\u0002\t%\u0015AC2iK\u000e\\7\u000b^8qgR\u0011!1\u0012\t\u0006\u000f\tm#Q\u0012\t\u0004\u000f\t=\u0015b\u0001BI\u0011\t\u0019\u0011J\u001c;\t\u000f\tU\u0005\u0001\"\u0001\u0003\u0018\u0006)R\r_3dkR,gi\u001c:nCR$X\r\u001a)sS:$H#B\u001b\u0003\u001a\nu\u0005b\u0002BN\u0005'\u0003\r!N\u0001\rM>\u0014X.\u0019;TiJLgn\u001a\u0005\t\u0005?\u0013\u0019\n1\u0001\u0003\"\u00069\u0011\r\u001c7Be\u001e\u001c\bCBA'\u0003#\u0014\u0019\u000bE\u0002\b\u0005KK1Aa*\t\u0005\r\te.\u001f\u0005\b\u0005W\u0003A\u0011\u0001B2\u0003-\u0019\u0007.Z2l!JLg\u000e^:\t\u0013\t=\u0006\u00011A\u0005\n\tE\u0016\u0001\u0004:fg>dg/\u001a#faRDWC\u0001BG\u0011%\u0011)\f\u0001a\u0001\n\u0013\u00119,\u0001\tsKN|GN^3EKB$\bn\u0018\u0013fcR\u00191I!/\t\u0013\u001d\u0013\u0019,!AA\u0002\t5\u0005\u0002\u0003B_\u0001\u0001\u0006KA!$\u0002\u001bI,7o\u001c7wK\u0012+\u0007\u000f\u001e5!\u0011\u001d\u0011\t\r\u0001C\u0005\u0005G\na!\u001b8eK:$\bb\u0002Bc\u0001\u0011%!1M\u0001\u0007I\u0016$WM\u001c;\t\u000f\t%\u0007\u0001\"\u0011\u0003L\u0006\u0019An\\4\u0015\u0007\r\u0013i\rC\u0005\u0003P\n\u001dG\u00111\u0001\u0003R\u00069Q.Z:tC\u001e,\u0007\u0003B\u0004\u0003TVJ1A!6\t\u0005!a$-\u001f8b[\u0016t\u0004\"\u0003Bm\u0001E\u0005I\u0011\u0001Bn\u0003I)g/\u00197vCR,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tu'\u0006\u0002B-\u0005?\\#A!9\u0011\t\t\r(Q^\u0007\u0003\u0005KTAAa:\u0003j\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005WD\u0011AC1o]>$\u0018\r^5p]&!!q\u001eBs\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class LoFirrtlExpressionEvaluator
implements package.SimpleLogger {
    private final DependencyGraph dependencyGraph;
    private final CircuitState circuitState;
    private HashSet<String> toResolve;
    private boolean evaluateAll;
    private boolean exceptionCaught;
    private boolean useTopologicalSortedKeys;
    private boolean allowCombinationalLoops;
    private final ExpressionExecutionStack evaluationStack;
    private String[] defaultKeysToResolve;
    private boolean keyOrderInitialized;
    private final ArrayBuffer<String> orderedKeysToResolve;
    private final Timer timer;
    private int resolveDepth;
    private boolean verbose;

    @Override
    public void setVerbose(boolean value) {
        package.SimpleLogger.setVerbose$(this, value);
    }

    @Override
    public boolean setVerbose$default$1() {
        return package.SimpleLogger.setVerbose$default$1$(this);
    }

    @Override
    public boolean verbose() {
        return this.verbose;
    }

    @Override
    public void verbose_$eq(boolean x$1) {
        this.verbose = x$1;
    }

    public DependencyGraph dependencyGraph() {
        return this.dependencyGraph;
    }

    public CircuitState circuitState() {
        return this.circuitState;
    }

    public HashSet<String> toResolve() {
        return this.toResolve;
    }

    public void toResolve_$eq(HashSet<String> x$1) {
        this.toResolve = x$1;
    }

    public boolean evaluateAll() {
        return this.evaluateAll;
    }

    public void evaluateAll_$eq(boolean x$1) {
        this.evaluateAll = x$1;
    }

    public boolean exceptionCaught() {
        return this.exceptionCaught;
    }

    public void exceptionCaught_$eq(boolean x$1) {
        this.exceptionCaught = x$1;
    }

    public boolean useTopologicalSortedKeys() {
        return this.useTopologicalSortedKeys;
    }

    public void useTopologicalSortedKeys_$eq(boolean x$1) {
        this.useTopologicalSortedKeys = x$1;
    }

    public boolean allowCombinationalLoops() {
        return this.allowCombinationalLoops;
    }

    public void allowCombinationalLoops_$eq(boolean x$1) {
        this.allowCombinationalLoops = x$1;
    }

    public ExpressionExecutionStack evaluationStack() {
        return this.evaluationStack;
    }

    public String[] defaultKeysToResolve() {
        return this.defaultKeysToResolve;
    }

    public void defaultKeysToResolve_$eq(String[] x$1) {
        this.defaultKeysToResolve = x$1;
    }

    public boolean keyOrderInitialized() {
        return this.keyOrderInitialized;
    }

    public void keyOrderInitialized_$eq(boolean x$1) {
        this.keyOrderInitialized = x$1;
    }

    public ArrayBuffer<String> orderedKeysToResolve() {
        return this.orderedKeysToResolve;
    }

    public Timer timer() {
        return this.timer;
    }

    public Concrete getValue(String key) {
        Concrete concrete;
        BoxedUnit boxedUnit;
        if (this.dependencyGraph().memoryOutputKeys().contains((Object)key)) {
            Seq dependentKeys = (Seq)this.dependencyGraph().memoryOutputKeys().apply((Object)key);
            dependentKeys.foreach((Function1 & Serializable & scala.Serializable)elem -> this.resolveDependency((String)elem));
        }
        if (this.circuitState().isOutput(key)) {
            if (!this.circuitState().rhsOutputs().contains((Object)key) && this.dependencyGraph().nameToExpression().contains((Object)key)) {
                this.resolveDependency(key);
                boxedUnit = this.circuitState().rhsOutputs().$plus$eq((Object)key);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option<Concrete> option = this.circuitState().getValue(key);
        if (option instanceof Some) {
            Concrete value;
            Some some = (Some)option;
            concrete = value = (Concrete)some.value();
        } else {
            concrete = this.resolveDependency(key);
        }
        return concrete;
    }

    public BigInt mask(BigInt number, BigInt size) {
        if (size.$less((Object)BigInt$.MODULE$.int2bigInt(1))) {
            return package$.MODULE$.Big0();
        }
        int convenientShiftSize = 30;
        BigInt modulo = BigInt$.MODULE$.int2bigInt(1);
        BigInt toShift = size.$minus(BigInt$.MODULE$.int2bigInt(1)).max(BigInt$.MODULE$.int2bigInt(0)).$plus(BigInt$.MODULE$.int2bigInt(1));
        while (toShift.$greater((Object)BigInt$.MODULE$.int2bigInt(0))) {
            modulo = modulo.$less$less(toShift.min(BigInt$.MODULE$.int2bigInt(convenientShiftSize)).toInt());
            toShift = toShift.$minus(BigInt$.MODULE$.int2bigInt(convenientShiftSize));
        }
        return number.$percent(modulo);
    }

    public BigInt shiftRight(BigInt number, BigInt size) {
        int convenientShiftSize = 30;
        BigInt toShift = size.max(BigInt$.MODULE$.int2bigInt(0));
        BigInt shiftedNumber = number;
        while (toShift.$greater((Object)BigInt$.MODULE$.int2bigInt(0))) {
            shiftedNumber = shiftedNumber.$greater$greater(toShift.min(BigInt$.MODULE$.int2bigInt(convenientShiftSize)).toInt());
            toShift = toShift.$minus(BigInt$.MODULE$.int2bigInt(convenientShiftSize));
        }
        return shiftedNumber;
    }

    public BigInt shiftLeft(BigInt number, BigInt size) {
        int convenientShiftSize = 30;
        BigInt toShift = size.max(BigInt$.MODULE$.int2bigInt(0));
        BigInt shiftedNumber = number;
        while (toShift.$greater((Object)BigInt$.MODULE$.int2bigInt(0))) {
            shiftedNumber = shiftedNumber.$less$less(toShift.min(BigInt$.MODULE$.int2bigInt(convenientShiftSize)).toInt());
            toShift = toShift.$minus(BigInt$.MODULE$.int2bigInt(convenientShiftSize));
        }
        return shiftedNumber;
    }

    public UIntLiteral makeUIntValue(BigInt value, IntWidth intWidth) {
        BigInt maskedValue = this.mask(value, intWidth.width());
        return new UIntLiteral(maskedValue, (Width)intWidth);
    }

    public SIntLiteral makeSIntValue(BigInt value, IntWidth intWidth) {
        BigInt maskedValue = this.mask(value, intWidth.width());
        return new SIntLiteral(maskedValue, (Width)intWidth);
    }

    /*
     * WARNING - void declaration
     */
    public IntWidth getWidth(Type tpe) {
        void var3_10;
        SIntType sIntType;
        Width width;
        IntWidth intWidth;
        UIntType uIntType;
        Width width2;
        Type type = tpe;
        if (type instanceof UIntType && (width2 = (uIntType = (UIntType)type).width()) instanceof IntWidth) {
            IntWidth intWidth2;
            intWidth = intWidth2 = (IntWidth)width2;
        } else if (type instanceof SIntType && (width = (sIntType = (SIntType)type).width()) instanceof IntWidth) {
            IntWidth intWidth3;
            intWidth = intWidth3 = (IntWidth)width;
        } else {
            throw new MatchError((Object)type);
        }
        IntWidth intWidth4 = intWidth;
        return var3_10;
    }

    public Concrete mathPrimitive(PrimOp opCode, Seq<Expression> args, Type tpe) {
        Concrete concrete;
        Concrete arg1 = this.evaluate((Expression)args.head(), this.evaluate$default$2());
        Concrete arg2 = this.evaluate((Expression)((IterableLike)args.tail()).head(), this.evaluate$default$2());
        PrimOp primOp = opCode;
        if (PrimOps.Add$.MODULE$.equals(primOp)) {
            concrete = arg1.$plus(arg2);
        } else if (PrimOps.Sub$.MODULE$.equals(primOp)) {
            concrete = arg1.$minus(arg2);
        } else if (PrimOps.Mul$.MODULE$.equals(primOp)) {
            concrete = arg1.$times(arg2);
        } else if (PrimOps.Div$.MODULE$.equals(primOp)) {
            concrete = arg1.$div(arg2);
        } else if (PrimOps.Rem$.MODULE$.equals(primOp)) {
            concrete = arg1.$percent(arg2);
        } else {
            throw new MatchError((Object)primOp);
        }
        return concrete;
    }

    public Concrete bitSelectOp(PrimOp opCode, Seq<Expression> args, Seq<BigInt> parameters, Type tpe) {
        Concrete e = this.evaluate((Expression)args.head(), this.evaluate$default$2());
        BigInt hi = (BigInt)parameters.head();
        BigInt lo = (BigInt)((IterableLike)parameters.tail()).head();
        return e.bits(hi, lo);
    }

    public Concrete comparisonOp(PrimOp opCode, Seq<Expression> args, Type tpe) {
        ConcreteUInt concreteUInt;
        Concrete arg1 = this.evaluate((Expression)args.head(), this.evaluate$default$2());
        Concrete arg2 = this.evaluate((Expression)((IterableLike)args.tail()).head(), this.evaluate$default$2());
        PrimOp primOp = opCode;
        if (PrimOps.Eq$.MODULE$.equals(primOp)) {
            concreteUInt = arg1.$eq$eq(arg2);
        } else if (PrimOps.Neq$.MODULE$.equals(primOp)) {
            concreteUInt = arg1.$bang$eq(arg2);
        } else if (PrimOps.Lt$.MODULE$.equals(primOp)) {
            concreteUInt = arg1.$less(arg2);
        } else if (PrimOps.Leq$.MODULE$.equals(primOp)) {
            concreteUInt = arg1.$less$eq(arg2);
        } else if (PrimOps.Gt$.MODULE$.equals(primOp)) {
            concreteUInt = arg1.$greater(arg2);
        } else if (PrimOps.Geq$.MODULE$.equals(primOp)) {
            concreteUInt = arg1.$greater$eq(arg2);
        } else {
            throw new MatchError((Object)primOp);
        }
        return concreteUInt;
    }

    public Concrete paddingOp(PrimOp opCode, Seq<Expression> args, Seq<BigInt> parameters, Type tpe) {
        Concrete e = this.evaluate((Expression)args.head(), this.evaluate$default$2());
        BigInt n = (BigInt)parameters.head();
        return e.pad(n);
    }

    public Concrete castingOp(PrimOp opCode, Seq<Expression> args, Type tpe) {
        Product product;
        Concrete e = this.evaluate((Expression)args.head(), this.evaluate$default$2());
        PrimOp primOp = opCode;
        if (PrimOps.AsUInt$.MODULE$.equals(primOp)) {
            product = e.asUInt();
        } else if (PrimOps.AsSInt$.MODULE$.equals(primOp)) {
            product = e.asSInt();
        } else if (PrimOps.AsClock$.MODULE$.equals(primOp)) {
            product = e.asClock();
        } else {
            throw new MatchError((Object)primOp);
        }
        return product;
    }

    public Concrete bitOps(PrimOp opCode, Seq<Expression> args, Seq<BigInt> parameters, Type tpe) {
        Concrete concrete;
        Concrete e = this.evaluate((Expression)args.head(), this.evaluate$default$2());
        BigInt n = (BigInt)parameters.head();
        PrimOp primOp = opCode;
        if (PrimOps.Shl$.MODULE$.equals(primOp)) {
            concrete = e.$less$less(n);
        } else if (PrimOps.Shr$.MODULE$.equals(primOp)) {
            concrete = e.$greater$greater(n);
        } else if (PrimOps.Head$.MODULE$.equals(primOp)) {
            concrete = e.head(n);
        } else if (PrimOps.Tail$.MODULE$.equals(primOp)) {
            concrete = e.tail(n);
        } else {
            throw new MatchError((Object)primOp);
        }
        return concrete;
    }

    public Concrete dynamicBitOps(PrimOp opCode, Seq<Expression> args, Seq<BigInt> parameters, Type tpe) {
        Concrete concrete;
        Concrete e = this.evaluate((Expression)args.head(), this.evaluate$default$2());
        Concrete n = this.evaluate((Expression)((IterableLike)args.tail()).head(), this.evaluate$default$2());
        PrimOp primOp = opCode;
        if (PrimOps.Dshl$.MODULE$.equals(primOp)) {
            concrete = e.$less$less(n);
        } else if (PrimOps.Dshr$.MODULE$.equals(primOp)) {
            concrete = e.$greater$greater(n);
        } else {
            throw new MatchError((Object)primOp);
        }
        return concrete;
    }

    public Concrete oneArgOps(PrimOp opCode, Seq<Expression> args, Seq<BigInt> parameters, Type tpe) {
        Concrete concrete;
        Concrete e = this.evaluate((Expression)args.head(), this.evaluate$default$2());
        PrimOp primOp = opCode;
        if (PrimOps.Cvt$.MODULE$.equals(primOp)) {
            concrete = e.cvt();
        } else if (PrimOps.Neg$.MODULE$.equals(primOp)) {
            concrete = e.neg();
        } else if (PrimOps.Not$.MODULE$.equals(primOp)) {
            concrete = e.not();
        } else if (PrimOps.Andr$.MODULE$.equals(primOp)) {
            concrete = e.andReduce();
        } else if (PrimOps.Orr$.MODULE$.equals(primOp)) {
            concrete = e.orReduce();
        } else if (PrimOps.Xorr$.MODULE$.equals(primOp)) {
            concrete = e.xorReduce();
        } else {
            throw new MatchError((Object)primOp);
        }
        return concrete;
    }

    public Concrete binaryBitWise(PrimOp opCode, Seq<Expression> args, Type tpe) {
        ConcreteUInt concreteUInt;
        Concrete arg1 = this.evaluate((Expression)args.head(), this.evaluate$default$2());
        Concrete arg2 = this.evaluate((Expression)((IterableLike)args.tail()).head(), this.evaluate$default$2());
        PrimOp primOp = opCode;
        if (PrimOps.And$.MODULE$.equals(primOp)) {
            concreteUInt = arg1.$amp(arg2);
        } else if (PrimOps.Or$.MODULE$.equals(primOp)) {
            concreteUInt = arg1.$bar(arg2);
        } else if (PrimOps.Xor$.MODULE$.equals(primOp)) {
            concreteUInt = arg1.$up(arg2);
        } else if (PrimOps.Cat$.MODULE$.equals(primOp)) {
            concreteUInt = arg1.cat(arg2);
        } else {
            throw new MatchError((Object)primOp);
        }
        return concreteUInt;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Concrete evaluate(Expression expression, Option<String> leftHandSideOption) {
        Concrete concrete;
        this.log((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            String string;
            Option option = leftHandSideOption;
            if (option instanceof Some) {
                Some some = (Some)option;
                String key = (String)some.value();
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"evaluate     ", " <= ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftHandSideOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), expression.serialize(), this.dependencyGraph().getInfo(key)}));
            } else {
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"evaluate     ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expression.serialize()}));
            }
            return string;
        });
        this.indent();
        if (!this.evaluationStack().push(leftHandSideOption, expression) && this.allowCombinationalLoops()) {
            this.log((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Combinational loop detected, second evaluation of ", ", returning 1.U"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftHandSideOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")})));
            return new ConcreteUInt(BigInt$.MODULE$.int2bigInt(1), 1, ConcreteUInt$.MODULE$.apply$default$3());
        }
        try {
            Concrete concrete2;
            Expression expression2 = expression;
            if (expression2 instanceof Mux) {
                Concrete concrete3;
                Mux mux = (Mux)expression2;
                Expression condition = mux.cond();
                Expression trueExpression = mux.tval();
                Expression falseExpression = mux.fval();
                Type tpe = mux.tpe();
                Concrete concrete4 = this.evaluate(condition, this.evaluate$default$2());
                if (!(concrete4 instanceof ConcreteUInt)) throw InterpreterException$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mux(", ") must be (0|1).U<1> was ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{condition, concrete4, this.sourceInfo$1(leftHandSideOption)})));
                ConcreteUInt concreteUInt = (ConcreteUInt)concrete4;
                BigInt value = concreteUInt.value();
                int n = concreteUInt.width();
                if (1 != n) throw InterpreterException$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mux(", ") must be (0|1).U<1> was ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{condition, concrete4, this.sourceInfo$1(leftHandSideOption)})));
                if (value.$greater((Object)BigInt$.MODULE$.int2bigInt(0))) {
                    Object object = this.evaluateAll() ? this.evaluate(falseExpression, this.evaluate$default$2()) : BoxedUnit.UNIT;
                    concrete3 = this.evaluate(trueExpression, this.evaluate$default$2());
                } else {
                    Object object = this.evaluateAll() ? this.evaluate(trueExpression, this.evaluate$default$2()) : BoxedUnit.UNIT;
                    concrete3 = this.evaluate(falseExpression, this.evaluate$default$2());
                }
                Concrete v = concrete3;
                Concrete concrete5 = v.forceWidth(tpe);
                concrete2 = concrete5;
            } else if (expression2 instanceof WRef) {
                WRef wRef = (WRef)expression2;
                String name = wRef.name();
                Type tpe = wRef.tpe();
                concrete2 = this.getValue(name).forceWidth(tpe);
            } else if (expression2 instanceof WSubField) {
                WSubField wSubField = (WSubField)expression2;
                String name = wSubField.serialize();
                concrete2 = this.getValue(name).forceWidth(wSubField.tpe());
            } else if (expression2 instanceof WSubIndex) {
                WSubIndex wSubIndex = (WSubIndex)expression2;
                String name = wSubIndex.serialize();
                concrete2 = this.getValue(name).forceWidth(wSubIndex.tpe());
            } else if (expression2 instanceof ValidIf) {
                Concrete concrete6;
                ValidIf validIf = (ValidIf)expression2;
                Expression condition = validIf.cond();
                Expression value = validIf.value();
                Type tpe = validIf.tpe();
                if (this.evaluate(condition, this.evaluate$default$2()).value().$greater((Object)BigInt$.MODULE$.int2bigInt(0))) {
                    concrete6 = this.evaluate(value, this.evaluate$default$2()).forceWidth(tpe);
                } else {
                    void var5_36;
                    IntWidth intWidth;
                    Option option;
                    SIntType sIntType;
                    Width width;
                    IntWidth intWidth2;
                    Option option2;
                    UIntType uIntType;
                    Width width2;
                    Object object = this.evaluateAll() ? this.evaluate(value, this.evaluate$default$2()) : BoxedUnit.UNIT;
                    Type type = tpe;
                    if (type instanceof UIntType && (width2 = (uIntType = (UIntType)type).width()) instanceof IntWidth && !(option2 = IntWidth$.MODULE$.unapply(intWidth2 = (IntWidth)width2)).isEmpty()) {
                        BigInt w = (BigInt)option2.get();
                        ConcreteUInt concreteUInt = Concrete$.MODULE$.randomUInt(w.toInt(), Concrete$.MODULE$.randomUInt$default$2());
                    } else if (type instanceof SIntType && (width = (sIntType = (SIntType)type).width()) instanceof IntWidth && !(option = IntWidth$.MODULE$.unapply(intWidth = (IntWidth)width)).isEmpty()) {
                        BigInt w = (BigInt)option.get();
                        ConcreteSInt concreteSInt = Concrete$.MODULE$.randomSInt(w.toInt(), Concrete$.MODULE$.randomSInt$default$2());
                    } else {
                        if (!ClockType$.MODULE$.equals(type)) throw new MatchError((Object)type);
                        ConcreteClock concreteClock = Concrete$.MODULE$.randomClock();
                    }
                    concrete6 = (Concrete)var5_36;
                }
                concrete2 = concrete6;
            } else if (expression2 instanceof DoPrim) {
                Concrete concrete7;
                DoPrim doPrim = (DoPrim)expression2;
                PrimOp op = doPrim.op();
                Seq args = doPrim.args();
                Seq seq = doPrim.consts();
                Type tpe = doPrim.tpe();
                PrimOp primOp = op;
                if (PrimOps.Add$.MODULE$.equals(primOp)) {
                    concrete7 = this.mathPrimitive(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Sub$.MODULE$.equals(primOp)) {
                    concrete7 = this.mathPrimitive(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Mul$.MODULE$.equals(primOp)) {
                    concrete7 = this.mathPrimitive(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Div$.MODULE$.equals(primOp)) {
                    concrete7 = this.mathPrimitive(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Rem$.MODULE$.equals(primOp)) {
                    concrete7 = this.mathPrimitive(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Eq$.MODULE$.equals(primOp)) {
                    concrete7 = this.comparisonOp(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Neq$.MODULE$.equals(primOp)) {
                    concrete7 = this.comparisonOp(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Lt$.MODULE$.equals(primOp)) {
                    concrete7 = this.comparisonOp(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Leq$.MODULE$.equals(primOp)) {
                    concrete7 = this.comparisonOp(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Gt$.MODULE$.equals(primOp)) {
                    concrete7 = this.comparisonOp(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Geq$.MODULE$.equals(primOp)) {
                    concrete7 = this.comparisonOp(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Pad$.MODULE$.equals(primOp)) {
                    concrete7 = this.paddingOp(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.AsUInt$.MODULE$.equals(primOp)) {
                    concrete7 = this.castingOp(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.AsSInt$.MODULE$.equals(primOp)) {
                    concrete7 = this.castingOp(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.AsClock$.MODULE$.equals(primOp)) {
                    concrete7 = this.castingOp(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Shl$.MODULE$.equals(primOp)) {
                    concrete7 = this.bitOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.Shr$.MODULE$.equals(primOp)) {
                    concrete7 = this.bitOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.Dshl$.MODULE$.equals(primOp)) {
                    concrete7 = this.dynamicBitOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.Dshr$.MODULE$.equals(primOp)) {
                    concrete7 = this.dynamicBitOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.Cvt$.MODULE$.equals(primOp)) {
                    concrete7 = this.oneArgOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.Neg$.MODULE$.equals(primOp)) {
                    concrete7 = this.oneArgOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.Not$.MODULE$.equals(primOp)) {
                    concrete7 = this.oneArgOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.And$.MODULE$.equals(primOp)) {
                    concrete7 = this.binaryBitWise(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Or$.MODULE$.equals(primOp)) {
                    concrete7 = this.binaryBitWise(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Xor$.MODULE$.equals(primOp)) {
                    concrete7 = this.binaryBitWise(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Andr$.MODULE$.equals(primOp)) {
                    concrete7 = this.oneArgOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.Orr$.MODULE$.equals(primOp)) {
                    concrete7 = this.oneArgOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.Xorr$.MODULE$.equals(primOp)) {
                    concrete7 = this.oneArgOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.Cat$.MODULE$.equals(primOp)) {
                    concrete7 = this.binaryBitWise(op, (Seq<Expression>)args, tpe);
                } else if (PrimOps.Bits$.MODULE$.equals(primOp)) {
                    concrete7 = this.bitSelectOp(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else if (PrimOps.Head$.MODULE$.equals(primOp)) {
                    concrete7 = this.bitOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                } else {
                    if (!PrimOps.Tail$.MODULE$.equals(primOp)) throw new InterruptedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PrimOP ", " in ", " not yet supported ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{op, expression, this.sourceInfo$1(leftHandSideOption)})));
                    concrete7 = this.bitOps(op, (Seq<Expression>)args, (Seq<BigInt>)seq, tpe);
                }
                Concrete v = concrete7;
                concrete2 = v.forceWidth(tpe);
            } else if (expression2 instanceof UIntLiteral) {
                UIntLiteral uIntLiteral = (UIntLiteral)expression2;
                concrete2 = Concrete$.MODULE$.apply(uIntLiteral).forceWidth((Type)uIntLiteral.tpe());
            } else if (expression2 instanceof SIntLiteral) {
                SIntLiteral sIntLiteral = (SIntLiteral)expression2;
                concrete2 = Concrete$.MODULE$.apply(sIntLiteral).forceWidth((Type)sIntLiteral.tpe());
            } else {
                if (!(expression2 instanceof BlackBoxOutput)) throw new MatchError((Object)expression2);
                BlackBoxOutput blackBoxOutput = (BlackBoxOutput)expression2;
                this.log((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"got a black box, ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{blackBoxOutput})));
                Seq concreteInputs = (Seq)blackBoxOutput.dependentInputs().map((Function1 & Serializable & scala.Serializable)input -> this.getValue((String)input), Seq$.MODULE$.canBuildFrom());
                concrete2 = blackBoxOutput.execute((Seq<Concrete>)concreteInputs);
            }
            concrete = concrete2;
        }
        catch (Exception ie) {
            if (this.exceptionCaught()) throw ie;
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception during evaluation: ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ie.getMessage(), this.sourceInfo$1(leftHandSideOption)})));
            this.showStack();
            this.exceptionCaught_$eq(true);
            throw ie;
        }
        catch (AssertionError ie) {
            if (this.exceptionCaught()) throw ie;
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Assertion during evaluation: ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Throwable)((Object)ie)).getMessage(), this.sourceInfo$1(leftHandSideOption)})));
            this.showStack();
            this.exceptionCaught_$eq(true);
            throw ie;
        }
        Concrete result = concrete;
        this.evaluationStack().pop();
        this.dedent();
        this.log((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            Option option = leftHandSideOption;
            String string = option instanceof Some ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"evaluated    ", " <= ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftHandSideOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), result})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"evaluated     ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{result}));
            return string;
        });
        return result;
    }

    public Option<String> evaluate$default$2() {
        return None$.MODULE$;
    }

    public void showStack() {
        Predef$.MODULE$.println((Object)"Expression Evaluation stack");
        Predef$.MODULE$.println((Object)this.evaluationStack().stackListing());
    }

    public Concrete resolveRegister(String key) {
        Concrete concrete;
        DefRegister registerDef = (DefRegister)this.dependencyGraph().registers().apply((Object)key);
        Concrete resetCondition = this.evaluate(registerDef.reset(), this.evaluate$default$2());
        if (resetCondition.value().$greater((Object)BigInt$.MODULE$.int2bigInt(0))) {
            Concrete resetValue;
            concrete = resetValue = this.evaluate(registerDef.init(), this.evaluate$default$2()).forceWidth(package$.MODULE$.typeToWidth((Type)this.dependencyGraph().nameToType().apply((Object)registerDef.name())));
        } else {
            Expression expression = (Expression)this.dependencyGraph().nameToExpression().apply((Object)key);
            concrete = this.evaluate(expression, (Option<String>)new Some((Object)key));
        }
        Concrete newValue = concrete;
        return newValue;
    }

    /*
     * WARNING - void declaration
     */
    private Concrete resolveDependency(String key) {
        void var2_2;
        this.resolveDepth_$eq(this.resolveDepth() + 1);
        Concrete value = (Concrete)this.timer().apply(key, (Function0 & Serializable & scala.Serializable)() -> {
            Concrete concrete;
            if (this.circuitState().isInput(key)) {
                concrete = (Concrete)this.circuitState().getValue(key).get();
            } else if (this.circuitState().isRegister(key)) {
                concrete = this.resolveRegister(key);
            } else if (this.dependencyGraph().nameToExpression().contains((Object)key)) {
                Expression expression = (Expression)this.dependencyGraph().nameToExpression().apply((Object)key);
                concrete = this.evaluate(expression, (Option<String>)new Some((Object)key));
            } else if (this.dependencyGraph().memoryKeys().contains((Object)key)) {
                concrete = ((Memory)this.dependencyGraph().memoryKeys().apply((Object)key)).getValue(key);
            } else {
                throw new InterpreterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"error: don't know what to do with key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
            }
            return concrete;
        });
        Object object = this.useTopologicalSortedKeys() && !this.keyOrderInitialized() ? this.orderedKeysToResolve().$plus$eq((Object)key) : BoxedUnit.UNIT;
        this.circuitState().setValue(key, value, this.circuitState().setValue$default$3());
        this.resolveDepth_$eq(this.resolveDepth() - 1);
        return var2_2;
    }

    public void resolveDependencies(Iterable<String> specificDependencies) {
        block1: {
            WrappedArray toResolve = specificDependencies.nonEmpty() ? specificDependencies : (this.useTopologicalSortedKeys() && this.keyOrderInitialized() ? this.orderedKeysToResolve() : Predef$.MODULE$.wrapRefArray((Object[])this.defaultKeysToResolve()));
            this.exceptionCaught_$eq(false);
            this.evaluationStack().clear();
            toResolve.foreach((Function1 & Serializable & scala.Serializable)key -> this.resolveDependency((String)key));
            if (!this.useTopologicalSortedKeys() || this.keyOrderInitialized()) break block1;
            if (this.verbose()) {
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Key order ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.orderedKeysToResolve().mkString("\n")})));
            }
            this.keyOrderInitialized_$eq(true);
        }
    }

    public Option<Object> checkStops() {
        None$ none$;
        Object object = new Object();
        try {
            this.dependencyGraph().stops().foreach((Function1 & Serializable & scala.Serializable)stopStatement -> {
                LoFirrtlExpressionEvaluator.$anonfun$checkStops$1(this, object, stopStatement);
                return BoxedUnit.UNIT;
            });
            none$ = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                none$ = (Option)ex.value();
            }
            throw ex;
        }
        return none$;
    }

    public String executeFormattedPrint(String formatString, Seq<Object> allArgs) {
        StringBuilder outBuffer = new StringBuilder();
        String s = formatString;
        Seq args = allArgs;
        block3: while (new StringOps(Predef$.MODULE$.augmentString(s)).nonEmpty()) {
            char c;
            char c2;
            BoxedUnit boxedUnit;
            int n = s.indexOf("%");
            switch (n) {
                case -1: {
                    outBuffer.$plus$plus$eq(s);
                    s = "";
                    continue block3;
                }
            }
            outBuffer.$plus$plus$eq((String)new StringOps(Predef$.MODULE$.augmentString(s)).take(n));
            s = (String)new StringOps(Predef$.MODULE$.augmentString(s)).drop(n + 1);
            boolean bl = false;
            Some some = null;
            Option option = new StringOps(Predef$.MODULE$.augmentString(s)).headOption();
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                char c3 = BoxesRunTime.unboxToChar((Object)some.value());
                if ('%' == c3) {
                    outBuffer.$plus$plus$eq("%");
                    s = (String)new StringOps(Predef$.MODULE$.augmentString(s)).tail();
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (bl && 'b' == (c2 = BoxesRunTime.unboxToChar((Object)some.value()))) {
                outBuffer.$plus$plus$eq(scala.package$.MODULE$.BigInt().apply(args.head().toString()).toString(2));
                args = (Seq)args.tail();
                s = (String)new StringOps(Predef$.MODULE$.augmentString(s)).tail();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (bl && 'c' == (c = BoxesRunTime.unboxToChar((Object)some.value()))) {
                outBuffer.$plus$eq(scala.package$.MODULE$.BigInt().apply(args.head().toString()).toChar());
                args = (Seq)args.tail();
                s = (String)new StringOps(Predef$.MODULE$.augmentString(s)).tail();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (bl) {
                char specifier = BoxesRunTime.unboxToChar((Object)some.value());
                outBuffer.$plus$plus$eq(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"%", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)specifier)})))).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scala.package$.MODULE$.BigInt().apply(args.head().toString())})));
                args = (Seq)args.tail();
                s = (String)new StringOps(Predef$.MODULE$.augmentString(s)).tail();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            s = "";
            boxedUnit = BoxedUnit.UNIT;
        }
        return StringContext$.MODULE$.treatEscapes(outBuffer.toString());
    }

    public void checkPrints() {
        this.dependencyGraph().prints().foreach((Function1 & Serializable & scala.Serializable)printStatement -> {
            LoFirrtlExpressionEvaluator.$anonfun$checkPrints$1(this, printStatement);
            return BoxedUnit.UNIT;
        });
    }

    private int resolveDepth() {
        return this.resolveDepth;
    }

    private void resolveDepth_$eq(int x$1) {
        this.resolveDepth = x$1;
    }

    private void indent() {
        this.resolveDepth_$eq(this.resolveDepth() + 1);
    }

    private void dedent() {
        this.resolveDepth_$eq(this.resolveDepth() - 1);
    }

    @Override
    public void log(Function0<String> message) {
        block0: {
            if (!this.verbose()) break block0;
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString(" ")).$times(this.resolveDepth() * 2), message.apply()})));
        }
    }

    public static final /* synthetic */ boolean $anonfun$defaultKeysToResolve$2(LoFirrtlExpressionEvaluator $this, String key) {
        return $this.dependencyGraph().nameToExpression().contains((Object)key);
    }

    private final String sourceInfo$1(Option leftHandSideOption$1) {
        String string;
        Option option = leftHandSideOption$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            String key = (String)some.value();
            string = this.dependencyGraph().getInfo(key);
        } else {
            string = "";
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$checkStops$1(LoFirrtlExpressionEvaluator $this, Object nonLocalReturnKey1$1, Stop stopStatement) {
        if ($this.evaluate(stopStatement.en(), (Option<String>)new Some((Object)"stop")).value().$greater((Object)BigInt$.MODULE$.int2bigInt(0))) {
            if (stopStatement.ret() == 0) {
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Success:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stopStatement.info()})));
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
            }
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failure:", " returned ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stopStatement.info(), BoxesRunTime.boxToInteger((int)stopStatement.ret())})));
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)BoxesRunTime.boxToInteger((int)stopStatement.ret())));
        }
    }

    public static final /* synthetic */ void $anonfun$checkPrints$1(LoFirrtlExpressionEvaluator $this, Print printStatement) {
        block0: {
            Concrete condition = $this.evaluate(printStatement.en(), $this.evaluate$default$2());
            if (!condition.value().$greater((Object)BigInt$.MODULE$.int2bigInt(0))) break block0;
            Seq resolvedArgs = (Seq)printStatement.args().map((Function1 & Serializable & scala.Serializable)arg -> $this.evaluate((Expression)arg, $this.evaluate$default$2()).value(), Seq$.MODULE$.canBuildFrom());
            String formatString = printStatement.string().serialize();
            Predef$.MODULE$.print((Object)$this.executeFormattedPrint(formatString, (Seq<Object>)resolvedArgs));
        }
    }

    public LoFirrtlExpressionEvaluator(DependencyGraph dependencyGraph, CircuitState circuitState) {
        this.dependencyGraph = dependencyGraph;
        this.circuitState = circuitState;
        package.SimpleLogger.$init$(this);
        this.toResolve = (HashSet)HashSet$.MODULE$.apply(dependencyGraph.keys().toSeq());
        this.evaluateAll = false;
        this.exceptionCaught = false;
        this.useTopologicalSortedKeys = false;
        this.allowCombinationalLoops = false;
        this.evaluationStack = new ExpressionExecutionStack(this);
        HashSet keys = new HashSet();
        keys.$plus$plus$eq((TraversableOnce)((TraversableLike)circuitState.memories().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Memory memory = (Memory)tuple2._2();
            Seq<String> seq = memory.getAllFieldDependencies();
            return seq;
        }, Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)LoFirrtlExpressionEvaluator.$anonfun$defaultKeysToResolve$2(this, key))));
        keys.$plus$plus$eq(dependencyGraph.outputPorts());
        keys.$plus$plus$eq(dependencyGraph.registerNames());
        this.defaultKeysToResolve = (String[])keys.toArray(ClassTag$.MODULE$.apply(String.class));
        this.keyOrderInitialized = false;
        this.orderedKeysToResolve = new ArrayBuffer();
        this.timer = new Timer();
        this.timer().enabled_$eq(false);
        this.resolveDepth = 0;
    }
}

