/*
 * Decompiled with CFR 0.152.
 */
package firrtl_interpreter;

import firrtl.CommonOptions;
import firrtl.ExecutionOptionsManager;
import firrtl.HasCommonOptions;
import firrtl_interpreter.Concrete;
import firrtl_interpreter.Concrete$;
import firrtl_interpreter.ConcreteClock;
import firrtl_interpreter.ConcreteSInt;
import firrtl_interpreter.ConcreteUInt;
import firrtl_interpreter.FirrtlTerp;
import firrtl_interpreter.FirrtlTerp$;
import firrtl_interpreter.HasInterpreterSuite;
import firrtl_interpreter.InterpreterException;
import firrtl_interpreter.InterpreterException$;
import firrtl_interpreter.InterpreterOptions;
import firrtl_interpreter.InterpretiveTester$;
import firrtl_interpreter.Memory;
import firrtl_interpreter.package$;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\u0001\u0003\u0001\u0015\u0011!#\u00138uKJ\u0004(/\u001a;jm\u0016$Vm\u001d;fe*\t1!\u0001\ngSJ\u0014H\u000f\\0j]R,'\u000f\u001d:fi\u0016\u00148\u0001A\n\u0003\u0001\u0019\u0001\"a\u0002\u0006\u000e\u0003!Q\u0011!C\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0017!\u0011a!\u00118z%\u00164\u0007\u0002C\u0007\u0001\u0005\u0003\u0005\u000b\u0011\u0002\b\u0002\u000b%t\u0007/\u001e;\u0011\u0005=1bB\u0001\t\u0015!\t\t\u0002\"D\u0001\u0013\u0015\t\u0019B!\u0001\u0004=e>|GOP\u0005\u0003+!\ta\u0001\u0015:fI\u00164\u0017BA\f\u0019\u0005\u0019\u0019FO]5oO*\u0011Q\u0003\u0003\u0005\t5\u0001\u0011\t\u0011)A\u00057\u0005qq\u000e\u001d;j_:\u001cX*\u00198bO\u0016\u0014\bC\u0001\u000f\u001e\u001b\u0005\u0011\u0011B\u0001\u0010\u0003\u0005MA\u0015m]%oi\u0016\u0014\bO]3uKJ\u001cV/\u001b;f\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0003\u0019a\u0014N\\5u}Q\u0019!e\t\u0013\u0011\u0005q\u0001\u0001\"B\u0007 \u0001\u0004q\u0001b\u0002\u000e !\u0003\u0005\ra\u0007\u0005\bM\u0001\u0001\r\u0011\"\u0001(\u0003=)\u0007\u0010]3di\u0006$\u0018n\u001c8t\u001b\u0016$X#\u0001\u0015\u0011\u0005\u001dI\u0013B\u0001\u0016\t\u0005\rIe\u000e\u001e\u0005\bY\u0001\u0001\r\u0011\"\u0001.\u0003M)\u0007\u0010]3di\u0006$\u0018n\u001c8t\u001b\u0016$x\fJ3r)\tq\u0013\u0007\u0005\u0002\b_%\u0011\u0001\u0007\u0003\u0002\u0005+:LG\u000fC\u00043W\u0005\u0005\t\u0019\u0001\u0015\u0002\u0007a$\u0013\u0007\u0003\u00045\u0001\u0001\u0006K\u0001K\u0001\u0011Kb\u0004Xm\u0019;bi&|gn]'fi\u0002BqA\u000e\u0001C\u0002\u0013\u0005q'A\u0006j]R,'\u000f\u001d:fi\u0016\u0014X#\u0001\u001d\u0011\u0005qI\u0014B\u0001\u001e\u0003\u0005)1\u0015N\u001d:uYR+'\u000f\u001d\u0005\u0007y\u0001\u0001\u000b\u0011\u0002\u001d\u0002\u0019%tG/\u001a:qe\u0016$XM\u001d\u0011\t\u000fy\u0002!\u0019!C\u0001\u007f\u0005\u0011\u0012N\u001c;feB\u0014X\r^3s\u001fB$\u0018n\u001c8t+\u0005\u0001\u0005C\u0001\u000fB\u0013\t\u0011%A\u0001\nJ]R,'\u000f\u001d:fi\u0016\u0014x\n\u001d;j_:\u001c\bB\u0002#\u0001A\u0003%\u0001)A\nj]R,'\u000f\u001d:fi\u0016\u0014x\n\u001d;j_:\u001c\b\u0005C\u0004G\u0001\t\u0007I\u0011A$\u0002\u001b\r|W.\\8o\u001fB$\u0018n\u001c8t+\u0005A\u0005CA%M\u001b\u0005Q%\"A&\u0002\r\u0019L'O\u001d;m\u0013\ti%JA\u0007D_6lwN\\(qi&|gn\u001d\u0005\u0007\u001f\u0002\u0001\u000b\u0011\u0002%\u0002\u001d\r|W.\\8o\u001fB$\u0018n\u001c8tA!)\u0011\u000b\u0001C\u0001%\u0006Q1/\u001a;WKJ\u0014wn]3\u0015\u00059\u001a\u0006b\u0002+Q!\u0003\u0005\r!V\u0001\u0006m\u0006dW/\u001a\t\u0003\u000fYK!a\u0016\u0005\u0003\u000f\t{w\u000e\\3b]\"9\u0011\f\u0001b\u0001\n\u0003Q\u0016!C:uCJ$H+[7f+\u0005Y\u0006CA\u0004]\u0013\ti\u0006B\u0001\u0003M_:<\u0007BB0\u0001A\u0003%1,\u0001\u0006ti\u0006\u0014H\u000fV5nK\u0002Bq!\u0019\u0001A\u0002\u0013%!,A\u0006gC&dWO]3US6,\u0007bB2\u0001\u0001\u0004%I\u0001Z\u0001\u0010M\u0006LG.\u001e:f)&lWm\u0018\u0013fcR\u0011a&\u001a\u0005\be\t\f\t\u00111\u0001\\\u0011\u00199\u0007\u0001)Q\u00057\u0006aa-Y5mkJ,G+[7fA!9\u0011\u000e\u0001a\u0001\n\u0013Q\u0017\u0001\u00034bS2\u001cu\u000eZ3\u0016\u0003-\u00042a\u00027)\u0013\ti\u0007B\u0001\u0004PaRLwN\u001c\u0005\b_\u0002\u0001\r\u0011\"\u0003q\u000311\u0017-\u001b7D_\u0012,w\fJ3r)\tq\u0013\u000fC\u00043]\u0006\u0005\t\u0019A6\t\rM\u0004\u0001\u0015)\u0003l\u0003%1\u0017-\u001b7D_\u0012,\u0007\u0005C\u0003v\u0001\u0011\u0005a/\u0001\u0003gC&dGC\u0001\u0018x\u0011\u0015AH\u000f1\u0001)\u0003\u0011\u0019w\u000eZ3\t\u000bU\u0004A\u0011\u0001>\u0015\tmt\u00181\u0003\t\u0003\u000fqL!! \u0005\u0003\u000f9{G\u000f[5oO\"1q0\u001fa\u0001\u0003\u0003\t!!\u001a=\u0011\t\u0005\r\u0011Q\u0002\b\u0005\u0003\u000b\tIAD\u0002\u0012\u0003\u000fI\u0011!C\u0005\u0004\u0003\u0017A\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003\u001f\t\tBA\u0005UQJ|w/\u00192mK*\u0019\u00111\u0002\u0005\t\u0013\u0005U\u0011\u0010%AA\u0002\u0005]\u0011aA7tOB\u0019q\u0001\u001c\b\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e\u0005!\u0011n](L+\u0005)\u0006bBA\u0011\u0001\u0011\u0005\u00111E\u0001\u0005a>\\W\rF\u0003/\u0003K\tI\u0003C\u0004\u0002(\u0005}\u0001\u0019\u0001\b\u0002\t9\fW.\u001a\u0005\b)\u0006}\u0001\u0019AA\u0016!\u0011\t\u0019!!\f\n\t\u0005=\u0012\u0011\u0003\u0002\u0007\u0005&<\u0017J\u001c;\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u00024Q)a&!\u000e\u00028!9\u0011qEA\u0019\u0001\u0004q\u0001b\u0002+\u00022\u0001\u0007\u0011\u0011\b\t\u00049\u0005m\u0012bAA\u001f\u0005\tA1i\u001c8de\u0016$X\rC\u0004\u0002B\u0001!\t!a\u0011\u0002\u0015A|7.Z'f[>\u0014\u0018\u0010F\u0004/\u0003\u000b\n9%a\u0013\t\u000f\u0005\u001d\u0012q\ba\u0001\u001d!9\u0011\u0011JA \u0001\u0004A\u0013!B5oI\u0016D\bb\u0002+\u0002@\u0001\u0007\u00111\u0006\u0005\b\u0003\u001f\u0002A\u0011AA)\u0003\u0011\u0001X-Z6\u0015\t\u0005-\u00121\u000b\u0005\b\u0003O\ti\u00051\u0001\u000f\u0011\u001d\t9\u0006\u0001C\u0001\u00033\n!\u0002]3fW6+Wn\u001c:z)\u0019\tY#a\u0017\u0002^!9\u0011qEA+\u0001\u0004q\u0001bBA%\u0003+\u0002\r\u0001\u000b\u0005\b\u0003C\u0002A\u0011AA2\u00031\u0001X-Z6D_:\u001c'/\u001a;f)\u0011\tI$!\u001a\t\u000f\u0005\u001d\u0012q\fa\u0001\u001d!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0014AB3ya\u0016\u001cG\u000fF\u0003/\u0003[\ny\u0007C\u0004\u0002(\u0005\u001d\u0004\u0019\u0001\b\t\u0011\u0005E\u0014q\ra\u0001\u0003W\tQ\"\u001a=qK\u000e$X\r\u001a,bYV,\u0007bBA;\u0001\u0011\u0005\u0011qO\u0001\u0005gR,\u0007\u000fF\u0002/\u0003sB\u0011\"a\u001f\u0002tA\u0005\t\u0019\u0001\u0015\u0002\u00039Dq!a \u0001\t\u0003\t\t)\u0001\u0007sKB|'\u000f^*ue&tw-F\u0001\u000f\u0011\u001d\t)\t\u0001C\u0001\u0003\u000f\u000baA]3q_J$H#\u0001\u0018\t\u000f\u0005-\u0005\u0001\"\u0001\u0002\u001e\u00051a-\u001b8jg\"D\u0011\"a$\u0001#\u0003%\t!!%\u0002)M,GOV3sE>\u001cX\r\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019JK\u0002V\u0003+[#!a&\u0011\t\u0005e\u00151U\u0007\u0003\u00037SA!!(\u0002 \u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003CC\u0011AC1o]>$\u0018\r^5p]&!\u0011QUAN\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003S\u0003\u0011\u0013!C\u0001\u0003W\u000baBZ1jY\u0012\"WMZ1vYR$#'\u0006\u0002\u0002.*\"\u0011qCAK\u0011%\t\t\fAI\u0001\n\u0003\t\u0019,\u0001\bti\u0016\u0004H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005U&f\u0001\u0015\u0002\u0016\u001eI\u0011\u0011\u0018\u0002\u0002\u0002#\u0005\u00111X\u0001\u0013\u0013:$XM\u001d9sKRLg/\u001a+fgR,'\u000fE\u0002\u001d\u0003{3\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011qX\n\u0004\u0003{3\u0001b\u0002\u0011\u0002>\u0012\u0005\u00111\u0019\u000b\u0003\u0003wC!\"a2\u0002>F\u0005I\u0011AAe\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u001a\u0016\u00047\u0005U\u0005")
public class InterpretiveTester {
    private int expectationsMet = 0;
    private final FirrtlTerp interpreter;
    private final InterpreterOptions interpreterOptions;
    private final CommonOptions commonOptions;
    private final long startTime;
    private long failureTime;
    private Option<Object> failCode;

    public static HasInterpreterSuite $lessinit$greater$default$2() {
        return InterpretiveTester$.MODULE$.$lessinit$greater$default$2();
    }

    public int expectationsMet() {
        return this.expectationsMet;
    }

    public void expectationsMet_$eq(int x$1) {
        this.expectationsMet = x$1;
    }

    public FirrtlTerp interpreter() {
        return this.interpreter;
    }

    public InterpreterOptions interpreterOptions() {
        return this.interpreterOptions;
    }

    public CommonOptions commonOptions() {
        return this.commonOptions;
    }

    public void setVerbose(boolean value) {
        this.interpreter().setVerbose(value);
    }

    public boolean setVerbose$default$1() {
        return true;
    }

    public long startTime() {
        return this.startTime;
    }

    private long failureTime() {
        return this.failureTime;
    }

    private void failureTime_$eq(long x$1) {
        this.failureTime = x$1;
    }

    private Option<Object> failCode() {
        return this.failCode;
    }

    private void failCode_$eq(Option<Object> x$1) {
        this.failCode = x$1;
    }

    public void fail(int code) {
        block0: {
            this.interpreter().circuitState().writeVCD();
            if (!this.failCode().isEmpty()) break block0;
            this.failureTime_$eq(System.nanoTime());
            this.failCode_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)code)));
        }
    }

    public Nothing$ fail(Throwable ex, Option<String> msg) {
        Option<String> option = msg;
        if (option instanceof Some) {
            Some some = (Some)option;
            String s = (String)some.value();
            Predef$.MODULE$.println((Object)s);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.fail(2);
        throw ex;
    }

    public Option<String> fail$default$2() {
        return None$.MODULE$;
    }

    public boolean isOK() {
        Some some;
        int n;
        Option<Object> option = this.failCode();
        boolean bl = None$.MODULE$.equals(option) ? true : option instanceof Some && 0 == (n = BoxesRunTime.unboxToInt((Object)(some = (Some)option).value()));
        boolean bl2 = bl;
        return bl2;
    }

    public void poke(String name, BigInt value) {
        if (this.interpreter().checkStopped(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"poke(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, value})))) {
            return;
        }
        try {
            boolean isRegister = this.interpreter().circuitState().registers().contains((Object)name);
            this.interpreter().circuitState().vcdLowerClock();
            String x$1 = name;
            BigInt x$2 = value;
            boolean x$3 = isRegister;
            boolean x$4 = this.interpreter().setValueWithBigInt$default$3();
            this.interpreter().setValueWithBigInt(x$1, x$2, x$4, x$3);
        }
        catch (InterpreterException ie) {
            throw this.fail(ie, (Option<String>)new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error: poke(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, value}))));
        }
    }

    public void poke(String name, Concrete value) {
        if (this.interpreter().checkStopped(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"poke(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, value})))) {
            return;
        }
        try {
            boolean isRegister = this.interpreter().circuitState().registers().contains((Object)name);
            this.interpreter().circuitState().vcdLowerClock();
            this.interpreter().circuitState().setValue(name, value, isRegister);
        }
        catch (InterpreterException ie) {
            throw this.fail(ie, (Option<String>)new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error: poke(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, value}))));
        }
    }

    public void pokeMemory(String name, int index, BigInt value) {
        if (this.interpreter().checkStopped(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pokeMemory(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, value})))) {
            return;
        }
        Option option = this.interpreter().circuitState().memories().get((Object)name);
        if (!(option instanceof Some)) {
            throw InterpreterException$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error: memory ", ".forceWrite(", ", ", "). memory not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, BoxesRunTime.boxToInteger((int)index), value})));
        }
        Some some = (Some)option;
        Memory memory = (Memory)some.value();
        memory.forceWrite(index, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public BigInt peek(String name) {
        BigInt bigInt;
        if (this.interpreter().checkStopped(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"peek(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})))) {
            return BigInt$.MODULE$.int2bigInt(0);
        }
        Concrete concrete = this.interpreter().getValue(name);
        if (concrete instanceof ConcreteUInt) {
            BigInt value;
            ConcreteUInt concreteUInt = (ConcreteUInt)concrete;
            bigInt = value = concreteUInt.value();
        } else if (concrete instanceof ConcreteSInt) {
            BigInt value;
            ConcreteSInt concreteSInt = (ConcreteSInt)concrete;
            bigInt = value = concreteSInt.value();
        } else {
            throw this.fail(new InterpreterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error:peek(", ") value not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}))), this.fail$default$2());
        }
        return bigInt;
    }

    public BigInt peekMemory(String name, int index) {
        return this.interpreter().getMemory(name, index);
    }

    public Concrete peekConcrete(String name) {
        Concrete concrete;
        if (this.interpreter().checkStopped(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"peekConcrete(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})))) {
            return Concrete$.MODULE$.poisonedUInt(1);
        }
        Concrete concrete2 = this.interpreter().getValue(name);
        if (concrete2 == null) {
            throw this.fail(new InterpreterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error:peek(", ") value not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}))), this.fail$default$2());
        }
        Concrete concrete3 = concrete = concrete2;
        return concrete3;
    }

    public void expect(String name, BigInt expectedValue) {
        if (this.interpreter().checkStopped(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, expectedValue})))) {
            return;
        }
        Concrete concrete = this.interpreter().getValue(name);
        if (concrete instanceof ConcreteUInt) {
            ConcreteUInt concreteUInt = (ConcreteUInt)concrete;
            this.testValue$1(concreteUInt, name, expectedValue);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (concrete instanceof ConcreteSInt) {
            ConcreteSInt concreteSInt = (ConcreteSInt)concrete;
            this.testValue$1(concreteSInt, name, expectedValue);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (concrete instanceof ConcreteClock) {
            ConcreteClock concreteClock = (ConcreteClock)concrete;
            this.testValue$1(concreteClock, name, expectedValue);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw this.fail(new InterpreterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error:expect(", ", ", ") value not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, expectedValue}))), this.fail$default$2());
        }
        this.expectationsMet_$eq(this.expectationsMet() + 1);
    }

    public void step(int n) {
        if (this.interpreter().checkStopped(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"step(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})))) {
            return;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> this.interpreter().cycle(this.interpreter().cycle$default$1()));
    }

    public int step$default$1() {
        return 1;
    }

    public String reportString() {
        long endTime = System.nanoTime();
        double elapsedSeconds = (double)(endTime - this.startTime()) / 1.0E9;
        double arg$macro$17 = elapsedSeconds;
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.interpreter().loweredAst().main()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " tests passed "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.status$1(), BoxesRunTime.boxToInteger((int)this.expectationsMet())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in ", " cycles "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.interpreter().circuitState().stateCounter())})) + new StringOps("taking %.6f seconds").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$17)}));
    }

    public void report() {
        this.interpreter().writeVCD();
        Predef$.MODULE$.println((Object)this.reportString());
    }

    public boolean finish() {
        return this.isOK();
    }

    private final void testValue$1(Concrete concrete, String name$1, BigInt expectedValue$1) {
        BigInt bigInt = concrete.value();
        BigInt bigInt2 = expectedValue$1;
        if (bigInt == null ? bigInt2 != null : !bigInt.equals(bigInt2)) {
            if (!this.interpreter().verbose()) {
                this.interpreter().reEvaluate(name$1);
            }
            throw this.fail(new InterpreterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error:expect(", ", ", ") got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name$1, expectedValue$1, concrete.showValue()}))), this.fail$default$2());
        }
    }

    private final String status$1() {
        String string;
        Option<Object> option = this.interpreter().lastStopResult();
        if (option instanceof Some) {
            Some some = (Some)option;
            int stopResult = BoxesRunTime.unboxToInt((Object)some.value());
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed: Stop result ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)stopResult)}));
        } else {
            string = this.isOK() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Success:"})).s((Seq)Nil$.MODULE$) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed: Code ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.failCode().get()}));
        }
        return string;
    }

    public InterpretiveTester(String input, HasInterpreterSuite optionsManager) {
        package$.MODULE$.random().setSeed(optionsManager.interpreterOptions().randomSeed());
        this.interpreter = FirrtlTerp$.MODULE$.apply(input, optionsManager);
        this.interpreterOptions = optionsManager.interpreterOptions();
        this.commonOptions = ((HasCommonOptions)optionsManager).commonOptions();
        this.interpreter().evaluator().allowCombinationalLoops_$eq(this.interpreterOptions().allowCycles());
        this.interpreter().evaluator().useTopologicalSortedKeys_$eq(this.interpreterOptions().setOrderedExec());
        this.interpreter().evaluator().evaluationStack().maxExecutionDepth_$eq(this.interpreterOptions().maxExecutionDepth());
        this.interpreter().setVerbose(this.interpreterOptions().setVerbose());
        this.setVerbose(this.interpreterOptions().setVerbose());
        if (this.interpreterOptions().writeVCD()) {
            ((ExecutionOptionsManager)optionsManager).setTopNameIfNotSet(this.interpreter().loweredAst().main());
            ((ExecutionOptionsManager)optionsManager).makeTargetDir();
            this.interpreter().makeVCDLogger(this.interpreterOptions().vcdOutputFileName((ExecutionOptionsManager)optionsManager), this.interpreterOptions().vcdShowUnderscored());
        }
        this.startTime = System.nanoTime();
        this.failureTime = -1L;
        this.failCode = None$.MODULE$;
    }
}

