/*
 * Decompiled with CFR 0.152.
 */
package firrtl_interpreter;

import firrtl.Gender;
import firrtl.Kind;
import firrtl.WDefInstance;
import firrtl.WRef;
import firrtl.WSubField;
import firrtl.WSubIndex;
import firrtl.ir.Block;
import firrtl.ir.Circuit;
import firrtl.ir.ClockType$;
import firrtl.ir.Conditionally;
import firrtl.ir.Connect;
import firrtl.ir.DefMemory;
import firrtl.ir.DefModule;
import firrtl.ir.DefNode;
import firrtl.ir.DefRegister;
import firrtl.ir.DefWire;
import firrtl.ir.Direction;
import firrtl.ir.DoPrim;
import firrtl.ir.EmptyStmt$;
import firrtl.ir.Expression;
import firrtl.ir.ExtModule;
import firrtl.ir.FirrtlNode;
import firrtl.ir.Info;
import firrtl.ir.Input$;
import firrtl.ir.IntWidth$;
import firrtl.ir.IsInvalid;
import firrtl.ir.Module;
import firrtl.ir.Mux;
import firrtl.ir.Output$;
import firrtl.ir.Port;
import firrtl.ir.PrimOp;
import firrtl.ir.Print;
import firrtl.ir.SIntLiteral;
import firrtl.ir.SIntType;
import firrtl.ir.Statement;
import firrtl.ir.Stop;
import firrtl.ir.StringLit;
import firrtl.ir.Type;
import firrtl.ir.UIntLiteral;
import firrtl.ir.UIntType;
import firrtl.ir.ValidIf;
import firrtl.ir.Width;
import firrtl_interpreter.BlackBoxFactory;
import firrtl_interpreter.BlackBoxImplementation;
import firrtl_interpreter.BlackBoxOutput;
import firrtl_interpreter.DependencyGraph;
import firrtl_interpreter.FirrtlTerp;
import firrtl_interpreter.InterpreterException;
import firrtl_interpreter.InterpreterException$;
import firrtl_interpreter.package;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.BigInt$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DependencyGraph$
implements package.SimpleLogger {
    public static DependencyGraph$ MODULE$;
    private final int MaxColumnWidth;
    private boolean verbose;

    static {
        new DependencyGraph$();
    }

    @Override
    public void setVerbose(boolean value) {
        package.SimpleLogger.setVerbose$(this, value);
    }

    @Override
    public void log(Function0<String> msg) {
        package.SimpleLogger.log$(this, msg);
    }

    @Override
    public boolean setVerbose$default$1() {
        return package.SimpleLogger.setVerbose$default$1$(this);
    }

    @Override
    public boolean verbose() {
        return this.verbose;
    }

    @Override
    public void verbose_$eq(boolean x$1) {
        this.verbose = x$1;
    }

    public Seq<BlackBoxFactory> $lessinit$greater$default$3() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public int MaxColumnWidth() {
        return this.MaxColumnWidth;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DefModule findModule(String moduleName, Circuit circuit) {
        DefModule externalModule;
        boolean bl = false;
        Some some = null;
        Option option = circuit.modules().find((Function1 & Serializable & scala.Serializable)module -> BoxesRunTime.boxToBoolean((boolean)DependencyGraph$.$anonfun$findModule$1(moduleName, module)));
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            DefModule module2 = (DefModule)some.value();
            if (module2 instanceof Module) {
                Module module3 = (Module)module2;
                return module3;
            }
        }
        if (!bl || (externalModule = (DefModule)some.value()) == null) throw InterpreterException$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find top level module in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{moduleName})));
        DefModule defModule = externalModule;
        return defModule;
    }

    public Statement processDependencyStatements(String modulePrefix, Statement s, DependencyGraph dependencyGraph) {
        Block block;
        dependencyGraph.numberOfStatements_$eq(dependencyGraph.numberOfStatements() + 1);
        Statement statement = s;
        if (statement instanceof Block) {
            Block block2 = (Block)statement;
            block2.stmts().map((Function1 & Serializable & scala.Serializable)subStatement -> MODULE$.processDependencyStatements(modulePrefix, (Statement)subStatement, dependencyGraph), Seq$.MODULE$.canBuildFrom());
            block = block2;
        } else if (statement instanceof Connect) {
            Connect connect = (Connect)statement;
            Expression expression2 = connect.loc();
            if (expression2 instanceof WRef) {
                WRef wRef = (WRef)expression2;
                String name = wRef.name();
                dependencyGraph.update(DependencyGraph$.expand$1(name, modulePrefix), DependencyGraph$.renameExpression$1(connect.expr(), modulePrefix, dependencyGraph));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl = expression2 instanceof WSubField ? true : expression2 instanceof WSubIndex;
                if (bl) {
                    dependencyGraph.update(DependencyGraph$.expand$1(connect.loc().serialize(), modulePrefix), DependencyGraph$.renameExpression$1(connect.expr(), modulePrefix, dependencyGraph));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)expression2);
                }
            }
            block = connect;
        } else if (statement instanceof WDefInstance) {
            WDefInstance wDefInstance = (WDefInstance)statement;
            Info info = wDefInstance.info();
            String instanceName = wDefInstance.name();
            String moduleName = wDefInstance.module();
            DefModule subModule = this.findModule(moduleName, dependencyGraph.circuit());
            String newPrefix = modulePrefix.isEmpty() ? instanceName : modulePrefix + "." + instanceName;
            this.log((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"declaration:WDefInstance:", ":", " prefix now ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{instanceName, moduleName, newPrefix})));
            this.processModule(newPrefix, subModule, dependencyGraph);
            DefModule defModule = subModule;
            if (defModule instanceof Module) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (defModule instanceof ExtModule) {
                BoxedUnit boxedUnit;
                ExtModule extModule = (ExtModule)defModule;
                this.log((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"got external module ", " instance ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{extModule.name(), modulePrefix})));
                this.log((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Factories: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependencyGraph.blackBoxFactories().mkString("\n")})));
                boolean implementationFound = dependencyGraph.blackBoxFactories().exists((Function1 & Serializable & scala.Serializable)factory -> BoxesRunTime.boxToBoolean((boolean)DependencyGraph$.$anonfun$processDependencyStatements$6(modulePrefix, dependencyGraph, instanceName, newPrefix, extModule, factory)));
                if (!implementationFound) {
                    Predef$.MODULE$.println((Object)(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WARNING: external module \"", "\"(", ":", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{extModule.defname(), modulePrefix, extModule.name()})) + "was not matched with an implementation"));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                throw new MatchError((Object)defModule);
            }
            dependencyGraph.addSourceInfo(newPrefix, info);
            dependencyGraph.addInstanceName(instanceName, moduleName);
            block = s;
        } else if (statement instanceof DefNode) {
            DefNode defNode = (DefNode)statement;
            Info info = defNode.info();
            String name = defNode.name();
            Expression expression3 = defNode.value();
            this.log((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"declaration:DefNode:", ":", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, expression3.serialize(), DependencyGraph$.renameExpression$1(expression3, modulePrefix, dependencyGraph).serialize()})));
            String expandedName = DependencyGraph$.expand$1(name, modulePrefix);
            dependencyGraph.nodes().$plus$eq((Object)expandedName);
            dependencyGraph.recordName(expandedName);
            dependencyGraph.update(expandedName, DependencyGraph$.renameExpression$1(expression3, modulePrefix, dependencyGraph));
            dependencyGraph.addSourceInfo(expandedName, info);
            block = s;
        } else if (statement instanceof DefWire) {
            DefWire defWire = (DefWire)statement;
            Info info = defWire.info();
            String name = defWire.name();
            Type tpe = defWire.tpe();
            this.log((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"declaration:DefWire:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
            String expandedName = DependencyGraph$.expand$1(name, modulePrefix);
            dependencyGraph.wires().$plus$eq((Object)expandedName);
            dependencyGraph.recordName(expandedName);
            dependencyGraph.recordType(expandedName, tpe);
            dependencyGraph.addSourceInfo(expandedName, info);
            block = s;
        } else if (statement instanceof DefRegister) {
            DefRegister defRegister = (DefRegister)statement;
            Info info = defRegister.info();
            String name = defRegister.name();
            Type tpe = defRegister.tpe();
            Expression clockExpression = defRegister.clock();
            Expression resetExpression = defRegister.reset();
            Expression initValueExpression = defRegister.init();
            this.log((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"declaration:DefRegister:", " clock <- ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, clockExpression.serialize(), DependencyGraph$.renameExpression$1(clockExpression, modulePrefix, dependencyGraph).serialize()})));
            this.log((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"declaration:DefRegister:", " reset <- ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, resetExpression.serialize(), DependencyGraph$.renameExpression$1(resetExpression, modulePrefix, dependencyGraph).serialize()})));
            this.log((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"declaration:DefRegister:", " init  <- ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, initValueExpression.serialize(), DependencyGraph$.renameExpression$1(initValueExpression, modulePrefix, dependencyGraph).serialize()})));
            DefRegister renamedDefRegister = new DefRegister(info, DependencyGraph$.expand$1(name, modulePrefix), tpe, DependencyGraph$.renameExpression$1(clockExpression, modulePrefix, dependencyGraph), DependencyGraph$.renameExpression$1(resetExpression, modulePrefix, dependencyGraph), DependencyGraph$.renameExpression$1(initValueExpression, modulePrefix, dependencyGraph));
            String expandedName = DependencyGraph$.expand$1(name, modulePrefix);
            dependencyGraph.registerNames().$plus$eq((Object)expandedName);
            dependencyGraph.recordName(expandedName);
            dependencyGraph.recordType(expandedName, tpe);
            dependencyGraph.registers().update((Object)expandedName, (Object)renamedDefRegister);
            dependencyGraph.addSourceInfo(expandedName, info);
            block = s;
        } else if (statement instanceof DefMemory) {
            DefMemory defMemory = (DefMemory)statement;
            String expandedName = DependencyGraph$.expand$1(defMemory.name(), modulePrefix);
            this.log((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"declaration:DefMemory:", " becomes ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defMemory.name(), expandedName})));
            String x$2 = expandedName;
            Info x$3 = defMemory.copy$default$1();
            Type x$4 = defMemory.copy$default$3();
            int x$5 = defMemory.copy$default$4();
            int x$6 = defMemory.copy$default$5();
            int x$7 = defMemory.copy$default$6();
            Seq x$8 = defMemory.copy$default$7();
            Seq x$9 = defMemory.copy$default$8();
            Seq x$10 = defMemory.copy$default$9();
            Option x$11 = defMemory.copy$default$10();
            DefMemory newDefMemory = defMemory.copy(x$3, x$2, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11);
            dependencyGraph.addMemory(newDefMemory);
            dependencyGraph.addSourceInfo(expandedName, defMemory.info());
            block = s;
        } else if (statement instanceof IsInvalid) {
            IsInvalid isInvalid = (IsInvalid)statement;
            Info info = isInvalid.info();
            Expression expression4 = isInvalid.expr();
            block = new IsInvalid(info, DependencyGraph$.renameExpression$1(expression4, modulePrefix, dependencyGraph));
        } else if (statement instanceof Stop) {
            Stop stop = (Stop)statement;
            Info info = stop.info();
            int ret = stop.ret();
            Expression clkExpression = stop.clk();
            Expression enableExpression = stop.en();
            dependencyGraph.addStop(new Stop(info, ret, DependencyGraph$.renameExpression$1(clkExpression, modulePrefix, dependencyGraph), DependencyGraph$.renameExpression$1(enableExpression, modulePrefix, dependencyGraph)));
            block = s;
        } else if (statement instanceof Print) {
            Print print = (Print)statement;
            Info info = print.info();
            StringLit stringLiteral = print.string();
            Seq argExpressions = print.args();
            Expression clkExpression = print.clk();
            Expression enableExpression = print.en();
            dependencyGraph.addPrint(new Print(info, stringLiteral, (Seq)argExpressions.map((Function1 & Serializable & scala.Serializable)expression -> DependencyGraph$.renameExpression$1(expression, modulePrefix, dependencyGraph), Seq$.MODULE$.canBuildFrom()), DependencyGraph$.renameExpression$1(clkExpression, modulePrefix, dependencyGraph), DependencyGraph$.renameExpression$1(enableExpression, modulePrefix, dependencyGraph)));
            block = s;
        } else if (EmptyStmt$.MODULE$.equals(statement)) {
            block = s;
        } else {
            if (statement instanceof Conditionally) {
                Conditionally conditionally = (Conditionally)statement;
                throw new InterpreterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"conditionally unsupported in interpreter ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{conditionally})));
            }
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TODO: Unhandled statement ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s})));
            block = s;
        }
        return block;
    }

    public void processExternalInstance(ExtModule extModule, String modulePrefix, String instanceName, BlackBoxImplementation instance, DependencyGraph dependencyGraph) {
        extModule.ports().foreach((Function1 & Serializable & scala.Serializable)port -> {
            DependencyGraph$.$anonfun$processExternalInstance$1(modulePrefix, instance, dependencyGraph, port);
            return BoxedUnit.UNIT;
        });
    }

    public void processModule(String modulePrefix, DefModule myModule, DependencyGraph dependencyGraph) {
        DefModule defModule = myModule;
        if (defModule instanceof Module) {
            Module module = (Module)defModule;
            DependencyGraph$.processPorts$1((DefModule)module, modulePrefix, dependencyGraph);
            this.processDependencyStatements(modulePrefix, module.body(), dependencyGraph);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (defModule instanceof ExtModule) {
            ExtModule extModule = (ExtModule)defModule;
            this.log((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"got external module ", " instance ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{extModule.name(), modulePrefix})));
            DependencyGraph$.processPorts$1((DefModule)extModule, modulePrefix, dependencyGraph);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)defModule);
        }
    }

    public DependencyGraph apply(Circuit circuit, FirrtlTerp interpreter) {
        Module module;
        DefModule defModule = this.findModule(circuit.main(), circuit);
        if (!(defModule instanceof Module)) {
            if (defModule instanceof ExtModule) {
                ExtModule extModule = (ExtModule)defModule;
                throw InterpreterException$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Top level module must be a regular module ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{extModule})));
            }
            throw InterpreterException$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Top level module is not the right kind of module ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defModule})));
        }
        Module module2 = module = (Module)defModule;
        Module module3 = module2;
        DependencyGraph dependencyGraph = new DependencyGraph(circuit, module3, interpreter.blackBoxFactories());
        dependencyGraph.numberOfNodes_$eq(0);
        dependencyGraph.numberOfStatements_$eq(0);
        this.processModule("", (DefModule)module3, dependencyGraph);
        dependencyGraph.validNames().foreach((Function1 & Serializable & scala.Serializable)name -> {
            DependencyGraph$.$anonfun$apply$1(dependencyGraph, name);
            return BoxedUnit.UNIT;
        });
        this.log((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"For module ", " dependencyGraph ="})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{module3.name()})));
        ((IterableLike)dependencyGraph.nameToExpression().keys().toSeq().sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)k -> {
            DependencyGraph$.$anonfun$apply$3(dependencyGraph, k);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"End of dependency graph"})).s((Seq)Nil$.MODULE$));
        return dependencyGraph;
    }

    public static final /* synthetic */ boolean $anonfun$findModule$1(String moduleName$1, DefModule module) {
        String string = module.name();
        String string2 = moduleName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final String expand$1(String name, String modulePrefix$1) {
        return modulePrefix$1.isEmpty() ? name : modulePrefix$1 + "." + name;
    }

    private static final Expression renameExpression$1(Expression expression, String modulePrefix$1, DependencyGraph dependencyGraph$1) {
        WRef wRef;
        dependencyGraph$1.numberOfNodes_$eq(dependencyGraph$1.numberOfNodes() + 1);
        Expression expression2 = expression;
        if (expression2 instanceof Mux) {
            Mux mux = (Mux)expression2;
            Expression condition = mux.cond();
            Expression trueExpression = mux.tval();
            Expression falseExpression = mux.fval();
            Type tpe = mux.tpe();
            dependencyGraph$1.numberOfMuxes_$eq(dependencyGraph$1.numberOfMuxes() + 1);
            wRef = new Mux(DependencyGraph$.renameExpression$1(condition, modulePrefix$1, dependencyGraph$1), DependencyGraph$.renameExpression$1(trueExpression, modulePrefix$1, dependencyGraph$1), DependencyGraph$.renameExpression$1(falseExpression, modulePrefix$1, dependencyGraph$1), tpe);
        } else if (expression2 instanceof WRef) {
            WRef wRef2 = (WRef)expression2;
            String name = wRef2.name();
            Type tpe = wRef2.tpe();
            Kind kind = wRef2.kind();
            Gender gender = wRef2.gender();
            wRef = new WRef(DependencyGraph$.expand$1(name, modulePrefix$1), tpe, kind, gender);
        } else if (expression2 instanceof WSubField) {
            WSubField wSubField = (WSubField)expression2;
            Expression subExpression2 = wSubField.expr();
            String name = wSubField.name();
            Type tpe = wSubField.tpe();
            Gender gender = wSubField.gender();
            wRef = new WSubField(DependencyGraph$.renameExpression$1(subExpression2, modulePrefix$1, dependencyGraph$1), name, tpe, gender);
        } else if (expression2 instanceof WSubIndex) {
            WSubIndex wSubIndex = (WSubIndex)expression2;
            Expression subExpression3 = wSubIndex.expr();
            int value = wSubIndex.value();
            Type tpe = wSubIndex.tpe();
            Gender gender = wSubIndex.gender();
            wRef = new WSubIndex(DependencyGraph$.renameExpression$1(subExpression3, modulePrefix$1, dependencyGraph$1), value, tpe, gender);
        } else if (expression2 instanceof ValidIf) {
            ValidIf validIf = (ValidIf)expression2;
            Expression condition = validIf.cond();
            Expression value = validIf.value();
            Type tpe = validIf.tpe();
            wRef = new ValidIf(DependencyGraph$.renameExpression$1(condition, modulePrefix$1, dependencyGraph$1), DependencyGraph$.renameExpression$1(value, modulePrefix$1, dependencyGraph$1), tpe);
        } else if (expression2 instanceof DoPrim) {
            DoPrim doPrim = (DoPrim)expression2;
            PrimOp op = doPrim.op();
            Seq args = doPrim.args();
            Seq seq = doPrim.consts();
            Type tpe = doPrim.tpe();
            wRef = new DoPrim(op, (Seq)args.map((Function1 & Serializable & scala.Serializable)subExpression -> DependencyGraph$.renameExpression$1(subExpression, modulePrefix$1, dependencyGraph$1), Seq$.MODULE$.canBuildFrom()), seq, tpe);
        } else if (expression2 instanceof UIntLiteral) {
            UIntLiteral uIntLiteral = (UIntLiteral)expression2;
            wRef = uIntLiteral;
        } else if (expression2 instanceof SIntLiteral) {
            SIntLiteral sIntLiteral = (SIntLiteral)expression2;
            wRef = sIntLiteral;
        } else {
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"renameExpression:error: unhandled expression ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expression})));
        }
        WRef result = wRef;
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$processDependencyStatements$6(String modulePrefix$1, DependencyGraph dependencyGraph$1, String instanceName$1, String newPrefix$1, ExtModule x3$1, BlackBoxFactory factory) {
        boolean bl;
        MODULE$.log((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Found an existing factory");
        Option<BlackBoxImplementation> option = factory.createInstance(modulePrefix$1, x3$1.defname());
        if (option instanceof Some) {
            Some some = (Some)option;
            BlackBoxImplementation implementation = (BlackBoxImplementation)some.value();
            MODULE$.processExternalInstance(x3$1, newPrefix$1, instanceName$1, implementation, dependencyGraph$1);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final String expand$2(String name, String modulePrefix$3) {
        return modulePrefix$3 + "." + name;
    }

    public static final /* synthetic */ void $anonfun$processExternalInstance$1(String modulePrefix$3, BlackBoxImplementation instance$1, DependencyGraph dependencyGraph$3, Port port) {
        block0: {
            Direction direction = port.direction();
            Output$ output$ = Output$.MODULE$;
            if (direction != null ? !direction.equals(output$) : output$ != null) break block0;
            Seq<String> outputDependencies = instance$1.outputDependencies(port.name());
            Seq dependendInputs = (Seq)outputDependencies.map((Function1 & Serializable & scala.Serializable)s -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modulePrefix$3, s})), Seq$.MODULE$.canBuildFrom());
            dependencyGraph$3.update(DependencyGraph$.expand$2(port.name(), modulePrefix$3), new BlackBoxOutput(port.name(), instance$1, (Seq<String>)dependendInputs, port.tpe()));
        }
    }

    private static final void processPorts$1(DefModule module, String modulePrefix$2, DependencyGraph dependencyGraph$2) {
        module.ports().foreach((Function1 & Serializable & scala.Serializable)port -> {
            BoxedUnit boxedUnit;
            if (modulePrefix$2.isEmpty()) {
                dependencyGraph$2.nameToType().update((Object)port.name(), (Object)port.tpe());
                Direction direction = port.direction();
                Input$ input$ = Input$.MODULE$;
                if (!(direction != null ? !direction.equals(input$) : input$ != null)) {
                    dependencyGraph$2.inputPorts().$plus$eq((Object)port.name());
                    dependencyGraph$2.recordName(port.name());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    Direction direction2 = port.direction();
                    Output$ output$ = Output$.MODULE$;
                    if (!(direction2 != null ? !direction2.equals(output$) : output$ != null)) {
                        dependencyGraph$2.outputPorts().$plus$eq((Object)port.name());
                        dependencyGraph$2.recordName(port.name());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            } else {
                dependencyGraph$2.nameToType().update((Object)(modulePrefix$2 + "." + port.name()), (Object)port.tpe());
                dependencyGraph$2.recordName(modulePrefix$2 + "." + port.name());
                boxedUnit = dependencyGraph$2.inlinedPorts().$plus$eq((Object)(modulePrefix$2 + "." + port.name()));
            }
            return boxedUnit;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$1(DependencyGraph dependencyGraph$4, String name) {
        block6: {
            UIntLiteral uIntLiteral;
            if (dependencyGraph$4.nameToExpression().contains((Object)name)) break block6;
            Type type = (Type)dependencyGraph$4.nameToType().apply((Object)name);
            if (type instanceof UIntType) {
                UIntType uIntType = (UIntType)type;
                Width width = uIntType.width();
                uIntLiteral = new UIntLiteral(BigInt$.MODULE$.int2bigInt(0), width);
            } else if (type instanceof SIntType) {
                SIntType sIntType = (SIntType)type;
                Width width = sIntType.width();
                uIntLiteral = new SIntLiteral(BigInt$.MODULE$.int2bigInt(0), width);
            } else if (ClockType$.MODULE$.equals(type)) {
                uIntLiteral = new UIntLiteral(BigInt$.MODULE$.int2bigInt(0), (Width)IntWidth$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(1)));
            } else {
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"error can't find default value for ", ".type = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, dependencyGraph$4.nameToType().apply((Object)name)})));
            }
            UIntLiteral defaultValue = uIntLiteral;
            dependencyGraph$4.nameToExpression().update((Object)name, (Object)defaultValue);
        }
    }

    public static final /* synthetic */ void $anonfun$apply$3(DependencyGraph dependencyGraph$4, String k) {
        String v = ((FirrtlNode)dependencyGraph$4.nameToExpression().apply((Object)k)).serialize();
        MODULE$.log((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  ", " -> ("})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k})) + new StringOps(Predef$.MODULE$.augmentString(v.toString())).take(MODULE$.MaxColumnWidth()) + ")");
    }

    private DependencyGraph$() {
        MODULE$ = this;
        package.SimpleLogger.$init$(this);
        this.MaxColumnWidth = 100;
    }
}

