/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import zio.Chunk;
import zio.Chunk$;
import zio.internal.SingleThreadedRingBuffer$;

public final class SingleThreadedRingBuffer<A> {
    private final int capacity;
    private final Object[] array;
    private int size;
    private int current;

    public static <A> SingleThreadedRingBuffer<A> apply(int n) {
        return SingleThreadedRingBuffer$.MODULE$.apply(n);
    }

    public SingleThreadedRingBuffer(int capacity) {
        this.capacity = capacity;
        this.array = new Object[capacity];
        this.size = 0;
        this.current = 0;
    }

    public Option<A> head() {
        return Option$.MODULE$.apply(this.array[this.current]);
    }

    public A lastOrNull() {
        if (this.size == 0) {
            return null;
        }
        int index = this.current == 0 ? this.array.length - 1 : this.current - 1;
        return (A)this.array[index];
    }

    public void put(A value) {
        this.array[this.current] = value;
        this.increment();
    }

    public void dropLast() {
        if (this.size > 0) {
            this.decrement();
            this.array[this.current] = null;
            return;
        }
    }

    public Chunk<A> toChunk() {
        Object[] objectArray;
        int begin = this.current - this.size;
        if (begin < 0) {
            Object object = Predef$.MODULE$.refArrayOps(this.array);
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.slice$extension(object, this.capacity + begin, this.capacity));
            Object object3 = Predef$.MODULE$.refArrayOps(this.array);
            objectArray = (Object[])ArrayOps$.MODULE$.$plus$plus$extension(object2, ArrayOps$.MODULE$.slice$extension(object3, 0, this.current), ClassTag$.MODULE$.apply(Object.class));
        } else {
            Object object = Predef$.MODULE$.refArrayOps(this.array);
            objectArray = (Object[])ArrayOps$.MODULE$.slice$extension(object, begin, this.current);
        }
        Object[] newArray = objectArray;
        return Chunk$.MODULE$.fromArray(newArray);
    }

    public List<A> toReversedList() {
        Object[] objectArray;
        int begin = this.current - this.size;
        if (begin < 0) {
            Object object = Predef$.MODULE$.refArrayOps(this.array);
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.slice$extension(object, this.capacity + begin, this.capacity));
            Object object3 = Predef$.MODULE$.refArrayOps(this.array);
            objectArray = (Object[])ArrayOps$.MODULE$.$plus$plus$extension(object2, ArrayOps$.MODULE$.slice$extension(object3, 0, this.current), ClassTag$.MODULE$.apply(Object.class));
        } else {
            Object object = Predef$.MODULE$.refArrayOps(this.array);
            objectArray = (Object[])ArrayOps$.MODULE$.slice$extension(object, begin, this.current);
        }
        Object[] newArray = objectArray;
        return this.arrayToReversedList(newArray);
    }

    private List<Object> arrayToReversedList(Object[] array) {
        Nil$ result = package$.MODULE$.Nil();
        for (int i = 0; i < array.length; ++i) {
            result = result.$colon$colon(array[i]);
        }
        return result;
    }

    private void increment() {
        if (this.size < this.capacity) {
            ++this.size;
        }
        this.current = (this.current + 1) % this.capacity;
    }

    private void decrement() {
        --this.size;
        if (this.current > 0) {
            --this.current;
            return;
        }
        this.current = this.capacity - 1;
    }
}

