/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import zio.Chunk;
import zio.Chunk$;
import zio.internal.LinkedQueue$;
import zio.internal.MutableConcurrentQueue;

public final class LinkedQueue<A>
extends MutableConcurrentQueue<A>
implements Serializable {
    private final ConcurrentLinkedQueue<A> jucConcurrentQueue = new ConcurrentLinkedQueue();
    private final AtomicLong enqueuedCounter;
    private final AtomicLong dequeuedCounter;

    public static <A> LinkedQueue<A> apply(boolean bl) {
        return LinkedQueue$.MODULE$.apply(bl);
    }

    public LinkedQueue(boolean addMetrics) {
        this.enqueuedCounter = addMetrics ? new AtomicLong(0L) : null;
        this.dequeuedCounter = addMetrics ? new AtomicLong(0L) : null;
    }

    public LinkedQueue() {
        this(true);
    }

    @Override
    public final int capacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int size() {
        return this.jucConcurrentQueue.size();
    }

    @Override
    public long enqueuedCount() {
        if (this.enqueuedCounter != null) {
            return this.enqueuedCounter.get();
        }
        return 0L;
    }

    @Override
    public long dequeuedCount() {
        if (this.dequeuedCounter != null) {
            return this.dequeuedCounter.get();
        }
        return 0L;
    }

    @Override
    public boolean offer(A a) {
        boolean success = this.jucConcurrentQueue.offer(a);
        if (this.enqueuedCounter != null && success) {
            this.enqueuedCounter.incrementAndGet();
        }
        return success;
    }

    @Override
    public <A1 extends A> Chunk<A1> offerAll(Iterable<A1> as) {
        this.jucConcurrentQueue.addAll(JavaConverters$.MODULE$.asJavaCollectionConverter(as).asJavaCollection());
        if (this.enqueuedCounter != null) {
            this.enqueuedCounter.addAndGet(as.size());
        }
        return Chunk$.MODULE$.empty();
    }

    @Override
    public A poll(A a) {
        A polled = this.jucConcurrentQueue.poll();
        if (polled != null) {
            if (this.dequeuedCounter != null) {
                this.dequeuedCounter.incrementAndGet();
            }
            return polled;
        }
        return a;
    }

    @Override
    public boolean isEmpty() {
        return this.jucConcurrentQueue.isEmpty();
    }

    @Override
    public boolean isFull() {
        return false;
    }
}

