/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import scala.Product;
import scala.collection.Iterable;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import zio.Chunk;
import zio.Chunk$;
import zio.internal.BoundedHubSingle$State$;
import zio.internal.Hub;

public final class BoundedHubSingle<A>
extends Hub<A> {
    public final AtomicReference<State<A>> zio$internal$BoundedHubSingle$$state = new AtomicReference<State<Object>>(BoundedHubSingle$State$.MODULE$.apply(0, 0, 0, null));
    private final int capacity;

    public BoundedHubSingle() {
        this.capacity = 1;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public boolean isEmpty() {
        State<A> currentState = this.zio$internal$BoundedHubSingle$$state.get();
        int currentSubscribers = currentState.subscribers();
        return currentSubscribers == 0;
    }

    @Override
    public boolean isFull() {
        State<A> currentState = this.zio$internal$BoundedHubSingle$$state.get();
        int currentSubscribers = currentState.subscribers();
        return currentSubscribers != 0;
    }

    @Override
    public boolean publish(A a) {
        boolean loop = true;
        boolean published = true;
        while (loop) {
            int n;
            State<A> currentState = this.zio$internal$BoundedHubSingle$$state.get();
            int currentSubscriberCount = currentState.subscriberCount();
            int currentSubscribers = currentState.subscribers();
            if (currentSubscribers != 0) {
                loop = false;
                published = false;
                continue;
            }
            if (currentSubscriberCount == 0) {
                loop = false;
                continue;
            }
            int currentPublisherIndex = currentState.publisherIndex();
            int n2 = currentPublisherIndex + 1;
            State<A> updatedState = currentState.copy(n2, n = currentState.copy$default$2(), currentSubscriberCount, a);
            loop = !this.zio$internal$BoundedHubSingle$$state.compareAndSet(currentState, updatedState);
        }
        return published;
    }

    @Override
    public <A1 extends A> Chunk<A1> publishAll(Iterable<A1> as) {
        if (as.isEmpty()) {
            return Chunk$.MODULE$.empty();
        }
        Object a = as.head();
        if (this.publish(a)) {
            return Chunk$.MODULE$.fromIterable((Iterable)as.tail());
        }
        return Chunk$.MODULE$.fromIterable(as);
    }

    @Override
    public int size() {
        State<A> currentState = this.zio$internal$BoundedHubSingle$$state.get();
        int currentSubscribers = currentState.subscribers();
        if (currentSubscribers == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public void slide() {
        boolean loop = true;
        while (loop) {
            int n;
            State<A> currentState = this.zio$internal$BoundedHubSingle$$state.get();
            int currentSubscribers = currentState.subscribers();
            if (currentSubscribers == 0) {
                loop = false;
                continue;
            }
            Object a = null;
            int n2 = currentState.copy$default$1();
            State<Object> updatedState = currentState.copy(n2, n = currentState.copy$default$2(), 0, a);
            loop = !this.zio$internal$BoundedHubSingle$$state.compareAndSet(currentState, updatedState);
        }
    }

    @Override
    public Hub.Subscription<A> subscribe() {
        return new Hub.Subscription<A>(this){
            private final AtomicInteger subscriberIndex;
            private final AtomicBoolean unsubscribed;
            private final /* synthetic */ BoundedHubSingle $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                int currentPublisherIndex = 0;
                boolean loop = true;
                while (loop) {
                    A a;
                    int n;
                    State<A> currentState = $outer.zio$internal$BoundedHubSingle$$state.get();
                    int currentSubscriberCount = currentState.subscriberCount();
                    int n2 = currentSubscriberCount + 1;
                    int n3 = currentState.copy$default$1();
                    State<A> updatedState = currentState.copy(n3, n2, n = currentState.copy$default$3(), a = currentState.copy$default$4());
                    if (!$outer.zio$internal$BoundedHubSingle$$state.compareAndSet(currentState, updatedState)) continue;
                    currentPublisherIndex = currentState.publisherIndex();
                    loop = false;
                }
                this.subscriberIndex = new AtomicInteger(currentPublisherIndex);
                this.unsubscribed = new AtomicBoolean(false);
            }

            public boolean isEmpty() {
                int currentSubscriberIndex;
                if (this.unsubscribed.get()) {
                    return true;
                }
                State<A> currentState = this.$outer.zio$internal$BoundedHubSingle$$state.get();
                int currentSubscribers = currentState.subscribers();
                if (currentSubscribers == 0) {
                    return true;
                }
                int currentPublisherIndex = currentState.publisherIndex();
                return currentPublisherIndex == (currentSubscriberIndex = this.subscriberIndex.get());
            }

            public Object poll(Object object) {
                if (this.unsubscribed.get()) {
                    return object;
                }
                int currentSubscriberIndex = this.subscriberIndex.get();
                boolean loop = true;
                Object polled = object;
                while (loop) {
                    State<A> currentState = this.$outer.zio$internal$BoundedHubSingle$$state.get();
                    int currentPublisherIndex = currentState.publisherIndex();
                    int currentSubscribers = currentState.subscribers();
                    if (currentSubscribers == 0 || currentSubscriberIndex == currentPublisherIndex) {
                        loop = false;
                        continue;
                    }
                    if (this.subscriberIndex.compareAndSet(currentSubscriberIndex, currentPublisherIndex)) {
                        currentSubscriberIndex = currentPublisherIndex;
                        boolean bl = true;
                        while (bl) {
                            State<Object> updatedState;
                            State<Object> state;
                            A currentValue = currentState.value();
                            if (currentSubscribers == 1) {
                                State<A> state2 = currentState;
                                A a = null;
                                int n = state2.copy$default$1();
                                int n2 = state2.copy$default$2();
                                state = state2.copy(n, n2, 0, a);
                            } else {
                                State<A> state3 = currentState;
                                int n = currentSubscribers - 1;
                                int n3 = state3.copy$default$1();
                                int n4 = state3.copy$default$2();
                                A a = state3.copy$default$4();
                                state = updatedState = state3.copy(n3, n4, n, a);
                            }
                            if (this.$outer.zio$internal$BoundedHubSingle$$state.compareAndSet(currentState, updatedState)) {
                                bl = false;
                                loop = false;
                                polled = currentValue;
                                continue;
                            }
                            currentState = this.$outer.zio$internal$BoundedHubSingle$$state.get();
                            currentPublisherIndex = currentState.publisherIndex();
                            currentSubscribers = currentState.subscribers();
                            if (currentSubscribers == 0) {
                                bl = false;
                                loop = false;
                                continue;
                            }
                            if (currentSubscriberIndex == currentPublisherIndex) continue;
                            bl = false;
                        }
                        continue;
                    }
                    ++currentSubscriberIndex;
                }
                return polled;
            }

            public Chunk pollUpTo(int n) {
                if (n < 1) {
                    return Chunk$.MODULE$.empty();
                }
                Object default_ = null;
                Object a = this.poll((Object)default_);
                if (BoxesRunTime.equals((Object)a, default_)) {
                    return Chunk$.MODULE$.empty();
                }
                return Chunk$.MODULE$.single(a);
            }

            public int size() {
                int currentSubscriberIndex;
                if (this.unsubscribed.get()) {
                    return 0;
                }
                State<A> currentState = this.$outer.zio$internal$BoundedHubSingle$$state.get();
                int currentSubscribers = currentState.subscribers();
                if (currentSubscribers == 0) {
                    return 0;
                }
                int currentPublisherIndex = currentState.publisherIndex();
                if (currentPublisherIndex == (currentSubscriberIndex = this.subscriberIndex.get())) {
                    return 0;
                }
                return 1;
            }

            public void unsubscribe() {
                if (this.unsubscribed.compareAndSet(false, true)) {
                    int currentSubscriberIndex = this.subscriberIndex.getAndAdd(Integer.MAX_VALUE);
                    boolean loop = true;
                    while (loop) {
                        State<Object> state;
                        State<A> currentState = this.$outer.zio$internal$BoundedHubSingle$$state.get();
                        int currentPublisherIndex = currentState.publisherIndex();
                        int currentSubscriberCount = currentState.subscriberCount();
                        int currentSubscribers = currentState.subscribers();
                        if (currentSubscribers == 0 || currentSubscriberIndex == currentPublisherIndex) {
                            int n = currentSubscriberCount - 1;
                            int n2 = currentState.copy$default$1();
                            int n3 = currentState.copy$default$3();
                            A a = currentState.copy$default$4();
                            state = currentState.copy(n2, n, n3, a);
                        } else if (currentSubscribers == 1) {
                            int n = currentSubscriberCount - 1;
                            A a = null;
                            int n4 = currentState.copy$default$1();
                            state = currentState.copy(n4, n, 0, a);
                        } else {
                            int n = currentSubscriberCount - 1;
                            int n5 = currentSubscribers - 1;
                            int n6 = currentState.copy$default$1();
                            A a = currentState.copy$default$4();
                            state = currentState.copy(n6, n, n5, a);
                        }
                        State<Object> updatedState = state;
                        loop = !this.$outer.zio$internal$BoundedHubSingle$$state.compareAndSet(currentState, updatedState);
                    }
                    return;
                }
            }
        };
    }

    public static final class State<A>
    implements Product,
    Serializable {
        private final int publisherIndex;
        private final int subscriberCount;
        private final int subscribers;
        private final Object value;

        public static <A> State<A> apply(int n, int n2, int n3, A a) {
            return BoundedHubSingle$State$.MODULE$.apply(n, n2, n3, a);
        }

        public static State<?> fromProduct(Product product) {
            return BoundedHubSingle$State$.MODULE$.fromProduct(product);
        }

        public static <A> State<A> unapply(State<A> state) {
            return BoundedHubSingle$State$.MODULE$.unapply(state);
        }

        public State(int publisherIndex, int subscriberCount, int subscribers, A value) {
            this.publisherIndex = publisherIndex;
            this.subscriberCount = subscriberCount;
            this.subscribers = subscribers;
            this.value = value;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.publisherIndex());
            n = Statics.mix((int)n, (int)this.subscriberCount());
            n = Statics.mix((int)n, (int)this.subscribers());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.value()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.publisherIndex() != state.publisherIndex()) return false;
            if (this.subscriberCount() != state.subscriberCount()) return false;
            if (this.subscribers() != state.subscribers()) return false;
            if (!BoxesRunTime.equals(this.value(), state.value())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "publisherIndex";
                }
                case 1: {
                    return "subscriberCount";
                }
                case 2: {
                    return "subscribers";
                }
                case 3: {
                    return "value";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int publisherIndex() {
            return this.publisherIndex;
        }

        public int subscriberCount() {
            return this.subscriberCount;
        }

        public int subscribers() {
            return this.subscribers;
        }

        public A value() {
            return (A)this.value;
        }

        public <A> State<A> copy(int publisherIndex, int subscriberCount, int subscribers, A value) {
            return new State<A>(publisherIndex, subscriberCount, subscribers, value);
        }

        public int copy$default$1() {
            return this.publisherIndex();
        }

        public int copy$default$2() {
            return this.subscriberCount();
        }

        public int copy$default$3() {
            return this.subscribers();
        }

        public <A> A copy$default$4() {
            return this.value();
        }

        public int _1() {
            return this.publisherIndex();
        }

        public int _2() {
            return this.subscriberCount();
        }

        public int _3() {
            return this.subscribers();
        }

        public A _4() {
            return this.value();
        }
    }
}

