/*
 * Decompiled with CFR 0.152.
 */
package zio;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.Chunk$;
import zio.Dequeue;
import zio.Enqueue;
import zio.Exit$;
import zio.FiberId;
import zio.Promise;
import zio.Promise$unsafe$;
import zio.Queue$;
import zio.Queue$Strategy$;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.internal.MutableConcurrentQueue;

public abstract class Queue<A>
extends Dequeue.Internal<A>
implements Enqueue.Internal<A> {
    public static <A> ZIO<Object, Nothing$, Queue<A>> bounded(Function0<Object> function0, Object object) {
        return Queue$.MODULE$.bounded(function0, object);
    }

    public static <A> ZIO<Object, Nothing$, Queue<A>> dropping(Function0<Object> function0, Object object) {
        return Queue$.MODULE$.dropping(function0, object);
    }

    public static <A> ZIO<Object, Nothing$, Queue<A>> sliding(Function0<Object> function0, Object object) {
        return Queue$.MODULE$.sliding(function0, object);
    }

    public static <A> ZIO<Object, Nothing$, Queue<A>> unbounded(Object object) {
        return Queue$.MODULE$.unbounded(object);
    }

    @Override
    public final ZIO<Object, Nothing$, Object> isEmpty(Object trace) {
        return this.size(trace).map((JFunction1.mcZI.sp & Serializable)_$1 -> _$1 <= 0, trace);
    }

    @Override
    public final ZIO<Object, Nothing$, Object> isFull(Object trace) {
        return this.size(trace).map((JFunction1.mcZI.sp & Serializable)_$2 -> _$2 >= this.capacity(), trace);
    }

    public static abstract class Internal<A>
    extends Queue<A> {
    }

    public static final class QueueImpl<A>
    extends Queue<A> {
        private final MutableConcurrentQueue<A> queue;
        private final ConcurrentLinkedDeque<Promise<Nothing$, A>> takers;
        private final Promise<Nothing$, BoxedUnit> shutdownHook;
        private final AtomicBoolean shutdownFlag;
        private final Strategy<A> strategy;

        public QueueImpl(MutableConcurrentQueue<A> queue, ConcurrentLinkedDeque<Promise<Nothing$, A>> takers, Promise<Nothing$, BoxedUnit> shutdownHook, AtomicBoolean shutdownFlag, Strategy<A> strategy) {
            this.queue = queue;
            this.takers = takers;
            this.shutdownHook = shutdownHook;
            this.shutdownFlag = shutdownFlag;
            this.strategy = strategy;
        }

        private ZIO<Object, Nothing$, BoxedUnit> removeTaker(Promise<Nothing$, A> taker, Object trace) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (JFunction0.mcV.sp & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                this.takers.remove(taker);
            });
        }

        @Override
        public int capacity() {
            return this.queue.capacity();
        }

        @Override
        public ZIO<Object, Nothing$, Object> offer(A a, Object trace) {
            return ZIO$.MODULE$.suspendSucceed(() -> this.offer$$anonfun$1(trace, a), trace);
        }

        @Override
        public <A1 extends A> ZIO<Object, Nothing$, Chunk<A1>> offerAll(Iterable<A1> as, Object trace) {
            return ZIO$.MODULE$.suspendSucceed(() -> this.offerAll$$anonfun$1(trace, as), trace);
        }

        @Override
        public ZIO<Object, Nothing$, BoxedUnit> awaitShutdown(Object trace) {
            return this.shutdownHook.await(trace);
        }

        @Override
        public ZIO<Object, Nothing$, Object> size(Object trace) {
            return ZIO$.MODULE$.suspendSucceed(() -> this.size$$anonfun$1(trace), trace);
        }

        @Override
        public ZIO<Object, Nothing$, BoxedUnit> shutdown(Object trace) {
            return ZIO$.MODULE$.fiberIdWith((Function1 & Serializable)fiberId -> {
                if (this.shutdownFlag.compareAndSet(false, true)) {
                    Unsafe$ unsafe2 = Unsafe$.MODULE$;
                    this.shutdownHook.unsafe().succeedUnit($less$colon$less$.MODULE$.refl(), trace, unsafe2);
                    Iterator it = Queue$.MODULE$.zio$Queue$$$unsafePollAll(this.takers).iterator();
                    while (it.hasNext()) {
                        ((Promise)it.next()).unsafe().interruptAs((FiberId)fiberId, trace, unsafe2);
                    }
                    this.strategy.shutdown((FiberId)fiberId, trace, unsafe2);
                }
                return Exit$.MODULE$.unit();
            }, trace).uninterruptible(trace);
        }

        @Override
        public ZIO<Object, Nothing$, Object> isShutdown(Object trace) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return this.shutdownFlag.get();
            });
        }

        @Override
        public ZIO<Object, Nothing$, A> take(Object trace) {
            return ZIO$.MODULE$.fiberIdWith((Function1 & Serializable)fiberId -> {
                if (this.shutdownFlag.get()) {
                    return ZIO$.MODULE$.interrupt(trace);
                }
                Object a = this.queue.poll(null);
                if (a == null) {
                    Promise p = Promise$unsafe$.MODULE$.make((FiberId)fiberId, Unsafe$.MODULE$.unsafe());
                    return ZIO$.MODULE$.suspendSucceed(() -> this.take$$anonfun$1$$anonfun$1(p, trace), trace).onInterrupt(() -> this.take$$anonfun$1$$anonfun$2(p, trace), trace);
                }
                Object item = a;
                this.strategy.unsafeOnQueueEmptySpace(this.queue, this.takers);
                return Exit$.MODULE$.succeed(item);
            }, trace);
        }

        @Override
        public ZIO<Object, Nothing$, Chunk<A>> takeAll(Object trace) {
            return ZIO$.MODULE$.suspendSucceed(() -> this.takeAll$$anonfun$1(trace), trace);
        }

        @Override
        public ZIO<Object, Nothing$, Chunk<A>> takeUpTo(int max, Object trace) {
            return ZIO$.MODULE$.suspendSucceed(() -> this.takeUpTo$$anonfun$1(trace, max), trace);
        }

        @Override
        public ZIO<Object, Nothing$, Option<A>> poll(Object trace) {
            return ZIO$.MODULE$.suspendSucceed(() -> this.poll$$anonfun$1(trace), trace);
        }

        private final ZIO offer$$anonfun$1(Object trace$1, Object a$1) {
            boolean noRemaining;
            boolean bl;
            if (this.shutdownFlag.get()) {
                return ZIO$.MODULE$.interrupt(trace$1);
            }
            if (this.queue.isEmpty()) {
                Promise<Nothing$, A> taker = this.takers.poll();
                if (taker == null) {
                    bl = false;
                } else {
                    Queue$.MODULE$.zio$Queue$$$unsafeCompletePromise(taker, a$1);
                    bl = true;
                }
            } else {
                bl = noRemaining = false;
            }
            if (noRemaining) {
                return Exit$.MODULE$.true();
            }
            boolean succeeded = this.queue.offer(a$1);
            if (succeeded) {
                this.strategy.unsafeCompleteTakers(this.queue, this.takers);
                return Exit$.MODULE$.true();
            }
            return this.strategy.handleSurplus((Iterable<Object>)Chunk$.MODULE$.single(a$1), (MutableConcurrentQueue<Object>)this.queue, (ConcurrentLinkedDeque<Promise<Nothing$, Object>>)this.takers, this.shutdownFlag, trace$1);
        }

        private final ZIO offerAll$$anonfun$1(Object trace$2, Iterable as$1) {
            if (this.shutdownFlag.get()) {
                return ZIO$.MODULE$.interrupt(trace$2);
            }
            Chunk<Promise<Nothing$, A>> pTakers = this.queue.isEmpty() ? Queue$.MODULE$.zio$Queue$$$unsafePollN(this.takers, as$1.size()) : Chunk$.MODULE$.empty();
            Tuple2 tuple2 = as$1.splitAt(pTakers.size());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Iterable forTakers = (Iterable)tuple2._1();
            Iterable remaining = (Iterable)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)forTakers, (Object)remaining);
            Iterable forTakers2 = (Iterable)tuple22._1();
            Iterable remaining2 = (Iterable)tuple22._2();
            ((IterableOnceOps)pTakers.zip((IterableOnce)forTakers2)).foreach((Function1)((JProcedure1 & Serializable)Queue$::zio$Queue$QueueImpl$$_$offerAll$$anonfun$1$$anonfun$1));
            if (remaining2.isEmpty()) {
                return Exit$.MODULE$.emptyChunk();
            }
            Chunk surplus = Queue$.MODULE$.zio$Queue$$$unsafeOfferAll(this.queue, remaining2);
            if (surplus.isEmpty()) {
                this.strategy.unsafeCompleteTakers(this.queue, this.takers);
                return Exit$.MODULE$.emptyChunk();
            }
            return this.strategy.handleSurplus(surplus, this.queue, this.takers, this.shutdownFlag, trace$2).map(arg_0 -> Queue$.zio$Queue$QueueImpl$$_$offerAll$$anonfun$1$$anonfun$adapted$1(surplus, arg_0), trace$2);
        }

        private final ZIO size$$anonfun$1(Object trace$3) {
            if (this.shutdownFlag.get()) {
                return ZIO$.MODULE$.interrupt(trace$3);
            }
            return Exit$.MODULE$.succeed(BoxesRunTime.boxToInteger((int)(this.queue.size() - this.takers.size() + this.strategy.surplusSize())));
        }

        private final ZIO take$$anonfun$1$$anonfun$1(Promise p$1, Object trace$6) {
            this.takers.offer(p$1);
            this.strategy.unsafeCompleteTakers(this.queue, this.takers);
            if (this.shutdownFlag.get()) {
                return ZIO$.MODULE$.interrupt(trace$6);
            }
            return p$1.await(trace$6);
        }

        private final ZIO take$$anonfun$1$$anonfun$2(Promise p$2, Object trace$7) {
            return this.removeTaker(p$2, trace$7);
        }

        private final ZIO takeAll$$anonfun$1(Object trace$8) {
            if (this.shutdownFlag.get()) {
                return ZIO$.MODULE$.interrupt(trace$8);
            }
            Chunk<A> as = Queue$.MODULE$.zio$Queue$$$unsafePollAll(this.queue);
            if (!as.isEmpty()) {
                this.strategy.unsafeOnQueueEmptySpace(this.queue, this.takers);
                return Exit$.MODULE$.succeed(as);
            }
            return Exit$.MODULE$.emptyChunk();
        }

        private final ZIO takeUpTo$$anonfun$1(Object trace$9, int max$1) {
            if (this.shutdownFlag.get()) {
                return ZIO$.MODULE$.interrupt(trace$9);
            }
            Chunk<A> as = Queue$.MODULE$.zio$Queue$$$unsafePollN(this.queue, max$1);
            if (!as.isEmpty()) {
                this.strategy.unsafeOnQueueEmptySpace(this.queue, this.takers);
                return Exit$.MODULE$.succeed(as);
            }
            return Exit$.MODULE$.emptyChunk();
        }

        private final ZIO poll$$anonfun$1(Object trace$10) {
            if (this.shutdownFlag.get()) {
                return ZIO$.MODULE$.interrupt(trace$10);
            }
            Object var2_2 = this.queue.poll(null);
            if (var2_2 == null) {
                return Exit$.MODULE$.none();
            }
            Object v = var2_2;
            this.strategy.unsafeOnQueueEmptySpace(this.queue, this.takers);
            return Exit$.MODULE$.succeed(Some$.MODULE$.apply(v));
        }
    }

    public static abstract class Strategy<A> {
        private final AtomicBoolean draining = new AtomicBoolean(false);

        public static int ordinal(Strategy<?> strategy) {
            return Queue$Strategy$.MODULE$.ordinal(strategy);
        }

        public abstract ZIO<Object, Nothing$, Object> handleSurplus(Iterable<A> var1, MutableConcurrentQueue<A> var2, ConcurrentLinkedDeque<Promise<Nothing$, A>> var3, AtomicBoolean var4, Object var5);

        public abstract void unsafeOnQueueEmptySpace(MutableConcurrentQueue<A> var1, ConcurrentLinkedDeque<Promise<Nothing$, A>> var2);

        public abstract int surplusSize();

        public abstract void shutdown(FiberId var1, Object var2, Unsafe var3);

        public final void unsafeCompleteTakers(MutableConcurrentQueue<A> queue, ConcurrentLinkedDeque<Promise<Nothing$, A>> takers) {
            while (!takers.isEmpty() && this.draining.compareAndSet(false, true)) {
                try {
                    boolean keepPolling = !queue.isEmpty();
                    Object empty = null;
                    boolean notifyEmptySpace = false;
                    while (keepPolling) {
                        Promise<Nothing$, A> taker = takers.poll();
                        if (taker == null) {
                            keepPolling = false;
                            continue;
                        }
                        Object a = queue.poll(empty);
                        if (a == null) {
                            takers.addFirst(taker);
                            keepPolling = false;
                            continue;
                        }
                        Object a2 = a;
                        Queue$.MODULE$.zio$Queue$$$unsafeCompletePromise(taker, a2);
                        notifyEmptySpace = true;
                    }
                    if (notifyEmptySpace) {
                        this.unsafeOnQueueEmptySpace(queue, takers);
                    }
                }
                finally {
                    this.draining.set(false);
                }
                if (!queue.isEmpty()) continue;
                return;
            }
        }
    }
}

