/*
 * Decompiled with CFR 0.152.
 */
package zio.internal.metrics;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.Chunk$;
import zio.Chunk$Empty$;
import zio.ChunkBuilder;
import zio.ChunkBuilder$;
import zio.ChunkLike;
import zio.internal.metrics.AddersVersionSpecific;
import zio.internal.metrics.AtomicDouble;
import zio.internal.metrics.AtomicDouble$;
import zio.internal.metrics.ConcurrentMetricHooks;
import zio.internal.metrics.MetricHook;
import zio.internal.metrics.package$;
import zio.metrics.MetricKey;
import zio.metrics.MetricKeyType;
import zio.metrics.MetricKeyType$Counter$;
import zio.metrics.MetricKeyType$Frequency$;
import zio.metrics.MetricKeyType$Gauge$;
import zio.metrics.MetricState;

@ScalaSignature(bytes="\u0006\u0005=4QAC\u0006\u0001\u001fEAQa\b\u0001\u0005\u0002\u0005BQa\t\u0001\u0005\u0002\u0011BQA\u000e\u0001\u0005\n]BQ!\u0012\u0001\u0005\u0002\u0019CQa\u0014\u0001\u0005\nACQa\u0015\u0001\u0005\nQCQa\u0016\u0001\u0005\u0002aCQa\u0018\u0001\u0005\u0002\u0001DQa\u001a\u0001\u0005\u0002!\u0014QeQ8oGV\u0014(/\u001a8u\u001b\u0016$(/[2I_>\\7\u000f\u00157bi\u001a|'/\\*qK\u000eLg-[2\u000b\u00051i\u0011aB7fiJL7m\u001d\u0006\u0003\u001d=\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0002!\u0005\u0019!0[8\u0014\t\u0001\u0011\u0002\u0004\b\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005eQR\"A\u0006\n\u0005mY!!F\"p]\u000e,(O]3oi6+GO]5d\u0011>|7n\u001d\t\u00033uI!AH\u0006\u0003+\u0005#G-\u001a:t-\u0016\u00148/[8o'B,7-\u001b4jG\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001#!\tI\u0002!A\u0004d_VtG/\u001a:\u0015\u0005\u0015b\u0003C\u0001\u0014*\u001d\tIr%\u0003\u0002)\u0017\u0005QQ*\u001a;sS\u000eDun\\6\n\u0005)Z#aB\"pk:$XM\u001d\u0006\u0003Q-AQ!\f\u0002A\u00029\n1a[3z!\tyCG\u0004\u00021e5\t\u0011G\u0003\u0002\r\u001f%\u00111'M\u0001\n\u001b\u0016$(/[2LKfL!AK\u001b\u000b\u0005M\n\u0014aC5oGJ,W.\u001a8u\u0005f$2\u0001O\u001eA!\t\u0019\u0012(\u0003\u0002;)\t!QK\\5u\u0011\u0015a4\u00011\u0001>\u0003\u0019\tGo\\7jGB\u0011\u0011DP\u0005\u0003\u007f-\u0011A\"\u0011;p[&\u001cGi\\;cY\u0016DQ!Q\u0002A\u0002\t\u000bQA^1mk\u0016\u0004\"aE\"\n\u0005\u0011#\"A\u0002#pk\ndW-A\u0003hCV<W\rF\u0002H\u00156\u0003\"A\n%\n\u0005%[#!B$bk\u001e,\u0007\"B\u0017\u0005\u0001\u0004Y\u0005CA\u0018M\u0013\tIU\u0007C\u0003O\t\u0001\u0007!)A\u0004ti\u0006\u0014H/\u0011;\u0002\u0013U\u0004H-\u0019;f\u001b&tGc\u0001\u001dR%\")A(\u0002a\u0001{!)\u0011)\u0002a\u0001\u0005\u0006IQ\u000f\u001d3bi\u0016l\u0015\r\u001f\u000b\u0004qU3\u0006\"\u0002\u001f\u0007\u0001\u0004i\u0004\"B!\u0007\u0001\u0004\u0011\u0015!\u00035jgR|wM]1n)\tIF\f\u0005\u0002'5&\u00111l\u000b\u0002\n\u0011&\u001cHo\\4sC6DQ!L\u0004A\u0002u\u0003\"a\f0\n\u0005m+\u0014aB:v[6\f'/\u001f\u000b\u0003C\u0012\u0004\"A\n2\n\u0005\r\\#aB*v[6\f'/\u001f\u0005\u0006[!\u0001\r!\u001a\t\u0003_\u0019L!aY\u001b\u0002\u0013\u0019\u0014X-];f]\u000eLHCA5m!\t1#.\u0003\u0002lW\tIaI]3rk\u0016t7-\u001f\u0005\u0006[%\u0001\r!\u001c\t\u0003_9L!a[\u001b")
public class ConcurrentMetricHooksPlatformSpecific
implements ConcurrentMetricHooks,
AddersVersionSpecific {
    @Override
    public MetricHook<Object, MetricState.Counter> counter(MetricKey<MetricKeyType$Counter$> key) {
        DoubleAdder adder = new DoubleAdder();
        return new MetricHook<Object, MetricState.Counter>((Function1<Object, BoxedUnit>)(JFunction1.mcVD.sp & Serializable)v -> adder.add(v), (Function0<MetricState.Counter>)(Function0 & Serializable)() -> new MetricState.Counter(adder.sum()), (Function1<Object, BoxedUnit>)(JFunction1.mcVD.sp & Serializable)v -> adder.add(v));
    }

    private void incrementBy(AtomicDouble atomic, double value) {
        boolean loop = true;
        while (loop) {
            double current = atomic.get();
            loop = !atomic.compareAndSet(current, current + value);
        }
    }

    @Override
    public MetricHook<Object, MetricState.Gauge> gauge(MetricKey<MetricKeyType$Gauge$> key, double startAt) {
        AtomicDouble ref = AtomicDouble$.MODULE$.make(startAt);
        return new MetricHook<Object, MetricState.Gauge>((Function1<Object, BoxedUnit>)(JFunction1.mcVD.sp & Serializable)v -> ref.set(v), (Function0<MetricState.Gauge>)(Function0 & Serializable)() -> new MetricState.Gauge(ref.get()), (Function1<Object, BoxedUnit>)(JFunction1.mcVD.sp & Serializable)v -> this.incrementBy(ref, v));
    }

    private void updateMin(AtomicDouble atomic, double value) {
        boolean loop = true;
        while (loop) {
            double current = atomic.get();
            if (value < current) {
                loop = !atomic.compareAndSet(current, value);
                continue;
            }
            loop = false;
        }
    }

    private void updateMax(AtomicDouble atomic, double value) {
        boolean loop = true;
        while (loop) {
            double current = atomic.get();
            if (value > current) {
                loop = !atomic.compareAndSet(current, value);
                continue;
            }
            loop = false;
        }
    }

    @Override
    public MetricHook<Object, MetricState.Histogram> histogram(MetricKey<MetricKeyType.Histogram> key) {
        Chunk<Object> bounds = key.keyType().boundaries().values();
        AtomicLongArray values = new AtomicLongArray(bounds.length() + 1);
        double[] boundaries = new double[bounds.length()];
        LongAdder count = new LongAdder();
        DoubleAdder sum = new DoubleAdder();
        int size = bounds.length();
        AtomicDouble min = AtomicDouble$.MODULE$.make(Double.MAX_VALUE);
        AtomicDouble max = AtomicDouble$.MODULE$.make(-1.7976931348623157E308);
        Ordering.DeprecatedDoubleOrdering$ sorted_ord = Ordering.DeprecatedDoubleOrdering$.MODULE$;
        Chunk chunk = ChunkLike.sorted$(bounds, (Ordering)sorted_ord);
        Object var11_10 = null;
        if (chunk == null) {
            throw null;
        }
        chunk.zipWithIndexFrom(0).foreach((Function1 & Serializable)x0$1 -> {
            ConcurrentMetricHooksPlatformSpecific.$anonfun$histogram$1(boundaries, x0$1);
            return BoxedUnit.UNIT;
        });
        JFunction1.mcVD.sp & Serializable update = (JFunction1.mcVD.sp & Serializable)value -> {
            int from = 0;
            int to = size;
            while (from != to) {
                int mid = from + (to - from) / 2;
                double boundary = boundaries[mid];
                if (value <= boundary) {
                    to = mid;
                } else {
                    from = mid;
                }
                if (to != from + 1) continue;
                if (value <= boundaries[from]) {
                    to = from;
                    continue;
                }
                from = to;
            }
            values.getAndIncrement(from);
            count.increment();
            sum.add(value);
            this.updateMin(min, value);
            this.updateMax(max, value);
        };
        return new MetricHook<Object, MetricState.Histogram>((Function1<Object, BoxedUnit>)update, (Function0<MetricState.Histogram>)(Function0 & Serializable)() -> new MetricState.Histogram(ConcurrentMetricHooksPlatformSpecific.getBuckets$1(size, boundaries, values), count.longValue(), min.get(), max.get(), sum.sum()), (Function1<Object, BoxedUnit>)update);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MetricHook<Tuple2<Object, Instant>, MetricState.Summary> summary(MetricKey<MetricKeyType.Summary> key) {
        void sorted_ord;
        AtomicReferenceArray values = new AtomicReferenceArray(key.keyType().maxSize());
        AtomicLong head = new AtomicLong(0L);
        LongAdder count = new LongAdder();
        DoubleAdder sum = new DoubleAdder();
        AtomicDouble min = AtomicDouble$.MODULE$.make(Double.MAX_VALUE);
        AtomicDouble max = AtomicDouble$.MODULE$.make(-1.7976931348623157E308);
        Chunk<Object> chunk = key.keyType().quantiles();
        Ordering<Object> ordering = package$.MODULE$.DoubleOrdering();
        if (chunk == null) {
            throw null;
        }
        Chunk<Object> sorted_this = chunk;
        Object var9_9 = null;
        ordering = null;
        Chunk sortedQuantiles = ChunkLike.sorted$(sorted_this, (Ordering)sorted_ord);
        return new MetricHook<Tuple2<Object, Instant>, MetricState.Summary>((Function1 & Serializable)x$2 -> {
            this.observe$1(x$2, key, head, values, count, sum, min, max);
            return BoxedUnit.UNIT;
        }, (Function0 & Serializable)() -> new MetricState.Summary(((MetricKeyType.Summary)key.keyType()).error(), ConcurrentMetricHooksPlatformSpecific.snapshot$1(Instant.now(), key, values, sortedQuantiles), count.longValue(), min.get(), max.get(), sum.sum()), (Function1 & Serializable)x$3 -> {
            this.observe$1(x$3, key, head, values, count, sum, min, max);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public MetricHook<String, MetricState.Frequency> frequency(MetricKey<MetricKeyType$Frequency$> key) {
        LongAdder count = new LongAdder();
        ConcurrentHashMap values = new ConcurrentHashMap();
        Function1 & Serializable update = (Function1 & Serializable)word -> {
            ConcurrentMetricHooksPlatformSpecific.$anonfun$frequency$1(count, values, word);
            return BoxedUnit.UNIT;
        };
        return new MetricHook<String, MetricState.Frequency>(update, (Function0 & Serializable)() -> new MetricState.Frequency((Map<String, Object>)ConcurrentMetricHooksPlatformSpecific.snapshot$2(values)), update);
    }

    public static final /* synthetic */ void $anonfun$histogram$1(double[] boundaries$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            double n = x0$1._1$mcD$sp();
            int i = x0$1._2$mcI$sp();
            boundaries$1[i] = n;
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Chunk getBuckets$1(int size$1, double[] boundaries$1, AtomicLongArray values$1) {
        var builder = new ChunkBuilder<A>(){
            private ArrayBuilder<A> arrayBuilder;
            private int size;

            private ArrayBuilder<A> arrayBuilder() {
                return this.arrayBuilder;
            }

            private void arrayBuilder_$eq(ArrayBuilder<A> x$1) {
                this.arrayBuilder = x$1;
            }

            private int size() {
                return this.size;
            }

            private void size_$eq(int x$1) {
                this.size = x$1;
            }

            public ChunkBuilder$.anon.1 addOne(A a) {
                if (this.arrayBuilder() == null) {
                    Object object;
                    ClassTag<A> tag = Chunk$.MODULE$.Tags().fromValue(a);
                    Class clazz = tag.runtimeClass();
                    Class<Byte> clazz2 = Byte.TYPE;
                    if (!(clazz2 != null ? !clazz2.equals(clazz) : clazz != null)) {
                        object = new ArrayBuilder.ofByte();
                    } else {
                        Class<Short> clazz3 = Short.TYPE;
                        if (!(clazz3 != null ? !clazz3.equals(clazz) : clazz != null)) {
                            object = new ArrayBuilder.ofShort();
                        } else {
                            Class<Character> clazz4 = Character.TYPE;
                            if (!(clazz4 != null ? !clazz4.equals(clazz) : clazz != null)) {
                                object = new ArrayBuilder.ofChar();
                            } else {
                                Class<Integer> clazz5 = Integer.TYPE;
                                if (!(clazz5 != null ? !clazz5.equals(clazz) : clazz != null)) {
                                    object = new ArrayBuilder.ofInt();
                                } else {
                                    Class<Long> clazz6 = Long.TYPE;
                                    if (!(clazz6 != null ? !clazz6.equals(clazz) : clazz != null)) {
                                        object = new ArrayBuilder.ofLong();
                                    } else {
                                        Class<Float> clazz7 = Float.TYPE;
                                        if (!(clazz7 != null ? !clazz7.equals(clazz) : clazz != null)) {
                                            object = new ArrayBuilder.ofFloat();
                                        } else {
                                            Class<Double> clazz8 = Double.TYPE;
                                            if (!(clazz8 != null ? !clazz8.equals(clazz) : clazz != null)) {
                                                object = new ArrayBuilder.ofDouble();
                                            } else {
                                                Class<Boolean> clazz9 = Boolean.TYPE;
                                                if (!(clazz9 != null ? !clazz9.equals(clazz) : clazz != null)) {
                                                    object = new ArrayBuilder.ofBoolean();
                                                } else {
                                                    Class<Void> clazz10 = Void.TYPE;
                                                    object = !(clazz10 != null ? !clazz10.equals(clazz) : clazz != null) ? new ArrayBuilder.ofUnit() : new ArrayBuilder.ofRef(tag);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    clazz = null;
                    this.arrayBuilder_$eq((ArrayBuilder<A>)object);
                    if (this.size() != -1) {
                        this.arrayBuilder().sizeHint(this.size());
                    }
                }
                try {
                    this.arrayBuilder().addOne(a);
                }
                catch (ClassCastException classCastException) {
                    Object object;
                    Object as = this.arrayBuilder().result();
                    ClassTag make_evidence$1 = ClassTag$.MODULE$.AnyRef();
                    Class clazz = make_evidence$1.runtimeClass();
                    Class<Byte> clazz11 = Byte.TYPE;
                    if (!(clazz11 != null ? !clazz11.equals(clazz) : clazz != null)) {
                        object = new ArrayBuilder.ofByte();
                    } else {
                        Class<Short> clazz12 = Short.TYPE;
                        if (!(clazz12 != null ? !clazz12.equals(clazz) : clazz != null)) {
                            object = new ArrayBuilder.ofShort();
                        } else {
                            Class<Character> clazz13 = Character.TYPE;
                            if (!(clazz13 != null ? !clazz13.equals(clazz) : clazz != null)) {
                                object = new ArrayBuilder.ofChar();
                            } else {
                                Class<Integer> clazz14 = Integer.TYPE;
                                if (!(clazz14 != null ? !clazz14.equals(clazz) : clazz != null)) {
                                    object = new ArrayBuilder.ofInt();
                                } else {
                                    Class<Long> clazz15 = Long.TYPE;
                                    if (!(clazz15 != null ? !clazz15.equals(clazz) : clazz != null)) {
                                        object = new ArrayBuilder.ofLong();
                                    } else {
                                        Class<Float> clazz16 = Float.TYPE;
                                        if (!(clazz16 != null ? !clazz16.equals(clazz) : clazz != null)) {
                                            object = new ArrayBuilder.ofFloat();
                                        } else {
                                            Class<Double> clazz17 = Double.TYPE;
                                            if (!(clazz17 != null ? !clazz17.equals(clazz) : clazz != null)) {
                                                object = new ArrayBuilder.ofDouble();
                                            } else {
                                                Class<Boolean> clazz18 = Boolean.TYPE;
                                                if (!(clazz18 != null ? !clazz18.equals(clazz) : clazz != null)) {
                                                    object = new ArrayBuilder.ofBoolean();
                                                } else {
                                                    Class<Void> clazz19 = Void.TYPE;
                                                    object = !(clazz19 != null ? !clazz19.equals(clazz) : clazz != null) ? new ArrayBuilder.ofUnit() : new ArrayBuilder.ofRef(make_evidence$1);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    Object var5_5 = null;
                    clazz = null;
                    this.arrayBuilder_$eq((ArrayBuilder<A>)object);
                    if (this.size() != -1) {
                        this.arrayBuilder().sizeHint(this.size());
                    }
                    this.arrayBuilder().addAll(as);
                    this.arrayBuilder().addOne(a);
                }
                return this;
            }

            public void clear() {
                if (this.arrayBuilder() != null) {
                    this.arrayBuilder().clear();
                    return;
                }
            }

            public Chunk<A> result() {
                if (this.arrayBuilder() == null) {
                    return Chunk$Empty$.MODULE$;
                }
                return Chunk$.MODULE$.fromArray(this.arrayBuilder().result());
            }

            public void sizeHint(int n) {
                if (this.arrayBuilder() == null) {
                    this.size_$eq(n);
                    return;
                }
                this.arrayBuilder().sizeHint(n);
            }

            public int knownSize() {
                if (this.arrayBuilder() == null) {
                    return -1;
                }
                return this.arrayBuilder().knownSize();
            }
            {
                this.arrayBuilder = null;
                this.size = -1;
            }
        };
        long cumulated = 0L;
        for (int i = 0; i != size$1; ++i) {
            void $minus$greater$extension_y;
            double boundary = boundaries$1[i];
            long value = values$1.get(i);
            Long l = cumulated += value;
            Double $minus$greater$extension_$this = boundary;
            Object var11_8 = null;
            l = null;
            Tuple2 $plus$eq_elem = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            builder.addOne($plus$eq_elem);
            Object var13_10 = null;
        }
        return builder.result();
    }

    private static final long getCount$1(LongAdder count$2) {
        return count$2.longValue();
    }

    private static final double getMin$1(AtomicDouble min$2) {
        return min$2.get();
    }

    private static final double getMax$1(AtomicDouble max$2) {
        return max$2.get();
    }

    private static final double getSum$1(DoubleAdder sum$2) {
        return sum$2.sum();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object $anonfun$summary$1(AtomicReferenceArray values$2, Instant now$1, MetricKey key$1, ChunkBuilder builder$1, int idx) {
        Tuple2 item = (Tuple2)values$2.get(idx);
        if (item != null) {
            void var8_7;
            double v = item._1$mcD$sp();
            Instant t = (Instant)item._2();
            Duration age = Duration.between((Temporal)var8_7, now$1);
            if (!age.isNegative() && age.compareTo(((MetricKeyType.Summary)key$1.keyType()).maxAge()) <= 0) {
                void $plus$eq_elem;
                void var6_6;
                Double d = (double)var6_6;
                if (builder$1 == null) {
                    throw null;
                }
                return builder$1.addOne($plus$eq_elem);
            }
            return BoxedUnit.UNIT;
        }
        return BoxedUnit.UNIT;
    }

    private static final Chunk snapshot$1(Instant now, MetricKey key$1, AtomicReferenceArray values$2, Chunk sortedQuantiles$1) {
        var builder = new /* invalid duplicate definition of identical inner class */;
        int n = 0;
        int until$extension_end = ((MetricKeyType.Summary)key$1.keyType()).maxSize();
        Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                ConcurrentMetricHooksPlatformSpecific.$anonfun$summary$1(values$2, now, key$1, builder, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var6_7 = null;
        return package$.MODULE$.calculateQuantiles(sortedQuantiles$1, builder.result().sorted(package$.MODULE$.DoubleOrdering()));
    }

    private final void observe$1(Tuple2 tuple, MetricKey key$1, AtomicLong head$1, AtomicReferenceArray values$2, LongAdder count$2, DoubleAdder sum$2, AtomicDouble min$2, AtomicDouble max$2) {
        if (((MetricKeyType.Summary)key$1.keyType()).maxSize() > 0) {
            int target = (int)(head$1.incrementAndGet() % (long)((MetricKeyType.Summary)key$1.keyType()).maxSize());
            values$2.set(target, tuple);
        }
        double value = tuple._1$mcD$sp();
        count$2.increment();
        sum$2.add(value);
        this.updateMin(min$2, value);
        this.updateMax(max$2, value);
    }

    public static final /* synthetic */ void $anonfun$frequency$1(LongAdder count$3, ConcurrentHashMap values$3, String word) {
        count$3.increment();
        LongAdder slot = (LongAdder)values$3.get(word);
        if (slot == null) {
            LongAdder cnt = new LongAdder();
            values$3.putIfAbsent(word, cnt);
            slot = (LongAdder)values$3.get(word);
        }
        slot.increment();
    }

    private static final Map snapshot$2(ConcurrentHashMap values$3) {
        scala.collection.mutable.Map builder = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        for (Map.Entry e : values$3.entrySet()) {
            builder.update(e.getKey(), (Object)((LongAdder)e.getValue()).longValue());
        }
        return builder.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ Object $anonfun$summary$1$adapted(AtomicReferenceArray values$2, Instant now$1, MetricKey key$1, ChunkBuilder builder$1, Object idx) {
        return ConcurrentMetricHooksPlatformSpecific.$anonfun$summary$1(values$2, now$1, key$1, builder$1, BoxesRunTime.unboxToInt((Object)idx));
    }
}

