/*
 * Decompiled with CFR 0.152.
 */
package zio.test;

import java.io.Serializable;
import scala.Byte$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Product;
import scala.Short$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import zio.Chunk;
import zio.NonEmptyChunk;
import zio.NonEmptyChunk$;
import zio.test.PrettyPrintVersionSpecific;

public final class PrettyPrint$
implements PrettyPrintVersionSpecific,
Serializable {
    public static final PrettyPrint$ MODULE$ = new PrettyPrint$();

    private PrettyPrint$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PrettyPrint$.class);
    }

    public String apply(Object any) {
        Object object = any;
        if (object == null) {
            return "<null>";
        }
        if (object instanceof String) {
            String string = (String)object;
            String surround = StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(string), '\n') ? "\"\"\"" : "\"";
            StringBuilder builder = new StringBuilder(string.length() + 2 * surround.length() + 16);
            builder.append(surround);
            builder.append(string.replace("\"", "\\\""));
            builder.append(surround);
            return builder.toString();
        }
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            return String.valueOf(n);
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            return String.valueOf(l);
        }
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            return String.valueOf(d);
        }
        if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            return String.valueOf(f);
        }
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            return String.valueOf(bl);
        }
        if (object instanceof Character) {
            char c = BoxesRunTime.unboxToChar((Object)object);
            char[] s = new char[]{'\'', c, '\''};
            return new String(s);
        }
        if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            return String.valueOf(Short$.MODULE$.short2int(s));
        }
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            return String.valueOf(Byte$.MODULE$.byte2int(by));
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            return bigDecimal.toString();
        }
        if (object instanceof BigInt) {
            BigInt bigInt = (BigInt)object;
            return bigInt.toString();
        }
        if (object instanceof Symbol) {
            Symbol symbol = (Symbol)object;
            return symbol.toString();
        }
        if (object instanceof Some) {
            Object a = ((Some)object).value();
            return "Some(" + this.apply(a) + ")";
        }
        if (None$.MODULE$.equals(object)) {
            return "None";
        }
        if (object == package$.MODULE$.Nil()) {
            return "Nil";
        }
        if (object instanceof Chunk) {
            Chunk chunk = (Chunk)object;
            return this.prettyPrintIterator((Iterable<?>)chunk, "Chunk");
        }
        if (object instanceof List) {
            List list = (List)object;
            return this.prettyPrintIterator((Iterable<?>)list, "List");
        }
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            return this.prettyPrintIterator((Iterable<?>)vector, "Vector");
        }
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object array = object;
            return this.prettyPrintIterator((Iterable<?>)Predef$.MODULE$.genericWrapArray(array), "Array");
        }
        if (object instanceof Set) {
            Set set = (Set)object;
            return this.prettyPrintIterator((Iterable<?>)set, "Set");
        }
        if (object instanceof NonEmptyChunk) {
            NonEmptyChunk nonEmptyChunk = (NonEmptyChunk)object;
            return this.prettyPrintIterator((Iterable<?>)NonEmptyChunk$.MODULE$.toChunk(nonEmptyChunk), "NonEmptyChunk");
        }
        if (object instanceof Seq) {
            Seq iterable = (Seq)object;
            return this.prettyPrintIterator((Iterable<?>)iterable, this.className(iterable));
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            scala.collection.immutable.Iterable body = (scala.collection.immutable.Iterable)map.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Object key = tuple2._1();
                    Object value = tuple2._2();
                    return MODULE$.apply(key) + " -> " + MODULE$.apply(value);
                }
                throw new MatchError((Object)tuple2);
            });
            return "Map(\n" + this.indent(body.mkString(",\n")) + "\n)";
        }
        if (object instanceof Product) {
            Product product = (Product)object;
            return this.prettyPrintProduct(product);
        }
        Object other = object;
        return other.toString();
    }

    private String prettyPrintIterator(Iterable<?> iterable, String className) {
        if (iterable.isEmpty()) {
            return className + "()";
        }
        StringBuilder acc = new StringBuilder(className.length() + 16 * iterable.size());
        acc.append(className);
        acc.append('(');
        Iterator iterator = iterable.iterator();
        acc.append(this.apply(iterator.next()));
        while (iterator.hasNext()) {
            acc.append(", ");
            acc.append(this.apply(iterator.next()));
        }
        acc.append(')');
        return acc.toString();
    }

    private String indent(String string) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])string.split("\n"));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)v -> "  " + v, ClassTag$.MODULE$.apply(String.class))).mkString("\n");
    }

    private String className(Object any) {
        return any.getClass().getSimpleName();
    }
}

