/*
 * Decompiled with CFR 0.152.
 */
package zio.test;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import zio.CanFail$;
import zio.IsSubtypeOfError$;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.internal.Platform$;
import zio.test.ExecutionEvent;
import zio.test.TestDebugFileLock;

public final class TestDebug$ {
    public static final TestDebug$ MODULE$ = new TestDebug$();
    private static final String outputDirectory = "target/test-reports-zio";
    private static final Set<String> tasks = Platform$.MODULE$.newConcurrentSet(Unsafe$.MODULE$.unsafe());

    private String outputDirectory() {
        return outputDirectory;
    }

    private String outputFileForTask(String task) {
        return this.outputDirectory() + "/" + task + "_debug.txt";
    }

    private Set<String> tasks() {
        return tasks;
    }

    private ZIO<Object, Nothing$, BoxedUnit> createDebugFile(String fullyQualifiedTaskName) {
        return ZIO$.MODULE$.succeed((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            if (MODULE$.tasks().add(fullyQualifiedTaskName)) {
                MODULE$.makeOutputDirectory();
                File file = new File(MODULE$.outputFileForTask(fullyQualifiedTaskName));
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                return;
            }
        }, (Object)"zio.test.TestDebug.createDebugFile(TestDebug.scala:14)");
    }

    private Path makeOutputDirectory() {
        return Files.createDirectories(Paths.get(this.outputDirectory(), new String[0]).getParent(), new FileAttribute[0]);
    }

    public ZIO<Object, Nothing$, BoxedUnit> deleteIfEmpty(String fullyQualifiedTaskName) {
        return ZIO$.MODULE$.succeed((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            if (MODULE$.tasks().remove(fullyQualifiedTaskName)) {
                File file = new File(MODULE$.outputFileForTask(fullyQualifiedTaskName));
                if (file.exists()) {
                    BufferedSource source = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec());
                    List nonBlankLines = source.getLines().filterNot((Function1 & Serializable)input -> BoxesRunTime.boxToBoolean((boolean)TestDebug$.MODULE$.isBlank(input))).toList();
                    source.close();
                    if (nonBlankLines.isEmpty()) {
                        file.delete();
                        return;
                    }
                    return;
                }
                return;
            }
        }, (Object)"zio.test.TestDebug.deleteIfEmpty(TestDebug.scala:28)");
    }

    private boolean isBlank(String input) {
        Object var2_2;
        char[] charArrayOps_xs = input.toCharArray();
        void v0 = var2_2;
        var2_2 = null;
        void forall$extension_$this = v0;
        for (int forall$extension_i = 0; forall$extension_i < ((void)forall$extension_$this).length; ++forall$extension_i) {
            if (BoxesRunTime.unboxToBoolean((Object)TestDebug$.$anonfun$isBlank$1$adapted(Character.valueOf((char)forall$extension_$this[forall$extension_i])))) continue;
            return false;
        }
        return true;
    }

    public ZIO<Object, Nothing$, BoxedUnit> print(ExecutionEvent executionEvent, TestDebugFileLock lock) {
        if (executionEvent instanceof ExecutionEvent.TestStarted) {
            ExecutionEvent.TestStarted testStarted = (ExecutionEvent.TestStarted)executionEvent;
            return this.createDebugFile(testStarted.fullyQualifiedName()).$times$greater((Function0 & Serializable)() -> {
                void mkString_end;
                void mkString_sep;
                List<String> list = testStarted.labels();
                String string = " - ";
                if (list == null) {
                    throw null;
                }
                List<String> mkString_this = list;
                String string2 = "";
                String mkString_start = "";
                Object var4_5 = null;
                string2 = null;
                Object var2_3 = null;
                string = null;
                return MODULE$.write(testStarted.fullyQualifiedName(), IterableOnceOps.mkString$(mkString_this, (String)mkString_start, (String)mkString_sep, (String)mkString_end) + " STARTED\n", true, lock);
            }, (Object)"zio.test.TestDebug.print(TestDebug.scala:48)");
        }
        if (executionEvent instanceof ExecutionEvent.Test) {
            ExecutionEvent.Test test = (ExecutionEvent.Test)executionEvent;
            return this.createDebugFile(test.fullyQualifiedName()).$times$greater((Function0 & Serializable)() -> {
                void mkString_end;
                void mkString_sep;
                List<String> list = test.labels();
                String string = " - ";
                if (list == null) {
                    throw null;
                }
                List<String> mkString_this = list;
                String string2 = "";
                String mkString_start = "";
                Object var4_5 = null;
                string2 = null;
                Object var2_3 = null;
                string = null;
                return MODULE$.removeLine(test.fullyQualifiedName(), IterableOnceOps.mkString$(mkString_this, (String)mkString_start, (String)mkString_sep, (String)mkString_end) + " STARTED", lock);
            }, (Object)"zio.test.TestDebug.print(TestDebug.scala:52)");
        }
        return ZIO$.MODULE$.unit();
    }

    private ZIO<Object, Nothing$, BoxedUnit> write(String fullyQualifiedTaskName, String content, boolean append, TestDebugFileLock lock) {
        return lock.updateFile((ZIO<Object, Nothing$, BoxedUnit>)ZIO.Acquire$.MODULE$.apply$extension(ZIO$.MODULE$.acquireReleaseWith((Function0 & Serializable)() -> ZIO$.MODULE$.attemptBlockingIO((Function0 & Serializable)() -> new FileWriter(MODULE$.outputFileForTask(fullyQualifiedTaskName), append), (Object)"zio.test.TestDebug.write(TestDebug.scala:67)")), (Function1 & Serializable)f -> ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcV.sp & Serializable)() -> f.close(), (Object)"zio.test.TestDebug.write(TestDebug.scala:68)").orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(), (Object)"zio.test.TestDebug.write(TestDebug.scala:68)")).apply((Function1 & Serializable)f -> ZIO$.MODULE$.attemptBlockingIO((Function0 & Serializable)() -> f.append(content), (Object)"zio.test.TestDebug.write(TestDebug.scala:69)"), (Object)"zio.test.TestDebug.write(TestDebug.scala:68)").ignore((Object)"zio.test.TestDebug.write(TestDebug.scala:71)"));
    }

    private ZIO<Object, Nothing$, BoxedUnit> removeLine(String fullyQualifiedTaskName, String searchString, TestDebugFileLock lock) {
        return lock.updateFile((ZIO<Object, Nothing$, BoxedUnit>)ZIO$.MODULE$.succeed((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            File file = new File(MODULE$.outputFileForTask(fullyQualifiedTaskName));
            if (file.exists()) {
                void mkString_end;
                void mkString_sep;
                BufferedSource source = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec());
                List remainingLines = source.getLines().filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains(searchString))).toList();
                PrintWriter pw = new PrintWriter(MODULE$.outputFileForTask(fullyQualifiedTaskName));
                String string = "\n";
                if (remainingLines == null) {
                    throw null;
                }
                String string2 = "";
                String mkString_start = "";
                Object var7_8 = null;
                string2 = null;
                string = null;
                pw.write(IterableOnceOps.mkString$((IterableOnceOps)remainingLines, (String)mkString_start, (String)mkString_sep, (String)mkString_end) + "\n");
                pw.close();
                source.close();
                return;
            }
        }, (Object)"zio.test.TestDebug.removeLine(TestDebug.scala:76)"));
    }

    public static final /* synthetic */ boolean $anonfun$isBlank$1(char x$1) {
        return Character.isWhitespace(x$1);
    }

    private TestDebug$() {
    }

    public static final /* synthetic */ Object $anonfun$isBlank$1$adapted(Object x$1) {
        return BoxesRunTime.boxToBoolean((boolean)TestDebug$.$anonfun$isBlank$1(BoxesRunTime.unboxToChar((Object)x$1)));
    }
}

