/*
 * Decompiled with CFR 0.152.
 */
package zio.stream.compression;

import java.io.Serializable;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import zio.CanFail;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.Exit$;
import zio.IsSubtypeOfError$;
import zio.ZIO;
import zio.ZIO$;
import zio.stream.compression.CompressionException;
import zio.stream.compression.CompressionException$;
import zio.stream.compression.Gunzipper$;

public class Gunzipper {
    public final int zio$stream$compression$Gunzipper$$bufferSize;
    private State state;

    public static ZIO<Object, Nothing$, Gunzipper> make(int n, Object object) {
        return Gunzipper$.MODULE$.make(n, object);
    }

    public Gunzipper(int bufferSize) {
        this.zio$stream$compression$Gunzipper$$bufferSize = bufferSize;
        this.state = new ParseHeaderStep(this, Array$.MODULE$.emptyByteArray(), new CRC32());
    }

    public void close() {
        this.state.close();
    }

    public ZIO<Object, CompressionException, Chunk<Object>> onChunk(Chunk<Object> c, Object trace) {
        return ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$1 -> {
            Tuple2<State, Chunk<Object>> tuple2 = this.state.feed((byte[])c.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            State newState = (State)tuple2._1();
            Chunk output = (Chunk)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)newState, (Object)output);
            State newState2 = (State)tuple22._1();
            Chunk output2 = (Chunk)tuple22._2();
            this.state = newState2;
            return output2;
        }, trace).refineOrDie((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof DataFormatException) {
                    DataFormatException e = (DataFormatException)throwable;
                    return true;
                }
                if (throwable instanceof CompressionException) {
                    CompressionException e = (CompressionException)throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof DataFormatException) {
                    DataFormatException e = (DataFormatException)throwable;
                    return CompressionException$.MODULE$.apply(e);
                }
                if (throwable instanceof CompressionException) {
                    CompressionException e = (CompressionException)throwable;
                    return e;
                }
                return function1.apply((Object)x);
            }
        }, IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), (CanFail)CanFail$.MODULE$, trace);
    }

    public ZIO<Object, CompressionException, Chunk<Object>> onNone(Object trace) {
        if (this.state.isInProgress()) {
            return ZIO$.MODULE$.fail(Gunzipper::onNone$$anonfun$1, trace);
        }
        return Exit$.MODULE$.emptyChunk();
    }

    public State zio$stream$compression$Gunzipper$$nextStep(byte[] acc, boolean checkCrc16, CRC32 crc32, boolean parseExtra, int commentsToSkip) {
        if (parseExtra) {
            return new ParseExtraStep(this, acc, crc32, checkCrc16, commentsToSkip);
        }
        if (commentsToSkip > 0) {
            return new SkipCommentsStep(this, checkCrc16, crc32, commentsToSkip);
        }
        if (checkCrc16) {
            return new CheckCrc16Step(this, Array$.MODULE$.emptyByteArray(), crc32.getValue());
        }
        return new Decompress();
    }

    public int zio$stream$compression$Gunzipper$$u8(byte b) {
        return b & 0xFF;
    }

    public int zio$stream$compression$Gunzipper$$u16(byte b1, byte b2) {
        return this.zio$stream$compression$Gunzipper$$u8(b1) | this.zio$stream$compression$Gunzipper$$u8(b2) << 8;
    }

    public int zio$stream$compression$Gunzipper$$u32(byte b1, byte b2, byte b3, byte b4) {
        return this.zio$stream$compression$Gunzipper$$u16(b1, b2) | this.zio$stream$compression$Gunzipper$$u16(b3, b4) << 16;
    }

    private static final CompressionException onNone$$anonfun$1() {
        return CompressionException$.MODULE$.apply("Stream closed before completion.", CompressionException$.MODULE$.apply$default$2());
    }

    public class CheckCrc16Step
    implements State {
        private final byte[] pastCrc16Bytes;
        private final long crcValue;
        private final /* synthetic */ Gunzipper $outer;

        public CheckCrc16Step(Gunzipper $outer, byte[] pastCrc16Bytes, long crcValue) {
            this.pastCrc16Bytes = pastCrc16Bytes;
            this.crcValue = crcValue;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public Tuple2<State, Chunk<Object>> feed(byte[] chunkBytes) {
            Object object = Predef$.MODULE$.byteArrayOps(this.pastCrc16Bytes);
            Object object2 = Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)chunkBytes, ClassTag$.MODULE$.apply(Byte.TYPE)));
            Tuple2 tuple2 = ArrayOps$.MODULE$.splitAt$extension(object2, 2);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            byte[] crc16Bytes = (byte[])tuple2._1();
            byte[] leftover = (byte[])tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)crc16Bytes, (Object)leftover);
            byte[] crc16Bytes2 = (byte[])tuple22._1();
            byte[] leftover2 = (byte[])tuple22._2();
            if (crc16Bytes2.length < 2) {
                return Tuple2$.MODULE$.apply((Object)new CheckCrc16Step(this.$outer, crc16Bytes2, this.crcValue), (Object)Chunk$.MODULE$.empty());
            }
            int computedCrc16 = (int)(this.crcValue & 0xFFFFL);
            int expectedCrc = this.$outer.zio$stream$compression$Gunzipper$$u16(crc16Bytes2[0], crc16Bytes2[1]);
            if (computedCrc16 != expectedCrc) {
                throw CompressionException$.MODULE$.apply("Invalid header CRC16", CompressionException$.MODULE$.apply$default$2());
            }
            return this.$outer.new Decompress().feed(leftover2);
        }

        public final /* synthetic */ Gunzipper zio$stream$compression$Gunzipper$CheckCrc16Step$$$outer() {
            return this.$outer;
        }
    }

    public class CheckTrailerStep
    implements State {
        private final byte[] acc;
        private final long expectedCrc32;
        private final long expectedIsize;
        private final /* synthetic */ Gunzipper $outer;

        public CheckTrailerStep(Gunzipper $outer, byte[] acc, long expectedCrc32, long expectedIsize) {
            this.acc = acc;
            this.expectedCrc32 = expectedCrc32;
            this.expectedIsize = expectedIsize;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        private int readInt(byte[] a) {
            return this.$outer.zio$stream$compression$Gunzipper$$u32(a[0], a[1], a[2], a[3]);
        }

        @Override
        public Tuple2<State, Chunk<Object>> feed(byte[] chunkBytes) {
            Object object = Predef$.MODULE$.byteArrayOps(this.acc);
            byte[] bytes = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)chunkBytes, ClassTag$.MODULE$.apply(Byte.TYPE));
            if (bytes.length < 8) {
                return Tuple2$.MODULE$.apply((Object)new CheckTrailerStep(this.$outer, bytes, this.expectedCrc32, this.expectedIsize), (Object)Chunk$.MODULE$.empty());
            }
            Object object2 = Predef$.MODULE$.byteArrayOps(bytes);
            Tuple2 tuple2 = ArrayOps$.MODULE$.splitAt$extension(object2, 8);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            byte[] trailerBytes = (byte[])tuple2._1();
            byte[] leftover = (byte[])tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)trailerBytes, (Object)leftover);
            byte[] trailerBytes2 = (byte[])tuple22._1();
            byte[] leftover2 = (byte[])tuple22._2();
            Object object3 = Predef$.MODULE$.byteArrayOps(trailerBytes2);
            int crc32 = this.readInt((byte[])ArrayOps$.MODULE$.take$extension(object3, 4));
            Object object4 = Predef$.MODULE$.byteArrayOps(trailerBytes2);
            int isize = this.readInt((byte[])ArrayOps$.MODULE$.drop$extension(object4, 4));
            if ((int)this.expectedCrc32 != crc32) {
                throw CompressionException$.MODULE$.apply("Invalid CRC32", CompressionException$.MODULE$.apply$default$2());
            }
            if ((int)this.expectedIsize != isize) {
                throw CompressionException$.MODULE$.apply("Invalid ISIZE", CompressionException$.MODULE$.apply$default$2());
            }
            return new ParseHeaderStep(this.$outer, Array$.MODULE$.emptyByteArray(), new CRC32()).feed(leftover2);
        }

        public final /* synthetic */ Gunzipper zio$stream$compression$Gunzipper$CheckTrailerStep$$$outer() {
            return this.$outer;
        }
    }

    public class Decompress
    implements State {
        private final Inflater inflater;
        private final CRC32 crc32;
        private final byte[] buffer;

        public Decompress() {
            if (Gunzipper.this == null) {
                throw new NullPointerException();
            }
            this.inflater = new Inflater(true);
            this.crc32 = new CRC32();
            this.buffer = new byte[Gunzipper.this.zio$stream$compression$Gunzipper$$bufferSize];
        }

        public Chunk<Object> pullOutput(Inflater inflater, byte[] buffer) {
            if (inflater.needsInput()) {
                return Chunk$.MODULE$.empty();
            }
            return this.next$1(inflater, buffer, Chunk$.MODULE$.empty());
        }

        @Override
        public void close() {
            this.inflater.end();
        }

        @Override
        public Tuple2<State, Chunk<Object>> feed(byte[] chunkBytes) {
            this.inflater.setInput(chunkBytes);
            Chunk<Object> newChunk = this.pullOutput(this.inflater, this.buffer);
            if (this.inflater.finished()) {
                Object object = Predef$.MODULE$.byteArrayOps(chunkBytes);
                byte[] leftover = (byte[])ArrayOps$.MODULE$.takeRight$extension(object, this.inflater.getRemaining());
                Tuple2<State, Chunk<Object>> tuple2 = new CheckTrailerStep(Gunzipper.this, Array$.MODULE$.emptyByteArray(), this.crc32.getValue(), this.inflater.getBytesWritten()).feed(leftover);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                State state = (State)tuple2._1();
                Chunk restOfChunks = (Chunk)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)state, (Object)restOfChunks);
                State state2 = (State)tuple22._1();
                Chunk restOfChunks2 = (Chunk)tuple22._2();
                return Tuple2$.MODULE$.apply((Object)state2, (Object)newChunk.$plus$plus(restOfChunks2));
            }
            return Tuple2$.MODULE$.apply((Object)this, newChunk);
        }

        public final /* synthetic */ Gunzipper zio$stream$compression$Gunzipper$Decompress$$$outer() {
            return Gunzipper.this;
        }

        private final Chunk next$1(Inflater inflater$1, byte[] buffer$1, Chunk prev) {
            Chunk pulled;
            while (true) {
                int read = inflater$1.inflate(buffer$1);
                byte[] newBytes = Arrays.copyOf(buffer$1, read);
                this.crc32.update(newBytes);
                Chunk current = Chunk$.MODULE$.fromArray((Object)newBytes);
                pulled = prev.$plus$plus(current);
                if (read <= 0 || inflater$1.getRemaining() <= 0) break;
                prev = pulled;
            }
            return pulled;
        }
    }

    public class ParseExtraStep
    implements State {
        private final byte[] acc;
        private final CRC32 crc32;
        private final boolean checkCrc16;
        private final int commentsToSkip;
        private final /* synthetic */ Gunzipper $outer;

        public ParseExtraStep(Gunzipper $outer, byte[] acc, CRC32 crc32, boolean checkCrc16, int commentsToSkip) {
            this.acc = acc;
            this.crc32 = crc32;
            this.checkCrc16 = checkCrc16;
            this.commentsToSkip = commentsToSkip;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public Tuple2<State, Chunk<Object>> feed(byte[] chunkBytes) {
            Object object = Predef$.MODULE$.byteArrayOps(this.acc);
            byte[] bytes = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)chunkBytes, ClassTag$.MODULE$.apply(Byte.TYPE));
            if (bytes.length < 12) {
                return Tuple2$.MODULE$.apply((Object)new ParseExtraStep(this.$outer, bytes, this.crc32, this.checkCrc16, this.commentsToSkip), (Object)Chunk$.MODULE$.empty());
            }
            int xlenLenght = 2;
            int extraBytes = this.$outer.zio$stream$compression$Gunzipper$$u16(bytes[Gunzipper$.zio$stream$compression$Gunzipper$$$fixedHeaderLength], bytes[Gunzipper$.zio$stream$compression$Gunzipper$$$fixedHeaderLength + 1]);
            int headerWithExtraLength = Gunzipper$.zio$stream$compression$Gunzipper$$$fixedHeaderLength + xlenLenght + extraBytes;
            if (bytes.length < headerWithExtraLength) {
                return Tuple2$.MODULE$.apply((Object)new ParseExtraStep(this.$outer, bytes, this.crc32, this.checkCrc16, this.commentsToSkip), (Object)Chunk$.MODULE$.empty());
            }
            Object object2 = Predef$.MODULE$.byteArrayOps(bytes);
            Tuple2 tuple2 = ArrayOps$.MODULE$.splitAt$extension(object2, headerWithExtraLength);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            byte[] headerWithExtra = (byte[])tuple2._1();
            byte[] leftover = (byte[])tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)headerWithExtra, (Object)leftover);
            byte[] headerWithExtra2 = (byte[])tuple22._1();
            byte[] leftover2 = (byte[])tuple22._2();
            Object object3 = Predef$.MODULE$.byteArrayOps(headerWithExtra2);
            this.crc32.update((byte[])ArrayOps$.MODULE$.drop$extension(object3, Gunzipper$.zio$stream$compression$Gunzipper$$$fixedHeaderLength));
            return this.$outer.zio$stream$compression$Gunzipper$$nextStep(headerWithExtra2, this.checkCrc16, this.crc32, false, this.commentsToSkip).feed(leftover2);
        }

        public final /* synthetic */ Gunzipper zio$stream$compression$Gunzipper$ParseExtraStep$$$outer() {
            return this.$outer;
        }
    }

    public class ParseHeaderStep
    implements State {
        private final byte[] acc;
        private final CRC32 crc32;
        private final /* synthetic */ Gunzipper $outer;

        public ParseHeaderStep(Gunzipper $outer, byte[] acc, CRC32 crc32) {
            this.acc = acc;
            this.crc32 = crc32;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public Tuple2<State, Chunk<Object>> feed(byte[] chunkBytes) {
            Object object = Predef$.MODULE$.byteArrayOps(this.acc);
            byte[] bytes = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)chunkBytes, ClassTag$.MODULE$.apply(Byte.TYPE));
            if (bytes.length < Gunzipper$.zio$stream$compression$Gunzipper$$$fixedHeaderLength) {
                return Tuple2$.MODULE$.apply((Object)new ParseHeaderStep(this.$outer, bytes, this.crc32), (Object)Chunk$.MODULE$.empty());
            }
            Object object2 = Predef$.MODULE$.byteArrayOps(bytes);
            Tuple2 tuple2 = ArrayOps$.MODULE$.splitAt$extension(object2, Gunzipper$.zio$stream$compression$Gunzipper$$$fixedHeaderLength);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            byte[] header = (byte[])tuple2._1();
            byte[] leftover = (byte[])tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)header, (Object)leftover);
            byte[] header2 = (byte[])tuple22._1();
            byte[] leftover2 = (byte[])tuple22._2();
            this.crc32.update(header2);
            if (this.$outer.zio$stream$compression$Gunzipper$$u8(header2[0]) != 31 || this.$outer.zio$stream$compression$Gunzipper$$u8(header2[1]) != 139) {
                throw CompressionException$.MODULE$.apply("Invalid GZIP header", CompressionException$.MODULE$.apply$default$2());
            }
            if (header2[2] != 8) {
                throw CompressionException$.MODULE$.apply("Only deflate (8) compression method is supported, present: " + header2[2], CompressionException$.MODULE$.apply$default$2());
            }
            int flags = header2[3] & 0xFF;
            boolean checkCrc16 = (flags & 2) > 0;
            boolean hasExtra = (flags & 4) > 0;
            boolean skipFileName = (flags & 8) > 0;
            boolean skipFileComment = (flags & 0x10) > 0;
            int commentsToSkip = (skipFileName ? 1 : 0) + (skipFileComment ? 1 : 0);
            return this.$outer.zio$stream$compression$Gunzipper$$nextStep(header2, checkCrc16, this.crc32, hasExtra, commentsToSkip).feed(leftover2);
        }

        @Override
        public boolean isInProgress() {
            Object object = Predef$.MODULE$.byteArrayOps(this.acc);
            return ArrayOps$.MODULE$.nonEmpty$extension(object);
        }

        public final /* synthetic */ Gunzipper zio$stream$compression$Gunzipper$ParseHeaderStep$$$outer() {
            return this.$outer;
        }
    }

    public class SkipCommentsStep
    implements State {
        private final boolean checkCrc16;
        private final CRC32 crc32;
        private final int commentsToSkip;
        private final /* synthetic */ Gunzipper $outer;

        public SkipCommentsStep(Gunzipper $outer, boolean checkCrc16, CRC32 crc32, int commentsToSkip) {
            this.checkCrc16 = checkCrc16;
            this.crc32 = crc32;
            this.commentsToSkip = commentsToSkip;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public Tuple2<State, Chunk<Object>> feed(byte[] chunkBytes) {
            Tuple2 tuple2;
            Tuple2 tuple22;
            Object object = Predef$.MODULE$.byteArrayOps(chunkBytes);
            int idx = ArrayOps$.MODULE$.indexOf$extension(object, (Object)BoxesRunTime.boxToByte((byte)0), ArrayOps$.MODULE$.indexOf$default$2$extension(object));
            if (idx == -1) {
                tuple22 = Tuple2$.MODULE$.apply((Object)chunkBytes, (Object)Array$.MODULE$.emptyByteArray());
            } else {
                Object object2 = Predef$.MODULE$.byteArrayOps(chunkBytes);
                tuple22 = tuple2 = ArrayOps$.MODULE$.splitAt$extension(object2, idx + 1);
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            byte[] upTo0 = (byte[])tuple2._1();
            byte[] leftover = (byte[])tuple2._2();
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)upTo0, (Object)leftover);
            byte[] upTo02 = (byte[])tuple23._1();
            byte[] leftover2 = (byte[])tuple23._2();
            this.crc32.update(upTo02);
            return this.$outer.zio$stream$compression$Gunzipper$$nextStep(Array$.MODULE$.emptyByteArray(), this.checkCrc16, this.crc32, false, this.commentsToSkip - 1).feed(leftover2);
        }

        public final /* synthetic */ Gunzipper zio$stream$compression$Gunzipper$SkipCommentsStep$$$outer() {
            return this.$outer;
        }
    }

    public static interface State {
        public static void close$(State $this) {
            $this.close();
        }

        default public void close() {
        }

        public Tuple2<State, Chunk<Object>> feed(byte[] var1);

        public static boolean isInProgress$(State $this) {
            return $this.isInProgress();
        }

        default public boolean isInProgress() {
            return true;
        }
    }
}

