/*
 * Decompiled with CFR 0.152.
 */
package zio.json.internal;

import java.io.Reader;
import java.util.Arrays;
import zio.json.internal.OneCharReader;
import zio.json.internal.PlaybackReader;
import zio.json.internal.RecordingReader;
import zio.json.internal.RetractReader;
import zio.json.internal.RewindTwice;
import zio.json.internal.UnexpectedEnd;

public final class WithRecordingReader
extends Reader
implements OneCharReader,
RecordingReader,
PlaybackReader {
    private final OneCharReader in;
    private char[] tape;
    private int eob;
    private int writing;
    private int reading;

    public WithRecordingReader(OneCharReader in, int initial) {
        this.in = in;
        this.tape = new char[Math.max(initial, 1)];
        this.eob = -1;
        this.writing = 0;
        this.reading = -1;
    }

    @Override
    public void close() {
        ((Reader)((Object)this.in)).close();
    }

    @Override
    public int read() {
        int n;
        try {
            n = this.readChar();
        }
        catch (UnexpectedEnd unexpectedEnd) {
            this.eob = this.reading;
            n = -1;
        }
        return n;
    }

    @Override
    public char readChar() {
        if (this.reading != -1) {
            if (this.reading == this.eob) {
                throw new UnexpectedEnd();
            }
            char v = this.tape[this.reading];
            ++this.reading;
            if (this.reading >= this.writing) {
                this.reading = -1;
                this.writing = -1;
            }
            return v;
        }
        char v = this.in.readChar();
        if (this.writing != -1) {
            this.tape[this.writing] = v;
            ++this.writing;
            if (this.writing == this.tape.length) {
                this.tape = Arrays.copyOf(this.tape, this.tape.length * 2);
            }
        }
        return v;
    }

    @Override
    public void rewind() {
        if (this.writing != -1) {
            this.reading = 0;
            return;
        }
        throw new RewindTwice();
    }

    @Override
    public void retract() {
        if (this.reading == -1) {
            OneCharReader oneCharReader = this.in;
            if (oneCharReader instanceof RetractReader) {
                RetractReader rr = (RetractReader)oneCharReader;
                rr.retract();
                if (this.writing != -1) {
                    --this.writing;
                    return;
                }
                return;
            }
            this.reading = this.writing - 1;
            return;
        }
        --this.reading;
    }

    @Override
    public int offset() {
        if (this.reading == -1) {
            return this.writing;
        }
        return this.reading;
    }

    @Override
    public char history(int idx) {
        return this.tape[idx];
    }
}

