/*
 * Decompiled with CFR 0.152.
 */
package zio.json.internal;

import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import scala.collection.immutable.List;
import scala.runtime.ModuleSerializationProxy;
import zio.json.JsonDecoder$;
import zio.json.JsonDecoder$UnsafeJson$;
import zio.json.JsonError;
import zio.json.JsonError$Message$;
import zio.json.internal.EscapedString;
import zio.json.internal.FastStringBuilder;
import zio.json.internal.OneCharReader;
import zio.json.internal.RetractReader;
import zio.json.internal.StringMatrix;
import zio.json.internal.UnsafeNumbers$;
import zio.json.internal.UnsafeNumbers$UnsafeNumber$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Lexer$
implements Serializable {
    private static final int NumberMaxBits;
    private static final char[] ull;
    private static final char[] alse;
    private static final char[] rue;
    public static final Lexer$ MODULE$;

    private Lexer$() {
    }

    static {
        MODULE$ = new Lexer$();
        NumberMaxBits = 128;
        ull = "ull".toCharArray();
        alse = "alse".toCharArray();
        rue = "rue".toCharArray();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Lexer$.class);
    }

    public int NumberMaxBits() {
        return NumberMaxBits;
    }

    public boolean firstField(List<JsonError> trace, RetractReader in) {
        char c = in.nextNonWhitespace();
        if ('\"' == c) {
            in.retract();
            return true;
        }
        if ('}' == c) {
            return false;
        }
        char c2 = c;
        JsonDecoder$.MODULE$.JsonError();
        JsonError.Message message = JsonError$Message$.MODULE$.apply(new StringBuilder(29).append("expected string or '}' got '").append(c2).append("'").toString());
        throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)trace.$colon$colon((Object)message));
    }

    public boolean nextField(List<JsonError> trace, OneCharReader in) {
        char c = in.nextNonWhitespace();
        if (',' == c) {
            return true;
        }
        if ('}' == c) {
            return false;
        }
        char c2 = c;
        JsonDecoder$.MODULE$.JsonError();
        JsonError.Message message = JsonError$Message$.MODULE$.apply(new StringBuilder(26).append("expected ',' or '}' got '").append(c2).append("'").toString());
        throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)trace.$colon$colon((Object)message));
    }

    public boolean firstArrayElement(RetractReader in) {
        char c = in.nextNonWhitespace();
        if (']' == c) {
            return false;
        }
        in.retract();
        return true;
    }

    public boolean nextArrayElement(List<JsonError> trace, OneCharReader in) {
        char c = in.nextNonWhitespace();
        if (',' == c) {
            return true;
        }
        if (']' == c) {
            return false;
        }
        char c2 = c;
        JsonDecoder$.MODULE$.JsonError();
        JsonError.Message message = JsonError$Message$.MODULE$.apply(new StringBuilder(26).append("expected ',' or ']' got '").append(c2).append("'").toString());
        throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)trace.$colon$colon((Object)message));
    }

    public int field(List<JsonError> trace, OneCharReader in, StringMatrix matrix) {
        int f = this.enumeration(trace, in, matrix);
        this.char(trace, in, ':');
        return f;
    }

    public int enumeration(List<JsonError> trace, OneCharReader in, StringMatrix matrix) {
        Reader stream = this.streamingString(trace, in);
        int i = 0;
        long bs = matrix.initial();
        int c = -1;
        while ((c = stream.read()) != -1) {
            bs = matrix.update(bs, i, c);
            ++i;
        }
        bs = matrix.exact(bs, i);
        return matrix.first(bs);
    }

    public void skipValue(List<JsonError> trace, RetractReader in) {
        char c = in.nextNonWhitespace();
        switch (c) {
            case 'n': {
                this.readChars(trace, in, ull, "null");
                return;
            }
            case 'f': {
                this.readChars(trace, in, alse, "false");
                return;
            }
            case 't': {
                this.readChars(trace, in, rue, "true");
                return;
            }
            case '{': {
                if (this.firstField(trace, in)) {
                    do {
                        this.char(trace, in, '\"');
                        this.skipString(trace, in);
                        this.char(trace, in, ':');
                        this.skipValue(trace, in);
                    } while (this.nextField(trace, in));
                    return;
                }
                return;
            }
            case '[': {
                if (this.firstArrayElement(in)) {
                    do {
                        this.skipValue(trace, in);
                    } while (this.nextArrayElement(trace, in));
                    return;
                }
                return;
            }
            case '\"': {
                this.skipString(trace, in);
                return;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.skipNumber(in);
                return;
            }
        }
        char c2 = c;
        JsonDecoder$.MODULE$.JsonError();
        JsonError.Message message = JsonError$Message$.MODULE$.apply(new StringBuilder(13).append("unexpected '").append(c2).append("'").toString());
        throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)trace.$colon$colon((Object)message));
    }

    public void skipNumber(RetractReader in) {
        while (this.isNumber(in.readChar())) {
        }
        in.retract();
    }

    public void skipString(List<JsonError> trace, OneCharReader in) {
        EscapedString stream = new EscapedString(trace, in);
        int i = 0;
        while ((i = stream.read()) != -1) {
        }
    }

    public Reader streamingString(List<JsonError> trace, OneCharReader in) {
        this.char(trace, in, '\"');
        return new EscapedString(trace, in);
    }

    public CharSequence string(List<JsonError> trace, OneCharReader in) {
        this.char(trace, in, '\"');
        EscapedString stream = new EscapedString(trace, in);
        FastStringBuilder sb = new FastStringBuilder(64);
        while (true) {
            int c = stream.read();
            if (c == -1) {
                return sb.buffer();
            }
            sb.append((char)c);
        }
        JsonDecoder$.MODULE$.JsonError();
        JsonError.Message message = JsonError$Message$.MODULE$.apply("impossible string");
        throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)trace.$colon$colon((Object)message));
    }

    public boolean boolean(List<JsonError> trace, OneCharReader in) {
        char c = in.nextNonWhitespace();
        if ('t' == c) {
            this.readChars(trace, in, rue, "true");
            return true;
        }
        if ('f' == c) {
            this.readChars(trace, in, alse, "false");
            return false;
        }
        char c2 = c;
        JsonDecoder$.MODULE$.JsonError();
        JsonError.Message message = JsonError$Message$.MODULE$.apply(new StringBuilder(31).append("expected 'true' or 'false' got ").append(c2).toString());
        throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)trace.$colon$colon((Object)message));
    }

    /*
     * WARNING - void declaration
     */
    public byte byte(List<JsonError> trace, RetractReader in) {
        void v0;
        this.checkNumber(trace, in);
        try {
            void var3_3;
            byte i = UnsafeNumbers$.MODULE$.byte_((Reader)((Object)in), false);
            in.retract();
            v0 = var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                JsonDecoder$.MODULE$.JsonError();
                JsonError.Message message = JsonError$Message$.MODULE$.apply("expected a Byte");
                throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)trace.$colon$colon((Object)message));
            }
            throw throwable;
        }
        return (byte)v0;
    }

    /*
     * WARNING - void declaration
     */
    public short short(List<JsonError> trace, RetractReader in) {
        void v0;
        this.checkNumber(trace, in);
        try {
            void var3_3;
            short i = UnsafeNumbers$.MODULE$.short_((Reader)((Object)in), false);
            in.retract();
            v0 = var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                JsonDecoder$.MODULE$.JsonError();
                JsonError.Message message = JsonError$Message$.MODULE$.apply("expected a Short");
                throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)trace.$colon$colon((Object)message));
            }
            throw throwable;
        }
        return (short)v0;
    }

    /*
     * WARNING - void declaration
     */
    public int int(List<JsonError> trace, RetractReader in) {
        void v0;
        this.checkNumber(trace, in);
        try {
            void var3_3;
            int i = UnsafeNumbers$.MODULE$.int_((Reader)((Object)in), false);
            in.retract();
            v0 = var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                JsonDecoder$.MODULE$.JsonError();
                JsonError.Message message = JsonError$Message$.MODULE$.apply("expected an Int");
                throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)trace.$colon$colon((Object)message));
            }
            throw throwable;
        }
        return (int)v0;
    }

    /*
     * WARNING - void declaration
     */
    public long long(List<JsonError> trace, RetractReader in) {
        void v0;
        this.checkNumber(trace, in);
        try {
            void var3_3;
            long i = UnsafeNumbers$.MODULE$.long_((Reader)((Object)in), false);
            in.retract();
            v0 = var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                JsonDecoder$.MODULE$.JsonError();
                JsonError.Message message = JsonError$Message$.MODULE$.apply("expected a Long");
                throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)trace.$colon$colon((Object)message));
            }
            throw throwable;
        }
        return (long)v0;
    }

    /*
     * WARNING - void declaration
     */
    public BigInteger bigInteger(List<JsonError> trace, RetractReader in) {
        void v0;
        this.checkNumber(trace, in);
        try {
            void var3_3;
            BigInteger i = UnsafeNumbers$.MODULE$.bigInteger_((Reader)((Object)in), false, this.NumberMaxBits());
            in.retract();
            v0 = var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                JsonDecoder$.MODULE$.JsonError();
                JsonError.Message message = JsonError$Message$.MODULE$.apply(new StringBuilder(26).append("expected a ").append(this.NumberMaxBits()).append(" bit BigInteger").toString());
                throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)trace.$colon$colon((Object)message));
            }
            throw throwable;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    public float float(List<JsonError> trace, RetractReader in) {
        void v0;
        this.checkNumber(trace, in);
        try {
            void var3_3;
            float i = UnsafeNumbers$.MODULE$.float_((Reader)((Object)in), false, this.NumberMaxBits());
            in.retract();
            v0 = var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                JsonDecoder$.MODULE$.JsonError();
                JsonError.Message message = JsonError$Message$.MODULE$.apply("expected a Float");
                throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)trace.$colon$colon((Object)message));
            }
            throw throwable;
        }
        return (float)v0;
    }

    /*
     * WARNING - void declaration
     */
    public double double(List<JsonError> trace, RetractReader in) {
        void v0;
        this.checkNumber(trace, in);
        try {
            void var3_3;
            double i = UnsafeNumbers$.MODULE$.double_((Reader)((Object)in), false, this.NumberMaxBits());
            in.retract();
            v0 = var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                JsonDecoder$.MODULE$.JsonError();
                JsonError.Message message = JsonError$Message$.MODULE$.apply("expected a Double");
                throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)trace.$colon$colon((Object)message));
            }
            throw throwable;
        }
        return (double)v0;
    }

    /*
     * WARNING - void declaration
     */
    public BigDecimal bigDecimal(List<JsonError> trace, RetractReader in) {
        void v0;
        this.checkNumber(trace, in);
        try {
            void var3_3;
            BigDecimal i = UnsafeNumbers$.MODULE$.bigDecimal_((Reader)((Object)in), false, this.NumberMaxBits());
            in.retract();
            v0 = var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (UnsafeNumbers$UnsafeNumber$.MODULE$.equals(throwable2)) {
                JsonDecoder$.MODULE$.JsonError();
                JsonError.Message message = JsonError$Message$.MODULE$.apply(new StringBuilder(22).append("expected a ").append(this.NumberMaxBits()).append(" BigDecimal").toString());
                throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)trace.$colon$colon((Object)message));
            }
            throw throwable;
        }
        return v0;
    }

    private void checkNumber(List<JsonError> trace, RetractReader in) {
        char c = in.nextNonWhitespace();
        switch (c) {
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                break;
            }
            default: {
                char c2 = c;
                JsonDecoder$.MODULE$.JsonError();
                JsonError.Message message = JsonError$Message$.MODULE$.apply(new StringBuilder(23).append("expected a number, got ").append(c2).toString());
                throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)trace.$colon$colon((Object)message));
            }
        }
        in.retract();
    }

    public void char(List<JsonError> trace, OneCharReader in, char c) {
        char got = in.nextNonWhitespace();
        if (got != c) {
            JsonDecoder$.MODULE$.JsonError();
            JsonError.Message message = JsonError$Message$.MODULE$.apply(new StringBuilder(18).append("expected '").append(c).append("' got '").append(got).append("'").toString());
            throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)trace.$colon$colon((Object)message));
        }
    }

    public void charOnly(List<JsonError> trace, OneCharReader in, char c) {
        char got = in.readChar();
        if (got != c) {
            JsonDecoder$.MODULE$.JsonError();
            JsonError.Message message = JsonError$Message$.MODULE$.apply(new StringBuilder(18).append("expected '").append(c).append("' got '").append(got).append("'").toString());
            throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)trace.$colon$colon((Object)message));
        }
    }

    private boolean isNumber(char c) {
        char c2 = c;
        switch (c2) {
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'E': 
            case 'e': {
                return true;
            }
        }
        return false;
    }

    public void readChars(List<JsonError> trace, OneCharReader in, char[] expect, String errMsg) {
        for (int i = 0; i < expect.length; ++i) {
            if (in.readChar() == expect[i]) continue;
            JsonDecoder$.MODULE$.JsonError();
            JsonError.Message message = JsonError$Message$.MODULE$.apply(new StringBuilder(11).append("expected '").append(errMsg).append("'").toString());
            throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)trace.$colon$colon((Object)message));
        }
    }
}

