/*
 * Decompiled with CFR 0.152.
 */
package zio.json.internal;

import java.io.Reader;
import scala.collection.immutable.List;
import zio.json.JsonDecoder$;
import zio.json.JsonDecoder$UnsafeJson$;
import zio.json.JsonError;
import zio.json.JsonError$Message$;
import zio.json.internal.OneCharReader;
import zio.json.internal.UnexpectedEnd;

public final class EscapedString
extends Reader
implements OneCharReader {
    private final List<JsonError> trace;
    private final OneCharReader in;
    private boolean escaped;

    public EscapedString(List<JsonError> trace, OneCharReader in) {
        this.trace = trace;
        this.in = in;
        this.escaped = false;
    }

    @Override
    public void close() {
        ((Reader)((Object)this.in)).close();
    }

    @Override
    public int read() {
        char c;
        while (true) {
            c = this.in.readChar();
            if (this.escaped) {
                this.escaped = false;
                char c2 = c;
                switch (c2) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        return c;
                    }
                    case 'b': {
                        return 8;
                    }
                    case 'f': {
                        return 12;
                    }
                    case 'n': {
                        return 10;
                    }
                    case 'r': {
                        return 13;
                    }
                    case 't': {
                        return 9;
                    }
                    case 'u': {
                        return this.nextHex4();
                    }
                }
                JsonDecoder$.MODULE$.JsonError();
                JsonError.Message message = JsonError$Message$.MODULE$.apply(new StringBuilder(21).append("invalid '\\").append(c).append("' in string").toString());
                throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)this.trace.$colon$colon((Object)message));
            }
            if (c != '\\') break;
            this.escaped = true;
        }
        if (c == '\"') {
            return -1;
        }
        if (c < ' ') {
            JsonDecoder$.MODULE$.JsonError();
            JsonError.Message message = JsonError$Message$.MODULE$.apply("invalid control in string");
            throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)this.trace.$colon$colon((Object)message));
        }
        return c;
    }

    @Override
    public char readChar() {
        int v = this.read();
        if (v == -1) {
            throw new UnexpectedEnd();
        }
        return (char)v;
    }

    public int nextHex4() {
        int accum = 0;
        for (int i = 0; i < 4; ++i) {
            int n;
            int c = this.in.read();
            if (c == -1) {
                JsonDecoder$.MODULE$.JsonError();
                JsonError.Message message = JsonError$Message$.MODULE$.apply("unexpected EOB in string");
                throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)this.trace.$colon$colon((Object)message));
            }
            if (48 <= c && c <= 57) {
                n = c - 48;
            } else if (65 <= c && c <= 70) {
                n = c - 65 + 10;
            } else if (97 <= c && c <= 102) {
                n = c - 97 + 10;
            } else {
                JsonDecoder$.MODULE$.JsonError();
                JsonError.Message message = JsonError$Message$.MODULE$.apply("invalid charcode in string");
                throw JsonDecoder$UnsafeJson$.MODULE$.apply((List<JsonError>)this.trace.$colon$colon((Object)message));
            }
            c = n;
            accum = accum * 16 + c;
        }
        return accum;
    }
}

