package zio.json

import zio.json.internal._

private[json] trait GeneratedTupleDecoders { this: JsonDecoder.type =>
  implicit def tuple1[A1](implicit A1: JsonDecoder[A1]): JsonDecoder[Tuple1[A1]] =
    new JsonDecoder[Tuple1[A1]] {
      private[this] val traces: Array[JsonError] = (0 to 0).map(JsonError.ArrayAccess(_)).toArray
      def unsafeDecode(trace: List[JsonError], in: RetractReader): Tuple1[A1] = {
        Lexer.char(trace, in, '[')
        val a1 = A1.unsafeDecode(traces(0) :: trace, in)
        Lexer.char(trace, in, ']')
        new Tuple1(a1)
      }
    }

  implicit def tuple2[A1, A2](implicit A1: JsonDecoder[A1], A2: JsonDecoder[A2]): JsonDecoder[Tuple2[A1, A2]] =
    new JsonDecoder[Tuple2[A1, A2]] {
      private[this] val traces: Array[JsonError] = (0 to 1).map(JsonError.ArrayAccess(_)).toArray
      def unsafeDecode(trace: List[JsonError], in: RetractReader): Tuple2[A1, A2] = {
        Lexer.char(trace, in, '[')
        val a1 = A1.unsafeDecode(traces(0) :: trace, in)
        Lexer.char(trace, in, ',')
        val a2 = A2.unsafeDecode(traces(1) :: trace, in)
        Lexer.char(trace, in, ']')
        new Tuple2(a1, a2)
      }
    }

  implicit def tuple3[A1, A2, A3](implicit A1: JsonDecoder[A1], A2: JsonDecoder[A2], A3: JsonDecoder[A3]): JsonDecoder[Tuple3[A1, A2, A3]] =
    new JsonDecoder[Tuple3[A1, A2, A3]] {
      private[this] val traces: Array[JsonError] = (0 to 2).map(JsonError.ArrayAccess(_)).toArray
      def unsafeDecode(trace: List[JsonError], in: RetractReader): Tuple3[A1, A2, A3] = {
        Lexer.char(trace, in, '[')
        val a1 = A1.unsafeDecode(traces(0) :: trace, in)
        Lexer.char(trace, in, ',')
        val a2 = A2.unsafeDecode(traces(1) :: trace, in)
        Lexer.char(trace, in, ',')
        val a3 = A3.unsafeDecode(traces(2) :: trace, in)
        Lexer.char(trace, in, ']')
        new Tuple3(a1, a2, a3)
      }
    }

  implicit def tuple4[A1, A2, A3, A4](implicit A1: JsonDecoder[A1], A2: JsonDecoder[A2], A3: JsonDecoder[A3], A4: JsonDecoder[A4]): JsonDecoder[Tuple4[A1, A2, A3, A4]] =
    new JsonDecoder[Tuple4[A1, A2, A3, A4]] {
      private[this] val traces: Array[JsonError] = (0 to 3).map(JsonError.ArrayAccess(_)).toArray
      def unsafeDecode(trace: List[JsonError], in: RetractReader): Tuple4[A1, A2, A3, A4] = {
        Lexer.char(trace, in, '[')
        val a1 = A1.unsafeDecode(traces(0) :: trace, in)
        Lexer.char(trace, in, ',')
        val a2 = A2.unsafeDecode(traces(1) :: trace, in)
        Lexer.char(trace, in, ',')
        val a3 = A3.unsafeDecode(traces(2) :: trace, in)
        Lexer.char(trace, in, ',')
        val a4 = A4.unsafeDecode(traces(3) :: trace, in)
        Lexer.char(trace, in, ']')
        new Tuple4(a1, a2, a3, a4)
      }
    }

  implicit def tuple5[A1, A2, A3, A4, A5](implicit A1: JsonDecoder[A1], A2: JsonDecoder[A2], A3: JsonDecoder[A3], A4: JsonDecoder[A4], A5: JsonDecoder[A5]): JsonDecoder[Tuple5[A1, A2, A3, A4, A5]] =
    new JsonDecoder[Tuple5[A1, A2, A3, A4, A5]] {
      private[this] val traces: Array[JsonError] = (0 to 4).map(JsonError.ArrayAccess(_)).toArray
      def unsafeDecode(trace: List[JsonError], in: RetractReader): Tuple5[A1, A2, A3, A4, A5] = {
        Lexer.char(trace, in, '[')
        val a1 = A1.unsafeDecode(traces(0) :: trace, in)
        Lexer.char(trace, in, ',')
        val a2 = A2.unsafeDecode(traces(1) :: trace, in)
        Lexer.char(trace, in, ',')
        val a3 = A3.unsafeDecode(traces(2) :: trace, in)
        Lexer.char(trace, in, ',')
        val a4 = A4.unsafeDecode(traces(3) :: trace, in)
        Lexer.char(trace, in, ',')
        val a5 = A5.unsafeDecode(traces(4) :: trace, in)
        Lexer.char(trace, in, ']')
        new Tuple5(a1, a2, a3, a4, a5)
      }
    }

  implicit def tuple6[A1, A2, A3, A4, A5, A6](implicit A1: JsonDecoder[A1], A2: JsonDecoder[A2], A3: JsonDecoder[A3], A4: JsonDecoder[A4], A5: JsonDecoder[A5], A6: JsonDecoder[A6]): JsonDecoder[Tuple6[A1, A2, A3, A4, A5, A6]] =
    new JsonDecoder[Tuple6[A1, A2, A3, A4, A5, A6]] {
      private[this] val traces: Array[JsonError] = (0 to 5).map(JsonError.ArrayAccess(_)).toArray
      def unsafeDecode(trace: List[JsonError], in: RetractReader): Tuple6[A1, A2, A3, A4, A5, A6] = {
        Lexer.char(trace, in, '[')
        val a1 = A1.unsafeDecode(traces(0) :: trace, in)
        Lexer.char(trace, in, ',')
        val a2 = A2.unsafeDecode(traces(1) :: trace, in)
        Lexer.char(trace, in, ',')
        val a3 = A3.unsafeDecode(traces(2) :: trace, in)
        Lexer.char(trace, in, ',')
        val a4 = A4.unsafeDecode(traces(3) :: trace, in)
        Lexer.char(trace, in, ',')
        val a5 = A5.unsafeDecode(traces(4) :: trace, in)
        Lexer.char(trace, in, ',')
        val a6 = A6.unsafeDecode(traces(5) :: trace, in)
        Lexer.char(trace, in, ']')
        new Tuple6(a1, a2, a3, a4, a5, a6)
      }
    }

  implicit def tuple7[A1, A2, A3, A4, A5, A6, A7](implicit A1: JsonDecoder[A1], A2: JsonDecoder[A2], A3: JsonDecoder[A3], A4: JsonDecoder[A4], A5: JsonDecoder[A5], A6: JsonDecoder[A6], A7: JsonDecoder[A7]): JsonDecoder[Tuple7[A1, A2, A3, A4, A5, A6, A7]] =
    new JsonDecoder[Tuple7[A1, A2, A3, A4, A5, A6, A7]] {
      private[this] val traces: Array[JsonError] = (0 to 6).map(JsonError.ArrayAccess(_)).toArray
      def unsafeDecode(trace: List[JsonError], in: RetractReader): Tuple7[A1, A2, A3, A4, A5, A6, A7] = {
        Lexer.char(trace, in, '[')
        val a1 = A1.unsafeDecode(traces(0) :: trace, in)
        Lexer.char(trace, in, ',')
        val a2 = A2.unsafeDecode(traces(1) :: trace, in)
        Lexer.char(trace, in, ',')
        val a3 = A3.unsafeDecode(traces(2) :: trace, in)
        Lexer.char(trace, in, ',')
        val a4 = A4.unsafeDecode(traces(3) :: trace, in)
        Lexer.char(trace, in, ',')
        val a5 = A5.unsafeDecode(traces(4) :: trace, in)
        Lexer.char(trace, in, ',')
        val a6 = A6.unsafeDecode(traces(5) :: trace, in)
        Lexer.char(trace, in, ',')
        val a7 = A7.unsafeDecode(traces(6) :: trace, in)
        Lexer.char(trace, in, ']')
        new Tuple7(a1, a2, a3, a4, a5, a6, a7)
      }
    }

  implicit def tuple8[A1, A2, A3, A4, A5, A6, A7, A8](implicit A1: JsonDecoder[A1], A2: JsonDecoder[A2], A3: JsonDecoder[A3], A4: JsonDecoder[A4], A5: JsonDecoder[A5], A6: JsonDecoder[A6], A7: JsonDecoder[A7], A8: JsonDecoder[A8]): JsonDecoder[Tuple8[A1, A2, A3, A4, A5, A6, A7, A8]] =
    new JsonDecoder[Tuple8[A1, A2, A3, A4, A5, A6, A7, A8]] {
      private[this] val traces: Array[JsonError] = (0 to 7).map(JsonError.ArrayAccess(_)).toArray
      def unsafeDecode(trace: List[JsonError], in: RetractReader): Tuple8[A1, A2, A3, A4, A5, A6, A7, A8] = {
        Lexer.char(trace, in, '[')
        val a1 = A1.unsafeDecode(traces(0) :: trace, in)
        Lexer.char(trace, in, ',')
        val a2 = A2.unsafeDecode(traces(1) :: trace, in)
        Lexer.char(trace, in, ',')
        val a3 = A3.unsafeDecode(traces(2) :: trace, in)
        Lexer.char(trace, in, ',')
        val a4 = A4.unsafeDecode(traces(3) :: trace, in)
        Lexer.char(trace, in, ',')
        val a5 = A5.unsafeDecode(traces(4) :: trace, in)
        Lexer.char(trace, in, ',')
        val a6 = A6.unsafeDecode(traces(5) :: trace, in)
        Lexer.char(trace, in, ',')
        val a7 = A7.unsafeDecode(traces(6) :: trace, in)
        Lexer.char(trace, in, ',')
        val a8 = A8.unsafeDecode(traces(7) :: trace, in)
        Lexer.char(trace, in, ']')
        new Tuple8(a1, a2, a3, a4, a5, a6, a7, a8)
      }
    }

  implicit def tuple9[A1, A2, A3, A4, A5, A6, A7, A8, A9](implicit A1: JsonDecoder[A1], A2: JsonDecoder[A2], A3: JsonDecoder[A3], A4: JsonDecoder[A4], A5: JsonDecoder[A5], A6: JsonDecoder[A6], A7: JsonDecoder[A7], A8: JsonDecoder[A8], A9: JsonDecoder[A9]): JsonDecoder[Tuple9[A1, A2, A3, A4, A5, A6, A7, A8, A9]] =
    new JsonDecoder[Tuple9[A1, A2, A3, A4, A5, A6, A7, A8, A9]] {
      private[this] val traces: Array[JsonError] = (0 to 8).map(JsonError.ArrayAccess(_)).toArray
      def unsafeDecode(trace: List[JsonError], in: RetractReader): Tuple9[A1, A2, A3, A4, A5, A6, A7, A8, A9] = {
        Lexer.char(trace, in, '[')
        val a1 = A1.unsafeDecode(traces(0) :: trace, in)
        Lexer.char(trace, in, ',')
        val a2 = A2.unsafeDecode(traces(1) :: trace, in)
        Lexer.char(trace, in, ',')
        val a3 = A3.unsafeDecode(traces(2) :: trace, in)
        Lexer.char(trace, in, ',')
        val a4 = A4.unsafeDecode(traces(3) :: trace, in)
        Lexer.char(trace, in, ',')
        val a5 = A5.unsafeDecode(traces(4) :: trace, in)
        Lexer.char(trace, in, ',')
        val a6 = A6.unsafeDecode(traces(5) :: trace, in)
        Lexer.char(trace, in, ',')
        val a7 = A7.unsafeDecode(traces(6) :: trace, in)
        Lexer.char(trace, in, ',')
        val a8 = A8.unsafeDecode(traces(7) :: trace, in)
        Lexer.char(trace, in, ',')
        val a9 = A9.unsafeDecode(traces(8) :: trace, in)
        Lexer.char(trace, in, ']')
        new Tuple9(a1, a2, a3, a4, a5, a6, a7, a8, a9)
      }
    }

  implicit def tuple10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10](implicit A1: JsonDecoder[A1], A2: JsonDecoder[A2], A3: JsonDecoder[A3], A4: JsonDecoder[A4], A5: JsonDecoder[A5], A6: JsonDecoder[A6], A7: JsonDecoder[A7], A8: JsonDecoder[A8], A9: JsonDecoder[A9], A10: JsonDecoder[A10]): JsonDecoder[Tuple10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10]] =
    new JsonDecoder[Tuple10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10]] {
      private[this] val traces: Array[JsonError] = (0 to 9).map(JsonError.ArrayAccess(_)).toArray
      def unsafeDecode(trace: List[JsonError], in: RetractReader): Tuple10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10] = {
        Lexer.char(trace, in, '[')
        val a1 = A1.unsafeDecode(traces(0) :: trace, in)
        Lexer.char(trace, in, ',')
        val a2 = A2.unsafeDecode(traces(1) :: trace, in)
        Lexer.char(trace, in, ',')
        val a3 = A3.unsafeDecode(traces(2) :: trace, in)
        Lexer.char(trace, in, ',')
        val a4 = A4.unsafeDecode(traces(3) :: trace, in)
        Lexer.char(trace, in, ',')
        val a5 = A5.unsafeDecode(traces(4) :: trace, in)
        Lexer.char(trace, in, ',')
        val a6 = A6.unsafeDecode(traces(5) :: trace, in)
        Lexer.char(trace, in, ',')
        val a7 = A7.unsafeDecode(traces(6) :: trace, in)
        Lexer.char(trace, in, ',')
        val a8 = A8.unsafeDecode(traces(7) :: trace, in)
        Lexer.char(trace, in, ',')
        val a9 = A9.unsafeDecode(traces(8) :: trace, in)
        Lexer.char(trace, in, ',')
        val a10 = A10.unsafeDecode(traces(9) :: trace, in)
        Lexer.char(trace, in, ']')
        new Tuple10(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)
      }
    }

  implicit def tuple11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11](implicit A1: JsonDecoder[A1], A2: JsonDecoder[A2], A3: JsonDecoder[A3], A4: JsonDecoder[A4], A5: JsonDecoder[A5], A6: JsonDecoder[A6], A7: JsonDecoder[A7], A8: JsonDecoder[A8], A9: JsonDecoder[A9], A10: JsonDecoder[A10], A11: JsonDecoder[A11]): JsonDecoder[Tuple11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11]] =
    new JsonDecoder[Tuple11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11]] {
      private[this] val traces: Array[JsonError] = (0 to 10).map(JsonError.ArrayAccess(_)).toArray
      def unsafeDecode(trace: List[JsonError], in: RetractReader): Tuple11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11] = {
        Lexer.char(trace, in, '[')
        val a1 = A1.unsafeDecode(traces(0) :: trace, in)
        Lexer.char(trace, in, ',')
        val a2 = A2.unsafeDecode(traces(1) :: trace, in)
        Lexer.char(trace, in, ',')
        val a3 = A3.unsafeDecode(traces(2) :: trace, in)
        Lexer.char(trace, in, ',')
        val a4 = A4.unsafeDecode(traces(3) :: trace, in)
        Lexer.char(trace, in, ',')
        val a5 = A5.unsafeDecode(traces(4) :: trace, in)
        Lexer.char(trace, in, ',')
        val a6 = A6.unsafeDecode(traces(5) :: trace, in)
        Lexer.char(trace, in, ',')
        val a7 = A7.unsafeDecode(traces(6) :: trace, in)
        Lexer.char(trace, in, ',')
        val a8 = A8.unsafeDecode(traces(7) :: trace, in)
        Lexer.char(trace, in, ',')
        val a9 = A9.unsafeDecode(traces(8) :: trace, in)
        Lexer.char(trace, in, ',')
        val a10 = A10.unsafeDecode(traces(9) :: trace, in)
        Lexer.char(trace, in, ',')
        val a11 = A11.unsafeDecode(traces(10) :: trace, in)
        Lexer.char(trace, in, ']')
        new Tuple11(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11)
      }
    }

  implicit def tuple12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12](implicit A1: JsonDecoder[A1], A2: JsonDecoder[A2], A3: JsonDecoder[A3], A4: JsonDecoder[A4], A5: JsonDecoder[A5], A6: JsonDecoder[A6], A7: JsonDecoder[A7], A8: JsonDecoder[A8], A9: JsonDecoder[A9], A10: JsonDecoder[A10], A11: JsonDecoder[A11], A12: JsonDecoder[A12]): JsonDecoder[Tuple12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12]] =
    new JsonDecoder[Tuple12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12]] {
      private[this] val traces: Array[JsonError] = (0 to 11).map(JsonError.ArrayAccess(_)).toArray
      def unsafeDecode(trace: List[JsonError], in: RetractReader): Tuple12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12] = {
        Lexer.char(trace, in, '[')
        val a1 = A1.unsafeDecode(traces(0) :: trace, in)
        Lexer.char(trace, in, ',')
        val a2 = A2.unsafeDecode(traces(1) :: trace, in)
        Lexer.char(trace, in, ',')
        val a3 = A3.unsafeDecode(traces(2) :: trace, in)
        Lexer.char(trace, in, ',')
        val a4 = A4.unsafeDecode(traces(3) :: trace, in)
        Lexer.char(trace, in, ',')
        val a5 = A5.unsafeDecode(traces(4) :: trace, in)
        Lexer.char(trace, in, ',')
        val a6 = A6.unsafeDecode(traces(5) :: trace, in)
        Lexer.char(trace, in, ',')
        val a7 = A7.unsafeDecode(traces(6) :: trace, in)
        Lexer.char(trace, in, ',')
        val a8 = A8.unsafeDecode(traces(7) :: trace, in)
        Lexer.char(trace, in, ',')
        val a9 = A9.unsafeDecode(traces(8) :: trace, in)
        Lexer.char(trace, in, ',')
        val a10 = A10.unsafeDecode(traces(9) :: trace, in)
        Lexer.char(trace, in, ',')
        val a11 = A11.unsafeDecode(traces(10) :: trace, in)
        Lexer.char(trace, in, ',')
        val a12 = A12.unsafeDecode(traces(11) :: trace, in)
        Lexer.char(trace, in, ']')
        new Tuple12(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12)
      }
    }

  implicit def tuple13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13](implicit A1: JsonDecoder[A1], A2: JsonDecoder[A2], A3: JsonDecoder[A3], A4: JsonDecoder[A4], A5: JsonDecoder[A5], A6: JsonDecoder[A6], A7: JsonDecoder[A7], A8: JsonDecoder[A8], A9: JsonDecoder[A9], A10: JsonDecoder[A10], A11: JsonDecoder[A11], A12: JsonDecoder[A12], A13: JsonDecoder[A13]): JsonDecoder[Tuple13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13]] =
    new JsonDecoder[Tuple13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13]] {
      private[this] val traces: Array[JsonError] = (0 to 12).map(JsonError.ArrayAccess(_)).toArray
      def unsafeDecode(trace: List[JsonError], in: RetractReader): Tuple13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13] = {
        Lexer.char(trace, in, '[')
        val a1 = A1.unsafeDecode(traces(0) :: trace, in)
        Lexer.char(trace, in, ',')
        val a2 = A2.unsafeDecode(traces(1) :: trace, in)
        Lexer.char(trace, in, ',')
        val a3 = A3.unsafeDecode(traces(2) :: trace, in)
        Lexer.char(trace, in, ',')
        val a4 = A4.unsafeDecode(traces(3) :: trace, in)
        Lexer.char(trace, in, ',')
        val a5 = A5.unsafeDecode(traces(4) :: trace, in)
        Lexer.char(trace, in, ',')
        val a6 = A6.unsafeDecode(traces(5) :: trace, in)
        Lexer.char(trace, in, ',')
        val a7 = A7.unsafeDecode(traces(6) :: trace, in)
        Lexer.char(trace, in, ',')
        val a8 = A8.unsafeDecode(traces(7) :: trace, in)
        Lexer.char(trace, in, ',')
        val a9 = A9.unsafeDecode(traces(8) :: trace, in)
        Lexer.char(trace, in, ',')
        val a10 = A10.unsafeDecode(traces(9) :: trace, in)
        Lexer.char(trace, in, ',')
        val a11 = A11.unsafeDecode(traces(10) :: trace, in)
        Lexer.char(trace, in, ',')
        val a12 = A12.unsafeDecode(traces(11) :: trace, in)
        Lexer.char(trace, in, ',')
        val a13 = A13.unsafeDecode(traces(12) :: trace, in)
        Lexer.char(trace, in, ']')
        new Tuple13(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13)
      }
    }

  implicit def tuple14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14](implicit A1: JsonDecoder[A1], A2: JsonDecoder[A2], A3: JsonDecoder[A3], A4: JsonDecoder[A4], A5: JsonDecoder[A5], A6: JsonDecoder[A6], A7: JsonDecoder[A7], A8: JsonDecoder[A8], A9: JsonDecoder[A9], A10: JsonDecoder[A10], A11: JsonDecoder[A11], A12: JsonDecoder[A12], A13: JsonDecoder[A13], A14: JsonDecoder[A14]): JsonDecoder[Tuple14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14]] =
    new JsonDecoder[Tuple14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14]] {
      private[this] val traces: Array[JsonError] = (0 to 13).map(JsonError.ArrayAccess(_)).toArray
      def unsafeDecode(trace: List[JsonError], in: RetractReader): Tuple14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14] = {
        Lexer.char(trace, in, '[')
        val a1 = A1.unsafeDecode(traces(0) :: trace, in)
        Lexer.char(trace, in, ',')
        val a2 = A2.unsafeDecode(traces(1) :: trace, in)
        Lexer.char(trace, in, ',')
        val a3 = A3.unsafeDecode(traces(2) :: trace, in)
        Lexer.char(trace, in, ',')
        val a4 = A4.unsafeDecode(traces(3) :: trace, in)
        Lexer.char(trace, in, ',')
        val a5 = A5.unsafeDecode(traces(4) :: trace, in)
        Lexer.char(trace, in, ',')
        val a6 = A6.unsafeDecode(traces(5) :: trace, in)
        Lexer.char(trace, in, ',')
        val a7 = A7.unsafeDecode(traces(6) :: trace, in)
        Lexer.char(trace, in, ',')
        val a8 = A8.unsafeDecode(traces(7) :: trace, in)
        Lexer.char(trace, in, ',')
        val a9 = A9.unsafeDecode(traces(8) :: trace, in)
        Lexer.char(trace, in, ',')
        val a10 = A10.unsafeDecode(traces(9) :: trace, in)
        Lexer.char(trace, in, ',')
        val a11 = A11.unsafeDecode(traces(10) :: trace, in)
        Lexer.char(trace, in, ',')
        val a12 = A12.unsafeDecode(traces(11) :: trace, in)
        Lexer.char(trace, in, ',')
        val a13 = A13.unsafeDecode(traces(12) :: trace, in)
        Lexer.char(trace, in, ',')
        val a14 = A14.unsafeDecode(traces(13) :: trace, in)
        Lexer.char(trace, in, ']')
        new Tuple14(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14)
      }
    }

  implicit def tuple15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15](implicit A1: JsonDecoder[A1], A2: JsonDecoder[A2], A3: JsonDecoder[A3], A4: JsonDecoder[A4], A5: JsonDecoder[A5], A6: JsonDecoder[A6], A7: JsonDecoder[A7], A8: JsonDecoder[A8], A9: JsonDecoder[A9], A10: JsonDecoder[A10], A11: JsonDecoder[A11], A12: JsonDecoder[A12], A13: JsonDecoder[A13], A14: JsonDecoder[A14], A15: JsonDecoder[A15]): JsonDecoder[Tuple15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15]] =
    new JsonDecoder[Tuple15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15]] {
      private[this] val traces: Array[JsonError] = (0 to 14).map(JsonError.ArrayAccess(_)).toArray
      def unsafeDecode(trace: List[JsonError], in: RetractReader): Tuple15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15] = {
        Lexer.char(trace, in, '[')
        val a1 = A1.unsafeDecode(traces(0) :: trace, in)
        Lexer.char(trace, in, ',')
        val a2 = A2.unsafeDecode(traces(1) :: trace, in)
        Lexer.char(trace, in, ',')
        val a3 = A3.unsafeDecode(traces(2) :: trace, in)
        Lexer.char(trace, in, ',')
        val a4 = A4.unsafeDecode(traces(3) :: trace, in)
        Lexer.char(trace, in, ',')
        val a5 = A5.unsafeDecode(traces(4) :: trace, in)
        Lexer.char(trace, in, ',')
        val a6 = A6.unsafeDecode(traces(5) :: trace, in)
        Lexer.char(trace, in, ',')
        val a7 = A7.unsafeDecode(traces(6) :: trace, in)
        Lexer.char(trace, in, ',')
        val a8 = A8.unsafeDecode(traces(7) :: trace, in)
        Lexer.char(trace, in, ',')
        val a9 = A9.unsafeDecode(traces(8) :: trace, in)
        Lexer.char(trace, in, ',')
        val a10 = A10.unsafeDecode(traces(9) :: trace, in)
        Lexer.char(trace, in, ',')
        val a11 = A11.unsafeDecode(traces(10) :: trace, in)
        Lexer.char(trace, in, ',')
        val a12 = A12.unsafeDecode(traces(11) :: trace, in)
        Lexer.char(trace, in, ',')
        val a13 = A13.unsafeDecode(traces(12) :: trace, in)
        Lexer.char(trace, in, ',')
        val a14 = A14.unsafeDecode(traces(13) :: trace, in)
        Lexer.char(trace, in, ',')
        val a15 = A15.unsafeDecode(traces(14) :: trace, in)
        Lexer.char(trace, in, ']')
        new Tuple15(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15)
      }
    }

  implicit def tuple16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16](implicit A1: JsonDecoder[A1], A2: JsonDecoder[A2], A3: JsonDecoder[A3], A4: JsonDecoder[A4], A5: JsonDecoder[A5], A6: JsonDecoder[A6], A7: JsonDecoder[A7], A8: JsonDecoder[A8], A9: JsonDecoder[A9], A10: JsonDecoder[A10], A11: JsonDecoder[A11], A12: JsonDecoder[A12], A13: JsonDecoder[A13], A14: JsonDecoder[A14], A15: JsonDecoder[A15], A16: JsonDecoder[A16]): JsonDecoder[Tuple16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16]] =
    new JsonDecoder[Tuple16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16]] {
      private[this] val traces: Array[JsonError] = (0 to 15).map(JsonError.ArrayAccess(_)).toArray
      def unsafeDecode(trace: List[JsonError], in: RetractReader): Tuple16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16] = {
        Lexer.char(trace, in, '[')
        val a1 = A1.unsafeDecode(traces(0) :: trace, in)
        Lexer.char(trace, in, ',')
        val a2 = A2.unsafeDecode(traces(1) :: trace, in)
        Lexer.char(trace, in, ',')
        val a3 = A3.unsafeDecode(traces(2) :: trace, in)
        Lexer.char(trace, in, ',')
        val a4 = A4.unsafeDecode(traces(3) :: trace, in)
        Lexer.char(trace, in, ',')
        val a5 = A5.unsafeDecode(traces(4) :: trace, in)
        Lexer.char(trace, in, ',')
        val a6 = A6.unsafeDecode(traces(5) :: trace, in)
        Lexer.char(trace, in, ',')
        val a7 = A7.unsafeDecode(traces(6) :: trace, in)
        Lexer.char(trace, in, ',')
        val a8 = A8.unsafeDecode(traces(7) :: trace, in)
        Lexer.char(trace, in, ',')
        val a9 = A9.unsafeDecode(traces(8) :: trace, in)
        Lexer.char(trace, in, ',')
        val a10 = A10.unsafeDecode(traces(9) :: trace, in)
        Lexer.char(trace, in, ',')
        val a11 = A11.unsafeDecode(traces(10) :: trace, in)
        Lexer.char(trace, in, ',')
        val a12 = A12.unsafeDecode(traces(11) :: trace, in)
        Lexer.char(trace, in, ',')
        val a13 = A13.unsafeDecode(traces(12) :: trace, in)
        Lexer.char(trace, in, ',')
        val a14 = A14.unsafeDecode(traces(13) :: trace, in)
        Lexer.char(trace, in, ',')
        val a15 = A15.unsafeDecode(traces(14) :: trace, in)
        Lexer.char(trace, in, ',')
        val a16 = A16.unsafeDecode(traces(15) :: trace, in)
        Lexer.char(trace, in, ']')
        new Tuple16(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16)
      }
    }

  implicit def tuple17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17](implicit A1: JsonDecoder[A1], A2: JsonDecoder[A2], A3: JsonDecoder[A3], A4: JsonDecoder[A4], A5: JsonDecoder[A5], A6: JsonDecoder[A6], A7: JsonDecoder[A7], A8: JsonDecoder[A8], A9: JsonDecoder[A9], A10: JsonDecoder[A10], A11: JsonDecoder[A11], A12: JsonDecoder[A12], A13: JsonDecoder[A13], A14: JsonDecoder[A14], A15: JsonDecoder[A15], A16: JsonDecoder[A16], A17: JsonDecoder[A17]): JsonDecoder[Tuple17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17]] =
    new JsonDecoder[Tuple17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17]] {
      private[this] val traces: Array[JsonError] = (0 to 16).map(JsonError.ArrayAccess(_)).toArray
      def unsafeDecode(trace: List[JsonError], in: RetractReader): Tuple17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17] = {
        Lexer.char(trace, in, '[')
        val a1 = A1.unsafeDecode(traces(0) :: trace, in)
        Lexer.char(trace, in, ',')
        val a2 = A2.unsafeDecode(traces(1) :: trace, in)
        Lexer.char(trace, in, ',')
        val a3 = A3.unsafeDecode(traces(2) :: trace, in)
        Lexer.char(trace, in, ',')
        val a4 = A4.unsafeDecode(traces(3) :: trace, in)
        Lexer.char(trace, in, ',')
        val a5 = A5.unsafeDecode(traces(4) :: trace, in)
        Lexer.char(trace, in, ',')
        val a6 = A6.unsafeDecode(traces(5) :: trace, in)
        Lexer.char(trace, in, ',')
        val a7 = A7.unsafeDecode(traces(6) :: trace, in)
        Lexer.char(trace, in, ',')
        val a8 = A8.unsafeDecode(traces(7) :: trace, in)
        Lexer.char(trace, in, ',')
        val a9 = A9.unsafeDecode(traces(8) :: trace, in)
        Lexer.char(trace, in, ',')
        val a10 = A10.unsafeDecode(traces(9) :: trace, in)
        Lexer.char(trace, in, ',')
        val a11 = A11.unsafeDecode(traces(10) :: trace, in)
        Lexer.char(trace, in, ',')
        val a12 = A12.unsafeDecode(traces(11) :: trace, in)
        Lexer.char(trace, in, ',')
        val a13 = A13.unsafeDecode(traces(12) :: trace, in)
        Lexer.char(trace, in, ',')
        val a14 = A14.unsafeDecode(traces(13) :: trace, in)
        Lexer.char(trace, in, ',')
        val a15 = A15.unsafeDecode(traces(14) :: trace, in)
        Lexer.char(trace, in, ',')
        val a16 = A16.unsafeDecode(traces(15) :: trace, in)
        Lexer.char(trace, in, ',')
        val a17 = A17.unsafeDecode(traces(16) :: trace, in)
        Lexer.char(trace, in, ']')
        new Tuple17(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17)
      }
    }

  implicit def tuple18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18](implicit A1: JsonDecoder[A1], A2: JsonDecoder[A2], A3: JsonDecoder[A3], A4: JsonDecoder[A4], A5: JsonDecoder[A5], A6: JsonDecoder[A6], A7: JsonDecoder[A7], A8: JsonDecoder[A8], A9: JsonDecoder[A9], A10: JsonDecoder[A10], A11: JsonDecoder[A11], A12: JsonDecoder[A12], A13: JsonDecoder[A13], A14: JsonDecoder[A14], A15: JsonDecoder[A15], A16: JsonDecoder[A16], A17: JsonDecoder[A17], A18: JsonDecoder[A18]): JsonDecoder[Tuple18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18]] =
    new JsonDecoder[Tuple18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18]] {
      private[this] val traces: Array[JsonError] = (0 to 17).map(JsonError.ArrayAccess(_)).toArray
      def unsafeDecode(trace: List[JsonError], in: RetractReader): Tuple18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18] = {
        Lexer.char(trace, in, '[')
        val a1 = A1.unsafeDecode(traces(0) :: trace, in)
        Lexer.char(trace, in, ',')
        val a2 = A2.unsafeDecode(traces(1) :: trace, in)
        Lexer.char(trace, in, ',')
        val a3 = A3.unsafeDecode(traces(2) :: trace, in)
        Lexer.char(trace, in, ',')
        val a4 = A4.unsafeDecode(traces(3) :: trace, in)
        Lexer.char(trace, in, ',')
        val a5 = A5.unsafeDecode(traces(4) :: trace, in)
        Lexer.char(trace, in, ',')
        val a6 = A6.unsafeDecode(traces(5) :: trace, in)
        Lexer.char(trace, in, ',')
        val a7 = A7.unsafeDecode(traces(6) :: trace, in)
        Lexer.char(trace, in, ',')
        val a8 = A8.unsafeDecode(traces(7) :: trace, in)
        Lexer.char(trace, in, ',')
        val a9 = A9.unsafeDecode(traces(8) :: trace, in)
        Lexer.char(trace, in, ',')
        val a10 = A10.unsafeDecode(traces(9) :: trace, in)
        Lexer.char(trace, in, ',')
        val a11 = A11.unsafeDecode(traces(10) :: trace, in)
        Lexer.char(trace, in, ',')
        val a12 = A12.unsafeDecode(traces(11) :: trace, in)
        Lexer.char(trace, in, ',')
        val a13 = A13.unsafeDecode(traces(12) :: trace, in)
        Lexer.char(trace, in, ',')
        val a14 = A14.unsafeDecode(traces(13) :: trace, in)
        Lexer.char(trace, in, ',')
        val a15 = A15.unsafeDecode(traces(14) :: trace, in)
        Lexer.char(trace, in, ',')
        val a16 = A16.unsafeDecode(traces(15) :: trace, in)
        Lexer.char(trace, in, ',')
        val a17 = A17.unsafeDecode(traces(16) :: trace, in)
        Lexer.char(trace, in, ',')
        val a18 = A18.unsafeDecode(traces(17) :: trace, in)
        Lexer.char(trace, in, ']')
        new Tuple18(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18)
      }
    }

  implicit def tuple19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19](implicit A1: JsonDecoder[A1], A2: JsonDecoder[A2], A3: JsonDecoder[A3], A4: JsonDecoder[A4], A5: JsonDecoder[A5], A6: JsonDecoder[A6], A7: JsonDecoder[A7], A8: JsonDecoder[A8], A9: JsonDecoder[A9], A10: JsonDecoder[A10], A11: JsonDecoder[A11], A12: JsonDecoder[A12], A13: JsonDecoder[A13], A14: JsonDecoder[A14], A15: JsonDecoder[A15], A16: JsonDecoder[A16], A17: JsonDecoder[A17], A18: JsonDecoder[A18], A19: JsonDecoder[A19]): JsonDecoder[Tuple19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19]] =
    new JsonDecoder[Tuple19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19]] {
      private[this] val traces: Array[JsonError] = (0 to 18).map(JsonError.ArrayAccess(_)).toArray
      def unsafeDecode(trace: List[JsonError], in: RetractReader): Tuple19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19] = {
        Lexer.char(trace, in, '[')
        val a1 = A1.unsafeDecode(traces(0) :: trace, in)
        Lexer.char(trace, in, ',')
        val a2 = A2.unsafeDecode(traces(1) :: trace, in)
        Lexer.char(trace, in, ',')
        val a3 = A3.unsafeDecode(traces(2) :: trace, in)
        Lexer.char(trace, in, ',')
        val a4 = A4.unsafeDecode(traces(3) :: trace, in)
        Lexer.char(trace, in, ',')
        val a5 = A5.unsafeDecode(traces(4) :: trace, in)
        Lexer.char(trace, in, ',')
        val a6 = A6.unsafeDecode(traces(5) :: trace, in)
        Lexer.char(trace, in, ',')
        val a7 = A7.unsafeDecode(traces(6) :: trace, in)
        Lexer.char(trace, in, ',')
        val a8 = A8.unsafeDecode(traces(7) :: trace, in)
        Lexer.char(trace, in, ',')
        val a9 = A9.unsafeDecode(traces(8) :: trace, in)
        Lexer.char(trace, in, ',')
        val a10 = A10.unsafeDecode(traces(9) :: trace, in)
        Lexer.char(trace, in, ',')
        val a11 = A11.unsafeDecode(traces(10) :: trace, in)
        Lexer.char(trace, in, ',')
        val a12 = A12.unsafeDecode(traces(11) :: trace, in)
        Lexer.char(trace, in, ',')
        val a13 = A13.unsafeDecode(traces(12) :: trace, in)
        Lexer.char(trace, in, ',')
        val a14 = A14.unsafeDecode(traces(13) :: trace, in)
        Lexer.char(trace, in, ',')
        val a15 = A15.unsafeDecode(traces(14) :: trace, in)
        Lexer.char(trace, in, ',')
        val a16 = A16.unsafeDecode(traces(15) :: trace, in)
        Lexer.char(trace, in, ',')
        val a17 = A17.unsafeDecode(traces(16) :: trace, in)
        Lexer.char(trace, in, ',')
        val a18 = A18.unsafeDecode(traces(17) :: trace, in)
        Lexer.char(trace, in, ',')
        val a19 = A19.unsafeDecode(traces(18) :: trace, in)
        Lexer.char(trace, in, ']')
        new Tuple19(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19)
      }
    }

  implicit def tuple20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20](implicit A1: JsonDecoder[A1], A2: JsonDecoder[A2], A3: JsonDecoder[A3], A4: JsonDecoder[A4], A5: JsonDecoder[A5], A6: JsonDecoder[A6], A7: JsonDecoder[A7], A8: JsonDecoder[A8], A9: JsonDecoder[A9], A10: JsonDecoder[A10], A11: JsonDecoder[A11], A12: JsonDecoder[A12], A13: JsonDecoder[A13], A14: JsonDecoder[A14], A15: JsonDecoder[A15], A16: JsonDecoder[A16], A17: JsonDecoder[A17], A18: JsonDecoder[A18], A19: JsonDecoder[A19], A20: JsonDecoder[A20]): JsonDecoder[Tuple20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20]] =
    new JsonDecoder[Tuple20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20]] {
      private[this] val traces: Array[JsonError] = (0 to 19).map(JsonError.ArrayAccess(_)).toArray
      def unsafeDecode(trace: List[JsonError], in: RetractReader): Tuple20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20] = {
        Lexer.char(trace, in, '[')
        val a1 = A1.unsafeDecode(traces(0) :: trace, in)
        Lexer.char(trace, in, ',')
        val a2 = A2.unsafeDecode(traces(1) :: trace, in)
        Lexer.char(trace, in, ',')
        val a3 = A3.unsafeDecode(traces(2) :: trace, in)
        Lexer.char(trace, in, ',')
        val a4 = A4.unsafeDecode(traces(3) :: trace, in)
        Lexer.char(trace, in, ',')
        val a5 = A5.unsafeDecode(traces(4) :: trace, in)
        Lexer.char(trace, in, ',')
        val a6 = A6.unsafeDecode(traces(5) :: trace, in)
        Lexer.char(trace, in, ',')
        val a7 = A7.unsafeDecode(traces(6) :: trace, in)
        Lexer.char(trace, in, ',')
        val a8 = A8.unsafeDecode(traces(7) :: trace, in)
        Lexer.char(trace, in, ',')
        val a9 = A9.unsafeDecode(traces(8) :: trace, in)
        Lexer.char(trace, in, ',')
        val a10 = A10.unsafeDecode(traces(9) :: trace, in)
        Lexer.char(trace, in, ',')
        val a11 = A11.unsafeDecode(traces(10) :: trace, in)
        Lexer.char(trace, in, ',')
        val a12 = A12.unsafeDecode(traces(11) :: trace, in)
        Lexer.char(trace, in, ',')
        val a13 = A13.unsafeDecode(traces(12) :: trace, in)
        Lexer.char(trace, in, ',')
        val a14 = A14.unsafeDecode(traces(13) :: trace, in)
        Lexer.char(trace, in, ',')
        val a15 = A15.unsafeDecode(traces(14) :: trace, in)
        Lexer.char(trace, in, ',')
        val a16 = A16.unsafeDecode(traces(15) :: trace, in)
        Lexer.char(trace, in, ',')
        val a17 = A17.unsafeDecode(traces(16) :: trace, in)
        Lexer.char(trace, in, ',')
        val a18 = A18.unsafeDecode(traces(17) :: trace, in)
        Lexer.char(trace, in, ',')
        val a19 = A19.unsafeDecode(traces(18) :: trace, in)
        Lexer.char(trace, in, ',')
        val a20 = A20.unsafeDecode(traces(19) :: trace, in)
        Lexer.char(trace, in, ']')
        new Tuple20(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20)
      }
    }

  implicit def tuple21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21](implicit A1: JsonDecoder[A1], A2: JsonDecoder[A2], A3: JsonDecoder[A3], A4: JsonDecoder[A4], A5: JsonDecoder[A5], A6: JsonDecoder[A6], A7: JsonDecoder[A7], A8: JsonDecoder[A8], A9: JsonDecoder[A9], A10: JsonDecoder[A10], A11: JsonDecoder[A11], A12: JsonDecoder[A12], A13: JsonDecoder[A13], A14: JsonDecoder[A14], A15: JsonDecoder[A15], A16: JsonDecoder[A16], A17: JsonDecoder[A17], A18: JsonDecoder[A18], A19: JsonDecoder[A19], A20: JsonDecoder[A20], A21: JsonDecoder[A21]): JsonDecoder[Tuple21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21]] =
    new JsonDecoder[Tuple21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21]] {
      private[this] val traces: Array[JsonError] = (0 to 20).map(JsonError.ArrayAccess(_)).toArray
      def unsafeDecode(trace: List[JsonError], in: RetractReader): Tuple21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21] = {
        Lexer.char(trace, in, '[')
        val a1 = A1.unsafeDecode(traces(0) :: trace, in)
        Lexer.char(trace, in, ',')
        val a2 = A2.unsafeDecode(traces(1) :: trace, in)
        Lexer.char(trace, in, ',')
        val a3 = A3.unsafeDecode(traces(2) :: trace, in)
        Lexer.char(trace, in, ',')
        val a4 = A4.unsafeDecode(traces(3) :: trace, in)
        Lexer.char(trace, in, ',')
        val a5 = A5.unsafeDecode(traces(4) :: trace, in)
        Lexer.char(trace, in, ',')
        val a6 = A6.unsafeDecode(traces(5) :: trace, in)
        Lexer.char(trace, in, ',')
        val a7 = A7.unsafeDecode(traces(6) :: trace, in)
        Lexer.char(trace, in, ',')
        val a8 = A8.unsafeDecode(traces(7) :: trace, in)
        Lexer.char(trace, in, ',')
        val a9 = A9.unsafeDecode(traces(8) :: trace, in)
        Lexer.char(trace, in, ',')
        val a10 = A10.unsafeDecode(traces(9) :: trace, in)
        Lexer.char(trace, in, ',')
        val a11 = A11.unsafeDecode(traces(10) :: trace, in)
        Lexer.char(trace, in, ',')
        val a12 = A12.unsafeDecode(traces(11) :: trace, in)
        Lexer.char(trace, in, ',')
        val a13 = A13.unsafeDecode(traces(12) :: trace, in)
        Lexer.char(trace, in, ',')
        val a14 = A14.unsafeDecode(traces(13) :: trace, in)
        Lexer.char(trace, in, ',')
        val a15 = A15.unsafeDecode(traces(14) :: trace, in)
        Lexer.char(trace, in, ',')
        val a16 = A16.unsafeDecode(traces(15) :: trace, in)
        Lexer.char(trace, in, ',')
        val a17 = A17.unsafeDecode(traces(16) :: trace, in)
        Lexer.char(trace, in, ',')
        val a18 = A18.unsafeDecode(traces(17) :: trace, in)
        Lexer.char(trace, in, ',')
        val a19 = A19.unsafeDecode(traces(18) :: trace, in)
        Lexer.char(trace, in, ',')
        val a20 = A20.unsafeDecode(traces(19) :: trace, in)
        Lexer.char(trace, in, ',')
        val a21 = A21.unsafeDecode(traces(20) :: trace, in)
        Lexer.char(trace, in, ']')
        new Tuple21(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21)
      }
    }

  implicit def tuple22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22](implicit A1: JsonDecoder[A1], A2: JsonDecoder[A2], A3: JsonDecoder[A3], A4: JsonDecoder[A4], A5: JsonDecoder[A5], A6: JsonDecoder[A6], A7: JsonDecoder[A7], A8: JsonDecoder[A8], A9: JsonDecoder[A9], A10: JsonDecoder[A10], A11: JsonDecoder[A11], A12: JsonDecoder[A12], A13: JsonDecoder[A13], A14: JsonDecoder[A14], A15: JsonDecoder[A15], A16: JsonDecoder[A16], A17: JsonDecoder[A17], A18: JsonDecoder[A18], A19: JsonDecoder[A19], A20: JsonDecoder[A20], A21: JsonDecoder[A21], A22: JsonDecoder[A22]): JsonDecoder[Tuple22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22]] =
    new JsonDecoder[Tuple22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22]] {
      private[this] val traces: Array[JsonError] = (0 to 21).map(JsonError.ArrayAccess(_)).toArray
      def unsafeDecode(trace: List[JsonError], in: RetractReader): Tuple22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22] = {
        Lexer.char(trace, in, '[')
        val a1 = A1.unsafeDecode(traces(0) :: trace, in)
        Lexer.char(trace, in, ',')
        val a2 = A2.unsafeDecode(traces(1) :: trace, in)
        Lexer.char(trace, in, ',')
        val a3 = A3.unsafeDecode(traces(2) :: trace, in)
        Lexer.char(trace, in, ',')
        val a4 = A4.unsafeDecode(traces(3) :: trace, in)
        Lexer.char(trace, in, ',')
        val a5 = A5.unsafeDecode(traces(4) :: trace, in)
        Lexer.char(trace, in, ',')
        val a6 = A6.unsafeDecode(traces(5) :: trace, in)
        Lexer.char(trace, in, ',')
        val a7 = A7.unsafeDecode(traces(6) :: trace, in)
        Lexer.char(trace, in, ',')
        val a8 = A8.unsafeDecode(traces(7) :: trace, in)
        Lexer.char(trace, in, ',')
        val a9 = A9.unsafeDecode(traces(8) :: trace, in)
        Lexer.char(trace, in, ',')
        val a10 = A10.unsafeDecode(traces(9) :: trace, in)
        Lexer.char(trace, in, ',')
        val a11 = A11.unsafeDecode(traces(10) :: trace, in)
        Lexer.char(trace, in, ',')
        val a12 = A12.unsafeDecode(traces(11) :: trace, in)
        Lexer.char(trace, in, ',')
        val a13 = A13.unsafeDecode(traces(12) :: trace, in)
        Lexer.char(trace, in, ',')
        val a14 = A14.unsafeDecode(traces(13) :: trace, in)
        Lexer.char(trace, in, ',')
        val a15 = A15.unsafeDecode(traces(14) :: trace, in)
        Lexer.char(trace, in, ',')
        val a16 = A16.unsafeDecode(traces(15) :: trace, in)
        Lexer.char(trace, in, ',')
        val a17 = A17.unsafeDecode(traces(16) :: trace, in)
        Lexer.char(trace, in, ',')
        val a18 = A18.unsafeDecode(traces(17) :: trace, in)
        Lexer.char(trace, in, ',')
        val a19 = A19.unsafeDecode(traces(18) :: trace, in)
        Lexer.char(trace, in, ',')
        val a20 = A20.unsafeDecode(traces(19) :: trace, in)
        Lexer.char(trace, in, ',')
        val a21 = A21.unsafeDecode(traces(20) :: trace, in)
        Lexer.char(trace, in, ',')
        val a22 = A22.unsafeDecode(traces(21) :: trace, in)
        Lexer.char(trace, in, ']')
        new Tuple22(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22)
      }
    }
}