/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.server;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.pkitesting.CertificateBuilder;
import io.netty.pkitesting.X509Bundle;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple3;
import scala.Tuple3$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.util.Using;
import zio.Config;
import zio.http.ClientAuth;
import zio.http.ClientAuth$Optional$;
import zio.http.ClientAuth$Required$;
import zio.http.SSLConfig;
import zio.http.SSLConfig$Data$FromFile$;
import zio.http.SSLConfig$Data$FromJavaxNetSsl$;
import zio.http.SSLConfig$Data$FromJavaxNetSsl$File$;
import zio.http.SSLConfig$Data$FromJavaxNetSsl$Resource$;
import zio.http.SSLConfig$Data$FromResource$;
import zio.http.SSLConfig$Data$Generate$;
import zio.http.netty.server.SSLUtil;

public final class SSLUtil$
implements Serializable {
    public static final SSLUtil$ MODULE$ = new SSLUtil$();

    private SSLUtil$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SSLUtil$.class);
    }

    public final SSLUtil.SslContextBuilderOps SslContextBuilderOps(SslContextBuilder self) {
        return new SSLUtil.SslContextBuilderOps(self);
    }

    public io.netty.handler.ssl.ClientAuth getClientAuth(ClientAuth clientAuth) {
        ClientAuth clientAuth2 = clientAuth;
        if (ClientAuth$Required$.MODULE$.equals(clientAuth2)) {
            return io.netty.handler.ssl.ClientAuth.REQUIRE;
        }
        if (ClientAuth$Optional$.MODULE$.equals(clientAuth2)) {
            return io.netty.handler.ssl.ClientAuth.OPTIONAL;
        }
        return io.netty.handler.ssl.ClientAuth.NONE;
    }

    public SslContext buildSslServerContext(SSLConfig sslConfig, InputStream certInputStream, InputStream keyInputStream, Option<InputStream> trustCertCollectionPath) {
        SslContextBuilder sslServerContext = SslContextBuilder.forServer((InputStream)certInputStream, (InputStream)keyInputStream);
        trustCertCollectionPath.foreach((Function1 & Serializable)stream -> sslServerContext.trustManager(stream));
        return this.SslContextBuilderOps(sslServerContext).buildWithDefaultOptions(sslConfig);
    }

    public SslContext sslConfigToSslContext(SSLConfig sslConfig) {
        SSLConfig.Data data = sslConfig.data();
        if (SSLConfig$Data$Generate$.MODULE$.equals(data)) {
            X509Bundle selfSigned = new CertificateBuilder().rsa2048().buildSelfSigned();
            return this.SslContextBuilderOps(SslContextBuilder.forServer((PrivateKey)selfSigned.getKeyPair().getPrivate(), (X509Certificate[])new X509Certificate[]{selfSigned.getCertificate()})).buildWithDefaultOptions(sslConfig);
        }
        if (data instanceof SSLConfig.Data.FromFile) {
            SSLConfig.Data.FromFile fromFile = SSLConfig$Data$FromFile$.MODULE$.unapply((SSLConfig.Data.FromFile)data);
            String string = fromFile._1();
            String string2 = fromFile._2();
            Option<String> option = fromFile._3();
            String certPath = string;
            String keyPath = string2;
            Option<String> trustCertCollectionPath = option;
            return (SslContext)Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
                FileInputStream certInputStream = (FileInputStream)use.apply((Object)new FileInputStream(certPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                FileInputStream keyInputStream = (FileInputStream)use.apply((Object)new FileInputStream(keyPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                Option trustCertInputStream = trustCertCollectionPath.map((Function1 & Serializable)path -> (FileInputStream)use.apply((Object)new FileInputStream((String)path), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
                return MODULE$.buildSslServerContext(sslConfig, certInputStream, keyInputStream, (Option<InputStream>)trustCertInputStream);
            }).get();
        }
        if (data instanceof SSLConfig.Data.FromResource) {
            SSLConfig.Data.FromResource fromResource = SSLConfig$Data$FromResource$.MODULE$.unapply((SSLConfig.Data.FromResource)data);
            String string = fromResource._1();
            String string3 = fromResource._2();
            Option<String> option = fromResource._3();
            String certPath = string;
            String keyPath = string3;
            Option<String> trustCertCollectionPath = option;
            ClassLoader classLoader = this.getClass().getClassLoader();
            return (SslContext)Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
                InputStream certInputStream = (InputStream)use.apply((Object)classLoader.getResourceAsStream(certPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                InputStream keyInputStream = (InputStream)use.apply((Object)classLoader.getResourceAsStream(keyPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                Option trustCertInputStream = trustCertCollectionPath.map((Function1 & Serializable)path -> (InputStream)use.apply((Object)classLoader.getResourceAsStream((String)path), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
                return MODULE$.buildSslServerContext(sslConfig, certInputStream, keyInputStream, (Option<InputStream>)trustCertInputStream);
            }).get();
        }
        if (data instanceof SSLConfig.Data.FromJavaxNetSsl) {
            Tuple3 tuple3;
            SSLConfig.Data.FromJavaxNetSsl fromJavaxNetSsl = SSLConfig$Data$FromJavaxNetSsl$.MODULE$.unapply((SSLConfig.Data.FromJavaxNetSsl)data);
            String string = fromJavaxNetSsl._1();
            SSLConfig.Data.FromJavaxNetSsl.Source source = fromJavaxNetSsl._2();
            Option<Config.Secret> option = fromJavaxNetSsl._3();
            Option<SSLConfig.Data.TrustManagerKeyStore> option2 = fromJavaxNetSsl._4();
            String keyManagerKeyStoreType = string;
            SSLConfig.Data.FromJavaxNetSsl.Source keyManagerSource = source;
            Option<Config.Secret> keyManagerPassword = option;
            Option<SSLConfig.Data.TrustManagerKeyStore> trustManager2 = option2;
            SSLConfig.Data.FromJavaxNetSsl.Source source2 = keyManagerSource;
            if (source2 instanceof SSLConfig.Data.FromJavaxNetSsl.File) {
                String string4;
                SSLConfig.Data.FromJavaxNetSsl.File file = SSLConfig$Data$FromJavaxNetSsl$File$.MODULE$.unapply((SSLConfig.Data.FromJavaxNetSsl.File)source2);
                String path = string4 = file._1();
                FileInputStream inputStream = new FileInputStream(path);
                tuple3 = Tuple3$.MODULE$.apply((Object)keyManagerKeyStoreType, (Object)inputStream, keyManagerPassword);
            } else if (source2 instanceof SSLConfig.Data.FromJavaxNetSsl.Resource) {
                String string5;
                SSLConfig.Data.FromJavaxNetSsl.Resource resource = SSLConfig$Data$FromJavaxNetSsl$Resource$.MODULE$.unapply((SSLConfig.Data.FromJavaxNetSsl.Resource)source2);
                String path = string5 = resource._1();
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(path);
                tuple3 = Tuple3$.MODULE$.apply((Object)keyManagerKeyStoreType, (Object)inputStream, keyManagerPassword);
            } else {
                throw new MatchError((Object)source2);
            }
            Tuple3 keyManagerInfo = tuple3;
            Option trustManagerInfo = trustManager2.map((Function1 & Serializable)trustManager -> {
                InputStream inputStream;
                SSLConfig.Data.FromJavaxNetSsl.Source source = trustManager.trustManagerSource();
                if (source instanceof SSLConfig.Data.FromJavaxNetSsl.File) {
                    String string;
                    SSLConfig.Data.FromJavaxNetSsl.File file = SSLConfig$Data$FromJavaxNetSsl$File$.MODULE$.unapply((SSLConfig.Data.FromJavaxNetSsl.File)source);
                    String path = string = file._1();
                    inputStream = new FileInputStream(path);
                } else if (source instanceof SSLConfig.Data.FromJavaxNetSsl.Resource) {
                    String string;
                    SSLConfig.Data.FromJavaxNetSsl.Resource resource = SSLConfig$Data$FromJavaxNetSsl$Resource$.MODULE$.unapply((SSLConfig.Data.FromJavaxNetSsl.Resource)source);
                    String path = string = resource._1();
                    inputStream = MODULE$.getClass().getClassLoader().getResourceAsStream(path);
                } else {
                    throw new MatchError((Object)source);
                }
                FileInputStream inputStream2 = inputStream;
                return Tuple3$.MODULE$.apply((Object)trustManager.trustManagerKeyStoreType(), (Object)inputStream2, trustManager.trustManagerPassword());
            });
            return this.SslContextBuilderOps(this.keyManagerTrustManagerToSslContext((Tuple3<String, InputStream, Option<Config.Secret>>)keyManagerInfo, (Option<Tuple3<String, InputStream, Option<Config.Secret>>>)trustManagerInfo)).buildWithDefaultOptions(sslConfig);
        }
        throw new MatchError((Object)data);
    }

    private SslContextBuilder keyManagerTrustManagerToSslContext(Tuple3<String, InputStream, Option<Config.Secret>> keyManagerInfo, Option<Tuple3<String, InputStream, Option<Config.Secret>>> trustManagerInfo) {
        Tuple3<String, InputStream, Option<Config.Secret>> tuple3 = keyManagerInfo;
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String keyStoreType = (String)tuple3._1();
        InputStream inputStream = (InputStream)tuple3._2();
        Option maybePassword = (Option)tuple3._3();
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        char[] password = (char[])maybePassword.map((Function1 & Serializable)_$1 -> (char[])_$1.value().toArray(ClassTag$.MODULE$.apply(Character.TYPE))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        keyStore.load(inputStream, password);
        keyManagerFactory.init(keyStore, password);
        KeyManagerFactory mkeyManagerFactory = keyManagerFactory;
        Option mtrustManagerFactory = trustManagerInfo.map((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                String keyStoreType = (String)tuple3._1();
                InputStream inputStream = (InputStream)tuple3._2();
                Option maybePassword = (Option)tuple3._3();
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                char[] password = (char[])maybePassword.map((Function1 & Serializable)_$2 -> (char[])_$2.value().toArray(ClassTag$.MODULE$.apply(Character.TYPE))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                keyStore.load(inputStream, password);
                trustManagerFactory.init(keyStore);
                return trustManagerFactory;
            }
            throw new MatchError((Object)tuple3);
        });
        ObjectRef bldr = ObjectRef.create((Object)SslContextBuilder.forServer((KeyManagerFactory)mkeyManagerFactory));
        mtrustManagerFactory.foreach((Function1)(JProcedure1 & Serializable)tmf -> {
            bldr$1.elem = ((SslContextBuilder)bldr$1.elem).trustManager(tmf);
        });
        return (SslContextBuilder)bldr.elem;
    }
}

