/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.Future;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import zio.CanFail;
import zio.CanFail$;
import zio.Chunk;
import zio.NonEmptyChunk;
import zio.NonEmptyChunk$;
import zio.Random$;
import zio.Scope;
import zio.Scope$;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZKeyedPool;
import zio.ZKeyedPool$;
import zio.http.ClientSSLConfig;
import zio.http.ConnectionPoolConfig;
import zio.http.ConnectionPoolConfig$Disabled$;
import zio.http.ConnectionPoolConfig$Dynamic$;
import zio.http.ConnectionPoolConfig$DynamicPerHost$;
import zio.http.ConnectionPoolConfig$Fixed$;
import zio.http.ConnectionPoolConfig$FixedPerHost$;
import zio.http.Decompression;
import zio.http.DnsResolver;
import zio.http.Proxy;
import zio.http.URL;
import zio.http.netty.NettyFutureExecutor$;
import zio.http.netty.NettyProxy$;
import zio.http.netty.NettyRuntime;
import zio.http.netty.client.ClientSSLConverter$;
import zio.http.netty.client.NettyClientDriver;
import zio.http.netty.client.NettyConnectionPool;
import zio.http.netty.client.NettyConnectionPool$BootstrapSyntax$;
import zio.http.netty.client.NettyConnectionPool$PoolKey$;
import zio.http.netty.package$Names$;
import zio.package;

public final class NettyConnectionPool$
implements Serializable {
    public static final NettyConnectionPool$PoolKey$ PoolKey;
    public static final NettyConnectionPool$BootstrapSyntax$ BootstrapSyntax;
    public static final NettyConnectionPool$ MODULE$;

    private NettyConnectionPool$() {
    }

    static {
        MODULE$ = new NettyConnectionPool$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NettyConnectionPool$.class);
    }

    public ZIO<Scope, Throwable, Channel> createChannel(ChannelFactory<Channel> channelFactory, EventLoopGroup eventLoopGroup, NettyRuntime nettyRuntime, URL.Location.Absolute location, Option<Proxy> proxy, ClientSSLConfig sslOptions, int maxInitialLineLength, int maxHeaderSize, Decompression decompression, Option<Duration> idleTimeout, Option<Duration> connectionTimeout, Option<InetSocketAddress> localAddress, DnsResolver dnsResolver, Object trace) {
        ChannelInitializer<Channel> initializer = new ChannelInitializer<Channel>(proxy, location, sslOptions, idleTimeout, nettyRuntime, trace, maxInitialLineLength, maxHeaderSize, decompression){
            private final Option proxy$1;
            private final URL.Location.Absolute location$1;
            private final ClientSSLConfig sslOptions$1;
            private final Option idleTimeout$1;
            private final NettyRuntime nettyRuntime$1;
            private final Object trace$1;
            private final int maxInitialLineLength$1;
            private final int maxHeaderSize$1;
            private final Decompression decompression$1;
            {
                this.proxy$1 = proxy$3;
                this.location$1 = location$8;
                this.sslOptions$1 = sslOptions$3;
                this.idleTimeout$1 = idleTimeout$4;
                this.nettyRuntime$1 = nettyRuntime$2;
                this.trace$1 = trace$30;
                this.maxInitialLineLength$1 = maxInitialLineLength$3;
                this.maxHeaderSize$1 = maxHeaderSize$3;
                this.decompression$1 = decompression$3;
            }

            public void initChannel(Channel ch) {
                BoxedUnit boxedUnit;
                ChannelPipeline pipeline = ch.pipeline();
                Option option = this.proxy$1;
                if (option instanceof Some) {
                    Proxy proxy = (Proxy)((Some)option).value();
                    boxedUnit = pipeline.addLast(package$Names$.MODULE$.ProxyHandler(), (ChannelHandler)NettyProxy$.MODULE$.fromProxy(proxy).encode().getOrElse(this::initChannel$$anonfun$1));
                } else if (None$.MODULE$.equals(option)) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
                if (BoxesRunTime.unboxToBoolean((Object)this.location$1.scheme().isSecure().getOrElse(NettyConnectionPool$::zio$http$netty$client$NettyConnectionPool$$anon$1$$_$initChannel$$anonfun$2))) {
                    pipeline.addLast(package$Names$.MODULE$.SSLHandler(), (ChannelHandler)ClientSSLConverter$.MODULE$.toNettySSLContext(this.sslOptions$1).newHandler(ch.alloc(), this.location$1.host(), this.location$1.port()));
                }
                this.idleTimeout$1.foreach(arg_0 -> NettyConnectionPool$.zio$http$netty$client$NettyConnectionPool$$anon$1$$_$initChannel$$anonfun$3(pipeline, arg_0));
                pipeline.addLast(package$Names$.MODULE$.ClientReadTimeoutErrorHandler(), (ChannelHandler)new NettyConnectionPool.ReadTimeoutErrorHandler(this.nettyRuntime$1, this.trace$1));
                pipeline.addLast(package$Names$.MODULE$.HttpClientCodec(), (ChannelHandler)new HttpClientCodec(this.maxInitialLineLength$1, this.maxHeaderSize$1, 8192, true));
                if (this.decompression$1.enabled()) {
                    pipeline.addLast(package$Names$.MODULE$.HttpRequestDecompression(), (ChannelHandler)new HttpContentDecompressor(this.decompression$1.strict(), 0));
                }
            }

            private final HttpProxyHandler initChannel$$anonfun$1() {
                return new HttpProxyHandler((SocketAddress)new InetSocketAddress(this.location$1.host(), this.location$1.port()));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{initChannel$$anonfun$1(), zio$http$netty$client$NettyConnectionPool$$anon$1$$_$initChannel$$anonfun$2(), zio$http$netty$client$NettyConnectionPool$$anon$1$$_$initChannel$$anonfun$3(io.netty.channel.ChannelPipeline java.time.Duration )}, serializedLambda);
            }
        };
        return dnsResolver.resolve(location.host(), trace).flatMap(arg_0 -> NettyConnectionPool$.createChannel$$anonfun$1(trace, channelFactory, eventLoopGroup, location, connectionTimeout, (ChannelInitializer)initializer, localAddress, arg_0), trace);
    }

    private <R, E, A, B> ZIO<R, E, B> collectFirstSuccess(NonEmptyChunk<A> as, Function1<A, ZIO<R, E, B>> f, Object trace) {
        return ZIO$.MODULE$.suspendSucceed(() -> this.collectFirstSuccess$$anonfun$1(as, f, trace), trace);
    }

    private boolean refreshIdleTimeoutHandler(Channel channel, Duration timeout) {
        channel.pipeline().replace(package$Names$.MODULE$.ReadTimeoutHandler(), package$Names$.MODULE$.ReadTimeoutHandler(), (ChannelHandler)new ReadTimeoutHandler(timeout.toMillis(), TimeUnit.MILLISECONDS));
        return channel.isOpen();
    }

    public ZIO<NettyClientDriver, Nothing$, NettyConnectionPool> fromConfig(ConnectionPoolConfig config, Object trace) {
        ZIO<NettyClientDriver, Nothing$, NettyConnectionPool> zIO;
        ConnectionPoolConfig connectionPoolConfig = config;
        if (ConnectionPoolConfig$Disabled$.MODULE$.equals(connectionPoolConfig)) {
            zIO = this.createDisabled(trace);
        } else if (connectionPoolConfig instanceof ConnectionPoolConfig.Fixed) {
            int n;
            ConnectionPoolConfig.Fixed fixed = ConnectionPoolConfig$Fixed$.MODULE$.unapply((ConnectionPoolConfig.Fixed)connectionPoolConfig);
            int size = n = fixed._1();
            zIO = this.createFixed(size, trace);
        } else if (connectionPoolConfig instanceof ConnectionPoolConfig.FixedPerHost) {
            ConnectionPoolConfig.FixedPerHost fixedPerHost = ConnectionPoolConfig$FixedPerHost$.MODULE$.unapply((ConnectionPoolConfig.FixedPerHost)connectionPoolConfig);
            Map<URL.Location.Absolute, ConnectionPoolConfig.Fixed> map = fixedPerHost._1();
            ConnectionPoolConfig.Fixed fixed = fixedPerHost._2();
            Map<URL.Location.Absolute, ConnectionPoolConfig.Fixed> sizes = map;
            ConnectionPoolConfig.Fixed fixed2 = fixed;
            zIO = this.createFixedPerHost((Function1<URL.Location.Absolute, Object>)(Function1 & Serializable)location -> ((ConnectionPoolConfig.Fixed)sizes.getOrElse(location, () -> NettyConnectionPool$.fromConfig$$anonfun$1$$anonfun$1(fixed2))).size(), trace);
        } else if (connectionPoolConfig instanceof ConnectionPoolConfig.Dynamic) {
            ConnectionPoolConfig.Dynamic dynamic = ConnectionPoolConfig$Dynamic$.MODULE$.unapply((ConnectionPoolConfig.Dynamic)connectionPoolConfig);
            int n = dynamic._1();
            int n2 = dynamic._2();
            Duration duration = dynamic._3();
            int minimum = n;
            int maximum = n2;
            Duration ttl = duration;
            zIO = this.createDynamic(minimum, maximum, ttl, trace);
        } else if (connectionPoolConfig instanceof ConnectionPoolConfig.DynamicPerHost) {
            ConnectionPoolConfig.DynamicPerHost dynamicPerHost = ConnectionPoolConfig$DynamicPerHost$.MODULE$.unapply((ConnectionPoolConfig.DynamicPerHost)connectionPoolConfig);
            Map<URL.Location.Absolute, ConnectionPoolConfig.Dynamic> map = dynamicPerHost._1();
            ConnectionPoolConfig.Dynamic dynamic = dynamicPerHost._2();
            Map<URL.Location.Absolute, ConnectionPoolConfig.Dynamic> configs = map;
            ConnectionPoolConfig.Dynamic dynamic2 = dynamic;
            zIO = this.createDynamicPerHost((Function1<URL.Location.Absolute, Object>)(Function1 & Serializable)location -> ((ConnectionPoolConfig.Dynamic)configs.getOrElse(location, () -> NettyConnectionPool$.fromConfig$$anonfun$2$$anonfun$1(dynamic2))).minimum(), (Function1<URL.Location.Absolute, Object>)(Function1 & Serializable)location -> ((ConnectionPoolConfig.Dynamic)configs.getOrElse(location, () -> NettyConnectionPool$.fromConfig$$anonfun$3$$anonfun$1(dynamic2))).maximum(), (Function1<URL.Location.Absolute, Duration>)(Function1 & Serializable)location -> ((ConnectionPoolConfig.Dynamic)configs.getOrElse(location, () -> NettyConnectionPool$.fromConfig$$anonfun$4$$anonfun$1(dynamic2))).ttl(), trace);
        } else {
            throw new MatchError((Object)connectionPoolConfig);
        }
        return zIO.map((Function1 & Serializable)pool -> pool, trace);
    }

    private ZIO<NettyClientDriver, Nothing$, NettyConnectionPool> createDisabled(Object trace) {
        return ZIO$.MODULE$.service(package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(NettyClientDriver.class, LightTypeTag$.MODULE$.parse(940870809, "\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001\u0004\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0015zio.http.ClientDriver\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30))), trace).flatMap((Function1 & Serializable)driver -> ZIO$.MODULE$.service(package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(DnsResolver.class, LightTypeTag$.MODULE$.parse(499331248, "\u0004\u0000\u0001\u0014zio.http.DnsResolver\u0001\u0001", "\u0000\u0000\u0000", 30))), trace).map((Function1 & Serializable)dnsResolver -> new NettyConnectionPool.NoNettyConnectionPool(driver.channelFactory(), driver.eventLoopGroup(), driver.nettyRuntime(), (DnsResolver)dnsResolver), trace), trace);
    }

    private ZIO<NettyClientDriver, Nothing$, NettyConnectionPool> createFixed(int size, Object trace) {
        return this.createFixedPerHost((Function1<URL.Location.Absolute, Object>)(Function1 & Serializable)_$3 -> size, trace);
    }

    private ZIO<NettyClientDriver, Nothing$, NettyConnectionPool> createFixedPerHost(Function1<URL.Location.Absolute, Object> size, Object trace) {
        return ZIO$.MODULE$.service(package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(NettyClientDriver.class, LightTypeTag$.MODULE$.parse(940870809, "\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001\u0004\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0015zio.http.ClientDriver\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30))), trace).flatMap((Function1 & Serializable)driver -> ZIO$.MODULE$.service(package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(DnsResolver.class, LightTypeTag$.MODULE$.parse(499331248, "\u0004\u0000\u0001\u0014zio.http.DnsResolver\u0001\u0001", "\u0000\u0000\u0000", 30))), trace).map((Function1 & Serializable)dnsResolver -> {
            Function1 & Serializable poolFn = (Function1 & Serializable)key -> MODULE$.createChannel(driver.channelFactory(), driver.eventLoopGroup(), driver.nettyRuntime(), key.location(), key.proxy(), key.sslOptions(), key.maxInitialLineLength(), key.maxHeaderSize(), key.decompression(), key.idleTimeout(), key.connectionTimeout(), (Option<InetSocketAddress>)None$.MODULE$, (DnsResolver)dnsResolver, trace).uninterruptible(trace);
            Function1 & Serializable _size = (Function1 & Serializable)key -> BoxesRunTime.unboxToInt((Object)size.apply((Object)key.location()));
            return Tuple3$.MODULE$.apply(dnsResolver, (Object)poolFn, (Object)_size);
        }, trace).flatMap((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                DnsResolver dnsResolver = (DnsResolver)tuple3._1();
                Function1 poolFn = (Function1)tuple3._2();
                Function1 _size = (Function1)tuple3._3();
                return ZKeyedPool$.MODULE$.make(poolFn, _size, Tag$.MODULE$.apply(Scope.class, LightTypeTag$.MODULE$.parse(1294249275, "\u0004\u0000\u0001\tzio.Scope\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\tzio.Scope\u0001\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001", 30)), trace).map((Function1 & Serializable)keyedPool -> new NettyConnectionPool.ZioNettyConnectionPool((ZKeyedPool<Throwable, NettyConnectionPool.PoolKey, Channel>)keyedPool, (Function1<NettyConnectionPool.PoolKey, Object>)_size), trace);
            }
            throw new MatchError((Object)tuple3);
        }, trace), trace);
    }

    private ZIO<NettyClientDriver, Nothing$, NettyConnectionPool> createDynamic(int min, int max, Duration ttl, Object trace) {
        return this.createDynamicPerHost((Function1<URL.Location.Absolute, Object>)(Function1 & Serializable)_$4 -> min, (Function1<URL.Location.Absolute, Object>)(Function1 & Serializable)_$5 -> max, (Function1<URL.Location.Absolute, Duration>)(Function1 & Serializable)_$6 -> ttl, trace);
    }

    private ZIO<NettyClientDriver, Nothing$, NettyConnectionPool> createDynamicPerHost(Function1<URL.Location.Absolute, Object> min, Function1<URL.Location.Absolute, Object> max, Function1<URL.Location.Absolute, Duration> ttl, Object trace) {
        return ZIO$.MODULE$.service(package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(NettyClientDriver.class, LightTypeTag$.MODULE$.parse(940870809, "\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001\u0004\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0015zio.http.ClientDriver\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30))), trace).flatMap((Function1 & Serializable)driver -> ZIO$.MODULE$.service(package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(DnsResolver.class, LightTypeTag$.MODULE$.parse(499331248, "\u0004\u0000\u0001\u0014zio.http.DnsResolver\u0001\u0001", "\u0000\u0000\u0000", 30))), trace).map((Function1 & Serializable)dnsResolver -> {
            Function1 & Serializable poolFn = (Function1 & Serializable)key -> MODULE$.createChannel(driver.channelFactory(), driver.eventLoopGroup(), driver.nettyRuntime(), key.location(), key.proxy(), key.sslOptions(), key.maxInitialLineLength(), key.maxHeaderSize(), key.decompression(), key.idleTimeout(), key.connectionTimeout(), (Option<InetSocketAddress>)None$.MODULE$, (DnsResolver)dnsResolver, trace).uninterruptible(trace);
            return Tuple2$.MODULE$.apply(dnsResolver, (Object)poolFn);
        }, trace).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                DnsResolver dnsResolver = (DnsResolver)tuple2._1();
                Function1 poolFn = (Function1)tuple2._2();
                return ZKeyedPool$.MODULE$.make(poolFn, (Function1 & Serializable)key -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)min.apply((Object)key.location()))), BoxesRunTime.unboxToInt((Object)max.apply((Object)key.location()))), (Function1 & Serializable)key -> (Duration)ttl.apply((Object)key.location()), Tag$.MODULE$.apply(Scope.class, LightTypeTag$.MODULE$.parse(1294249275, "\u0004\u0000\u0001\tzio.Scope\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\tzio.Scope\u0001\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001", 30)), trace).map((Function1 & Serializable)keyedPool -> new NettyConnectionPool.ZioNettyConnectionPool((ZKeyedPool<Throwable, NettyConnectionPool.PoolKey, Channel>)keyedPool, (Function1<NettyConnectionPool.PoolKey, Object>)(Function1 & Serializable)key -> BoxesRunTime.unboxToInt((Object)max.apply((Object)key.location()))), trace);
            }
            throw new MatchError((Object)tuple2);
        }, trace), trace);
    }

    public final Bootstrap BootstrapSyntax(Bootstrap bootstrap) {
        return bootstrap;
    }

    public static final boolean zio$http$netty$client$NettyConnectionPool$$anon$1$$_$initChannel$$anonfun$2() {
        return false;
    }

    public static final /* synthetic */ ChannelPipeline zio$http$netty$client$NettyConnectionPool$$anon$1$$_$initChannel$$anonfun$3(ChannelPipeline pipeline$1, Duration timeout) {
        return pipeline$1.addLast(package$Names$.MODULE$.ReadTimeoutHandler(), (ChannelHandler)new ReadTimeoutHandler(timeout.toMillis(), TimeUnit.MILLISECONDS));
    }

    private static final List createChannel$$anonfun$1$$anonfun$1(Chunk resolvedHosts$1) {
        return resolvedHosts$1.toList();
    }

    private static final Future createChannel$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(ChannelFuture channelFuture$2, Channel ch$2) {
        channelFuture$2.cancel(true);
        return ch$2.close();
    }

    private static final boolean createChannel$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(Channel ch$3) {
        return ch$3.isOpen();
    }

    private static final ZIO createChannel$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2(ChannelFuture channelFuture$1, Channel ch$1, Object trace$7) {
        return NettyFutureExecutor$.MODULE$.executed(() -> NettyConnectionPool$.createChannel$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(channelFuture$1, ch$1), trace$7).when(() -> NettyConnectionPool$.createChannel$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(ch$1), trace$7).ignoreLogged(trace$7);
    }

    private static final Future createChannel$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1(ChannelFuture channelFuture$4) {
        return channelFuture$4;
    }

    private static final Channel createChannel$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$2(Channel ch$5) {
        return ch$5;
    }

    private static final ZIO createChannel$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$3(ChannelFuture channelFuture$3, Object trace$8, Channel ch$4) {
        return NettyFutureExecutor$.MODULE$.executed(() -> NettyConnectionPool$.createChannel$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1(channelFuture$3), trace$8).as(() -> NettyConnectionPool$.createChannel$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$2(ch$4), trace$8);
    }

    private static final ZIO createChannel$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(ChannelFactory channelFactory$5, EventLoopGroup eventLoopGroup$5, InetAddress host$1, URL.Location.Absolute location$6, Option connectionTimeout$5, ChannelInitializer initializer$5, Option localAddress$5, Object trace$6) {
        Bootstrap bootstrap = (Bootstrap)NettyConnectionPool$BootstrapSyntax$.MODULE$.withOption$extension(MODULE$.BootstrapSyntax(((Bootstrap)new Bootstrap().channelFactory(channelFactory$5).group(eventLoopGroup$5)).remoteAddress((SocketAddress)new InetSocketAddress(host$1, location$6.port()))), ChannelOption.CONNECT_TIMEOUT_MILLIS, connectionTimeout$5.map((Function1 & Serializable)_$1 -> Predef$.MODULE$.int2Integer((int)_$1.toMillis()))).handler((ChannelHandler)initializer$5);
        localAddress$5.foreach((Function1 & Serializable)x$0 -> (Bootstrap)bootstrap.localAddress(x$0));
        ChannelFuture channelFuture = bootstrap.connect();
        Channel ch = channelFuture.channel();
        return Scope$.MODULE$.addFinalizer(() -> NettyConnectionPool$.createChannel$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2(channelFuture, ch, trace$6), trace$6).$times$greater(() -> NettyConnectionPool$.createChannel$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$3(channelFuture, trace$6, ch), trace$6);
    }

    private static final /* synthetic */ ZIO createChannel$$anonfun$1(Object trace$2, ChannelFactory channelFactory$1, EventLoopGroup eventLoopGroup$1, URL.Location.Absolute location$2, Option connectionTimeout$1, ChannelInitializer initializer$1, Option localAddress$1, Chunk resolvedHosts) {
        return Random$.MODULE$.shuffle(() -> NettyConnectionPool$.createChannel$$anonfun$1$$anonfun$1(resolvedHosts), trace$2).flatMap((Function1 & Serializable)hosts -> {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace$2, (Function0 & Serializable)() -> {
                Unsafe$ unsafe$2 = Unsafe$.MODULE$;
                return NonEmptyChunk$.MODULE$.fromIterable(hosts.head(), (Iterable)hosts.tail());
            }).flatMap((Function1 & Serializable)hostsNec -> MODULE$.collectFirstSuccess((NonEmptyChunk)hostsNec, (Function1 & Serializable)host -> ZIO$.MODULE$.suspend(() -> NettyConnectionPool$.createChannel$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(channelFactory$1, eventLoopGroup$1, host, location$2, connectionTimeout$1, initializer$1, localAddress$1, trace$2), trace$2), trace$2).map((Function1 & Serializable)ch -> ch, trace$2), trace$2);
        }, trace$2);
    }

    private static final Object loop$1$$anonfun$1$$anonfun$1(Object e$1) {
        return e$1;
    }

    private final ZIO loop$1(Function1 f$2, Iterator it$1, Object trace$10) {
        return ((ZIO)f$2.apply(it$1.next())).catchAll((Function1 & Serializable)e -> {
            if (it$1.hasNext()) {
                return this.loop$1(f$2, it$1, trace$10);
            }
            return ZIO$.MODULE$.fail(() -> NettyConnectionPool$.loop$1$$anonfun$1$$anonfun$1(e), trace$10);
        }, (CanFail)CanFail$.MODULE$, trace$10);
    }

    private final ZIO collectFirstSuccess$$anonfun$1(NonEmptyChunk as$1, Function1 f$1, Object trace$9) {
        Iterator it = as$1.iterator();
        return this.loop$1(f$1, it, trace$9);
    }

    public static final String zio$http$netty$client$NettyConnectionPool$ReadTimeoutErrorHandler$$_$exceptionCaught$$anonfun$1() {
        return "ReadTimeoutException caught";
    }

    public static final boolean zio$http$netty$client$NettyConnectionPool$ZioNettyConnectionPool$$_$get$$anonfun$1$$anonfun$2$$anonfun$1() {
        return true;
    }

    public static final /* synthetic */ boolean zio$http$netty$client$NettyConnectionPool$ZioNettyConnectionPool$$_$get$$anonfun$1$$anonfun$2$$anonfun$2(Channel channel$1, Duration _$2) {
        return MODULE$.refreshIdleTimeoutHandler(channel$1, _$2);
    }

    public static final /* synthetic */ Channel zio$http$netty$client$NettyConnectionPool$ZioNettyConnectionPool$$_$get$$anonfun$1$$anonfun$2$$anonfun$3(Channel channel$2) {
        Unsafe$ unsafe$2 = Unsafe$.MODULE$;
        return channel$2;
    }

    public static final ZIO zio$http$netty$client$NettyConnectionPool$ZioNettyConnectionPool$$_$get$$anonfun$1$$anonfun$2$$anonfun$4(ZIO release$1, Object trace$15) {
        return release$1.forkDaemon(trace$15);
    }

    private static final None$ get$$anonfun$1$$anonfun$2$$anonfun$5$$anonfun$1() {
        return None$.MODULE$;
    }

    public static final ZIO zio$http$netty$client$NettyConnectionPool$ZioNettyConnectionPool$$_$get$$anonfun$1$$anonfun$2$$anonfun$5(Object trace$16) {
        return ZIO$.MODULE$.fail(NettyConnectionPool$::get$$anonfun$1$$anonfun$2$$anonfun$5$$anonfun$1, trace$16);
    }

    public static final Throwable zio$http$netty$client$NettyConnectionPool$ZioNettyConnectionPool$$_$get$$anonfun$1$$anonfun$4$$anonfun$1(Throwable e$2) {
        return e$2;
    }

    public static final boolean zio$http$netty$client$NettyConnectionPool$ZioNettyConnectionPool$$_$get$$anonfun$1$$anonfun$5$$anonfun$1(Channel c$1) {
        return c$1.isOpen();
    }

    public static final /* synthetic */ boolean zio$http$netty$client$NettyConnectionPool$ZioNettyConnectionPool$$_$retrySchedule$$anonfun$1(Object x$1) {
        Object object = x$1;
        return None$.MODULE$.equals(object);
    }

    private static final ConnectionPoolConfig.Fixed fromConfig$$anonfun$1$$anonfun$1(ConnectionPoolConfig.Fixed default$2) {
        return default$2;
    }

    private static final ConnectionPoolConfig.Dynamic fromConfig$$anonfun$2$$anonfun$1(ConnectionPoolConfig.Dynamic default$4) {
        return default$4;
    }

    private static final ConnectionPoolConfig.Dynamic fromConfig$$anonfun$3$$anonfun$1(ConnectionPoolConfig.Dynamic default$6) {
        return default$6;
    }

    private static final ConnectionPoolConfig.Dynamic fromConfig$$anonfun$4$$anonfun$1(ConnectionPoolConfig.Dynamic default$8) {
        return default$8;
    }
}

