/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.CookieHeaderNames;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.io.Serializable;
import java.time.Duration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.Chunk$;
import zio.http.Cookie;
import zio.http.Cookie$Request$;
import zio.http.Cookie$Response$;
import zio.http.Cookie$SameSite$Lax$;
import zio.http.Cookie$SameSite$None$;
import zio.http.Cookie$SameSite$Strict$;
import zio.http.Path;
import zio.http.Path$;

public final class NettyCookieEncoding$
implements Serializable {
    public static final NettyCookieEncoding$ MODULE$ = new NettyCookieEncoding$();

    private NettyCookieEncoding$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NettyCookieEncoding$.class);
    }

    public final String encodeRequestCookie(Cookie.Request cookie, boolean validate2) {
        ClientCookieEncoder encoder = validate2 ? ClientCookieEncoder.STRICT : ClientCookieEncoder.LAX;
        DefaultCookie builder = new DefaultCookie(cookie.name(), cookie.content());
        return encoder.encode((Cookie)builder);
    }

    public final Chunk<Cookie.Request> decodeRequestCookie(String header, boolean validate2) {
        ServerCookieDecoder decoder = validate2 ? ServerCookieDecoder.STRICT : ServerCookieDecoder.LAX;
        return Chunk$.MODULE$.fromJavaIterable((Iterable)decoder.decodeAll(header)).map((Function1 & Serializable)cookie -> Cookie$Request$.MODULE$.apply(cookie.name(), cookie.value()));
    }

    public final String encodeResponseCookie(Cookie.Response cookie, boolean validate2) {
        DefaultCookie builder = new DefaultCookie(cookie.name(), cookie.content());
        ServerCookieEncoder encoder = validate2 ? ServerCookieEncoder.STRICT : ServerCookieEncoder.LAX;
        cookie.domain().foreach((Function1)(JProcedure1 & Serializable)x$0 -> builder.setDomain(x$0));
        cookie.path().foreach((Function1)(JProcedure1 & Serializable)i -> builder.setPath(i.encode()));
        cookie.maxAge().foreach((Function1)(JProcedure1 & Serializable)i -> builder.setMaxAge(i.getSeconds()));
        cookie.sameSite().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Cookie.SameSite sameSite = x$1;
            if (Cookie$SameSite$Strict$.MODULE$.equals(sameSite)) {
                builder.setSameSite(CookieHeaderNames.SameSite.Strict);
                return;
            }
            if (Cookie$SameSite$Lax$.MODULE$.equals(sameSite)) {
                builder.setSameSite(CookieHeaderNames.SameSite.Lax);
                return;
            }
            if (Cookie$SameSite$None$.MODULE$.equals(sameSite)) {
                builder.setSameSite(CookieHeaderNames.SameSite.None);
                return;
            }
            throw new MatchError((Object)sameSite);
        });
        builder.setHttpOnly(cookie.isHttpOnly());
        builder.setSecure(cookie.isSecure());
        return encoder.encode((Cookie)builder);
    }

    public final Cookie.Response decodeResponseCookie(String header, boolean validate2) {
        Option option;
        ClientCookieDecoder decoder = validate2 ? ClientCookieDecoder.STRICT : ClientCookieDecoder.LAX;
        DefaultCookie cookie = (DefaultCookie)decoder.decode(header);
        String string = cookie.name();
        String string2 = cookie.value();
        Option option2 = Option$.MODULE$.apply((Object)cookie.domain());
        Option option3 = Option$.MODULE$.apply((Object)cookie.path()).map((Function1 & Serializable)path -> Path$.MODULE$.decode((String)path));
        Option option4 = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)cookie.maxAge())).filter((Function1)(JFunction1.mcZJ.sp & Serializable)_$1 -> _$1 >= 0L).map((Function1 & Serializable)i -> NettyCookieEncoding$.$anonfun$3(BoxesRunTime.unboxToLong((Object)i)));
        boolean bl = cookie.isSecure();
        boolean bl2 = cookie.isHttpOnly();
        CookieHeaderNames.SameSite sameSite = cookie.sameSite();
        CookieHeaderNames.SameSite sameSite2 = CookieHeaderNames.SameSite.Strict;
        CookieHeaderNames.SameSite sameSite3 = sameSite;
        if (!(sameSite2 != null ? !sameSite2.equals(sameSite3) : sameSite3 != null)) {
            option = Option$.MODULE$.apply((Object)Cookie$SameSite$Strict$.MODULE$);
        } else {
            CookieHeaderNames.SameSite sameSite4 = CookieHeaderNames.SameSite.Lax;
            CookieHeaderNames.SameSite sameSite5 = sameSite;
            if (!(sameSite4 != null ? !sameSite4.equals(sameSite5) : sameSite5 != null)) {
                option = Option$.MODULE$.apply((Object)Cookie$SameSite$Lax$.MODULE$);
            } else {
                CookieHeaderNames.SameSite sameSite6 = CookieHeaderNames.SameSite.None;
                CookieHeaderNames.SameSite sameSite7 = sameSite;
                if (!(sameSite6 != null ? !sameSite6.equals(sameSite7) : sameSite7 != null)) {
                    option = Option$.MODULE$.apply((Object)Cookie$SameSite$None$.MODULE$);
                } else if (sameSite == null) {
                    option = None$.MODULE$;
                } else {
                    throw new MatchError((Object)sameSite);
                }
            }
        }
        Option option5 = option;
        return Cookie$Response$.MODULE$.apply(string, string2, (Option<String>)option2, (Option<Path>)option3, bl, bl2, (Option<Duration>)option4, (Option<Cookie.SameSite>)option5);
    }

    private static final /* synthetic */ Duration $anonfun$3(long i) {
        return Duration.ofSeconds(i);
    }
}

