/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.Tuple3;
import scala.Tuple4;
import scala.deriving.Mirror;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import zio.Chunk;
import zio.Config;
import zio.Config$;
import zio.Duration$;
import zio.Zippable$;
import zio.http.netty.ChannelType;
import zio.http.netty.ChannelType$AUTO$;
import zio.http.netty.ChannelType$EPOLL$;
import zio.http.netty.ChannelType$KQUEUE$;
import zio.http.netty.ChannelType$NIO$;
import zio.http.netty.ChannelType$URING$;
import zio.http.netty.EventLoopGroups;
import zio.http.netty.NettyConfig;
import zio.http.netty.NettyConfig$BossGroup$;
import zio.http.netty.NettyConfig$LeakDetectionLevel$;
import zio.http.netty.NettyConfig$LeakDetectionLevel$ADVANCED$;
import zio.http.netty.NettyConfig$LeakDetectionLevel$DISABLED$;
import zio.http.netty.NettyConfig$LeakDetectionLevel$PARANOID$;
import zio.http.netty.NettyConfig$LeakDetectionLevel$SIMPLE$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class NettyConfig$
implements Mirror.Product,
Serializable {
    public static final NettyConfig$BossGroup$ BossGroup;
    private static final NettyConfig default;
    private static final NettyConfig defaultWithFastShutdown;
    public static final NettyConfig$LeakDetectionLevel$ LeakDetectionLevel;
    public static final NettyConfig$ MODULE$;

    private NettyConfig$() {
    }

    static {
        MODULE$ = new NettyConfig$();
        Duration quietPeriod = Duration$.MODULE$.fromSeconds(2L);
        Duration timeout = Duration$.MODULE$.fromSeconds(15L);
        default = MODULE$.apply(NettyConfig$LeakDetectionLevel$SIMPLE$.MODULE$, ChannelType$AUTO$.MODULE$, Runtime.getRuntime().availableProcessors(), quietPeriod, timeout, NettyConfig$BossGroup$.MODULE$.apply(ChannelType$AUTO$.MODULE$, 1, quietPeriod, timeout));
        Duration quietPeriod2 = Duration$.MODULE$.fromMillis(50L);
        Duration timeout2 = Duration$.MODULE$.fromMillis(250L);
        NettyConfig.BossGroup bossGroup = MODULE$.default().bossGroup().copy(MODULE$.default().bossGroup().copy$default$1(), MODULE$.default().bossGroup().copy$default$2(), quietPeriod2, timeout2);
        NettyConfig.LeakDetectionLevel leakDetectionLevel = MODULE$.default().copy$default$1();
        ChannelType channelType = MODULE$.default().copy$default$2();
        int n = MODULE$.default().copy$default$3();
        defaultWithFastShutdown = MODULE$.default().copy(leakDetectionLevel, channelType, n, quietPeriod2, timeout2, bossGroup);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NettyConfig$.class);
    }

    public NettyConfig apply(NettyConfig.LeakDetectionLevel leakDetectionLevel, ChannelType channelType, int nThreads, Duration shutdownQuietPeriodDuration, Duration shutdownTimeoutDuration, NettyConfig.BossGroup bossGroup) {
        return new NettyConfig(leakDetectionLevel, channelType, nThreads, shutdownQuietPeriodDuration, shutdownTimeoutDuration, bossGroup);
    }

    public NettyConfig unapply(NettyConfig x$1) {
        return x$1;
    }

    private Config<EventLoopGroups.Config> baseConfig() {
        return Config$.MODULE$.string("channel-type").mapOrFail((Function1 & Serializable)x$1 -> {
            String string = x$1;
            switch (string == null ? 0 : string.hashCode()) {
                case -1123703930: {
                    if (!"kqueue".equals(string)) break;
                    return package$.MODULE$.Right().apply((Object)ChannelType$KQUEUE$.MODULE$);
                }
                case 109076: {
                    if (!"nio".equals(string)) break;
                    return package$.MODULE$.Right().apply((Object)ChannelType$NIO$.MODULE$);
                }
                case 3005871: {
                    if (!"auto".equals(string)) break;
                    return package$.MODULE$.Right().apply((Object)ChannelType$AUTO$.MODULE$);
                }
                case 96722340: {
                    if (!"epoll".equals(string)) break;
                    return package$.MODULE$.Right().apply((Object)ChannelType$EPOLL$.MODULE$);
                }
                case 111552549: {
                    if (!"uring".equals(string)) break;
                    return package$.MODULE$.Right().apply((Object)ChannelType$URING$.MODULE$);
                }
            }
            String other = string;
            String string2 = new StringBuilder(22).append("Invalid channel type: ").append(other).toString();
            Chunk chunk = Config.Error$.InvalidData$.MODULE$.$lessinit$greater$default$1();
            return package$.MODULE$.Left().apply((Object)Config.Error$.InvalidData$.MODULE$.apply(chunk, string2));
        }).withDefault(NettyConfig$::baseConfig$$anonfun$2).$plus$plus(NettyConfig$::baseConfig$$anonfun$3, Zippable$.MODULE$.Zippable2()).$plus$plus(NettyConfig$::baseConfig$$anonfun$4, Zippable$.MODULE$.Zippable3()).$plus$plus(NettyConfig$::baseConfig$$anonfun$5, Zippable$.MODULE$.Zippable4()).map((Function1 & Serializable)x$1 -> {
            Tuple4 tuple4 = x$1;
            if (tuple4 != null) {
                ChannelType channelT = (ChannelType)tuple4._1();
                int maxThreads = BoxesRunTime.unboxToInt((Object)tuple4._2());
                Duration quietPeriod = (Duration)tuple4._3();
                Duration timeout = (Duration)tuple4._4();
                return new EventLoopGroups.Config(channelT, maxThreads, quietPeriod, timeout){
                    private final ChannelType channelType;
                    private final int nThreads;
                    private final long shutdownQuietPeriod;
                    private final long shutdownTimeOut;
                    private final TimeUnit shutdownTimeUnit;
                    {
                        this.channelType = channelT$1;
                        this.nThreads = maxThreads$1;
                        this.shutdownQuietPeriod = quietPeriod$1.toMillis();
                        this.shutdownTimeOut = timeout$1.toMillis();
                        this.shutdownTimeUnit = TimeUnit.MILLISECONDS;
                    }

                    public ChannelType channelType() {
                        return this.channelType;
                    }

                    public int nThreads() {
                        return this.nThreads;
                    }

                    public long shutdownQuietPeriod() {
                        return this.shutdownQuietPeriod;
                    }

                    public long shutdownTimeOut() {
                        return this.shutdownTimeOut;
                    }

                    public TimeUnit shutdownTimeUnit() {
                        return this.shutdownTimeUnit;
                    }
                };
            }
            throw new MatchError((Object)tuple4);
        });
    }

    public Config<NettyConfig> config() {
        return NettyConfig$LeakDetectionLevel$.MODULE$.config().nested(NettyConfig$::config$$anonfun$1).withDefault(NettyConfig$::config$$anonfun$2).$plus$plus(NettyConfig$::config$$anonfun$3, Zippable$.MODULE$.Zippable2()).$plus$plus(NettyConfig$::config$$anonfun$4, Zippable$.MODULE$.Zippable3()).map((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                NettyConfig.LeakDetectionLevel leakDetectionLevel = (NettyConfig.LeakDetectionLevel)tuple3._1();
                EventLoopGroups.Config worker = (EventLoopGroups.Config)tuple3._2();
                EventLoopGroups.Config boss = (EventLoopGroups.Config)tuple3._3();
                return this.apply(leakDetectionLevel, worker.channelType(), worker.nThreads(), this.toDuration$1(worker.shutdownQuietPeriod(), worker.shutdownTimeUnit()), this.toDuration$1(worker.shutdownTimeOut(), worker.shutdownTimeUnit()), NettyConfig$BossGroup$.MODULE$.apply(boss.channelType(), boss.nThreads(), this.toDuration$1(boss.shutdownQuietPeriod(), boss.shutdownTimeUnit()), this.toDuration$1(boss.shutdownTimeOut(), boss.shutdownTimeUnit())));
            }
            throw new MatchError((Object)tuple3);
        });
    }

    public NettyConfig default() {
        return default;
    }

    public NettyConfig defaultWithFastShutdown() {
        return defaultWithFastShutdown;
    }

    public NettyConfig fromProduct(Product x$0) {
        return new NettyConfig((NettyConfig.LeakDetectionLevel)x$0.productElement(0), (ChannelType)x$0.productElement(1), BoxesRunTime.unboxToInt((Object)x$0.productElement(2)), (Duration)x$0.productElement(3), (Duration)x$0.productElement(4), (NettyConfig.BossGroup)x$0.productElement(5));
    }

    private static final ChannelType baseConfig$$anonfun$2() {
        return MODULE$.default().channelType();
    }

    private static final int baseConfig$$anonfun$3$$anonfun$1() {
        return MODULE$.default().nThreads();
    }

    private static final Config baseConfig$$anonfun$3() {
        return Config$.MODULE$.int("max-threads").withDefault(NettyConfig$::baseConfig$$anonfun$3$$anonfun$1);
    }

    private static final Duration baseConfig$$anonfun$4$$anonfun$1() {
        return MODULE$.default().shutdownQuietPeriodDuration();
    }

    private static final Config baseConfig$$anonfun$4() {
        return Config$.MODULE$.duration("shutdown-quiet-period").withDefault(NettyConfig$::baseConfig$$anonfun$4$$anonfun$1);
    }

    private static final Duration baseConfig$$anonfun$5$$anonfun$1() {
        return MODULE$.default().shutdownTimeoutDuration();
    }

    private static final Config baseConfig$$anonfun$5() {
        return Config$.MODULE$.duration("shutdown-timeout").withDefault(NettyConfig$::baseConfig$$anonfun$5$$anonfun$1);
    }

    private static final String config$$anonfun$1() {
        return "leak-detection-level";
    }

    private static final NettyConfig.LeakDetectionLevel config$$anonfun$2() {
        return MODULE$.default().leakDetectionLevel();
    }

    private static final String config$$anonfun$3$$anonfun$1() {
        return "worker-group";
    }

    private static final Config config$$anonfun$3$$anonfun$2() {
        return MODULE$.baseConfig();
    }

    private static final Config config$$anonfun$3() {
        return MODULE$.baseConfig().nested(NettyConfig$::config$$anonfun$3$$anonfun$1).orElse(NettyConfig$::config$$anonfun$3$$anonfun$2);
    }

    private static final String config$$anonfun$4$$anonfun$1() {
        return "boss-group";
    }

    private static final Config config$$anonfun$4() {
        return MODULE$.baseConfig().nested(NettyConfig$::config$$anonfun$4$$anonfun$1);
    }

    private final Duration toDuration$1(long n, TimeUnit timeUnit) {
        return Duration$.MODULE$.fromJava(Duration.of(n, timeUnit.toChronoUnit()));
    }

    public static final /* synthetic */ Either zio$http$netty$NettyConfig$LeakDetectionLevel$$$_$config$$anonfun$6(String x$1) {
        String string = x$1;
        switch (string == null ? 0 : string.hashCode()) {
            case -902286926: {
                if (!"simple".equals(string)) break;
                return package$.MODULE$.Right().apply((Object)NettyConfig$LeakDetectionLevel$SIMPLE$.MODULE$);
            }
            case -718837726: {
                if (!"advanced".equals(string)) break;
                return package$.MODULE$.Right().apply((Object)NettyConfig$LeakDetectionLevel$ADVANCED$.MODULE$);
            }
            case 270940796: {
                if (!"disabled".equals(string)) break;
                return package$.MODULE$.Right().apply((Object)NettyConfig$LeakDetectionLevel$DISABLED$.MODULE$);
            }
            case 1171464828: {
                if (!"paranoid".equals(string)) break;
                return package$.MODULE$.Right().apply((Object)NettyConfig$LeakDetectionLevel$PARANOID$.MODULE$);
            }
        }
        String other = string;
        String string2 = new StringBuilder(30).append("Invalid leak detection level: ").append(other).toString();
        Chunk chunk = Config.Error$.InvalidData$.MODULE$.$lessinit$greater$default$1();
        return package$.MODULE$.Left().apply((Object)Config.Error$.InvalidData$.MODULE$.apply(chunk, string2));
    }
}

