/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.IOException;
import scala.MatchError;
import scala.collection.mutable.ArrayBuilder;
import scala.runtime.BoxedUnit;
import zio.Chunk;
import zio.Chunk$;
import zio.http.netty.AsyncBodyReader;
import zio.http.netty.AsyncBodyReader$ByteArrayBuilderOps$;
import zio.http.netty.AsyncBodyReader$State$;
import zio.http.netty.AsyncBodyReader$State$Buffering$;
import zio.http.netty.AsyncBodyReader$State$Direct$;
import zio.http.netty.NettyBody;
import zio.http.netty.NettyBody$UnsafeAsync$Aggregating$;

public abstract class AsyncBodyReader
extends SimpleChannelInboundHandler<HttpContent> {
    private State state = AsyncBodyReader$State$Buffering$.MODULE$;
    private final ArrayBuilder.ofByte buffer = new ArrayBuilder.ofByte();
    private boolean previousAutoRead = false;
    private boolean readingDone = false;
    private ChannelHandlerContext ctx;

    public AsyncBodyReader() {
        super(true);
    }

    private Chunk<Object> result(ArrayBuilder.ofByte buffer) {
        byte[] arr = buffer.result();
        return Chunk.ByteArray$.MODULE$.apply(arr, 0, arr.length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void connect(NettyBody.UnsafeAsync callback) {
        ArrayBuilder.ofByte buffer0 = this.buffer;
        AsyncBodyReader asyncBodyReader = this;
        synchronized (asyncBodyReader) {
            State state = this.state;
            if (!AsyncBodyReader$State$Buffering$.MODULE$.equals(state)) throw new IllegalStateException("Cannot connect twice");
            this.state = AsyncBodyReader$State$Direct$.MODULE$.apply(callback);
            if (this.readingDone) {
                callback.apply(this.result(buffer0), true);
            } else {
                if (!this.ctx.channel().isOpen()) throw new IllegalStateException("Attempting to read from a closed channel, which will never finish");
                NettyBody.UnsafeAsync unsafeAsync = callback;
                if (unsafeAsync instanceof NettyBody.UnsafeAsync.Aggregating) {
                    int n;
                    NettyBody.UnsafeAsync.Aggregating aggregating = NettyBody$UnsafeAsync$Aggregating$.MODULE$.unapply((NettyBody.UnsafeAsync.Aggregating)unsafeAsync);
                    int bufSize = n = aggregating._1();
                    this.buffer.sizeHint(bufSize);
                } else {
                    NettyBody.UnsafeAsync cb = unsafeAsync;
                    cb.apply(this.result(buffer0), false);
                }
                this.ctx.read();
            }
            return;
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.previousAutoRead = ctx.channel().config().isAutoRead();
        ctx.channel().config().setAutoRead(false);
        this.ctx = ctx;
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        ChannelConfig channelConfig = ctx.channel().config().setAutoRead(this.previousAutoRead);
    }

    public void onLastMessage() {
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpContent msg) {
        ArrayBuilder.ofByte buffer0 = this.buffer;
        AsyncBodyReader asyncBodyReader = this;
        synchronized (asyncBodyReader) {
            BoxedUnit boxedUnit;
            boolean bl;
            State state;
            boolean isLast = msg instanceof LastHttpContent;
            byte[] content = ByteBufUtil.getBytes((ByteBuf)msg.content());
            if (isLast) {
                this.readingDone = true;
                ctx.channel().pipeline().remove((ChannelHandler)this);
                this.onLastMessage();
            }
            if (AsyncBodyReader$State$Buffering$.MODULE$.equals(state = this.state)) {
                buffer0.addAll((Object)content);
                bl = true;
            } else if (state instanceof State.Direct) {
                NettyBody.UnsafeAsync unsafeAsync;
                State.Direct direct = AsyncBodyReader$State$Direct$.MODULE$.unapply((State.Direct)state);
                NettyBody.UnsafeAsync callback = unsafeAsync = direct._1();
                if (isLast && buffer0.knownSize() == 0) {
                    callback.apply((Chunk<Object>)Chunk$.MODULE$.fromArray((Object)content), true);
                    bl = false;
                } else if (unsafeAsync instanceof NettyBody.UnsafeAsync.Aggregating) {
                    NettyBody.UnsafeAsync.Aggregating callback2 = (NettyBody.UnsafeAsync.Aggregating)unsafeAsync;
                    buffer0.addAll((Object)content);
                    if (isLast) {
                        callback2.apply(this.result(buffer0), true);
                    }
                    bl = !isLast;
                } else if (unsafeAsync instanceof NettyBody.UnsafeAsync.Streaming) {
                    NettyBody.UnsafeAsync.Streaming callback3 = (NettyBody.UnsafeAsync.Streaming)unsafeAsync;
                    callback3.apply((Chunk<Object>)Chunk$.MODULE$.fromArray((Object)content), isLast);
                    bl = false;
                } else {
                    NettyBody.UnsafeAsync callback4 = unsafeAsync;
                    callback4.apply((Chunk<Object>)Chunk$.MODULE$.fromArray((Object)content), isLast);
                    bl = !isLast;
                }
            } else {
                throw new MatchError((Object)state);
            }
            boolean readMore = bl;
            if (readMore) {
                ctx.read();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        AsyncBodyReader asyncBodyReader = this;
        synchronized (asyncBodyReader) {
            State state = this.state;
            if (!AsyncBodyReader$State$Buffering$.MODULE$.equals(state)) {
                if (state instanceof State.Direct) {
                    NettyBody.UnsafeAsync unsafeAsync;
                    State.Direct direct = AsyncBodyReader$State$Direct$.MODULE$.unapply((State.Direct)state);
                    NettyBody.UnsafeAsync callback = unsafeAsync = direct._1();
                    callback.fail(cause);
                } else {
                    throw new MatchError((Object)state);
                }
            }
        }
        super.exceptionCaught(ctx, cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        AsyncBodyReader asyncBodyReader = this;
        synchronized (asyncBodyReader) {
            State state = this.state;
            if (!AsyncBodyReader$State$Buffering$.MODULE$.equals(state)) {
                if (state instanceof State.Direct) {
                    NettyBody.UnsafeAsync unsafeAsync;
                    State.Direct direct = AsyncBodyReader$State$Direct$.MODULE$.unapply((State.Direct)state);
                    NettyBody.UnsafeAsync callback = unsafeAsync = direct._1();
                    callback.fail(new IOException("Channel closed unexpectedly"));
                } else {
                    throw new MatchError((Object)state);
                }
            }
        }
        ctx.fireChannelInactive();
    }

    public static final class ByteArrayBuilderOps<A> {
        private final ArrayBuilder self;

        public static <A> void addAll$extension(ArrayBuilder arrayBuilder, byte[] byArray) {
            AsyncBodyReader$ByteArrayBuilderOps$.MODULE$.addAll$extension(arrayBuilder, byArray);
        }

        public static <A> boolean equals$extension(ArrayBuilder arrayBuilder, Object object) {
            return AsyncBodyReader$ByteArrayBuilderOps$.MODULE$.equals$extension(arrayBuilder, object);
        }

        public static <A> int hashCode$extension(ArrayBuilder arrayBuilder) {
            return AsyncBodyReader$ByteArrayBuilderOps$.MODULE$.hashCode$extension(arrayBuilder);
        }

        public static <A> int knownSize$extension(ArrayBuilder arrayBuilder) {
            return AsyncBodyReader$ByteArrayBuilderOps$.MODULE$.knownSize$extension(arrayBuilder);
        }

        public ByteArrayBuilderOps(ArrayBuilder<Object> self) {
            this.self = self;
        }

        public int hashCode() {
            return AsyncBodyReader$ByteArrayBuilderOps$.MODULE$.hashCode$extension(this.zio$http$netty$AsyncBodyReader$ByteArrayBuilderOps$$self());
        }

        public boolean equals(Object x$0) {
            return AsyncBodyReader$ByteArrayBuilderOps$.MODULE$.equals$extension(this.zio$http$netty$AsyncBodyReader$ByteArrayBuilderOps$$self(), x$0);
        }

        public ArrayBuilder<Object> zio$http$netty$AsyncBodyReader$ByteArrayBuilderOps$$self() {
            return this.self;
        }

        public void addAll(byte[] as) {
            AsyncBodyReader$ByteArrayBuilderOps$.MODULE$.addAll$extension(this.zio$http$netty$AsyncBodyReader$ByteArrayBuilderOps$$self(), as);
        }

        public int knownSize() {
            return AsyncBodyReader$ByteArrayBuilderOps$.MODULE$.knownSize$extension(this.zio$http$netty$AsyncBodyReader$ByteArrayBuilderOps$$self());
        }
    }

    public static interface State {
        public static int ordinal(State state) {
            return AsyncBodyReader$State$.MODULE$.ordinal(state);
        }
    }
}

