/*
 * Decompiled with CFR 0.152.
 */
package zio.http.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Currency;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import zio.Cause$;
import zio.Chunk;
import zio.Chunk$;
import zio.Unsafe$;
import zio.http.Headers;
import zio.http.Headers$;
import zio.http.QueryParams;
import zio.http.codec.HttpCodecError;
import zio.http.internal.ErrorConstructor;
import zio.http.internal.StringSchemaCodec;
import zio.http.internal.StringSchemaCodec$PrimitiveCodec$;
import zio.schema.Schema;
import zio.schema.StandardType;
import zio.schema.TypeId;
import zio.schema.codec.DecodeError;
import zio.schema.validation.Validation$;
import zio.schema.validation.ValidationError;

public final class StringSchemaCodec$
implements Serializable {
    public static final StringSchemaCodec$PrimitiveCodec$ PrimitiveCodec;
    public static final StringSchemaCodec$ MODULE$;

    private StringSchemaCodec$() {
    }

    static {
        MODULE$ = new StringSchemaCodec$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StringSchemaCodec$.class);
    }

    public Schema.Field<?, ?> unlazyField(Schema.Field<?, ?> field) {
        Schema.Field<?, ?> field2 = field;
        Schema.Field<?, ?> f = field2;
        if (f.schema() instanceof Schema.Lazy) {
            return Schema.Field$.MODULE$.apply(f.name(), ((Schema.Lazy)f.schema()).schema(), f.annotations(), f.validation(), f.get(), f.set());
        }
        Schema.Field<?, ?> f2 = field2;
        return f2;
    }

    public <A> A defaultValue(Schema<A> schema) {
        if (schema instanceof Schema.Collection) {
            return (A)Try$.MODULE$.apply(() -> StringSchemaCodec$.defaultValue$$anonfun$1(schema)).fold((Function1 & Serializable)_$4 -> null, (Function1 & Serializable)x -> Predef$.MODULE$.identity(x));
        }
        Either either = schema.defaultValue();
        if (either instanceof Right) {
            Object value = ((Right)either).value();
            return (A)value;
        }
        if (either instanceof Left) {
            Schema<A> schema2 = schema;
            if (schema2 instanceof Schema.Optional) {
                return (A)None$.MODULE$;
            }
            if (schema2 instanceof Schema.Collection) {
                Schema.Collection collection = (Schema.Collection)schema2;
                return (A)Try$.MODULE$.apply(() -> StringSchemaCodec$.defaultValue$$anonfun$4(collection)).fold((Function1 & Serializable)_$5 -> null, (Function1 & Serializable)x -> Predef$.MODULE$.identity(x));
            }
            return null;
        }
        throw new MatchError((Object)either);
    }

    public boolean isOptional(Schema<?> schema) {
        Schema<?> schema2 = schema;
        if (schema2 instanceof Schema.Optional) {
            return true;
        }
        if (schema2 instanceof Schema.Record) {
            Schema.Record record = (Schema.Record)schema2;
            return record.fields().forall((Function1 & Serializable)_$6 -> _$6.optional()) || record.defaultValue().isRight();
        }
        if (schema2 instanceof Schema.Collection) {
            Schema.Collection d = (Schema.Collection)schema2;
            boolean bool = Try$.MODULE$.apply(() -> StringSchemaCodec$.$anonfun$6(d)).isSuccess() || d.defaultValue().isRight();
            return bool;
        }
        return false;
    }

    public boolean isOptionalSchema(Schema<?> schema) {
        Schema.Transform s;
        Schema<?> schema2 = schema;
        if (schema2 instanceof Schema.Optional) {
            return true;
        }
        return schema2 instanceof Schema.Transform && (s = (Schema.Transform)schema2).schema() instanceof Schema.Optional;
    }

    public Object zio$http$internal$StringSchemaCodec$$$decodeAndUnwrap(Schema.Field<?, ?> field, StringSchemaCodec.PrimitiveCodec<Object> codec, String value, Function2<String, DecodeError, HttpCodecError> ex) {
        Object object;
        try {
            object = codec.decode().apply((Object)value);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof DecodeError) {
                DecodeError err = (DecodeError)throwable2;
                throw (Throwable)ex.apply((Object)field.fieldName(), (Object)err);
            }
            throw throwable;
        }
        return object;
    }

    public Object zio$http$internal$StringSchemaCodec$$$validateDecoded(StringSchemaCodec.PrimitiveCodec<Object> codec, Object decoded, ErrorConstructor error) {
        Chunk validationErrors = codec.schema().validate(decoded, codec.schema());
        if (validationErrors.nonEmpty()) {
            throw (Throwable)((Object)error.invalid((Chunk<ValidationError>)validationErrors));
        }
        return decoded;
    }

    public boolean zio$http$internal$StringSchemaCodec$$$emptyStringIsValue(Schema<?> schema) {
        while (true) {
            Schema innerSchema;
            Schema schema2;
            if ((schema2 = schema) instanceof Schema.Optional) {
                Schema innerSchema2;
                Schema.Optional value = (Schema.Optional)schema2;
                schema = innerSchema2 = value.schema();
                continue;
            }
            if (!(schema2 instanceof Schema.Transform)) break;
            Schema.Transform value = (Schema.Transform)schema2;
            schema = innerSchema = value.schema();
        }
        StandardType standardType = ((Schema.Primitive)schema).standardType();
        if (StandardType.UnitType$.MODULE$.equals(standardType)) {
            return true;
        }
        if (StandardType.StringType$.MODULE$.equals(standardType)) {
            return true;
        }
        if (StandardType.BinaryType$.MODULE$.equals(standardType)) {
            return true;
        }
        return StandardType.CharType$.MODULE$.equals(standardType);
    }

    public Schema.Field<?, ?> mapFieldName(Schema.Field<?, ?> field, boolean kebabCase) {
        return Schema.Field$.MODULE$.apply(!kebabCase ? field.fieldName() : this.camelToKebab(field.fieldName()), (Schema)field.annotations().foldLeft((Object)field.schema(), (Function2 & Serializable)(_$7, _$8) -> _$7.annotate(_$8)), field.annotations(), field.validation(), field.get(), field.set());
    }

    public <A> StringSchemaCodec<A, Headers> headerFromSchema(Schema<A> schema0, ErrorConstructor error0, String name) {
        Schema schema;
        while (true) {
            Function0 function0;
            if ((schema = schema0) instanceof Schema.Primitive) {
                Schema.Primitive primitive = Schema.Primitive$.MODULE$.unapply((Schema.Primitive)schema);
                StandardType standardType = primitive._1();
                Chunk chunk = primitive._2();
                Schema.Primitive s = (Schema.Primitive)schema;
                return this.stringSchemaCodec$1(schema0, error0, name, this.recordSchema((Schema<A>)s, name));
            }
            if (schema instanceof Schema.Optional) {
                Schema.Optional optional = (Schema.Optional)schema;
                Schema.Optional optional2 = Schema.Optional$.MODULE$.unapply(optional);
                Schema schema2 = optional2._1();
                Chunk chunk = optional2._2();
                Schema schema3 = schema2;
                Schema.Optional s = optional;
                Schema schema4 = schema3;
                if (schema4 instanceof Schema.Collection || schema4 instanceof Schema.Primitive) {
                    return this.stringSchemaCodec$1(schema0, error0, name, this.recordSchema(schema3, name));
                }
                Schema s2 = schema4;
                if (s2 instanceof Schema.Record) {
                    return this.stringSchemaCodec$1(schema0, error0, name, schema3);
                }
                throw new IllegalArgumentException(new StringBuilder(19).append("Unsupported schema ").append(s).toString());
            }
            if (schema instanceof Schema.Transform) {
                Schema.Transform transform = (Schema.Transform)schema;
                Schema.Transform transform2 = Schema.Transform$.MODULE$.unapply(transform);
                Schema schema5 = transform2._1();
                Function1 function1 = transform2._2();
                Function1 function12 = transform2._3();
                Chunk chunk = transform2._4();
                Object object = transform2._5();
                Schema schema6 = schema5;
                Schema.Transform s = transform;
                Schema schema7 = schema6;
                if (schema7 instanceof Schema.Collection || schema7 instanceof Schema.Primitive) {
                    return this.stringSchemaCodec$1(schema0, error0, name, this.recordSchema((Schema)s, name));
                }
                if (schema7 instanceof Schema.Record) {
                    return this.stringSchemaCodec$1(schema0, error0, name, (Schema)s);
                }
                throw new IllegalArgumentException(new StringBuilder(19).append("Unsupported schema ").append(s).toString());
            }
            if (!(schema instanceof Schema.Lazy)) break;
            Schema.Lazy lazy = Schema.Lazy$.MODULE$.unapply((Schema.Lazy)schema);
            Function0 schema02 = function0 = lazy._1();
            schema0 = (Schema)schema02.apply();
        }
        if (schema instanceof Schema.Collection) {
            return this.stringSchemaCodec$1(schema0, error0, name, this.recordSchema(schema0, name));
        }
        if (schema instanceof Schema.Record) {
            Schema.Record record = (Schema.Record)schema;
            Schema.Record s = record;
            if (s.fields().size() == 1 && name != null) {
                return this.stringSchemaCodec$1(schema0, error0, name, this.recordSchema((Schema<A>)s, name));
            }
            Schema.Record s3 = record;
            return this.stringSchemaCodec$1(schema0, error0, name, (Schema)s3);
        }
        throw new IllegalArgumentException(new StringBuilder(19).append("Unsupported schema ").append(schema0).toString());
    }

    public <A> StringSchemaCodec<A, QueryParams> queryFromSchema(Schema<A> schema0, ErrorConstructor error0, String name) {
        Schema schema;
        while (true) {
            Function0 function0;
            if ((schema = schema0) instanceof Schema.Primitive) {
                Schema.Primitive primitive = Schema.Primitive$.MODULE$.unapply((Schema.Primitive)schema);
                StandardType standardType = primitive._1();
                Chunk chunk = primitive._2();
                Schema.Primitive s = (Schema.Primitive)schema;
                return this.stringSchemaCodec$2(schema0, error0, name, this.recordSchema((Schema<A>)s, name));
            }
            if (schema instanceof Schema.Optional) {
                Schema.Optional optional = (Schema.Optional)schema;
                Schema.Optional optional2 = Schema.Optional$.MODULE$.unapply(optional);
                Schema schema2 = optional2._1();
                Chunk chunk = optional2._2();
                Schema schema3 = schema2;
                Schema.Optional s = optional;
                Schema schema4 = schema3;
                if (schema4 instanceof Schema.Collection || schema4 instanceof Schema.Primitive) {
                    return this.stringSchemaCodec$2(schema0, error0, name, this.recordSchema(schema3, name));
                }
                Schema s2 = schema4;
                if (s2 instanceof Schema.Record) {
                    return this.stringSchemaCodec$2(schema0, error0, name, schema3);
                }
                Schema s3 = schema4;
                if (s3 instanceof Schema.Transform) {
                    return this.stringSchemaCodec$2(schema0, error0, name, this.recordSchema(s3, name));
                }
                throw new IllegalArgumentException(new StringBuilder(19).append("Unsupported schema ").append(s).toString());
            }
            if (schema instanceof Schema.Transform) {
                Schema.Transform transform = (Schema.Transform)schema;
                Schema.Transform transform2 = Schema.Transform$.MODULE$.unapply(transform);
                Schema schema5 = transform2._1();
                Function1 function1 = transform2._2();
                Function1 function12 = transform2._3();
                Chunk chunk = transform2._4();
                Object object = transform2._5();
                Schema schema6 = schema5;
                Schema.Transform s = transform;
                Schema schema7 = schema6;
                if (schema7 instanceof Schema.Collection || schema7 instanceof Schema.Primitive) {
                    return this.stringSchemaCodec$2(schema0, error0, name, this.recordSchema((Schema)s, name));
                }
                if (schema7 instanceof Schema.Record) {
                    return this.stringSchemaCodec$2(schema0, error0, name, (Schema)s);
                }
                throw new IllegalArgumentException(new StringBuilder(19).append("Unsupported schema ").append(s).toString());
            }
            if (!(schema instanceof Schema.Lazy)) break;
            Schema.Lazy lazy = Schema.Lazy$.MODULE$.unapply((Schema.Lazy)schema);
            Function0 schema02 = function0 = lazy._1();
            schema0 = (Schema)schema02.apply();
        }
        if (schema instanceof Schema.Collection) {
            return this.stringSchemaCodec$2(schema0, error0, name, this.recordSchema(schema0, name));
        }
        if (schema instanceof Schema.Record) {
            Schema.Record record = (Schema.Record)schema;
            Schema.Record s = record;
            if (s.fields().size() == 1 && name != null) {
                return this.stringSchemaCodec$2(schema0, error0, name, this.recordSchema((Schema<A>)s, name));
            }
            Schema.Record s4 = record;
            return this.stringSchemaCodec$2(schema0, error0, name, (Schema)s4);
        }
        throw new IllegalArgumentException(new StringBuilder(19).append("Unsupported schema ").append(schema0).toString());
    }

    private <A> Schema<A> recordSchema(Schema<A> s, String name) {
        return Schema.CaseClass1$.MODULE$.apply((TypeId)TypeId.Structural$.MODULE$, Schema.Field$.MODULE$.apply(name, s, Chunk$.MODULE$.empty(), Validation$.MODULE$.succeed(), (Function1 & Serializable)x -> Predef$.MODULE$.identity(x), (Function2 & Serializable)(_$9, v) -> v), (Function1 & Serializable)x -> Predef$.MODULE$.identity(x), Schema.CaseClass1$.MODULE$.apply$default$4());
    }

    public Function1<String, Object> zio$http$internal$StringSchemaCodec$$$parsePrimitive(StandardType<?> standardType) {
        StandardType<?> standardType2 = standardType;
        if (StandardType.UnitType$.MODULE$.equals(standardType2)) {
            String result = "";
            return (Function1 & Serializable)_$10 -> result;
        }
        if (StandardType.StringType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> s;
        }
        if (StandardType.BoolType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                boolean bl;
                block14: {
                    String string = s.toLowerCase();
                    switch (string == null ? 0 : string.hashCode()) {
                        case 48: {
                            if (!"0".equals(string)) {
                                throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)new Exception("Invalid boolean value"), Cause$.MODULE$.fail$default$2()), s);
                            }
                            break block14;
                        }
                        case 49: {
                            if ("1".equals(string)) break;
                            throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)new Exception("Invalid boolean value"), Cause$.MODULE$.fail$default$2()), s);
                        }
                        case 3521: {
                            if (!"no".equals(string)) {
                                throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)new Exception("Invalid boolean value"), Cause$.MODULE$.fail$default$2()), s);
                            }
                            break block14;
                        }
                        case 3551: {
                            if ("on".equals(string)) break;
                            throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)new Exception("Invalid boolean value"), Cause$.MODULE$.fail$default$2()), s);
                        }
                        case 109935: {
                            if (!"off".equals(string)) {
                                throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)new Exception("Invalid boolean value"), Cause$.MODULE$.fail$default$2()), s);
                            }
                            break block14;
                        }
                        case 119527: {
                            if ("yes".equals(string)) break;
                            throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)new Exception("Invalid boolean value"), Cause$.MODULE$.fail$default$2()), s);
                        }
                        case 3569038: {
                            if ("true".equals(string)) break;
                            throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)new Exception("Invalid boolean value"), Cause$.MODULE$.fail$default$2()), s);
                        }
                        case 97196323: {
                            if (!"false".equals(string)) {
                                throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)new Exception("Invalid boolean value"), Cause$.MODULE$.fail$default$2()), s);
                            }
                            break block14;
                        }
                    }
                    bl = true;
                    return BoxesRunTime.boxToBoolean((boolean)bl);
                }
                bl = false;
                return BoxesRunTime.boxToBoolean((boolean)bl);
                throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)new Exception("Invalid boolean value"), Cause$.MODULE$.fail$default$2()), s);
            };
        }
        if (StandardType.ByteType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                Byte by;
                try {
                    by = BoxesRunTime.boxToByte((byte)StringOps$.MODULE$.toByte$extension(Predef$.MODULE$.augmentString(s)));
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return by;
            };
        }
        if (StandardType.ShortType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                Short s2;
                try {
                    s2 = BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(s)));
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return s2;
            };
        }
        if (StandardType.IntType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                Integer n;
                try {
                    n = BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s)));
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return n;
            };
        }
        if (StandardType.LongType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                Long l;
                try {
                    l = BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(s)));
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return l;
            };
        }
        if (StandardType.FloatType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                Float f;
                try {
                    f = BoxesRunTime.boxToFloat((float)StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(s)));
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return f;
            };
        }
        if (StandardType.DoubleType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                Double d;
                try {
                    d = BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s)));
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return d;
            };
        }
        if (StandardType.BinaryType$.MODULE$.equals(standardType2)) {
            DecodeError.UnsupportedSchema result = DecodeError.UnsupportedSchema$.MODULE$.apply((Schema)Schema.Primitive$.MODULE$.apply(standardType, Schema.Primitive$.MODULE$.$lessinit$greater$default$2()), "TextCodec");
            return (Function1 & Serializable)_$11 -> {
                throw result;
            };
        }
        if (StandardType.CharType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> BoxesRunTime.boxToCharacter((char)s.charAt(0));
        }
        if (StandardType.UUIDType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                UUID uUID;
                try {
                    uUID = UUID.fromString(s);
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return uUID;
            };
        }
        if (StandardType.BigDecimalType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                BigDecimal bigDecimal;
                try {
                    bigDecimal = package$.MODULE$.BigDecimal().apply(s);
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return bigDecimal;
            };
        }
        if (StandardType.BigIntegerType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                BigInt bigInt;
                try {
                    bigInt = package$.MODULE$.BigInt().apply(s);
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return bigInt;
            };
        }
        if (StandardType.DayOfWeekType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                DayOfWeek dayOfWeek;
                try {
                    dayOfWeek = DayOfWeek.valueOf(s);
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return dayOfWeek;
            };
        }
        if (StandardType.MonthType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                Month month;
                try {
                    month = Month.valueOf(s);
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return month;
            };
        }
        if (StandardType.MonthDayType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                MonthDay monthDay;
                try {
                    monthDay = MonthDay.parse(s);
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return monthDay;
            };
        }
        if (StandardType.PeriodType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                Period period;
                try {
                    period = Period.parse(s);
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return period;
            };
        }
        if (StandardType.YearType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                Year year;
                try {
                    year = Year.parse(s);
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return year;
            };
        }
        if (StandardType.YearMonthType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                YearMonth yearMonth;
                try {
                    yearMonth = YearMonth.parse(s);
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return yearMonth;
            };
        }
        if (StandardType.ZoneIdType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                ZoneId zoneId;
                try {
                    zoneId = ZoneId.of(s);
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return zoneId;
            };
        }
        if (StandardType.ZoneOffsetType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                ZoneOffset zoneOffset;
                try {
                    zoneOffset = ZoneOffset.of(s);
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return zoneOffset;
            };
        }
        if (StandardType.DurationType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                Duration duration;
                try {
                    duration = Duration.parse(s);
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return duration;
            };
        }
        if (StandardType.InstantType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                Instant instant;
                try {
                    instant = Instant.parse(s);
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return instant;
            };
        }
        if (StandardType.LocalDateType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                LocalDate localDate;
                try {
                    localDate = LocalDate.parse(s);
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return localDate;
            };
        }
        if (StandardType.LocalTimeType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                LocalTime localTime;
                try {
                    localTime = LocalTime.parse(s);
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return localTime;
            };
        }
        if (StandardType.LocalDateTimeType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                LocalDateTime localDateTime;
                try {
                    localDateTime = LocalDateTime.parse(s);
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return localDateTime;
            };
        }
        if (StandardType.OffsetTimeType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                OffsetTime offsetTime;
                try {
                    offsetTime = OffsetTime.parse(s);
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return offsetTime;
            };
        }
        if (StandardType.OffsetDateTimeType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                OffsetDateTime offsetDateTime;
                try {
                    offsetDateTime = OffsetDateTime.parse(s);
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return offsetDateTime;
            };
        }
        if (StandardType.ZonedDateTimeType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                ZonedDateTime zonedDateTime;
                try {
                    zonedDateTime = ZonedDateTime.parse(s);
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return zonedDateTime;
            };
        }
        if (StandardType.CurrencyType$.MODULE$.equals(standardType2)) {
            return (Function1 & Serializable)s -> {
                Currency currency;
                try {
                    currency = Currency.getInstance(s);
                }
                catch (Exception e) {
                    throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
                return currency;
            };
        }
        throw new MatchError(standardType2);
    }

    private String camelToKebab(String s) {
        if (s.isEmpty()) {
            return "";
        }
        if (RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(s))))) {
            return new StringBuilder(0).append(BoxesRunTime.boxToCharacter((char)RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(s))))).toString()).append(this.camelToKebab(StringOps$.MODULE$.tail$extension(Predef$.MODULE$.augmentString(s)))).toString();
        }
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(s), '-')) {
            return s;
        }
        return (String)StringOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.augmentString(s), (Object)"", (Function2 & Serializable)(acc, c) -> StringSchemaCodec$.camelToKebab$$anonfun$1((String)acc, BoxesRunTime.unboxToChar((Object)c)));
    }

    private static final Object defaultValue$$anonfun$1(Schema schema$1) {
        return ((Schema.Collection)schema$1).empty();
    }

    private static final Object defaultValue$$anonfun$4(Schema.Collection collection$1) {
        return collection$1.empty();
    }

    private static final Object $anonfun$6(Schema.Collection d$1) {
        return d$1.empty();
    }

    public static final /* synthetic */ IterableOnce zio$http$internal$StringSchemaCodec$$anon$4$$_$getAll$$anonfun$1(String header) {
        if (header.isEmpty()) {
            return Chunk$.MODULE$.empty();
        }
        return Chunk$.MODULE$.fromIterable((Iterable)Predef$.MODULE$.wrapRefArray((Object[])header.split(",")));
    }

    private final StringSchemaCodec stringSchemaCodec$1(Schema schema0$tailLocal1$1, ErrorConstructor error0$1, String name$1, Schema schema1) {
        return new StringSchemaCodec<A, Headers>(schema0$tailLocal1$1, schema1, error0$1, name$1){
            private final Schema schema1$2;
            private final ErrorConstructor error0$3;
            private final String name$3;
            private Chunk recordFields;
            private Schema.Record recordSchema;
            private final Object defaultValue;
            private final boolean isOptional;
            private final boolean isOptionalSchema;
            {
                this.schema1$2 = schema1$1;
                this.error0$3 = error0$2;
                this.name$3 = name$2;
                StringSchemaCodec.$init$(this);
                this.defaultValue = StringSchemaCodec$.MODULE$.defaultValue(schema0$tailLocal1$2);
                this.isOptional = StringSchemaCodec$.MODULE$.isOptional(schema0$tailLocal1$2);
                this.isOptionalSchema = StringSchemaCodec$.MODULE$.isOptionalSchema(schema0$tailLocal1$2);
                Statics.releaseFence();
            }

            public Chunk recordFields() {
                return this.recordFields;
            }

            public Schema.Record recordSchema() {
                return this.recordSchema;
            }

            public void zio$http$internal$StringSchemaCodec$_setter_$recordFields_$eq(Chunk x$0) {
                this.recordFields = x$0;
            }

            public void zio$http$internal$StringSchemaCodec$_setter_$recordSchema_$eq(Schema.Record x$0) {
                this.recordSchema = x$0;
            }

            public Schema schema() {
                return this.schema1$2;
            }

            public Headers add(Headers headers, String key, String value) {
                return (Headers)headers.addHeaders(Headers$.MODULE$.apply(key, value));
            }

            public Headers addAll(Headers headers, String key, Iterable values) {
                if (values.isEmpty()) {
                    return headers;
                }
                return (Headers)headers.addHeaders(Headers$.MODULE$.apply(key, values.mkString(",")));
            }

            public boolean contains(Headers headers, String key) {
                return headers.contains(key);
            }

            public String unsafeGet(Headers headers, String key) {
                return headers.getUnsafe(key);
            }

            public Chunk getAll(Headers headers, String key) {
                return headers.rawHeaders(key).flatMap(StringSchemaCodec$::zio$http$internal$StringSchemaCodec$$anon$4$$_$getAll$$anonfun$1);
            }

            public int count(Headers headers, String key) {
                return headers.rawHeaders(key).size();
            }

            public ErrorConstructor error() {
                return this.error0$3;
            }

            public StringSchemaCodec optional() {
                return StringSchemaCodec$.MODULE$.headerFromSchema(this.schema().optional(), this.error0$3, this.name$3);
            }

            public boolean kebabCase() {
                return true;
            }

            public Object defaultValue() {
                return this.defaultValue;
            }

            public boolean isOptional() {
                return this.isOptional;
            }

            public boolean isOptionalSchema() {
                return this.isOptionalSchema;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{zio$http$internal$StringSchemaCodec$$anon$4$$_$getAll$$anonfun$1(java.lang.String )}, serializedLambda);
            }
        };
    }

    private final StringSchemaCodec stringSchemaCodec$2(Schema schema0$tailLocal2$1, ErrorConstructor error0$4, String name$4, Schema schema1) {
        return new StringSchemaCodec<A, QueryParams>(schema0$tailLocal2$1, schema1, error0$4, name$4){
            private final Schema schema1$4;
            private final ErrorConstructor error0$6;
            private final String name$6;
            private Chunk recordFields;
            private Schema.Record recordSchema;
            private final Object defaultValue;
            private final boolean isOptional;
            private final boolean isOptionalSchema;
            {
                this.schema1$4 = schema1$3;
                this.error0$6 = error0$5;
                this.name$6 = name$5;
                StringSchemaCodec.$init$(this);
                this.defaultValue = StringSchemaCodec$.MODULE$.defaultValue(schema0$tailLocal2$2);
                this.isOptional = StringSchemaCodec$.MODULE$.isOptional(schema0$tailLocal2$2);
                this.isOptionalSchema = StringSchemaCodec$.MODULE$.isOptionalSchema(schema0$tailLocal2$2);
                Statics.releaseFence();
            }

            public Chunk recordFields() {
                return this.recordFields;
            }

            public Schema.Record recordSchema() {
                return this.recordSchema;
            }

            public void zio$http$internal$StringSchemaCodec$_setter_$recordFields_$eq(Chunk x$0) {
                this.recordFields = x$0;
            }

            public void zio$http$internal$StringSchemaCodec$_setter_$recordSchema_$eq(Schema.Record x$0) {
                this.recordSchema = x$0;
            }

            public Schema schema() {
                return this.schema1$4;
            }

            public QueryParams add(QueryParams queryParams, String key, String value) {
                return (QueryParams)queryParams.addQueryParam(key, value);
            }

            public QueryParams addAll(QueryParams queryParams, String key, Iterable values) {
                return (QueryParams)queryParams.addQueryParams(key, (Chunk<String>)Chunk$.MODULE$.fromIterable(values));
            }

            public boolean contains(QueryParams queryParams, String key) {
                return queryParams.hasQueryParam(key);
            }

            public String unsafeGet(QueryParams queryParams, String key) {
                return queryParams.unsafeQueryParam(key);
            }

            public Chunk getAll(QueryParams queryParams, String key) {
                return queryParams.getAll(key);
            }

            public int count(QueryParams queryParams, String key) {
                return queryParams.valueCount(key);
            }

            public ErrorConstructor error() {
                return this.error0$6;
            }

            public StringSchemaCodec optional() {
                return StringSchemaCodec$.MODULE$.queryFromSchema(this.schema().optional(), this.error0$6, this.name$6);
            }

            public boolean kebabCase() {
                return false;
            }

            public Object defaultValue() {
                return this.defaultValue;
            }

            public boolean isOptional() {
                return this.isOptional;
            }

            public boolean isOptionalSchema() {
                return this.isOptionalSchema;
            }
        };
    }

    private static final /* synthetic */ String camelToKebab$$anonfun$1(String acc, char c) {
        if (RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(c))) {
            return new StringBuilder(1).append(acc).append("-").append(RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(c))).toString();
        }
        return new StringBuilder(0).append(acc).append(c).toString();
    }

    public static final /* synthetic */ Some zio$http$internal$StringSchemaCodec$PrimitiveCodec$$$_$primitiveSchemaDecoder$$anonfun$1(Object _$12) {
        return Some$.MODULE$.apply(_$12);
    }

    public static final /* synthetic */ Object zio$http$internal$StringSchemaCodec$PrimitiveCodec$$$_$primitiveSchemaDecoder$$anonfun$2(Function1 f$1, Object _$13) {
        Either either = (Either)f$1.apply(_$13);
        if (either instanceof Left) {
            String value = (String)((Left)either).value();
            throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.empty(), value);
        }
        if (either instanceof Right) {
            Object value = ((Right)either).value();
            return value;
        }
        throw new MatchError((Object)either);
    }

    public static final /* synthetic */ Object zio$http$internal$StringSchemaCodec$PrimitiveCodec$$$_$primitiveSchemaDecoder$$anonfun$3(Schema.Record r$1, Function1 decoder$1, String s) {
        Either either = r$1.construct(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{decoder$1.apply((Object)s)})), Unsafe$.MODULE$.unsafe());
        if (either instanceof Left) {
            String value = (String)((Left)either).value();
            throw DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.empty(), value);
        }
        if (either instanceof Right) {
            Object value = ((Right)either).value();
            return value;
        }
        throw new MatchError((Object)either);
    }

    public static final /* synthetic */ String zio$http$internal$StringSchemaCodec$PrimitiveCodec$$$_$primitiveSchemaEncoder$$anonfun$1(Function1 innerEncoder$1, Object a) {
        if (a == None$.MODULE$) {
            return null;
        }
        return (String)innerEncoder$1.apply(((Some)a).get());
    }

    public static final /* synthetic */ String zio$http$internal$StringSchemaCodec$PrimitiveCodec$$$_$primitiveSchemaEncoder$$anonfun$2(Function1 g$1, Function1 innerEncoder$2, Object a) {
        Either either = (Either)g$1.apply(a);
        if (either instanceof Left) {
            String value = (String)((Left)either).value();
            throw new IllegalArgumentException(value);
        }
        if (either instanceof Right) {
            Object value = ((Right)either).value();
            return (String)innerEncoder$2.apply(value);
        }
        throw new MatchError((Object)either);
    }

    public static final /* synthetic */ String zio$http$internal$StringSchemaCodec$PrimitiveCodec$$$_$primitiveSchemaEncoder$$anonfun$3(Object a) {
        return a.toString();
    }

    public static final /* synthetic */ String zio$http$internal$StringSchemaCodec$PrimitiveCodec$$$_$primitiveSchemaEncoder$$anonfun$4(Function1 encoder$1, Schema.Field field$2, Object a) {
        return (String)encoder$1.apply(field$2.get().apply(a));
    }
}

