/*
 * Decompiled with CFR 0.152.
 */
package zio.http.internal;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import scala.Function1;
import scala.collection.mutable.StringBuilder;
import scala.runtime.ModuleSerializationProxy;

public final class StringBuilderPool$
implements Serializable {
    private static final ConcurrentLinkedQueue<StringBuilder> pool;
    private static final int DefaultCapacity;
    private static final int MaxPoolSize;
    public static final StringBuilderPool$ MODULE$;

    private StringBuilderPool$() {
    }

    static {
        MODULE$ = new StringBuilderPool$();
        pool = new ConcurrentLinkedQueue();
        DefaultCapacity = 256;
        MaxPoolSize = 25;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StringBuilderPool$.class);
    }

    private StringBuilder borrow() {
        StringBuilder sb = pool.poll();
        if (sb != null) {
            sb.setLength(0);
            return sb;
        }
        return new StringBuilder(DefaultCapacity);
    }

    private void release(StringBuilder sb) {
        if (sb.length() <= DefaultCapacity * 4 && pool.size() < MaxPoolSize) {
            pool.offer(sb);
            return;
        }
    }

    public <T> T withStringBuilder(Function1<StringBuilder, T> f) {
        Object object;
        StringBuilder sb = this.borrow();
        try {
            object = f.apply((Object)sb);
        }
        finally {
            this.release(sb);
        }
        return (T)object;
    }
}

