/*
 * Decompiled with CFR 0.152.
 */
package zio.http.internal;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import scala.Function1;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import zio.http.QueryParams;
import zio.http.QueryParams$;
import zio.http.internal.ByteArrayOutputStreamPool$;

public final class QueryParamEncoding$
implements Serializable {
    public static final QueryParamEncoding$ MODULE$ = new QueryParamEncoding$();

    private QueryParamEncoding$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(QueryParamEncoding$.class);
    }

    public QueryParams decode(String queryStringFragment, Charset charset) {
        if (queryStringFragment == null || queryStringFragment.isEmpty()) {
            return QueryParams$.MODULE$.empty();
        }
        int length = queryStringFragment.length();
        int count = 1;
        for (int i = 0; i < length; ++i) {
            if (queryStringFragment.charAt(i) != '&') continue;
            ++count;
        }
        int paramCount = count;
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>(paramCount);
        int startIndex = 0;
        if (startIndex < length && queryStringFragment.charAt(startIndex) == '?') {
            ++startIndex;
        }
        while (startIndex < length) {
            List<String> values;
            int eqIndex = -1;
            int ampIndex = queryStringFragment.indexOf(38, startIndex);
            if (ampIndex == -1) {
                ampIndex = length;
            }
            for (int i = startIndex; i < ampIndex && eqIndex == -1; ++i) {
                if (queryStringFragment.charAt(i) != '=') continue;
                eqIndex = i;
            }
            String key = eqIndex != -1 ? this.decodeComponent(queryStringFragment, startIndex, eqIndex, charset) : this.decodeComponent(queryStringFragment, startIndex, ampIndex, charset);
            String value = eqIndex != -1 ? this.decodeComponent(queryStringFragment, eqIndex + 1, ampIndex, charset) : "";
            String string = key;
            String string2 = "";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                key = value;
                value = "";
            }
            if ((values = params.get(key)) == null) {
                values = new ArrayList<String>(1);
                params.put(key, values);
            }
            values.add(value);
            startIndex = ampIndex + 1;
        }
        return QueryParams$.MODULE$.apply(params);
    }

    public String encode(StringBuilder baseUri, QueryParams queryParams, Charset charset) {
        if (queryParams.isEmpty()) {
            return baseUri.toString();
        }
        int paramCount = queryParams.seq().size();
        baseUri.ensureCapacity(baseUri.length() + Math.min(paramCount * 20, 1024));
        boolean isFirst = true;
        for (Map.Entry entry : queryParams.seq()) {
            String key;
            String string = key = (String)entry.getKey();
            String string2 = "";
            if (!(string == null ? string2 != null : !string.equals(string2))) continue;
            List values = (List)entry.getValue();
            if (values.isEmpty()) {
                StringBuilder stringBuilder;
                if (isFirst) {
                    baseUri.append('?');
                    isFirst = false;
                    stringBuilder = BoxedUnit.UNIT;
                } else {
                    stringBuilder = baseUri.append('&');
                }
                this.encodeComponentInto(key, charset, baseUri);
                baseUri.append('=');
                continue;
            }
            int valuesSize = values.size();
            for (int j = 0; j < valuesSize; ++j) {
                StringBuilder stringBuilder;
                if (isFirst) {
                    baseUri.append('?');
                    isFirst = false;
                    stringBuilder = BoxedUnit.UNIT;
                } else {
                    stringBuilder = baseUri.append('&');
                }
                this.encodeComponentInto(key, charset, baseUri);
                baseUri.append('=');
                this.encodeComponentInto((String)values.get(j), charset, baseUri);
            }
        }
        return baseUri.toString();
    }

    private String decodeComponent(String component, int start, int end, Charset charset) {
        if (start >= end) {
            return "";
        }
        boolean needsDecoding = false;
        IntRef i = IntRef.create((int)start);
        while (i.elem < end && !needsDecoding) {
            char c = component.charAt(i.elem);
            needsDecoding = c == '%' || c == '+';
            ++i.elem;
        }
        if (!needsDecoding) {
            return component.substring(start, end);
        }
        return (String)ByteArrayOutputStreamPool$.MODULE$.withStream((Function1 & Serializable)byteBuffer -> {
            i$1.elem = start;
            while (i$1.elem < end) {
                char c = component.charAt(i$1.elem);
                if (c == '%' && i$1.elem + 2 < end) {
                    int digit1 = Character.digit(component.charAt(i$1.elem + 1), 16);
                    int digit2 = Character.digit(component.charAt(i$1.elem + 2), 16);
                    if (digit1 >= 0 && digit2 >= 0) {
                        int decoded = digit1 << 4 | digit2;
                        byteBuffer.write(decoded);
                        i$1.elem += 3;
                        continue;
                    }
                    byte[] bytes = "%".getBytes(charset);
                    byteBuffer.write(bytes, 0, bytes.length);
                    ++i$1.elem;
                    continue;
                }
                if (c == '+') {
                    byte[] bytes = " ".getBytes(charset);
                    byteBuffer.write(bytes, 0, bytes.length);
                    ++i$1.elem;
                    continue;
                }
                byte[] bytes = BoxesRunTime.boxToCharacter((char)c).toString().getBytes(charset);
                byteBuffer.write(bytes, 0, bytes.length);
                ++i$1.elem;
            }
            return new String(byteBuffer.toByteArray(), charset);
        });
    }

    private void encodeComponentInto(String component, Charset charset, StringBuilder target) {
        if (component.isEmpty()) {
            return;
        }
        boolean needsEncoding = false;
        int len = component.length();
        for (int i = 0; i < len && !needsEncoding; ++i) {
            char c = component.charAt(i);
            needsEncoding = !this.needsNoEncoding(c);
        }
        if (!needsEncoding) {
            target.append(component);
            return;
        }
        byte[] bytes = component.getBytes(charset);
        int bytesLen = bytes.length;
        for (int k = 0; k < bytesLen; ++k) {
            StringBuilder stringBuilder;
            int unsignedByte = bytes[k] & 0xFF;
            if (unsignedByte >= 97 && unsignedByte <= 122 || unsignedByte >= 65 && unsignedByte <= 90 || unsignedByte >= 48 && unsignedByte <= 57 || unsignedByte == 45 || unsignedByte == 46 || unsignedByte == 95 || unsignedByte == 126 || unsignedByte == 42) {
                stringBuilder = target.append((char)unsignedByte);
                continue;
            }
            if (unsignedByte == 32) {
                stringBuilder = target.append('+');
                continue;
            }
            target.append('%');
            target.append(RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(Character.forDigit(unsignedByte >> 4 & 0xF, 16))));
            stringBuilder = target.append(RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(Character.forDigit(unsignedByte & 0xF, 16))));
        }
    }

    private boolean needsNoEncoding(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == '_' || c == '~' || c == '*';
    }
}

