/*
 * Decompiled with CFR 0.152.
 */
package zio.http.codec.internal;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Chunk;
import zio.Exit$;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$;
import zio.http.FormField;
import zio.http.FormField$;
import zio.http.Header;
import zio.http.MediaType;
import zio.http.codec.BinaryCodecWithSchema;
import zio.http.codec.BinaryCodecWithSchema$;
import zio.http.codec.CodecConfig;
import zio.http.codec.HttpCodecError;
import zio.http.codec.HttpContentCodec;
import zio.http.codec.internal.BodyCodec$;
import zio.http.codec.internal.BodyCodec$Multiple$;
import zio.http.codec.internal.BodyCodec$Single$;
import zio.schema.Schema;
import zio.schema.Schema$;
import zio.schema.StandardType;
import zio.stream.ZPipeline;
import zio.stream.ZStream;

public interface BodyCodec<A> {
    public static int ordinal(BodyCodec<?> bodyCodec) {
        return BodyCodec$.MODULE$.ordinal(bodyCodec);
    }

    public static <E> ZPipeline<Object, HttpCodecError, E, E> validateStream(Schema<E> schema, Object object) {
        return BodyCodec$.MODULE$.validateStream(schema, object);
    }

    public static <A> ZIO<Object, HttpCodecError, A> validateZIO(Schema<A> schema, A a, Object object) {
        return BodyCodec$.MODULE$.validateZIO(schema, a, object);
    }

    public ZIO<Object, Throwable, A> decodeFromField(FormField var1, CodecConfig var2, Object var3);

    public ZIO<Object, Throwable, A> decodeFromBody(Body var1, CodecConfig var2, Object var3);

    public FormField encodeToField(A var1, Chunk<Header.Accept.MediaTypeWithQFactor> var2, String var3, CodecConfig var4, Object var5);

    public Body encodeToBody(A var1, Chunk<Header.Accept.MediaTypeWithQFactor> var2, CodecConfig var3, Object var4);

    public static BodyCodec erase$(BodyCodec $this) {
        return $this.erase();
    }

    default public BodyCodec<Object> erase() {
        return this;
    }

    public Option<MediaType> mediaType(Chunk<Header.Accept.MediaTypeWithQFactor> var1);

    public Option<String> name();

    public static final class Multiple<E>
    implements BodyCodec<ZStream<Object, Nothing$, E>>,
    Product,
    Serializable {
        private final HttpContentCodec codec;
        private final Option name;

        public static <E> Multiple<E> apply(HttpContentCodec<E> httpContentCodec, Option<String> option) {
            return BodyCodec$Multiple$.MODULE$.apply(httpContentCodec, option);
        }

        public static Multiple<?> fromProduct(Product product) {
            return BodyCodec$Multiple$.MODULE$.fromProduct(product);
        }

        public static <E> Multiple<E> unapply(Multiple<E> multiple) {
            return BodyCodec$Multiple$.MODULE$.unapply(multiple);
        }

        public Multiple(HttpContentCodec<E> codec, Option<String> name) {
            this.codec = codec;
            this.name = name;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Multiple)) return false;
            Multiple multiple = (Multiple)object;
            HttpContentCodec<E> httpContentCodec = this.codec();
            HttpContentCodec<E> httpContentCodec2 = multiple.codec();
            if (httpContentCodec == null) {
                if (httpContentCodec2 != null) {
                    return false;
                }
            } else if (!httpContentCodec.equals(httpContentCodec2)) return false;
            Option<String> option = this.name();
            Option<String> option2 = multiple.name();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Multiple;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Multiple";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "codec";
            }
            if (1 == n2) {
                return "name";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public HttpContentCodec<E> codec() {
            return this.codec;
        }

        @Override
        public Option<String> name() {
            return this.name;
        }

        @Override
        public Option<MediaType> mediaType(Chunk<Header.Accept.MediaTypeWithQFactor> accepted) {
            return Some$.MODULE$.apply(this.codec().chooseFirstOrDefault(accepted)._1());
        }

        @Override
        public ZIO<Object, Throwable, ZStream<Object, Nothing$, E>> decodeFromField(FormField field, CodecConfig config, Object trace) {
            return ZIO$.MODULE$.fromEither(() -> this.decodeFromField$$anonfun$3(field, trace, config), trace);
        }

        @Override
        public ZIO<Object, Throwable, ZStream<Object, Nothing$, E>> decodeFromBody(Body body, CodecConfig config, Object trace) {
            return ZIO$.MODULE$.fromEither(() -> this.decodeFromBody$$anonfun$4(body, trace, config), trace);
        }

        @Override
        public FormField encodeToField(ZStream<Object, Nothing$, E> value, Chunk<Header.Accept.MediaTypeWithQFactor> mediaTypes, String name, CodecConfig config, Object trace) {
            Tuple2<MediaType, BinaryCodecWithSchema<E>> selected = this.codec().chooseFirstOrDefault(mediaTypes);
            MediaType mediaType = (MediaType)selected._1();
            BinaryCodecWithSchema bc = (BinaryCodecWithSchema)selected._2();
            return FormField$.MODULE$.streamingBinaryField(name, (ZStream<Object, Nothing$, Object>)value.$greater$greater$greater(() -> BodyCodec$.zio$http$codec$internal$BodyCodec$Multiple$$_$encodeToField$$anonfun$1(bc, config), trace), mediaType, FormField$.MODULE$.streamingBinaryField$default$4(), FormField$.MODULE$.streamingBinaryField$default$5());
        }

        @Override
        public Body encodeToBody(ZStream<Object, Nothing$, E> value, Chunk<Header.Accept.MediaTypeWithQFactor> mediaTypes, CodecConfig config, Object trace) {
            Tuple2<MediaType, BinaryCodecWithSchema<E>> selected = this.codec().chooseFirstOrDefault(mediaTypes);
            MediaType mediaType = (MediaType)selected._1();
            BinaryCodecWithSchema bc = (BinaryCodecWithSchema)selected._2();
            return Body$.MODULE$.fromStreamChunked((ZStream<Object, Throwable, Object>)value.$greater$greater$greater(() -> BodyCodec$.zio$http$codec$internal$BodyCodec$Multiple$$_$encodeToBody$$anonfun$1(bc, config), trace)).contentType(mediaType);
        }

        public <E> Multiple<E> copy(HttpContentCodec<E> codec, Option<String> name) {
            return new Multiple<E>(codec, name);
        }

        public <E> HttpContentCodec<E> copy$default$1() {
            return this.codec();
        }

        public <E> Option<String> copy$default$2() {
            return this.name();
        }

        public HttpContentCodec<E> _1() {
            return this.codec();
        }

        public Option<String> _2() {
            return this.name();
        }

        private final Either decodeFromField$$anonfun$3(FormField field$2, Object trace$5, CodecConfig config$5) {
            return this.codec().lookup(field$2.contentType()).toRight(() -> BodyCodec$.zio$http$codec$internal$BodyCodec$Multiple$$_$decodeFromField$$anonfun$3$$anonfun$1(field$2)).map(arg_0 -> BodyCodec$.zio$http$codec$internal$BodyCodec$Multiple$$_$decodeFromField$$anonfun$3$$anonfun$2(field$2, trace$5, config$5, arg_0));
        }

        private final Either decodeFromBody$$anonfun$4(Body body$1, Object trace$8, CodecConfig config$8) {
            return BodyCodec$.MODULE$.zio$http$codec$internal$BodyCodec$$$codecForBody(this.codec(), body$1).map(arg_0 -> BodyCodec$.zio$http$codec$internal$BodyCodec$Multiple$$_$decodeFromBody$$anonfun$4$$anonfun$1(body$1, trace$8, config$8, arg_0));
        }
    }

    public static final class Single<A>
    implements BodyCodec<A>,
    Product,
    Serializable {
        private final HttpContentCodec codec;
        private final Option name;

        public static <A> Single<A> apply(HttpContentCodec<A> httpContentCodec, Option<String> option) {
            return BodyCodec$Single$.MODULE$.apply(httpContentCodec, option);
        }

        public static Single<?> fromProduct(Product product) {
            return BodyCodec$Single$.MODULE$.fromProduct(product);
        }

        public static <A> Single<A> unapply(Single<A> single) {
            return BodyCodec$Single$.MODULE$.unapply(single);
        }

        public Single(HttpContentCodec<A> codec, Option<String> name) {
            this.codec = codec;
            this.name = name;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Single)) return false;
            Single single = (Single)object;
            HttpContentCodec<A> httpContentCodec = this.codec();
            HttpContentCodec<A> httpContentCodec2 = single.codec();
            if (httpContentCodec == null) {
                if (httpContentCodec2 != null) {
                    return false;
                }
            } else if (!httpContentCodec.equals(httpContentCodec2)) return false;
            Option<String> option = this.name();
            Option<String> option2 = single.name();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Single;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Single";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "codec";
            }
            if (1 == n2) {
                return "name";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public HttpContentCodec<A> codec() {
            return this.codec;
        }

        @Override
        public Option<String> name() {
            return this.name;
        }

        @Override
        public Option<MediaType> mediaType(Chunk<Header.Accept.MediaTypeWithQFactor> accepted) {
            return Some$.MODULE$.apply(this.codec().chooseFirstOrDefault(accepted)._1());
        }

        @Override
        public ZIO<Object, Throwable, A> decodeFromField(FormField field, CodecConfig config, Object trace) {
            BinaryCodecWithSchema binaryCodecWithSchema;
            Tuple2 tuple2;
            Either codec0 = this.codec().lookup(field.contentType()).toRight(() -> BodyCodec$.zio$http$codec$internal$BodyCodec$Single$$_$_$$anonfun$1(field));
            Either either = codec0;
            if (either instanceof Left) {
                HttpCodecError.CustomError error = (HttpCodecError.CustomError)((Left)either).value();
                return Exit$.MODULE$.fail((Object)error);
            }
            if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null && (binaryCodecWithSchema = (BinaryCodecWithSchema)tuple2._2()) != null) {
                Schema schema;
                Schema schema2;
                BinaryCodecWithSchema binaryCodecWithSchema2 = BinaryCodecWithSchema$.MODULE$.unapply(binaryCodecWithSchema);
                Function1 function1 = binaryCodecWithSchema2._1();
                Schema schema3 = schema2 = (schema = binaryCodecWithSchema2._2());
                Schema schema4 = Schema$.MODULE$.apply(Schema$.MODULE$.primitive((StandardType)StandardType.UnitType$.MODULE$));
                if (!(schema3 != null ? !schema3.equals(schema4) : schema4 != null)) {
                    return (ZIO)Exit$.MODULE$.unit();
                }
                Schema schema5 = schema;
                BinaryCodecWithSchema bc = binaryCodecWithSchema;
                return field.asChunk(trace).flatMap(arg_0 -> BodyCodec$.zio$http$codec$internal$BodyCodec$Single$$_$decodeFromField$$anonfun$1(bc, config, trace, arg_0), trace).flatMap(arg_0 -> BodyCodec$.zio$http$codec$internal$BodyCodec$Single$$_$decodeFromField$$anonfun$2(schema5, trace, arg_0), trace);
            }
            throw new MatchError((Object)either);
        }

        @Override
        public ZIO<Object, Throwable, A> decodeFromBody(Body body, CodecConfig config, Object trace) {
            BinaryCodecWithSchema binaryCodecWithSchema;
            Tuple2 tuple2;
            Either<HttpCodecError.CustomError, Tuple2<MediaType, BinaryCodecWithSchema<A>>> codec0 = BodyCodec$.MODULE$.zio$http$codec$internal$BodyCodec$$$codecForBody(this.codec(), body);
            Either<HttpCodecError.CustomError, Tuple2<MediaType, BinaryCodecWithSchema<A>>> either = codec0;
            if (either instanceof Left) {
                HttpCodecError.CustomError error = (HttpCodecError.CustomError)((Left)either).value();
                return Exit$.MODULE$.fail((Object)error);
            }
            if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null && (binaryCodecWithSchema = (BinaryCodecWithSchema)tuple2._2()) != null) {
                Schema schema;
                Schema schema2;
                BinaryCodecWithSchema binaryCodecWithSchema2 = BinaryCodecWithSchema$.MODULE$.unapply(binaryCodecWithSchema);
                Function1 function1 = binaryCodecWithSchema2._1();
                Schema schema3 = schema2 = (schema = binaryCodecWithSchema2._2());
                Schema schema4 = Schema$.MODULE$.apply(Schema$.MODULE$.primitive((StandardType)StandardType.UnitType$.MODULE$));
                if (!(schema3 != null ? !schema3.equals(schema4) : schema4 != null)) {
                    if (body.isEmpty()) {
                        return (ZIO)Exit$.MODULE$.unit();
                    }
                    return ZIO$.MODULE$.fail(BodyCodec$::zio$http$codec$internal$BodyCodec$Single$$_$decodeFromBody$$anonfun$1, trace);
                }
                Schema schema5 = schema;
                BinaryCodecWithSchema bc = binaryCodecWithSchema;
                return body.asChunk(trace).flatMap(arg_0 -> BodyCodec$.zio$http$codec$internal$BodyCodec$Single$$_$decodeFromBody$$anonfun$2(bc, config, trace, arg_0), trace).flatMap(arg_0 -> BodyCodec$.zio$http$codec$internal$BodyCodec$Single$$_$decodeFromBody$$anonfun$3(schema5, trace, arg_0), trace);
            }
            throw new MatchError(either);
        }

        @Override
        public FormField encodeToField(A value, Chunk<Header.Accept.MediaTypeWithQFactor> mediaTypes, String name, CodecConfig config, Object trace) {
            Tuple2<MediaType, BinaryCodecWithSchema<A>> selected = this.codec().chooseFirstOrDefault(mediaTypes);
            MediaType mediaType = (MediaType)selected._1();
            BinaryCodecWithSchema bc = (BinaryCodecWithSchema)selected._2();
            if (mediaType.binary()) {
                return FormField$.MODULE$.binaryField(name, (Chunk<Object>)((Chunk)bc.codec(config).encode(value)), mediaType, FormField$.MODULE$.binaryField$default$4(), FormField$.MODULE$.binaryField$default$5());
            }
            return FormField$.MODULE$.textField(name, ((Chunk)bc.codec(config).encode(value)).asString(Chunk.IsText$.MODULE$.byteIsText()), mediaType);
        }

        @Override
        public Body encodeToBody(A value, Chunk<Header.Accept.MediaTypeWithQFactor> mediaTypes, CodecConfig config, Object trace) {
            Tuple2<MediaType, BinaryCodecWithSchema<A>> selected = this.codec().chooseFirstOrDefault(mediaTypes);
            MediaType mediaType = (MediaType)selected._1();
            BinaryCodecWithSchema bc = (BinaryCodecWithSchema)selected._2();
            Schema schema = bc.schema();
            Schema schema2 = Schema$.MODULE$.apply(Schema$.MODULE$.primitive((StandardType)StandardType.UnitType$.MODULE$));
            if (!(schema != null ? !schema.equals(schema2) : schema2 != null)) {
                return Body$.MODULE$.empty().contentType(mediaType);
            }
            return Body$.MODULE$.fromChunk((Chunk<Object>)((Chunk)bc.codec(config).encode(value)), mediaType);
        }

        public <A> Single<A> copy(HttpContentCodec<A> codec, Option<String> name) {
            return new Single<A>(codec, name);
        }

        public <A> HttpContentCodec<A> copy$default$1() {
            return this.codec();
        }

        public <A> Option<String> copy$default$2() {
            return this.name();
        }

        public HttpContentCodec<A> _1() {
            return this.codec();
        }

        public Option<String> _2() {
            return this.name();
        }
    }
}

