/*
 * Decompiled with CFR 0.152.
 */
package zio.http.codec;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import zio.Chunk;
import zio.Chunk$;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$;
import zio.http.Header;
import zio.http.Header$ContentType$;
import zio.http.MediaType;
import zio.http.MediaType$;
import zio.http.Request;
import zio.http.Response;
import zio.http.codec.BinaryCodecWithSchema;
import zio.http.codec.BinaryCodecWithSchema$;
import zio.http.codec.CodecConfig;
import zio.http.codec.CodecConfig$;
import zio.http.codec.HttpCodec;
import zio.http.codec.HttpCodecError;
import zio.http.codec.HttpCodecType;
import zio.http.codec.HttpContentCodec$;
import zio.http.codec.HttpContentCodec$Choices$;
import zio.http.codec.HttpContentCodec$DefaultCodecError$;
import zio.http.codec.HttpContentCodec$Filtered$;
import zio.http.internal.HeaderOps;
import zio.schema.Schema;
import zio.schema.codec.BinaryCodec;
import zio.stream.ZPipeline;
import zio.stream.ZPipeline$;

public interface HttpContentCodec<A> {
    public static BinaryCodec<Chunk<Object>> ByteChunkBinaryCodec() {
        return HttpContentCodec$.MODULE$.ByteChunkBinaryCodec();
    }

    public static <A> HttpContentCodec<A> apply(ListMap<MediaType, BinaryCodecWithSchema<A>> listMap) {
        return HttpContentCodec$.MODULE$.apply(listMap);
    }

    public static HttpContentCodec<Chunk<Object>> byteChunkCodec() {
        return HttpContentCodec$.MODULE$.byteChunkCodec();
    }

    public static HttpContentCodec<Object> byteCodec() {
        return HttpContentCodec$.MODULE$.byteCodec();
    }

    public static <A> HttpContentCodec<A> from(Tuple2<MediaType, BinaryCodecWithSchema<A>> tuple2, Seq<Tuple2<MediaType, BinaryCodecWithSchema<A>>> seq) {
        return HttpContentCodec$.MODULE$.from(tuple2, seq);
    }

    public static <A> HttpContentCodec<A> fromSchema(Schema<A> schema) {
        return HttpContentCodec$.MODULE$.fromSchema(schema);
    }

    public static int ordinal(HttpContentCodec<?> httpContentCodec) {
        return HttpContentCodec$.MODULE$.ordinal(httpContentCodec);
    }

    public static HttpCodec<HttpCodecType, HttpCodecError> responseErrorCodec() {
        return HttpContentCodec$.MODULE$.responseErrorCodec();
    }

    public static void $init$(HttpContentCodec $this) {
        $this.zio$http$codec$HttpContentCodec$_setter_$defaultMediaType_$eq((MediaType)$this.choices().headOption().map((Function1 & Serializable)_$3 -> (MediaType)_$3._1()).getOrElse(HttpContentCodec::$init$$$anonfun$2));
        $this.zio$http$codec$HttpContentCodec$_setter_$defaultCodec_$eq((BinaryCodec)$this.choices().headOption().map((Function1 & Serializable)_$4 -> ((BinaryCodecWithSchema)_$4._2()).codec(CodecConfig$.MODULE$.defaultConfig())).getOrElse(HttpContentCodec::$init$$$anonfun$4));
        $this.zio$http$codec$HttpContentCodec$_setter_$defaultSchema_$eq((Schema)$this.choices().headOption().map((Function1 & Serializable)_$5 -> ((BinaryCodecWithSchema)_$5._2()).schema()).getOrElse(HttpContentCodec::$init$$$anonfun$6));
        $this.zio$http$codec$HttpContentCodec$_setter_$defaultBinaryCodecWithSchema_$eq((BinaryCodecWithSchema)$this.choices().headOption().map((Function1 & Serializable)_$6 -> (BinaryCodecWithSchema)_$6._2()).getOrElse(HttpContentCodec::$init$$$anonfun$8));
    }

    public ListMap<MediaType, BinaryCodecWithSchema<A>> choices();

    public static HttpContentCodec $plus$plus$(HttpContentCodec $this, HttpContentCodec that) {
        return $this.$plus$plus(that);
    }

    default public HttpContentCodec<A> $plus$plus(HttpContentCodec<A> that) {
        return HttpContentCodec$Choices$.MODULE$.apply((ListMap)this.choices().$plus$plus(that.choices()));
    }

    public static ZIO decodeRequest$(HttpContentCodec $this, Request request, CodecConfig config) {
        return $this.decodeRequest(request, config);
    }

    default public ZIO<Object, Throwable, A> decodeRequest(Request request, CodecConfig config) {
        Tuple2 tuple2;
        MediaType contentType = this.mediaTypeFromContentTypeHeader(request);
        Option<Tuple2<MediaType, BinaryCodecWithSchema<A>>> option = this.lookup(contentType);
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            BinaryCodecWithSchema codec = (BinaryCodecWithSchema)tuple2._2();
            return request.body().asChunk("zio.http.codec.HttpContentCodec.decodeRequest(HttpContentCodec.scala:30)").flatMap((Function1 & Serializable)bytes -> ZIO$.MODULE$.fromEither(() -> HttpContentCodec.decodeRequest$$anonfun$1$$anonfun$1(codec, config, bytes), (Object)"zio.http.codec.HttpContentCodec.decodeRequest(HttpContentCodec.scala:31)"), (Object)"zio.http.codec.HttpContentCodec.decodeRequest(HttpContentCodec.scala:32)");
        }
        if (None$.MODULE$.equals(option)) {
            return ZIO$.MODULE$.fail(() -> HttpContentCodec.decodeRequest$$anonfun$2(contentType), (Object)"zio.http.codec.HttpContentCodec.decodeRequest(HttpContentCodec.scala:34)");
        }
        throw new MatchError(option);
    }

    public static ZIO decodeRequest$(HttpContentCodec $this, Request request) {
        return $this.decodeRequest(request);
    }

    default public ZIO<Object, Throwable, A> decodeRequest(Request request) {
        return CodecConfig$.MODULE$.codecRef().getWith((Function1 & Serializable)_$1 -> this.decodeRequest(request, (CodecConfig)_$1), (Object)"zio.http.codec.HttpContentCodec.decodeRequest(HttpContentCodec.scala:39)");
    }

    public static ZIO decodeResponse$(HttpContentCodec $this, Response response, CodecConfig config) {
        return $this.decodeResponse(response, config);
    }

    default public ZIO<Object, Throwable, A> decodeResponse(Response response, CodecConfig config) {
        Tuple2 tuple2;
        MediaType contentType = this.mediaTypeFromContentTypeHeader(response);
        Option<Tuple2<MediaType, BinaryCodecWithSchema<A>>> option = this.lookup(contentType);
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            BinaryCodecWithSchema codec = (BinaryCodecWithSchema)tuple2._2();
            return response.body().asChunk("zio.http.codec.HttpContentCodec.decodeResponse(HttpContentCodec.scala:45)").flatMap((Function1 & Serializable)bytes -> ZIO$.MODULE$.fromEither(() -> HttpContentCodec.decodeResponse$$anonfun$1$$anonfun$1(codec, config, bytes), (Object)"zio.http.codec.HttpContentCodec.decodeResponse(HttpContentCodec.scala:46)"), (Object)"zio.http.codec.HttpContentCodec.decodeResponse(HttpContentCodec.scala:47)");
        }
        if (None$.MODULE$.equals(option)) {
            return ZIO$.MODULE$.fail(() -> HttpContentCodec.decodeResponse$$anonfun$2(contentType), (Object)"zio.http.codec.HttpContentCodec.decodeResponse(HttpContentCodec.scala:49)");
        }
        throw new MatchError(option);
    }

    public static ZIO decodeResponse$(HttpContentCodec $this, Response response) {
        return $this.decodeResponse(response);
    }

    default public ZIO<Object, Throwable, A> decodeResponse(Response response) {
        return CodecConfig$.MODULE$.codecRef().getWith((Function1 & Serializable)_$2 -> this.decodeResponse(response, (CodecConfig)_$2), (Object)"zio.http.codec.HttpContentCodec.decodeResponse(HttpContentCodec.scala:54)");
    }

    private MediaType mediaTypeFromContentTypeHeader(HeaderOps<?> header) {
        if (header.headers().contains(Header$ContentType$.MODULE$.name())) {
            String contentType = header.headers().getUnsafe(Header$ContentType$.MODULE$.name());
            if (MediaType$.MODULE$.contentTypeMap().contains((Object)contentType)) {
                return (MediaType)MediaType$.MODULE$.contentTypeMap().apply((Object)contentType);
            }
            return MediaType$.MODULE$.unsafeParseCustomMediaType(contentType);
        }
        return MediaType$.MODULE$.application().json();
    }

    public static Either encode$(HttpContentCodec $this, Object value, CodecConfig config) {
        return $this.encode(value, config);
    }

    default public Either<String, Body> encode(A value, CodecConfig config) {
        if (this.choices().isEmpty()) {
            return package$.MODULE$.Left().apply((Object)"No codec defined");
        }
        return package$.MODULE$.Right().apply((Object)Body$.MODULE$.fromChunk((Chunk<Object>)((Chunk)((BinaryCodecWithSchema)((Tuple2)this.choices().head())._2()).codec(config).encode(value)), (MediaType)((Tuple2)this.choices().head())._1()));
    }

    public static CodecConfig encode$default$2$(HttpContentCodec $this) {
        return $this.encode$default$2();
    }

    default public CodecConfig encode$default$2() {
        return CodecConfig$.MODULE$.defaultConfig();
    }

    public static HttpContentCodec only$(HttpContentCodec $this, MediaType mediaType) {
        return $this.only(mediaType);
    }

    default public HttpContentCodec<A> only(MediaType mediaType) {
        if (this.lookup(mediaType).isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(31).append("MediaType ").append(mediaType).append(" is not supported by ").append(this).toString());
        }
        return HttpContentCodec$Filtered$.MODULE$.apply(this, mediaType);
    }

    public static HttpContentCodec only$(HttpContentCodec $this, Option mediaType) {
        return $this.only((Option<MediaType>)mediaType);
    }

    default public HttpContentCodec<A> only(Option<MediaType> mediaType) {
        Option<MediaType> option = mediaType;
        if (option instanceof Some) {
            MediaType value = (MediaType)((Some)option).value();
            return this.only(value);
        }
        if (None$.MODULE$.equals(option)) {
            return this;
        }
        throw new MatchError(option);
    }

    public static Tuple2 chooseFirst$(HttpContentCodec $this, Chunk mediaTypes) {
        return $this.chooseFirst((Chunk<Header.Accept.MediaTypeWithQFactor>)mediaTypes);
    }

    default public Tuple2<MediaType, BinaryCodecWithSchema<A>> chooseFirst(Chunk<Header.Accept.MediaTypeWithQFactor> mediaTypes) {
        if (mediaTypes.isEmpty()) {
            return Tuple2$.MODULE$.apply((Object)this.defaultMediaType(), this.defaultBinaryCodecWithSchema());
        }
        Tuple2 result = null;
        for (int i = 0; i < mediaTypes.size() && result == null; ++i) {
            Header.Accept.MediaTypeWithQFactor mediaType = (Header.Accept.MediaTypeWithQFactor)mediaTypes.apply(i);
            Option<Tuple2<MediaType, BinaryCodecWithSchema<A>>> lookupResult = this.lookup(mediaType.mediaType());
            if (!lookupResult.isDefined()) continue;
            result = (Tuple2)lookupResult.get();
        }
        if (result == null) {
            throw new IllegalArgumentException(new StringBuilder(42).append("None of the media types ").append(mediaTypes).append(" are supported by ").append(this).toString());
        }
        return result;
    }

    public static Tuple2 chooseFirstOrDefault$(HttpContentCodec $this, Chunk mediaTypes) {
        return $this.chooseFirstOrDefault((Chunk<Header.Accept.MediaTypeWithQFactor>)mediaTypes);
    }

    default public Tuple2<MediaType, BinaryCodecWithSchema<A>> chooseFirstOrDefault(Chunk<Header.Accept.MediaTypeWithQFactor> mediaTypes) {
        if (mediaTypes.isEmpty()) {
            return Tuple2$.MODULE$.apply((Object)this.defaultMediaType(), this.defaultBinaryCodecWithSchema());
        }
        Tuple2 result = null;
        for (int i = 0; i < mediaTypes.size() && result == null; ++i) {
            Header.Accept.MediaTypeWithQFactor mediaType = (Header.Accept.MediaTypeWithQFactor)mediaTypes.apply(i);
            Option<Tuple2<MediaType, BinaryCodecWithSchema<A>>> lookupResult = this.lookup(mediaType.mediaType());
            if (!lookupResult.isDefined()) continue;
            result = (Tuple2)lookupResult.get();
        }
        if (result == null) {
            return Tuple2$.MODULE$.apply((Object)this.defaultMediaType(), this.defaultBinaryCodecWithSchema());
        }
        return result;
    }

    public Option<Tuple2<MediaType, BinaryCodecWithSchema<A>>> lookup(MediaType var1);

    public MediaType defaultMediaType();

    public void zio$http$codec$HttpContentCodec$_setter_$defaultMediaType_$eq(MediaType var1);

    public BinaryCodec<A> defaultCodec();

    public void zio$http$codec$HttpContentCodec$_setter_$defaultCodec_$eq(BinaryCodec var1);

    public Schema<A> defaultSchema();

    public void zio$http$codec$HttpContentCodec$_setter_$defaultSchema_$eq(Schema var1);

    public BinaryCodecWithSchema<A> defaultBinaryCodecWithSchema();

    public void zio$http$codec$HttpContentCodec$_setter_$defaultBinaryCodecWithSchema_$eq(BinaryCodecWithSchema var1);

    public static HttpContentCodec optional$(HttpContentCodec $this) {
        return $this.optional();
    }

    default public HttpContentCodec<Option<A>> optional() {
        Product product;
        HttpContentCodec httpContentCodec = this;
        if (httpContentCodec instanceof Choices) {
            ListMap listMap;
            Choices choices = HttpContentCodec$Choices$.MODULE$.unapply((Choices)httpContentCodec);
            ListMap choices2 = listMap = choices._1();
            product = HttpContentCodec$Choices$.MODULE$.apply((ListMap)choices2.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    BinaryCodecWithSchema binaryCodecWithSchema = (BinaryCodecWithSchema)tuple2._2();
                    MediaType mediaType = (MediaType)tuple2._1();
                    if (binaryCodecWithSchema != null) {
                        BinaryCodecWithSchema binaryCodecWithSchema2 = BinaryCodecWithSchema$.MODULE$.unapply(binaryCodecWithSchema);
                        Function1 function1 = binaryCodecWithSchema2._1();
                        Schema schema = binaryCodecWithSchema2._2();
                        Function1 fromConfig = function1;
                        Schema schema2 = schema;
                        MediaType mediaType2 = (MediaType)Predef$.MODULE$.ArrowAssoc((Object)mediaType);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)mediaType2, BinaryCodecWithSchema$.MODULE$.apply(fromConfig.andThen((Function1 & Serializable)bc -> this.optBinaryCodec((BinaryCodec<A>)bc)), schema2.optional()));
                    }
                }
                throw new MatchError((Object)tuple2);
            }));
        } else if (httpContentCodec instanceof Filtered) {
            Filtered filtered = HttpContentCodec$Filtered$.MODULE$.unapply((Filtered)httpContentCodec);
            HttpContentCodec httpContentCodec2 = filtered._1();
            MediaType mediaType = filtered._2();
            HttpContentCodec codec = httpContentCodec2;
            MediaType mediaType2 = mediaType;
            product = HttpContentCodec$Filtered$.MODULE$.apply(codec.optional(), mediaType2);
        } else {
            throw new MatchError((Object)httpContentCodec);
        }
        return product;
    }

    private BinaryCodec<Option<A>> optBinaryCodec(BinaryCodec<A> bc) {
        return new BinaryCodec<Option<A>>(bc){
            private final BinaryCodec bc$1;
            {
                this.bc$1 = bc$2;
            }

            public Chunk encode(Option value) {
                Option option = value;
                if (option instanceof Some) {
                    Object a = ((Some)option).value();
                    return (Chunk)this.bc$1.encode(a);
                }
                if (None$.MODULE$.equals(option)) {
                    return Chunk$.MODULE$.empty();
                }
                throw new MatchError((Object)option);
            }

            public Either decode(Chunk bytes) {
                if (bytes.isEmpty()) {
                    return package$.MODULE$.Right().apply((Object)None$.MODULE$);
                }
                return this.bc$1.decode((Object)bytes).map(HttpContentCodec::zio$http$codec$HttpContentCodec$$anon$1$$_$decode$$anonfun$1);
            }

            public ZPipeline streamDecoder() {
                return ZPipeline$.MODULE$.chunks((Object)"zio.http.codec.HttpContentCodec.optBinaryCodec.$anon.streamDecoder(HttpContentCodec.scala:171)").map((Function1 & Serializable)_$8 -> this.bc$1.decode(_$8).toOption(), (Object)"zio.http.codec.HttpContentCodec.optBinaryCodec.$anon.streamDecoder(HttpContentCodec.scala:171)");
            }

            public ZPipeline streamEncoder() {
                return ZPipeline$.MODULE$.identity((Object)"zio.http.codec.HttpContentCodec.optBinaryCodec.$anon.streamEncoder(HttpContentCodec.scala:174)").map((Function1 & Serializable)_$9 -> (Chunk)_$9.fold(HttpContentCodec::zio$http$codec$HttpContentCodec$$anon$1$$_$streamEncoder$$anonfun$1$$anonfun$1, (Function1 & Serializable)value -> (Chunk)this.bc$1.encode(value)), (Object)"zio.http.codec.HttpContentCodec.optBinaryCodec.$anon.streamEncoder(HttpContentCodec.scala:174)").flattenChunks((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Object)"zio.http.codec.HttpContentCodec.optBinaryCodec.$anon.streamEncoder(HttpContentCodec.scala:174)");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{zio$http$codec$HttpContentCodec$$anon$1$$_$decode$$anonfun$1(java.lang.Object ), streamDecoder$$anonfun$1(zio.Chunk ), streamEncoder$$anonfun$1(scala.Option ), zio$http$codec$HttpContentCodec$$anon$1$$_$streamEncoder$$anonfun$1$$anonfun$1(), streamEncoder$$anonfun$1$$anonfun$2(java.lang.Object )}, serializedLambda);
            }
        };
    }

    private static MediaType $init$$$anonfun$2() {
        throw new IllegalArgumentException("No codec defined");
    }

    private static BinaryCodec $init$$$anonfun$4() {
        throw new IllegalArgumentException("No codec defined");
    }

    private static Schema $init$$$anonfun$6() {
        throw new IllegalArgumentException("No codec defined");
    }

    private static BinaryCodecWithSchema $init$$$anonfun$8() {
        throw new IllegalArgumentException("No codec defined");
    }

    private static Either decodeRequest$$anonfun$1$$anonfun$1(BinaryCodecWithSchema codec$2, CodecConfig config$2, Chunk bytes$1) {
        return codec$2.codec(config$2).decode((Object)bytes$1);
    }

    private static IllegalArgumentException decodeRequest$$anonfun$2(MediaType contentType$1) {
        return new IllegalArgumentException(new StringBuilder(32).append("No codec found for content type ").append(contentType$1).toString());
    }

    private static Either decodeResponse$$anonfun$1$$anonfun$1(BinaryCodecWithSchema codec$4, CodecConfig config$4, Chunk bytes$2) {
        return codec$4.codec(config$4).decode((Object)bytes$2);
    }

    private static IllegalArgumentException decodeResponse$$anonfun$2(MediaType contentType$2) {
        return new IllegalArgumentException(new StringBuilder(32).append("No codec found for content type ").append(contentType$2).toString());
    }

    public static /* synthetic */ Some zio$http$codec$HttpContentCodec$$anon$1$$_$decode$$anonfun$1(Object _$7) {
        return Some$.MODULE$.apply(_$7);
    }

    public static Chunk zio$http$codec$HttpContentCodec$$anon$1$$_$streamEncoder$$anonfun$1$$anonfun$1() {
        return Chunk$.MODULE$.empty();
    }

    public static final class Choices<A>
    implements HttpContentCodec<A>,
    Product,
    Serializable {
        private MediaType defaultMediaType;
        private BinaryCodec defaultCodec;
        private Schema defaultSchema;
        private BinaryCodecWithSchema defaultBinaryCodecWithSchema;
        private final ListMap choices;
        private Map<MediaType, Option<Tuple2<MediaType, BinaryCodecWithSchema<A>>>> lookupCache;

        public static <A> Choices<A> apply(ListMap<MediaType, BinaryCodecWithSchema<A>> listMap) {
            return HttpContentCodec$Choices$.MODULE$.apply(listMap);
        }

        public static Choices<?> fromProduct(Product product) {
            return HttpContentCodec$Choices$.MODULE$.fromProduct(product);
        }

        public static <A> Choices<A> unapply(Choices<A> choices) {
            return HttpContentCodec$Choices$.MODULE$.unapply(choices);
        }

        public Choices(ListMap<MediaType, BinaryCodecWithSchema<A>> choices) {
            this.choices = choices;
            HttpContentCodec.$init$(this);
            this.lookupCache = Predef$.MODULE$.Map().empty();
            Statics.releaseFence();
        }

        @Override
        public MediaType defaultMediaType() {
            return this.defaultMediaType;
        }

        @Override
        public BinaryCodec defaultCodec() {
            return this.defaultCodec;
        }

        @Override
        public Schema defaultSchema() {
            return this.defaultSchema;
        }

        @Override
        public BinaryCodecWithSchema defaultBinaryCodecWithSchema() {
            return this.defaultBinaryCodecWithSchema;
        }

        @Override
        public void zio$http$codec$HttpContentCodec$_setter_$defaultMediaType_$eq(MediaType x$0) {
            this.defaultMediaType = x$0;
        }

        @Override
        public void zio$http$codec$HttpContentCodec$_setter_$defaultCodec_$eq(BinaryCodec x$0) {
            this.defaultCodec = x$0;
        }

        @Override
        public void zio$http$codec$HttpContentCodec$_setter_$defaultSchema_$eq(Schema x$0) {
            this.defaultSchema = x$0;
        }

        @Override
        public void zio$http$codec$HttpContentCodec$_setter_$defaultBinaryCodecWithSchema_$eq(BinaryCodecWithSchema x$0) {
            this.defaultBinaryCodecWithSchema = x$0;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Choices)) return false;
            Choices choices = (Choices)object;
            ListMap<MediaType, BinaryCodecWithSchema<A>> listMap = this.choices();
            ListMap<MediaType, BinaryCodecWithSchema<A>> listMap2 = choices.choices();
            if (listMap != null) {
                if (!listMap.equals(listMap2)) return false;
                return true;
            }
            if (listMap2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Choices;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Choices";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "choices";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public ListMap<MediaType, BinaryCodecWithSchema<A>> choices() {
            return this.choices;
        }

        @Override
        public Option<Tuple2<MediaType, BinaryCodecWithSchema<A>>> lookup(MediaType mediaType) {
            if (this.lookupCache.contains((Object)mediaType)) {
                return (Option)this.lookupCache.apply((Object)mediaType);
            }
            Option codec = this.choices().collectFirst((PartialFunction)new Serializable(mediaType){
                private final MediaType mediaType$1;
                {
                    this.mediaType$1 = mediaType$2;
                }

                public final boolean isDefinedAt(Tuple2 x) {
                    Tuple2 tuple2 = x;
                    if (tuple2 != null) {
                        MediaType mt = (MediaType)tuple2._1();
                        BinaryCodecWithSchema codec = (BinaryCodecWithSchema)tuple2._2();
                        if (mt.matches(this.mediaType$1, mt.matches$default$2())) {
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(Tuple2 x, Function1 function1) {
                    Tuple2 tuple2 = x;
                    if (tuple2 != null) {
                        MediaType mt = (MediaType)tuple2._1();
                        BinaryCodecWithSchema codec = (BinaryCodecWithSchema)tuple2._2();
                        if (mt.matches(this.mediaType$1, mt.matches$default$2())) {
                            MediaType mediaType = (MediaType)Predef$.MODULE$.ArrowAssoc((Object)mt);
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)mediaType, (Object)codec);
                        }
                    }
                    return function1.apply((Object)x);
                }
            });
            MediaType mediaType2 = (MediaType)Predef$.MODULE$.ArrowAssoc((Object)mediaType);
            this.lookupCache = (Map)this.lookupCache.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)mediaType2, (Object)codec));
            return codec;
        }

        public <A> Choices<A> copy(ListMap<MediaType, BinaryCodecWithSchema<A>> choices) {
            return new Choices<A>(choices);
        }

        public <A> ListMap<MediaType, BinaryCodecWithSchema<A>> copy$default$1() {
            return this.choices();
        }

        public ListMap<MediaType, BinaryCodecWithSchema<A>> _1() {
            return this.choices();
        }
    }

    public static final class DefaultCodecError
    implements Product,
    Serializable {
        private final String name;
        private final String message;

        public static DefaultCodecError apply(String string, String string2) {
            return HttpContentCodec$DefaultCodecError$.MODULE$.apply(string, string2);
        }

        public static DefaultCodecError fromProduct(Product product) {
            return HttpContentCodec$DefaultCodecError$.MODULE$.fromProduct(product);
        }

        public static Schema<DefaultCodecError> schema() {
            return HttpContentCodec$DefaultCodecError$.MODULE$.schema();
        }

        public static DefaultCodecError unapply(DefaultCodecError defaultCodecError) {
            return HttpContentCodec$DefaultCodecError$.MODULE$.unapply(defaultCodecError);
        }

        public DefaultCodecError(String name, String message) {
            this.name = name;
            this.message = message;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DefaultCodecError)) return false;
            DefaultCodecError defaultCodecError = (DefaultCodecError)object;
            String string = this.name();
            String string2 = defaultCodecError.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.message();
            String string4 = defaultCodecError.message();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DefaultCodecError;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DefaultCodecError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            if (1 == n2) {
                return "message";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public String message() {
            return this.message;
        }

        public DefaultCodecError copy(String name, String message) {
            return new DefaultCodecError(name, message);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.message();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.message();
        }
    }

    public static final class Filtered<A>
    implements HttpContentCodec<A>,
    Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Filtered.class.getDeclaredField("choices$lzy1"));
        private MediaType defaultMediaType;
        private BinaryCodec defaultCodec;
        private Schema defaultSchema;
        private BinaryCodecWithSchema defaultBinaryCodecWithSchema;
        private final HttpContentCodec codec;
        private final MediaType mediaType;
        private volatile Object choices$lzy1;
        private final Option<Tuple2<MediaType, BinaryCodecWithSchema<A>>> choice;

        public static <A> Filtered<A> apply(HttpContentCodec<A> httpContentCodec, MediaType mediaType) {
            return HttpContentCodec$Filtered$.MODULE$.apply(httpContentCodec, mediaType);
        }

        public static Filtered<?> fromProduct(Product product) {
            return HttpContentCodec$Filtered$.MODULE$.fromProduct(product);
        }

        public static <A> Filtered<A> unapply(Filtered<A> filtered) {
            return HttpContentCodec$Filtered$.MODULE$.unapply(filtered);
        }

        public Filtered(HttpContentCodec<A> codec, MediaType mediaType) {
            this.codec = codec;
            this.mediaType = mediaType;
            HttpContentCodec.$init$(this);
            this.choice = this.choices().headOption();
            Statics.releaseFence();
        }

        @Override
        public MediaType defaultMediaType() {
            return this.defaultMediaType;
        }

        @Override
        public BinaryCodec defaultCodec() {
            return this.defaultCodec;
        }

        @Override
        public Schema defaultSchema() {
            return this.defaultSchema;
        }

        @Override
        public BinaryCodecWithSchema defaultBinaryCodecWithSchema() {
            return this.defaultBinaryCodecWithSchema;
        }

        @Override
        public void zio$http$codec$HttpContentCodec$_setter_$defaultMediaType_$eq(MediaType x$0) {
            this.defaultMediaType = x$0;
        }

        @Override
        public void zio$http$codec$HttpContentCodec$_setter_$defaultCodec_$eq(BinaryCodec x$0) {
            this.defaultCodec = x$0;
        }

        @Override
        public void zio$http$codec$HttpContentCodec$_setter_$defaultSchema_$eq(Schema x$0) {
            this.defaultSchema = x$0;
        }

        @Override
        public void zio$http$codec$HttpContentCodec$_setter_$defaultBinaryCodecWithSchema_$eq(BinaryCodecWithSchema x$0) {
            this.defaultBinaryCodecWithSchema = x$0;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Filtered)) return false;
            Filtered filtered = (Filtered)object;
            HttpContentCodec<A> httpContentCodec = this.codec();
            HttpContentCodec<A> httpContentCodec2 = filtered.codec();
            if (httpContentCodec == null) {
                if (httpContentCodec2 != null) {
                    return false;
                }
            } else if (!httpContentCodec.equals(httpContentCodec2)) return false;
            MediaType mediaType = this.mediaType();
            MediaType mediaType2 = filtered.mediaType();
            if (mediaType == null) {
                if (mediaType2 == null) return true;
                return false;
            } else {
                if (!((Object)mediaType).equals(mediaType2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Filtered;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Filtered";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "codec";
            }
            if (1 == n2) {
                return "mediaType";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public HttpContentCodec<A> codec() {
            return this.codec;
        }

        public MediaType mediaType() {
            return this.mediaType;
        }

        @Override
        public ListMap<MediaType, BinaryCodecWithSchema<A>> choices() {
            Object object = this.choices$lzy1;
            if (object instanceof ListMap) {
                return (ListMap)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (ListMap)this.choices$lzyINIT1();
        }

        private Object choices$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.choices$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        ListMap listMap = null;
                        try {
                            listMap = (ListMap)this.codec().choices().filter((Function1 & Serializable)_$10 -> {
                                Object object = _$10._1();
                                MediaType mediaType = this.mediaType();
                                return !(object != null ? !object.equals(mediaType) : mediaType != null);
                            });
                            object2 = listMap == null ? LazyVals.NullValue$.MODULE$ : listMap;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.choices$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return listMap;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public Option<Tuple2<MediaType, BinaryCodecWithSchema<A>>> lookup(MediaType mediaType) {
            if (this.mediaType().matches(mediaType, this.mediaType().matches$default$2())) {
                return this.choice;
            }
            return None$.MODULE$;
        }

        public <A> Filtered<A> copy(HttpContentCodec<A> codec, MediaType mediaType) {
            return new Filtered<A>(codec, mediaType);
        }

        public <A> HttpContentCodec<A> copy$default$1() {
            return this.codec();
        }

        public <A> MediaType copy$default$2() {
            return this.mediaType();
        }

        public HttpContentCodec<A> _1() {
            return this.codec();
        }

        public MediaType _2() {
            return this.mediaType();
        }
    }
}

