/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple5;
import scala.Tuple5$;
import scala.collection.StringOps$;
import scala.deriving.Mirror;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.control.NonFatal$;
import zio.Config;
import zio.Config$;
import zio.http.Charsets$;
import zio.http.Path;
import zio.http.Path$;
import zio.http.QueryParams;
import zio.http.QueryParams$;
import zio.http.Scheme;
import zio.http.Scheme$;
import zio.http.URL;
import zio.http.URL$Fragment$;
import zio.http.URL$Location$;
import zio.http.URL$Location$Absolute$;
import zio.http.URL$Location$Relative$;
import zio.http.internal.QueryParamEncoding$;
import zio.http.internal.ThreadLocals$;

public final class URL$
implements Mirror.Product,
Serializable {
    private static final URL empty;
    public static final URL$Location$ Location;
    public static final URL$Fragment$ Fragment;
    public static final URL$ MODULE$;

    private URL$() {
    }

    static {
        MODULE$ = new URL$();
        empty = MODULE$.apply(Path$.MODULE$.empty(), MODULE$.$lessinit$greater$default$2(), MODULE$.$lessinit$greater$default$3(), MODULE$.$lessinit$greater$default$4());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(URL$.class);
    }

    public URL apply(Path path, URL.Location kind, QueryParams queryParams, Option<URL.Fragment> fragment) {
        return new URL(path, kind, queryParams, fragment);
    }

    public URL unapply(URL x$1) {
        return x$1;
    }

    public URL.Location $lessinit$greater$default$2() {
        return URL$Location$Relative$.MODULE$;
    }

    public QueryParams $lessinit$greater$default$3() {
        return QueryParams$.MODULE$.empty();
    }

    public Option<URL.Fragment> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public URL empty() {
        return empty;
    }

    public Either<MalformedURLException, URL> decode(String rawUrl) {
        Either either;
        block5: {
            try {
                Option<URL> url;
                URI uri = new URI(rawUrl);
                Option<URL> option = url = uri.isAbsolute() ? this.fromAbsoluteURI(uri) : this.fromRelativeURI(uri);
                if (option instanceof Some) {
                    URL value = (URL)((Some)option).value();
                    either = package$.MODULE$.Right().apply((Object)value);
                    break block5;
                }
                if (None$.MODULE$.equals(option)) {
                    either = this.invalidURL$1(rawUrl, this.invalidURL$default$1$1());
                    break block5;
                }
                throw new MatchError(option);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    either = this.invalidURL$1(rawUrl, e);
                }
                throw throwable;
            }
        }
        return either;
    }

    public Config<URL> config() {
        return Config$.MODULE$.string().mapAttempt((Function1 & Serializable)_$1 -> (URL)MODULE$.decode((String)_$1).fold((Function1 & Serializable)_$2 -> {
            throw _$2;
        }, (Function1 & Serializable)x -> (URL)Predef$.MODULE$.identity(x)));
    }

    public Option<URL> fromURI(URI uri) {
        if (uri.isAbsolute()) {
            return this.fromAbsoluteURI(uri);
        }
        return this.fromRelativeURI(uri);
    }

    public URL root() {
        return this.apply(Path$.MODULE$.root(), this.$lessinit$greater$default$2(), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4());
    }

    public String zio$http$URL$$$encode(URL url) {
        String path = QueryParamEncoding$.MODULE$.encode(url.path().encodeBuilder(), url.queryParams(), Charsets$.MODULE$.Http());
        URL.Location location = url.kind();
        if (URL$Location$Relative$.MODULE$.equals(location) && url.fragment().isEmpty()) {
            return path;
        }
        if (URL$Location$Relative$.MODULE$.equals(location)) {
            return ThreadLocals$.MODULE$.stringBuilder().append(path).append('#').append(((URL.Fragment)url.fragment().get()).raw()).toString();
        }
        if (location instanceof URL.Location.Absolute) {
            URL.Location.Absolute absolute;
            URL.Location.Absolute abs = absolute = (URL.Location.Absolute)location;
            if (url.fragment().isEmpty()) {
                return this.fromAbsURL$1(abs, path).append(path).toString();
            }
            URL.Location.Absolute abs2 = absolute;
            return this.fromAbsURL$1(abs2, path).append(path).append('#').append(((URL.Fragment)url.fragment().get()).raw()).toString();
        }
        throw new MatchError((Object)location);
    }

    public String encodeHttpPath(URL url) {
        String prefix = !url.path().hasLeadingSlash() ? "/" : "";
        return new StringBuilder(0).append(prefix).append(url.queryParams().isEmpty() ? url.path().encode() : QueryParamEncoding$.MODULE$.encode(url.path().encodeBuilder(), url.queryParams(), Charsets$.MODULE$.Http())).toString();
    }

    public Option<URL> fromAbsoluteURI(URI uri) {
        return Scheme$.MODULE$.decode(uri.getScheme()).flatMap((Function1 & Serializable)scheme -> Option$.MODULE$.apply((Object)uri.getHost()).flatMap((Function1 & Serializable)host -> Option$.MODULE$.apply((Object)uri.getRawPath()).map((Function1 & Serializable)path -> {
            Option port = Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)uri.getPort())).filter((Function1)(JFunction1.mcZI.sp & Serializable)_$4 -> _$4 != -1);
            URL.Location.Absolute connection = URL$Location$Absolute$.MODULE$.apply((Scheme)scheme, (String)host, (Option<Object>)port);
            Path path2 = Path$.MODULE$.decode((String)path);
            Path path3 = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(path)) ? path2.addLeadingSlash() : path2;
            return Tuple5$.MODULE$.apply(path, (Object)port, (Object)connection, (Object)path2, (Object)path3);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple5 tuple5 = x$1;
            if (tuple5 != null) {
                String path = (String)tuple5._1();
                Option port = (Option)tuple5._2();
                URL.Location.Absolute connection = (URL.Location.Absolute)tuple5._3();
                Path path2 = (Path)tuple5._4();
                Path path3 = (Path)tuple5._5();
                return MODULE$.apply(path3, connection, QueryParams$.MODULE$.decode(uri.getRawQuery(), QueryParams$.MODULE$.decode$default$2()), URL$Fragment$.MODULE$.fromURI(uri));
            }
            throw new MatchError((Object)tuple5);
        })));
    }

    public Option<URL> fromRelativeURI(URI uri) {
        return Option$.MODULE$.apply((Object)uri.getRawPath()).map((Function1 & Serializable)path -> MODULE$.apply(Path$.MODULE$.decode((String)path), URL$Location$Relative$.MODULE$, QueryParams$.MODULE$.decode(uri.getRawQuery(), QueryParams$.MODULE$.decode$default$2()), URL$Fragment$.MODULE$.fromURI(uri)));
    }

    public URL fromProduct(Product x$0) {
        return new URL((Path)x$0.productElement(0), (URL.Location)x$0.productElement(1), (QueryParams)x$0.productElement(2), (Option<URL.Fragment>)((Option)x$0.productElement(3)));
    }

    private final Either invalidURL$1(String rawUrl$1, Throwable e) {
        return package$.MODULE$.Left().apply((Object)new URL.Err(rawUrl$1, e));
    }

    private final Throwable invalidURL$default$1$1() {
        return null;
    }

    public static final /* synthetic */ boolean zio$http$URL$Location$Absolute$$_$portIfNotDefault$$anonfun$1$$anonfun$1(int p$1, int _$3) {
        return _$3 != p$1;
    }

    public static final int zio$http$URL$Location$Absolute$$_$port$$anonfun$2() {
        return Scheme$.MODULE$.defaultPortForHTTP();
    }

    public static final /* synthetic */ Option zio$http$URL$Fragment$$$_$fromURI$$anonfun$1(URI uri$1, String raw) {
        return Option$.MODULE$.apply((Object)uri$1.getFragment()).map((Function1 & Serializable)decoded -> URL$Fragment$.MODULE$.zio$http$URL$Fragment$$$apply(raw, (String)decoded));
    }

    private final StringBuilder fromAbsURL$1(URL.Location.Absolute abs, String path) {
        Option<Object> option = abs.originalPort();
        if (None$.MODULE$.equals(option)) {
            StringBuilder sb = ThreadLocals$.MODULE$.stringBuilder().append(abs.scheme().encode()).append("://").append(abs.host());
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(path)) && StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(path)) != '/') {
                sb.append('/');
            }
            return sb;
        }
        Option<Object> port = option;
        StringBuilder sb = ThreadLocals$.MODULE$.stringBuilder().append(abs.scheme().encode()).append("://").append(abs.host()).append(':').append(BoxesRunTime.unboxToInt((Object)port.get()));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(path)) && StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(path)) != '/') {
            sb.append('/');
        }
        return sb;
    }
}

